/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalservicos.service;

import br.com.caelum.stella.tinytype.CPF;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.core.utils.EloHashUtils;
import br.com.elotech.portalservicos.domain.AcessoWeb;
import br.com.elotech.portalservicos.domain.support.UsuarioTrocaSenha;
import br.com.elotech.portalservicos.repository.AcessoWebRepository;
import br.com.elotech.portalservicos.service.EsqueciMinhaSenhaMailServiceImpl;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class AcessoWebService
extends CrudService<AcessoWeb, Long> {
    private final Logger log = LoggerFactory.getLogger(AcessoWebService.class);
    private final AcessoWebRepository acessoWebRepository;
    private final EsqueciMinhaSenhaMailServiceImpl esqueciMinhaSenhaService;

    @Autowired
    public AcessoWebService(AcessoWebRepository acessoWebRepository, EsqueciMinhaSenhaMailServiceImpl esqueciMinhaSenhaService) {
        this.acessoWebRepository = acessoWebRepository;
        this.esqueciMinhaSenhaService = esqueciMinhaSenhaService;
    }

    public AcessoWeb load(String username) {
        AcessoWeb usuario = this.acessoWebRepository.findByCpf(username);
        if (usuario == null) {
            throw new UsernameNotFoundException("Usu\u00e1rio n\u00e3o encontrado.");
        }
        return usuario;
    }

    public Boolean validaCpf(String cpf) {
        Boolean cpfValido = false;
        CPF resultCpf = new CPF(cpf);
        cpfValido = resultCpf.isValido();
        if (cpfValido.booleanValue()) {
            AcessoWeb acessoWeb = this.acessoWebRepository.findByCpf(cpf);
            cpfValido = acessoWeb == null;
        }
        return cpfValido;
    }

    protected void beforeInsert(AcessoWeb entity) {
        if (entity.getSenha() != null) {
            String encryptPassword = EloHashUtils.montarSenha((String)entity.getSenha());
            entity.setSenha(encryptPassword);
        }
    }

    public void trocaSenha(Authentication authentication, UsuarioTrocaSenha usuarioTrocaSenha) throws NoSuchAlgorithmException {
        AcessoWeb acessoWeb = this.load(authentication.getName());
        this.validaSenhaAtual(usuarioTrocaSenha, acessoWeb);
        String senhaNova = EloHashUtils.montarSenha((String)usuarioTrocaSenha.getSenhaNova());
        acessoWeb.setSenha(senhaNova);
        this.save((EloEntity)acessoWeb, authentication);
    }

    public void validaSenhaAtual(UsuarioTrocaSenha usuarioTrocaSenha, AcessoWeb acessoWeb) throws NoSuchAlgorithmException {
        String senhaAtual = EloHashUtils.montarSenha((String)usuarioTrocaSenha.getSenhaAtual());
        if (!acessoWeb.getSenha().equals(senhaAtual)) {
            throw new IllegalArgumentException("A senha atual n\u00e3o confere!");
        }
    }

    public AcessoWeb esqueciMinhaSenha(String cpf, String urlAtual) throws NoSuchAlgorithmException, InterruptedException, ExecutionException {
        AcessoWeb acessoWeb = (AcessoWeb)this.save((EloEntity)this.load(cpf).gerarAcessoAlterarSenha(), null);
        if (((Boolean)this.esqueciMinhaSenhaService.enviaEmail(acessoWeb, urlAtual).get()).booleanValue()) {
            this.log.debug(String.format("Email para altera\u00e7\u00e3o de senha enviado para %s", acessoWeb.getContato().getEmail()));
        }
        return acessoWeb;
    }

    public AcessoWeb alterarSenha(UsuarioTrocaSenha usuarioTrocaSenha) throws NoSuchAlgorithmException {
        AcessoWeb acessoWeb = this.findByCodigoAcessoEsqueciMinhaSenha(usuarioTrocaSenha.getCodigoAcessoEsqueciMinhaSenha());
        acessoWeb.setSenha(EloHashUtils.montarSenha((String)usuarioTrocaSenha.getSenhaNova()));
        return (AcessoWeb)this.save((EloEntity)acessoWeb, null);
    }

    public AcessoWeb findByCodigoAcessoEsqueciMinhaSenha(String codigoAcessoEsqueciMinhasenha) {
        return this.acessoWebRepository.findByCodigoAcessoEsqueciMinhaSenha(codigoAcessoEsqueciMinhasenha);
    }
}

