/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalservicos.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.portalservicos.domain.AcessoWebModulo;
import br.com.elotech.portalservicos.domain.AcessoWebModuloSeletor;
import br.com.elotech.portalservicos.repository.AcessoWebModuloRepository;
import br.com.elotech.portalservicos.service.AcessoWebSeletorService;
import br.com.elotech.portalservicos.web.rest.dto.ModuloDTO;
import br.com.elotech.portalservicos.web.rest.dto.SeletorDTO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class AcessoWebModuloService
extends CrudService<AcessoWebModulo, Long> {
    private final AcessoWebSeletorService acessoWebSeletorService;
    private final AcessoWebModuloRepository acessoWebModuloRepository;

    public AcessoWebModuloService(AcessoWebModuloRepository acessoWebModuloRepository, AcessoWebSeletorService acessoWebSeletorService) {
        this.acessoWebSeletorService = acessoWebSeletorService;
        this.acessoWebModuloRepository = acessoWebModuloRepository;
    }

    public List<ModuloDTO> loadModulos() {
        ArrayList<ModuloDTO> listModulos = new ArrayList<ModuloDTO>();
        List modulos = this.acessoWebModuloRepository.findByAtivo(Boolean.TRUE);
        for (AcessoWebModulo acessoWebModulo : modulos) {
            ModuloDTO moduloDTO = new ModuloDTO();
            moduloDTO.setDescricao(acessoWebModulo.getDescricao());
            moduloDTO.setTipoModulo(acessoWebModulo.getTipoModulo());
            moduloDTO.setUrl(acessoWebModulo.getUrl());
            moduloDTO.setImagem(acessoWebModulo.getImagem());
            List seletores = this.acessoWebSeletorService.findSeletoresByModulo(acessoWebModulo.getId());
            ArrayList<SeletorDTO> listSeletores = new ArrayList<SeletorDTO>();
            for (AcessoWebModuloSeletor acessoWebSeletor : seletores) {
                SeletorDTO seletorDTO = new SeletorDTO();
                seletorDTO.setDescricao(acessoWebSeletor.getSeletor().getDescricao());
                seletorDTO.setUrl(acessoWebSeletor.getSeletor().getUrl());
                seletorDTO.setRota(acessoWebSeletor.getSeletor().getRota());
                listSeletores.add(seletorDTO);
            }
            moduloDTO.setSeletores(listSeletores);
            listModulos.add(moduloDTO);
        }
        return listModulos;
    }
}

