/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalservicos.security;

import br.com.elotech.core.security.Http401UnauthorizedEntryPoint;
import br.com.elotech.core.security.SecurityConfigurationOverride;
import br.com.elotech.core.security.authorization.AuthorizationInterApiProvider;
import br.com.elotech.core.security.jwt.TokenProvider;
import br.com.elotech.core.security.jwt.filter.SecurityFiltersConfigurer;
import javax.inject.Inject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.userdetails.DaoAuthenticationConfigurer;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.data.repository.query.SecurityEvaluationContextExtension;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.web.filter.CorsFilter;

@Configuration
@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true, jsr250Enabled=true)
@Order(value=1)
@ConditionalOnProperty(name={"elotech.security.enabled"}, havingValue="true", matchIfMissing=true)
public class PortalServicosSecurityConfiguration
extends WebSecurityConfigurerAdapter
implements SecurityConfigurationOverride {
    @Inject
    private Http401UnauthorizedEntryPoint authenticationEntryPoint;
    @Inject
    private TokenProvider tokenProvider;
    @Inject
    private PasswordEncoder passwordEncoder;
    @Value(value="${security.require_ssl:false}")
    private Boolean requireSsl;
    @Inject
    private CorsFilter corsFilter;
    @Inject
    private UserDetailsService userDetailsService;
    @Inject
    private AuthorizationInterApiProvider authorizationInterApiProvider;

    @Inject
    public void configureGlobal(AuthenticationManagerBuilder auth) {
        DaoAuthenticationConfigurer builder = auth.userDetailsService(this.userDetailsService);
        builder.passwordEncoder(this.passwordEncoder);
    }

    public void configure(WebSecurity web) {
        ((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).antMatchers(new String[]{"/h2-console/**"});
    }

    protected void configure(HttpSecurity http) {
        if (this.requireSsl.booleanValue()) {
            ((ChannelSecurityConfigurer.RequiresChannelUrl)http.requiresChannel().anyRequest()).requiresSecure().and();
        }
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.authenticationEntryPoint).and()).csrf().disable()).formLogin().disable()).authorizeRequests().antMatchers(HttpMethod.GET, new String[]{"/api/acesso-web/me"})).authenticated().antMatchers(HttpMethod.GET, new String[]{"/api/acesso-web/validaCpf/**"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/api/acesso-web/change-password"})).authenticated().antMatchers(HttpMethod.GET, new String[]{"/api/acesso-web/**"})).hasAnyRole(new String[]{"ROLE_ADMIN", "FrmUnicoUsuario"}).antMatchers(HttpMethod.PUT, new String[]{"/api/acesso-web"})).hasAnyRole(new String[]{"ROLE_ADMIN", "FrmUnicoUsuario"}).antMatchers(HttpMethod.DELETE, new String[]{"/api/acesso-web"})).hasAnyRole(new String[]{"ROLE_ADMIN", "FrmUnicoUsuario"}).antMatchers(HttpMethod.GET, new String[]{"/api/acesso-web/report"})).hasAnyRole(new String[]{"ROLE_ADMIN", "FrmUnicoUsuario"}).anyRequest()).permitAll().and()).apply((SecurityConfigurerAdapter)this.securityConfigurerAdapter());
    }

    private SecurityFiltersConfigurer securityConfigurerAdapter() {
        return new SecurityFiltersConfigurer(this.tokenProvider, this.corsFilter, this.authorizationInterApiProvider);
    }

    @Bean
    public SecurityEvaluationContextExtension securityEvaluationContextExtension() {
        return new SecurityEvaluationContextExtension();
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }
}

