/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalservicos.security;

import br.com.elotech.core.utils.EloHashUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

@Component
public class PortalServicosPasswordEncoder
implements PasswordEncoder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public String encode(CharSequence rawPassword) {
        if (Objects.isNull(rawPassword)) {
            return "";
        }
        return EloHashUtils.montarSenha((String)rawPassword.toString());
    }

    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        if (encodedPassword == null || encodedPassword.length() == 0) {
            this.logger.warn("Empty encoded password");
            return false;
        }
        return this.encode(rawPassword).equals(encodedPassword);
    }
}

