/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalservicos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToAtivoInativoConverter;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.core.utils.EloHashUtils;
import br.com.elotech.portalservicos.domain.AcessoWebContato;
import br.com.elotech.portalservicos.domain.AcessoWebEmpresa;
import br.com.elotech.portalservicos.domain.AcessoWebEndereco;
import br.com.elotech.portalservicos.domain.AcessoWebTipoPermissao;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TribAcessoWeb")
public class AcessoWeb
implements EloEntity<Long> {
    @Id
    @EloSequence
    @Column(name="IDAcessoWeb")
    private Long id;
    @Length(max=15)
    private @Length(max=15) String cpf;
    private LocalDate dataNascimento;
    @Length(max=60)
    private @Length(max=60) String nome;
    @Length(max=15)
    private @Length(max=15) String rg;
    @Length(max=10)
    private @Length(max=10) String orgaoEmissor;
    @Length(max=2)
    private @Length(max=2) String ufEmissor;
    @Length(max=20)
    private @Length(max=20) String identificacaoProfissional;
    @Length(max=20)
    private @Length(max=20) String tipoConselho;
    @Embedded
    private AcessoWebEndereco endereco;
    @Embedded
    private AcessoWebContato contato;
    @Length(max=50)
    private @Length(max=50) String senha;
    @JsonIgnore
    @MetaModelIgnore
    @Length(max=50)
    private @Length(max=50) String codigoAcessoEsqueciMinhaSenha;
    @JsonIgnore
    @MetaModelIgnore
    @Column(name="dataLimiteEsqueciMinhaSenha")
    private LocalDate dataLimiteAcessoEsqueciMinhaSenha;
    @Column(insertable=false, updatable=false)
    private LocalDate dataCadastro = LocalDate.now();
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="acessoWeb")
    private List<AcessoWebEmpresa> acessoWebEmpresas;
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="TribAcessoWebContribuinte", joinColumns={@JoinColumn(name="IDAcessoWeb", referencedColumnName="IDAcessoWeb")}, inverseJoinColumns={@JoinColumn(name="IDTipoPermissao", referencedColumnName="IDTipoPermissao")})
    private List<AcessoWebTipoPermissao> acessoWebTipoPermissao;
    @Convert(converter=BooleanToAtivoInativoConverter.class)
    private Boolean ativo = true;
    @JsonIgnore
    @MetaModelIgnore
    @Length(max=70)
    private @Length(max=70) String codigoAlteracaoSenha;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean administrador;

    public static AcessoWeb allAtributesNull() {
        AcessoWeb acessoWeb = new AcessoWeb();
        acessoWeb.setDataCadastro(null);
        acessoWeb.setAtivo(null);
        return acessoWeb;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public LocalDate getDataNascimento() {
        return this.dataNascimento;
    }

    public void setDataNascimento(LocalDate dataNascimento) {
        this.dataNascimento = dataNascimento;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getRg() {
        return this.rg;
    }

    public void setRg(String rg) {
        this.rg = rg;
    }

    public String getOrgaoEmissor() {
        return this.orgaoEmissor;
    }

    public void setOrgaoEmissor(String orgaoEmissor) {
        this.orgaoEmissor = orgaoEmissor;
    }

    public String getUfEmissor() {
        return this.ufEmissor;
    }

    public void setUfEmissor(String ufEmissor) {
        this.ufEmissor = ufEmissor;
    }

    public String getIdentificacaoProfissional() {
        return this.identificacaoProfissional;
    }

    public void setIdentificacaoProfissional(String identificacaoProfissional) {
        this.identificacaoProfissional = identificacaoProfissional;
    }

    public String getTipoConselho() {
        return this.tipoConselho;
    }

    public void setTipoConselho(String tipoConselho) {
        this.tipoConselho = tipoConselho;
    }

    public AcessoWebEndereco getEndereco() {
        return this.endereco;
    }

    public void setEndereco(AcessoWebEndereco endereco) {
        this.endereco = endereco;
    }

    public AcessoWebContato getContato() {
        return this.contato;
    }

    public void setContato(AcessoWebContato contato) {
        this.contato = contato;
    }

    @JsonIgnore
    public String getSenha() {
        return this.senha;
    }

    @JsonProperty
    public void setSenha(String senha) {
        this.senha = senha;
    }

    public LocalDate getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(LocalDate dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public List<AcessoWebEmpresa> getAcessoWebEmpresas() {
        return this.acessoWebEmpresas;
    }

    public void setAcessoWebEmpresas(List<AcessoWebEmpresa> acessoWebEmpresas) {
        this.acessoWebEmpresas = acessoWebEmpresas;
    }

    public List<AcessoWebTipoPermissao> getAcessoWebTipoPermissao() {
        if (this.acessoWebTipoPermissao == null) {
            return new ArrayList<AcessoWebTipoPermissao>();
        }
        return this.acessoWebTipoPermissao;
    }

    public void setAcessoWebTipoPermissao(List<AcessoWebTipoPermissao> acessoWebTipoPermissao) {
        this.acessoWebTipoPermissao = acessoWebTipoPermissao;
    }

    public Boolean isAtivo() {
        return this.ativo;
    }

    public Boolean getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public String getCodigoAlteracaoSenha() {
        return this.codigoAlteracaoSenha;
    }

    public void setCodigoAlteracaoSenha(String codigoAlteracaoSenha) {
        this.codigoAlteracaoSenha = codigoAlteracaoSenha;
    }

    public Boolean isAdministrador() {
        return this.administrador;
    }

    public String getCodigoAcessoEsqueciMinhaSenha() {
        return this.codigoAcessoEsqueciMinhaSenha;
    }

    public void setCodigoAcessoEsqueciMinhaSenha(String codigoAcessoEsqueciMinhaSenha) {
        this.codigoAcessoEsqueciMinhaSenha = codigoAcessoEsqueciMinhaSenha;
    }

    public LocalDate getDataLimiteAcessoEsqueciMinhaSenha() {
        return this.dataLimiteAcessoEsqueciMinhaSenha;
    }

    public String formatDataLimiteAcessoEsqueciMinhaSenha() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd MMMM yyyy");
        return this.getDataLimiteAcessoEsqueciMinhaSenha().format(formatter);
    }

    public void setDataLimiteAcessoEsqueciMinhaSenha(LocalDate dataLimiteAcessoEsqueciMinhaSenha) {
        this.dataLimiteAcessoEsqueciMinhaSenha = dataLimiteAcessoEsqueciMinhaSenha;
    }

    public AcessoWeb gerarAcessoAlterarSenha() throws NoSuchAlgorithmException {
        Long diasParaAcessarEsqueciMinhaSenha = 1L;
        String codigoAcessoEsqueciMinhaSenha = EloHashUtils.hashMD5((String)LocalDate.now().toString());
        this.setCodigoAcessoEsqueciMinhaSenha(codigoAcessoEsqueciMinhaSenha);
        this.setDataLimiteAcessoEsqueciMinhaSenha(LocalDate.now().plusDays(diasParaAcessarEsqueciMinhaSenha));
        return this;
    }

    @Generated
    public String toString() {
        return "AcessoWeb(id=" + this.getId() + ", cpf=" + this.getCpf() + ", dataNascimento=" + this.getDataNascimento() + ", nome=" + this.getNome() + ", rg=" + this.getRg() + ", orgaoEmissor=" + this.getOrgaoEmissor() + ", ufEmissor=" + this.getUfEmissor() + ", identificacaoProfissional=" + this.getIdentificacaoProfissional() + ", tipoConselho=" + this.getTipoConselho() + ", endereco=" + this.getEndereco() + ", contato=" + this.getContato() + ", senha=" + this.getSenha() + ", codigoAcessoEsqueciMinhaSenha=" + this.getCodigoAcessoEsqueciMinhaSenha() + ", dataLimiteAcessoEsqueciMinhaSenha=" + this.getDataLimiteAcessoEsqueciMinhaSenha() + ", dataCadastro=" + this.getDataCadastro() + ", acessoWebTipoPermissao=" + this.getAcessoWebTipoPermissao() + ", ativo=" + this.getAtivo() + ", codigoAlteracaoSenha=" + this.getCodigoAlteracaoSenha() + ", administrador=" + this.administrador + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AcessoWeb)) {
            return false;
        }
        AcessoWeb other = (AcessoWeb)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$cpf = this.getCpf();
        String other$cpf = other.getCpf();
        if (this$cpf == null ? other$cpf != null : !this$cpf.equals(other$cpf)) {
            return false;
        }
        LocalDate this$dataNascimento = this.getDataNascimento();
        LocalDate other$dataNascimento = other.getDataNascimento();
        if (this$dataNascimento == null ? other$dataNascimento != null : !((Object)this$dataNascimento).equals(other$dataNascimento)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        String this$rg = this.getRg();
        String other$rg = other.getRg();
        if (this$rg == null ? other$rg != null : !this$rg.equals(other$rg)) {
            return false;
        }
        String this$orgaoEmissor = this.getOrgaoEmissor();
        String other$orgaoEmissor = other.getOrgaoEmissor();
        if (this$orgaoEmissor == null ? other$orgaoEmissor != null : !this$orgaoEmissor.equals(other$orgaoEmissor)) {
            return false;
        }
        String this$ufEmissor = this.getUfEmissor();
        String other$ufEmissor = other.getUfEmissor();
        if (this$ufEmissor == null ? other$ufEmissor != null : !this$ufEmissor.equals(other$ufEmissor)) {
            return false;
        }
        String this$identificacaoProfissional = this.getIdentificacaoProfissional();
        String other$identificacaoProfissional = other.getIdentificacaoProfissional();
        if (this$identificacaoProfissional == null ? other$identificacaoProfissional != null : !this$identificacaoProfissional.equals(other$identificacaoProfissional)) {
            return false;
        }
        String this$tipoConselho = this.getTipoConselho();
        String other$tipoConselho = other.getTipoConselho();
        if (this$tipoConselho == null ? other$tipoConselho != null : !this$tipoConselho.equals(other$tipoConselho)) {
            return false;
        }
        AcessoWebEndereco this$endereco = this.getEndereco();
        AcessoWebEndereco other$endereco = other.getEndereco();
        if (this$endereco == null ? other$endereco != null : !this$endereco.equals(other$endereco)) {
            return false;
        }
        AcessoWebContato this$contato = this.getContato();
        AcessoWebContato other$contato = other.getContato();
        if (this$contato == null ? other$contato != null : !this$contato.equals(other$contato)) {
            return false;
        }
        String this$senha = this.getSenha();
        String other$senha = other.getSenha();
        if (this$senha == null ? other$senha != null : !this$senha.equals(other$senha)) {
            return false;
        }
        String this$codigoAcessoEsqueciMinhaSenha = this.getCodigoAcessoEsqueciMinhaSenha();
        String other$codigoAcessoEsqueciMinhaSenha = other.getCodigoAcessoEsqueciMinhaSenha();
        if (this$codigoAcessoEsqueciMinhaSenha == null ? other$codigoAcessoEsqueciMinhaSenha != null : !this$codigoAcessoEsqueciMinhaSenha.equals(other$codigoAcessoEsqueciMinhaSenha)) {
            return false;
        }
        LocalDate this$dataLimiteAcessoEsqueciMinhaSenha = this.getDataLimiteAcessoEsqueciMinhaSenha();
        LocalDate other$dataLimiteAcessoEsqueciMinhaSenha = other.getDataLimiteAcessoEsqueciMinhaSenha();
        if (this$dataLimiteAcessoEsqueciMinhaSenha == null ? other$dataLimiteAcessoEsqueciMinhaSenha != null : !((Object)this$dataLimiteAcessoEsqueciMinhaSenha).equals(other$dataLimiteAcessoEsqueciMinhaSenha)) {
            return false;
        }
        LocalDate this$dataCadastro = this.getDataCadastro();
        LocalDate other$dataCadastro = other.getDataCadastro();
        if (this$dataCadastro == null ? other$dataCadastro != null : !((Object)this$dataCadastro).equals(other$dataCadastro)) {
            return false;
        }
        List this$acessoWebTipoPermissao = this.getAcessoWebTipoPermissao();
        List other$acessoWebTipoPermissao = other.getAcessoWebTipoPermissao();
        if (this$acessoWebTipoPermissao == null ? other$acessoWebTipoPermissao != null : !((Object)this$acessoWebTipoPermissao).equals(other$acessoWebTipoPermissao)) {
            return false;
        }
        Boolean this$ativo = this.getAtivo();
        Boolean other$ativo = other.getAtivo();
        if (this$ativo == null ? other$ativo != null : !((Object)this$ativo).equals(other$ativo)) {
            return false;
        }
        String this$codigoAlteracaoSenha = this.getCodigoAlteracaoSenha();
        String other$codigoAlteracaoSenha = other.getCodigoAlteracaoSenha();
        if (this$codigoAlteracaoSenha == null ? other$codigoAlteracaoSenha != null : !this$codigoAlteracaoSenha.equals(other$codigoAlteracaoSenha)) {
            return false;
        }
        Boolean this$administrador = this.administrador;
        Boolean other$administrador = other.administrador;
        return !(this$administrador == null ? other$administrador != null : !((Object)this$administrador).equals(other$administrador));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AcessoWeb;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $cpf = this.getCpf();
        result = result * 59 + ($cpf == null ? 43 : $cpf.hashCode());
        LocalDate $dataNascimento = this.getDataNascimento();
        result = result * 59 + ($dataNascimento == null ? 43 : ((Object)$dataNascimento).hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        String $rg = this.getRg();
        result = result * 59 + ($rg == null ? 43 : $rg.hashCode());
        String $orgaoEmissor = this.getOrgaoEmissor();
        result = result * 59 + ($orgaoEmissor == null ? 43 : $orgaoEmissor.hashCode());
        String $ufEmissor = this.getUfEmissor();
        result = result * 59 + ($ufEmissor == null ? 43 : $ufEmissor.hashCode());
        String $identificacaoProfissional = this.getIdentificacaoProfissional();
        result = result * 59 + ($identificacaoProfissional == null ? 43 : $identificacaoProfissional.hashCode());
        String $tipoConselho = this.getTipoConselho();
        result = result * 59 + ($tipoConselho == null ? 43 : $tipoConselho.hashCode());
        AcessoWebEndereco $endereco = this.getEndereco();
        result = result * 59 + ($endereco == null ? 43 : $endereco.hashCode());
        AcessoWebContato $contato = this.getContato();
        result = result * 59 + ($contato == null ? 43 : $contato.hashCode());
        String $senha = this.getSenha();
        result = result * 59 + ($senha == null ? 43 : $senha.hashCode());
        String $codigoAcessoEsqueciMinhaSenha = this.getCodigoAcessoEsqueciMinhaSenha();
        result = result * 59 + ($codigoAcessoEsqueciMinhaSenha == null ? 43 : $codigoAcessoEsqueciMinhaSenha.hashCode());
        LocalDate $dataLimiteAcessoEsqueciMinhaSenha = this.getDataLimiteAcessoEsqueciMinhaSenha();
        result = result * 59 + ($dataLimiteAcessoEsqueciMinhaSenha == null ? 43 : ((Object)$dataLimiteAcessoEsqueciMinhaSenha).hashCode());
        LocalDate $dataCadastro = this.getDataCadastro();
        result = result * 59 + ($dataCadastro == null ? 43 : ((Object)$dataCadastro).hashCode());
        List $acessoWebTipoPermissao = this.getAcessoWebTipoPermissao();
        result = result * 59 + ($acessoWebTipoPermissao == null ? 43 : ((Object)$acessoWebTipoPermissao).hashCode());
        Boolean $ativo = this.getAtivo();
        result = result * 59 + ($ativo == null ? 43 : ((Object)$ativo).hashCode());
        String $codigoAlteracaoSenha = this.getCodigoAlteracaoSenha();
        result = result * 59 + ($codigoAlteracaoSenha == null ? 43 : $codigoAlteracaoSenha.hashCode());
        Boolean $administrador = this.administrador;
        result = result * 59 + ($administrador == null ? 43 : ((Object)$administrador).hashCode());
        return result;
    }
}

