select row_number() over (order by t.nrCredito, t.nrAnocredito) as linha,
       t.idTceLancCredito,
	     t.nrCredito,
       t.nrAnoCredito,
       t.idTipoNaturezaCredito,
       t.idTipoCredito,
       t.idTipoOperacaoCredito,
       t.dtLancamento,
       t.nrMesbase,
       t.nrAnoBase,
       t.cdControleLeiAto,
       c.idtce,
       c.idtipoescopolei,
       t.vlLancamento
from tceLancCredito t
left join cgato c on c.entidade = :entidade and c.idato = t.cdControleLeiAto
where ((t.dtLancamento between :dataInicial and :dataFinal) or
       (extract(year from cast(:dataInicial as date)) = 2022
        and extract(month from cast(:dataInicial as date)) = 1
        and t.dtLancamento < :dataInicial))
order by t.nrCredito, t.nrAnocredito