select
    idTipoOperacaoCredito,
    idTipoNaturezaCredito,
    idTipoCredito,
    dtInscricao,
    vlInscricao,
    idDebitoParcelaTributoDestino,
    formaCorrecao,
    idDivida,
    entidade,
    exercicio,
    nrAnoBase,
    cdControleLeiAto,
    nrCredito,
    nrAnoCredito,
    datadividaativa,
    idDevolucaoCredito,
    sequenciaItem,
    sequenciaDebito
from (
select w.idtipooperacaocredito,w.idtiponaturezacredito,w.idtipocredito,w.dtinscricao,w.vlinscricao,w.iddebitoparcelatributodestino,w.formacorrecao,w.iddivida,w.entidade,w.exercicio,w.nranobase,w.cdcontroleleiato,w.nrcredito,w.nranocredito,w.datadividaativa,w.iddevolucaocredito,w.sequenciaitem,w.sequenciadebito
from (
select x.idtipooperacaocredito,x.idtiponaturezacredito,x.idtipocredito,x.dtinscricao,x.vlinscricao,x.iddebitoparcelatributodestino,x.formacorrecao,x.iddivida,
       x.entidade,x.exercicio,x.tipocadastro,x.cadastrogeral,x.guiarecolhimento,x.subdivida,x.parcela,x.receita,
       x.nranobase,x.cdcontroleleiato,x.nrcredito,x.nranocredito,x.datadividaativa,x.iddevolucaocredito,x.sequenciaitem,x.sequenciadebito,
       row_number() over (partition by x.entidade,x.exercicio,x.tipocadastro,x.cadastrogeral,x.guiarecolhimento,x.subdivida,x.parcela,x.receita,x.nrcredito,x.nranocredito order by x.iddebitoparcelatributodestino) as ocorrencia
from (
select distinct
    3                                                   as idTipoOperacaoCredito,
    null                                                as idTipoNaturezaCredito,
    tcrt.classificacaoreceitatipo                       as idTipoCredito,
    tlr.datainscricao                                   as dtInscricao,
    tdprd.valororiginal                                 as vlInscricao,
    tdprd.iddebitoparcelareceita                        as idDebitoParcelaTributoDestino,
    td.formacorrecao                                    as formaCorrecao,
    tgr.idkey                                           as idDivida,
    td.entidade                                         as entidade,
    td.exercicio                                        as exercicio,
    td.tipocadastro, td.cadastrogeral, td.guiarecolhimento, td.subdivida, tdprd.parcela, tdprd.receita,
    null                                                as nrAnoBase,
    tgr.fundamentolegal                                 as cdControleLeiAto,
    tlc.nrCredito,
    tlc.nrAnoCredito,
    tdpd.datadividaativa,
    0 												    as idDevolucaoCredito,
    null::numeric as sequenciaItem,
    null::numeric as sequenciaDebito
from triblivro tl
left outer join triblivroregistro tlr
 on tlr.entidade = tl.entidade
and tlr.exercicio = tl.exercicio
and tlr.livro = tl.livro
left outer join triblivroparcelareceita tlpr
 on tlpr.entidade = tlr.entidade
and tlpr.exercicio = tlr.exercicio
and tlpr.livro = tlr.livro
and tlpr.sequencia = tlr.sequencia
left outer join tribdebitoparcelareceita tdpr -- origem
 on tdpr.iddebitoparcelareceita = tlpr.iddebitoparcelareceita
left outer join tribdebitoreceita tdr
 on tdpr.entidade         = tdr.entidade
and tdpr.exercicio        = tdr.exercicio
and tdpr.tipocadastro     = tdr.tipocadastro
and tdpr.cadastrogeral    = tdr.cadastrogeral
and tdpr.guiarecolhimento = tdr.guiarecolhimento
and tdpr.subdivida        = tdr.subdivida
and tdpr.receita          = tdr.receita
left outer join tribdebito td
 on tdpr.entidade = td.entidade
and tdpr.exercicio = td.exercicio
and tdpr.tipocadastro = td.tipocadastro
and tdpr.cadastrogeral = td.cadastrogeral
and tdpr.guiarecolhimento = td.guiarecolhimento
and tdpr.subdivida = td.subdivida
left outer join tribreceita tr
 on tdr.entidade  = tr.entidade
and :exercicio = tr.exercicio
and tdr.receita   = tr.receita
join tribguiarecolhimento tgr
  on td.entidade = tgr.entidade
and td.exercicio = tgr.exercicio
and td.guiarecolhimento = tgr.guiarecolhimento
join tribdebitoparcelareceita tdprd
  on tdprd.entidade = tdpr.entidade
and tdprd.exercicio = tdpr.exercicio
and tdprd.tipocadastro = tdpr.tipocadastro -- destino
and tdprd.cadastrogeral = tdpr.cadastrogeral
and tdprd.guiarecolhimento = tdpr.guiarecolhimento
and tdprd.receita = tdpr.receita
and (
      	(tl.englobaparcelas = 'S'
      		and (tgr.tipoguiarecolhimento <> 'H' or tgr.subdividapelovencimento = 'S')
      		and tdprd.subdivida = tlpr.novasubdivida
      	)
      	or
      	((tl.englobaparcelas = 'N' or tgr.tipoguiarecolhimento = 'H')
      		and tdprd.parcela = tdpr.parcela
      		and tdprd.subdivida = tdpr.subdivida
      	)
    )
join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
join tribdebitoparcela tdpd
  on tdpd.entidade = tdprd.entidade
      and tdpd.exercicio = tdprd.exercicio
      and tdpd.tipocadastro = tdprd.tipocadastro /*DebitoParcela Destino*/
      and tdpd.cadastrogeral = tdprd.cadastrogeral
      and tdpd.guiarecolhimento = tdprd.guiarecolhimento
      and tdpd.subdivida = tdprd.subdivida
      and tdpd.parcela = tdprd.parcela
left join tcedebitolanccredito tdl on tdl.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
left join tcelanccredito tlc on tlc.idtcelanccredito = tdl.idtcelanccredito
where tlr.datainscricao between :dataInicial and :dataFinal
  AND tdprd.valororiginal > 0
  and trt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
  and td.entidade = :entidade
  and tl.tipolivro = 'EFETIVO'
  and not exists (select 1
                  from triblivroestornoparcelareceita tlpre
                  inner join triblivroestorno tle on tlpre.idlivroestorno = tle.idlivroestorno
                  where tle.dataestorno = tl.datainclusao
                    and tlpr.entidade = tlpre.entidade
                    and tlpr.exercicio = tlpre.exercicio
                    and tlpr.livro = tlpre.livro
                    and tlpr.sequencia = tlpre.sequencia
                    and tlpr.iddebitoparcelareceita = tlpre.iddebitoparcelareceita)
) x) w
where w.ocorrencia = 1
  and not exists(select 1 from tceDebitoInscCreditoDA tdicDA
                 where tdicDA.iddebitoparcelareceita = w.iddebitoparcelatributodestino)
union all
select
                 tceinsccreditoda.idTipoOperacaoCredito,
				         null as idTipoNaturezaCredito,
                 tceinsccreditoda.idTipoCredito,
                 tceinsccreditoda.dtInscricao,
                 tceinsccreditoda.vlInscricao,
                 tceinsccreditoda.iddebitoparcelareceita,
                 tceinsccreditoda.formaCorrecao,
                 tceinsccreditoda.idDivida,
                 tceinsccreditoda.entidade,
                 tceinsccreditoda.exercicio,
                 null as nrAnoBase,
                 tceinsccreditoda.cdControleLeiAto,
                 null as nrCredito,
                 null as nrAnoCredito,
                 tceinsccreditoda.datadividaativa,
                 tceinsccreditoda.idDevolucaoCredito,
                 tceinsccreditoda.sequenciaItem,
                 tceinsccreditoda.sequenciaDebito
            from
            (
              select case when (tcrt.tributavel = 'S') then 1 else 2 end as idTipoNaturezaCredito,
                   trt.classificacaoreceitatipo as idTipoCredito,
                   5 as idTipoOperacaoCredito,
                   d.data as dtInscricao,
                   dd.valordevolvido as vlInscricao,
                   tdpr.iddebitoparcelareceita,
                   tdp.exercicio as nrAnoBase,
                   tdp.datadividaativa,
                   tmd.idato as cdControleLeiAto,
                   0 as nrCredito,
                   0 as nrAnoCredito,
                   d.iddevolucaocredito as idDevolucaoCredito,
                   tgr.idkey as idDivida,
                   td.entidade,
    			   td.exercicio,
    			   td.formacorrecao,
    			   di.sequenciaitem as sequenciaItem,
    			   dd.sequenciadebito as sequenciaDebito
              from tribDevolucaoCredito            d
                 join tribDevolucaoCreditoItem     di   on di.iddevolucaocredito = d.iddevolucaocredito
                 join tribDevolucaoCreditoDebito   dd   on dd.iddevolucaocredito = di.iddevolucaocredito and dd.sequenciaitem = di.sequenciaitem
                 join tribDebitoParcelaReceita     tdpr on dd.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                 join tribdebitoparcela            tdp  on tdp.entidade  = tdpr.entidade and tdp.exercicio = tdpr.exercicio
                                                       and tdp.tipocadastro = tdpr.tipocadastro and tdp.cadastrogeral  = tdpr.cadastrogeral
                                                       and tdp.guiarecolhimento  = tdpr.guiarecolhimento and tdp.subdivida  = tdpr.subdivida
                                                       and tdp.parcela = tdpr.parcela
                 join tribreceita                  tr   on tr.entidade = :entidade
                                                       and tr.exercicio = :exercicio
                                                       and tr.receita = tdpr.receita
                 join tribreceitatipo              trt  on trt.tiporeceita = tr.tiporeceita
                 join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
                 join contabancaria                cb   on cb.entidade = d.entidade and cb.contabancaria = d.contabancaria
                 join tribmotivodesconto tmd on tmd.motivodesconto = d.motivodesconto
                 left outer join tribdebito td
 					          on tdpr.entidade = td.entidade
					          and tdpr.exercicio = td.exercicio
					          and tdpr.tipocadastro = td.tipocadastro
					          and tdpr.cadastrogeral = td.cadastrogeral
					          and tdpr.guiarecolhimento = td.guiarecolhimento
					          and tdpr.subdivida = td.subdivida
                 join tribguiarecolhimento tgr
  					        on td.entidade = tgr.entidade
      				      and td.exercicio = tgr.exercicio
      				      and td.guiarecolhimento = tgr.guiarecolhimento
                 join tribpagamentodebito tpd on tpd.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
              where d.entidade = :entidade
                and d.data between :dataInicial AND :dataFinal
                and d.tipo = 'N'
                and tpd.situacaoLegal in (1,2)
                and trt.classificacaoreceitatipo in (1,2,3,4,5,7)
                and coalesce(cb.integraarrecadacao, 'S') = 'S'
                and not exists (
                    select 1
                    from tcerestituicaoda rtda
                    where rtda.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                      and rtda.sequenciaitem = di.sequenciaitem
                      and rtda.sequenciadebito = dd.sequenciadebito
                )
            ) tceinsccreditoda
           ) tab
order by tab.datadividaativa,
         tab.nrcredito,
         tab.nrAnoCredito,
         tab.exercicio,
         tab.cdControleLeiAto