select distinct filtro.idTipoDeducaoCredito,
                filtro.dtDeducao,
                filtro.valor,
                filtro.dsMotivo,
                filtro.entidade,
                filtro.exercicio,
                filtro.idCancelamento,
                filtro.idpagamentobloqueto,
                filtro.iddebitoparcelareceita,
                filtro.idcreditocontribuinteitem,
                filtro.idAto as cdControleLeiAto,
                filtro.idTipoCredito,
                filtro.idParcelamento,
                filtro.idEstornoParcelamento,
                filtro.nrdivida,
                filtro.nranodivida,
                filtro.estornoPagamento
from (
--      /*cancelamento*/
         select ttd.tipotce                                                     as idTipoDeducaoCredito,
                cd.datacancelamento                                             as dtDeducao,
                tcdi.valor                                                      as valor,
                substr(md.descricao || '. ' || coalesce(cd.motivo, ''), 0, 250) as dsMotivo,
                tcdi.entidade,
                tcdi.exercicio,
                tcdi.idcancelamento,
                cast(null as integer)                                           as idpagamentobloqueto,
                tcdi.iddebitoparcelareceita,
                cast(null as integer)                                           as idcreditocontribuinteitem,
                tcrt.classificacaoreceitatipo                                   as idTipoCredito,
                md.idato,
                cast(null as integer)                                           as idParcelamento,
                cast(null as integer)                                           as idEstornoParcelamento,
                tic.nrdivida,
                tic.nranodivida,
                cast(null as integer)                                           as estornoPagamento
         from tribcancelamentodebito cd
                  join tribcancelamentodebitoitem tcdi
                       on tcdi.entidade = cd.entidade and tcdi.exercicio = cd.exercicio and
                          tcdi.idcancelamento = cd.idcancelamento
                  left join tribmotivodesconto md on md.motivodesconto = cd.motivocancelamento
                  left join tribtipodeducao ttd on ttd.tipodeducao = coalesce(md.tipodeducao, cd.tipodeducao)
                  join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tcdi.iddebitoparcelareceita
                  left join tribreceita tr on tr.entidade = :entidade
             and tr.exercicio = :exercicio
             and tr.receita = tdpr.receita
                  join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
                  join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
                  left join tcedebitoinsccreditoda tdida on tdpr.iddebitoparcelareceita = tdida.iddebitoparcelareceita
                  left join tceinsccreditoda tic on tdida.idtceinsccreditoda = tic.idtceinsccreditoda
                  left outer join tribdebito td
                                  on tdpr.entidade = td.entidade
                                      and tdpr.exercicio = td.exercicio
                                      and tdpr.tipocadastro = td.tipocadastro
                                      and tdpr.cadastrogeral = td.cadastrogeral
                                      and tdpr.guiarecolhimento = td.guiarecolhimento
                                      and tdpr.subdivida = td.subdivida
         where (cd.datacancelamento between :dataInicial and :dataFinal)
           and cd.entidade = :entidade
           and cd.tipoDeducao <> 8
           and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
           and tcdi.situacaolegal in (1, 2)
           and tcdi.valor > 0
           and ((tcdi.estornado = 'N' and tcdi.dataestorno is null)
             or (tcdi.estornado = 'S' and tcdi.dataestorno is not null and tcdi.dataestorno > cd.datacancelamento))
           and not exists (select 1
                           from tribestornoparcelamentodebito tepd
                                    left outer join tribestornoparcelamento tep
                                                    on tepd.idestornoparcelamento = tep.idestornoparcelamento
                           where (tepd.iddebitoorigem = td.iddebito and cd.datacancelamento = tep.dataestorno)
                              or (tepd.iddebitodestino = td.iddebito and tep.estornado = 'S' and
                                  cd.datacancelamento = tep.datareabilitacao))
           and not exists (select 1
                           from tceDeducaoCancelamentoDA tdcda
                           where tdcda.entidade = tcdi.entidade
                             and tdcda.exercicio = tcdi.exercicio
                             and tdcda.idcancelamento = tcdi.idcancelamento
                             and tdcda.iddebitoparcelareceita = tcdi.iddebitoparcelareceita)
           and not exists (select 1
                           from tribpgtonegociadodebitoorigem tpndo
                           where tpndo.entidade = tdpr.entidade
                             and tpndo.exercicio = tdpr.exercicio
                             and tpndo.tipocadastro = tdpr.tipocadastro
                             and tpndo.cadastrogeral = tdpr.cadastrogeral
                             and tpndo.guiarecolhimento = tdpr.guiarecolhimento
                             and tpndo.subdivida = tdpr.subdivida
                             and tpndo.parcela = tdpr.parcela)
         union all
--      /*pagamento*/
         select ttd.tipotce                                                            as idTipoDeducaoCredito,
                tp.datalancamento                                                      as dtDeducao,
                coalesce(tpd.valordescontoprincipal, 0) + coalesce(tpd.valordescontojuros, 0) + 
                coalesce(tpd.valordescontomulta, 0) + coalesce(tpd.valordescontocorrecao, 0) + 
                coalesce(tpd.valordescontojurosfinan, 0)                               as valor,
                substr(tmd.descricao || '. ' || coalesce(tbad.observacao, ''), 0, 250) as dsMotivo,
                tp.entidade,
                tp.exerciciopagamento                                                  as exercicio,
                cast(null as integer)                                                  as idcancelamento,
                tpd.idpagamentobloqueto,
                tpd.iddebitoparcelareceita,
                cast(null as integer)                                                  as idcreditocontribuinteitem,
                tcrt.classificacaoreceitatipo                                          as idTipoCredito,
                tmd.idato,
                cast(null as integer)                                                  as idParcelamento,
                cast(null as integer)                                                  as idEstornoParcelamento,
                tic.nrdivida,
                tic.nranodivida,
                cast(null as integer)                                                  as estornoPagamento
         from tribpagamentodebito tpd
                  join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                  join tribdebitoparcela tdp on tdp.entidade = tdpr.entidade and tdp.exercicio = tdpr.exercicio and
                                                tdp.tipocadastro = tdpr.tipocadastro
             and tdp.cadastrogeral = tdpr.cadastrogeral and tdp.guiarecolhimento = tdpr.guiarecolhimento
             and tdp.subdivida = tdpr.subdivida and tdp.parcela = tdpr.parcela
                  join tribpagamentobloqueto tpb on tpb.idpagamentobloqueto = tpd.idpagamentobloqueto
                  join tribpagamento tp
                       on tp.entidade = tpb.entidade and tp.exerciciopagamento = tpb.exerciciopagamento and
                          tp.pagamento = tpb.pagamento
                  left join tribbaixaautomaticadetalhe tbad
                            on tbad.entidade = tp.entidade and tbad.exerciciopagamento = tp.exerciciopagamento and
                               tbad.pagamento = tp.pagamento
                  left join tribmotivodesconto tmd on tmd.motivodesconto = tpb.motivodesconto
                  left join tribtipodeducao ttd on ttd.tipodeducao = tmd.tipodeducao
                  left join tribreceita tr on tr.entidade = :entidade
             and tr.exercicio = :exercicio
             and tr.receita = tdpr.receita
                  join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
                  join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
                  left join contabancaria cb on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
                  left join tcedebitoinsccreditoda tdida on tdpr.iddebitoparcelareceita = tdida.iddebitoparcelareceita
                  left join tceinsccreditoda tic on tdida.idtceinsccreditoda = tic.idtceinsccreditoda
         where tp.datalancamento between :dataInicial and :dataFinal
           and coalesce(cb.integraarrecadacao, 'S') = 'S'
           and tp.entidade = :entidade
           and (coalesce(tpd.valordescontoprincipal, 0) + coalesce(tpd.valordescontojuros, 0) + 
                coalesce(tpd.valordescontomulta, 0) + coalesce(tpd.valordescontocorrecao, 0) + 
                coalesce(tpd.valordescontojurosfinan, 0)) > 0
           and tpd.situacaolegal in (1, 2)
           and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
           and not exists (select 1
                           from tceDeducaoPagamentoDA tdpda
                           where tdpda.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                             and tdpda.idPagamentoBloqueto = tpd.idPagamentoBloqueto)
         union all
         /*Reabilitacao pagamento*/
         select ttd.tipotce                                                            as idTipoDeducaoCredito,
                tp.datalancamento                                                      as dtDeducao,
                coalesce(tpd.valordescontoprincipal, 0) + coalesce(tpd.valordescontojuros, 0) + 
                coalesce(tpd.valordescontomulta, 0) + coalesce(tpd.valordescontocorrecao, 0) + 
                coalesce(tpd.valordescontojurosfinan, 0)                               as valor,
                substr(tmd.descricao || '. ' || coalesce(tbad.observacao, ''), 0, 250) as dsMotivo,
                tep.entidade                                                           as entidade,
                tep.exercicio                                                          as exercicio,
                cast(null as integer)                                                  as idcancelamento,
                tpd.idpagamentobloqueto,
                tpd.iddebitoparcelareceita,
                cast(null as integer)                                                  as idcreditocontribuinteitem,
                tcrt.classificacaoreceitatipo                                          as idTipoCredito,
                tmd.idato,
                cast(null as integer)                                                  as idParcelamento,
                cast(null as integer)                                                  as idEstornoParcelamento,
                tic.nrdivida,
                tic.nranodivida,
                tep.estorno                                                            as estornoPagamento
         from tribpagamentodebito tpd
                  join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                  join tribdebitoparcela tdp on tdp.entidade = tdpr.entidade and tdp.exercicio = tdpr.exercicio and
                                                tdp.tipocadastro = tdpr.tipocadastro
             and tdp.cadastrogeral = tdpr.cadastrogeral and tdp.guiarecolhimento = tdpr.guiarecolhimento
             and tdp.subdivida = tdpr.subdivida and tdp.parcela = tdpr.parcela
                  join tribpagamentobloqueto tpb on tpb.idpagamentobloqueto = tpd.idpagamentobloqueto
                  join tribpagamento tp
                       on tp.entidade = tpb.entidade and tp.exerciciopagamento = tpb.exerciciopagamento and
                          tp.pagamento = tpb.pagamento
                  left join tribbaixaautomaticadetalhe tbad
                            on tbad.entidade = tp.entidade and tbad.exerciciopagamento = tp.exerciciopagamento and
                               tbad.pagamento = tp.pagamento
                  left join tribmotivodesconto tmd on tmd.motivodesconto = tpb.motivodesconto
                  left join tribtipodeducao ttd on ttd.tipodeducao = tmd.tipodeducao
                  left join tribreceita tr on tr.entidade = :entidade
             and tr.exercicio = :exercicio
             and tr.receita = tdpr.receita
                  join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
                  join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
                  left join contabancaria cb on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
                  left join tcedebitoinsccreditoda tdida on tdpr.iddebitoparcelareceita = tdida.iddebitoparcelareceita
                  left join tceinsccreditoda tic on tdida.idtceinsccreditoda = tic.idtceinsccreditoda
                  left join tribestornopagamento tep
                            on tep.entidade = tp.entidade and tep.exerciciopagamento = tp.exerciciopagamento
                                and tep.pagamento = tp.pagamento
         where tep.datareabilitacao is not null
           and tep.datareabilitacao between :dataInicial and :dataFinal
           and tep.datareabilitacao <> tep.data
           and coalesce(cb.integraarrecadacao, 'S') = 'S'
           and tp.entidade = :entidade
           and (coalesce(tpd.valordescontoprincipal, 0) + coalesce(tpd.valordescontojuros, 0) + 
                coalesce(tpd.valordescontomulta, 0) + coalesce(tpd.valordescontocorrecao, 0) + 
                coalesce(tpd.valordescontojurosfinan, 0)) > 0
           and tpd.situacaolegal in (1, 2)
           and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
           and not exists (select 1
                           from tcededucaopagamentoreab dcpr
                           where dcpr.exercicio = tep.exercicio
                             and dcpr.entidade = tep.entidade
                             and dcpr.estorno = tep.estorno
                             and dcpr.idpagamentobloqueto = tpd.idpagamentobloqueto
                             and dcpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita)
         union all
--      /*Credito*/
         select ttd.tipotce                   as idTipoDeducaoCredito,
                tcc.data                      as dtDeducao,
                tcci.valordesconto            as valor,
                substr(tmd.descricao, 0, 250) as dsMotivo,
                tcc.entidade,
                tcc.exercicio,
                cast(null as integer)         as idcancelamento,
                cast(null as integer)         as idpagamentobloqueto,
                tcci.iddebitoparcelareceita,
                tcci.idcreditocontribuinteitem,
                tcrt.classificacaoreceitatipo as idTipoCredito,
                tmd.idato,
                cast(null as integer)         as idParcelamento,
                cast(null as integer)         as idEstornoParcelamento,
                tic.nrdivida,
                tic.nranodivida,
                cast(null as integer)         as estornoPagamento
         from tribcreditocontribuinte tcc
                  join tribCreditoContribuinteItem tcci
                       on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and
                          tcci.creditocontribuinte = tcc.creditocontribuinte
                  join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
                  join tribdebitoparcela tdp on tdp.entidade = tdpr.entidade and tdp.exercicio = tdpr.exercicio and
                                                tdp.tipocadastro = tdpr.tipocadastro
             and tdp.cadastrogeral = tdpr.cadastrogeral and tdp.guiarecolhimento = tdpr.guiarecolhimento
             and tdp.subdivida = tdpr.subdivida and tdp.parcela = tdpr.parcela
                  join tribbloqueto tb
                       on tb.entidade = tcc.entidade and tb.exerciciobloqueto = tcc.exerciciobloqueto and
                          tb.bloqueto = tcc.bloqueto
                  left join tribGuiaRecolhimentoFormaPag tgrfp on tgrfp.entidade = :entidade
             and tgrfp.guiarecolhimento = tdpr.guiarecolhimento and tgrfp.formapagamento = tb.formapagamento
                  left join tribreceita tr on tr.entidade = :entidade
             and tr.exercicio = :exercicio
             and tr.receita = tdpr.receita
                  join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
                  join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
                  left join tribMotivoDesconto tmd
                            on tmd.motivodesconto = coalesce(tgrfp.motivodesconto, tb.motivodesconto)
                  left join tribTipoDeducao ttd on ttd.tipodeducao = tmd.tipodeducao
                  left join contabancaria cb on cb.entidade = tcc.entidade and cb.contabancaria = tcc.contabancaria
                  left join tcedebitoinsccreditoda tdida on tdpr.iddebitoparcelareceita = tdida.iddebitoparcelareceita
                  left join tceinsccreditoda tic on tdida.idtceinsccreditoda = tic.idtceinsccreditoda
         WHERE tcc.entidade = :entidade
           AND tcc.data BETWEEN :dataInicial AND :dataFinal
           and coalesce(cb.integraarrecadacao, 'S') = 'S'
           and tcci.valordesconto > 0
           and tdp.situacaolegal in (1, 2)
           and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
           and not exists (select 1
                           from tceDeducaoCreditoCreditoDA tdcc
                           where tdcc.idCreditoContribuinteItem = tcci.idcreditocontribuinteitem
                             and tdcc.idDebitoParcelaReceita = tcci.idDebitoParcelaReceita)
         union all
         /*Dedução parcelamento DA*/
         select ttd.tipotce                                                                  as idTipoDeducaoCredito,
                tp.dataparcelamento                                                          as dtDeducao,
                case
                    when valores.parcela = valores.max_parcela then
                        valores.valordescontoprincipal + valores.valordescontojuros +
                        valores.valordescontomulta + valores.valordescontocorrecao -
                        coalesce((select sum(v.rateio_desconto_principal + v.rateio_desconto_juros +
                                             v.rateio_desconto_multa + v.rateio_desconto_correcao)
                                  from vw_desconto_parcelamento v
                                  where v.idparcelamento = tp.idparcelamento
                                    and v.iddebito = valores.iddebito
                                    and v.receitaorigem = valores.receitaorigem
                                    and v.parcela <> valores.parcela), 0)
                    else
                        valores.rateio_desconto_principal + valores.rateio_desconto_juros +
                        valores.rateio_desconto_multa + valores.rateio_desconto_correcao end as valor,
                substr(tmd.descricao, 0, 250)                                                as dsMotivo,
                td.entidade,
                td.exercicio,
                cast(null as integer)                                                        as idcancelamento,
                cast(null as integer)                                                        as idpagamentobloqueto,
                valores.iddebitoparcelareceita                                               as iddebitoparcelareceita,
                cast(null as integer)                                                        as idcreditocontribuinteitem,
                trt.classificacaoreceitatipo                                                 as idtipocredito,
                tmd.idato,
                tp.idparcelamento,
                cast(null as integer)                                                        as idEstornoParcelamento,
                tida.nrdivida,
                tida.nranodivida,
                cast(null as integer)                                                        as estornoPagamento
         from tribparcelamento tp
                  left join vw_desconto_parcelamento valores on tp.idparcelamento = valores.idparcelamento
                  left join tribdebito td on valores.iddebito = td.iddebito
                  left join tcedebitoinsccreditoda tdida
                            on tdida.iddebitoparcelareceita = valores.iddebitoparcelareceita
                  left join tceinsccreditoda tida on tdida.idtceinsccreditoda = tida.idtceinsccreditoda
                  left join tribreceita tr
                            on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = valores.receita
                  left join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
                  left join tribclassificacaoreceitatipo tcrt
                            on trt.classificacaoreceitatipo = tcrt.classificacaoreceitatipo
                  join tribParamParcelamento tpp on tpp.idparametroparcelamento = tp.idparametroparcelamento
                  left join tribmotivodesconto tmd on tmd.motivodesconto = tpp.motivodesconto
                  left join tribtipodeducao ttd on ttd.tipodeducao = tmd.tipodeducao
         where tp.dataparcelamento between :dataInicial and :dataFinal
           and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
           and not exists(select 1
                          from tcededucaoparcda tdpda
                          where tdpda.idparcelamento = tp.idparcelamento
                            and tdpda.iddebitoparcelareceita = valores.iddebitoparcelareceita)
           and valores.situacaolegal in (1, 2)
         union all
         /* Reabilitação de estorno de parcelamento que foi para a proxima subdivida */
         select ttd.tipotce                                                                  as idTipoDeducaoCredito,
                tep.datareabilitacao                                                         as dtDeducao,
                case
                    when valores.parcela = valores.max_parcela then
                        valores.valordescontoprincipal + valores.valordescontojuros +
                        valores.valordescontomulta + valores.valordescontocorrecao -
                        coalesce((select sum(v.rateio_desconto_principal + v.rateio_desconto_juros +
                                             v.rateio_desconto_multa + v.rateio_desconto_correcao)
                                  from vw_desc_parcelamento_prox_sub v
                                  where v.idparcelamento = tp.idparcelamento
                                    and v.iddebito = valores.iddebito
                                    and v.receitaorigem = valores.receitaorigem
                                    and v.parcela <> valores.parcela), 0)
                    else
                        valores.rateio_desconto_principal + valores.rateio_desconto_juros +
                        valores.rateio_desconto_multa + valores.rateio_desconto_correcao end as valor,
                substr(tmd.descricao, 0, 250)                                                as dsMotivo,
                td.entidade,
                td.exercicio,
                cast(null as integer)                                                        as idcancelamento,
                cast(null as integer)                                                        as idpagamentobloqueto,
                valores.iddebitoparcelareceita                                               as iddebitoparcelareceita,
                cast(null as integer)                                                        as idcreditocontribuinteitem,
                trt.classificacaoreceitatipo                                                 as idtipocredito,
                tmd.idato,
                tep.idparcelamento,
                tep.idestornoparcelamento,
                tida.nrdivida,
                tida.nranodivida,
                cast(null as integer)                                                        as estornoPagamento
         from tribestornoparcelamento tep
                  left join tribparcelamento tp on tep.idparcelamento = tp.idparcelamento
                  left join vw_desc_parcelamento_prox_sub valores on tp.idparcelamento = valores.idparcelamento
                  left join tribdebito td on valores.iddebito = td.iddebito
                  left join tcedebitoinsccreditoda tdida
                            on tdida.iddebitoparcelareceita = valores.iddebitoparcelareceita
                  left join tceinsccreditoda tida on tdida.idtceinsccreditoda = tida.idtceinsccreditoda
                  left join tribreceita tr
                            on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = valores.receita
                  left join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
                  left join tribclassificacaoreceitatipo tcrt
                            on trt.classificacaoreceitatipo = tcrt.classificacaoreceitatipo
                  join tribParamParcelamento tpp on tpp.idparametroparcelamento = tp.idparametroparcelamento
                  left join tribmotivodesconto tmd on tmd.motivodesconto = tpp.motivodesconto
                  left join tribtipodeducao ttd on ttd.tipodeducao = tmd.tipodeducao
         where tep.datareabilitacao between :dataInicial and :dataFinal
           and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
           and exists(select 1
                      from tribestornoparcelamentodebito tepd
                      where tepd.idestornoparcelamento = tep.idestornoparcelamento
                        and tepd.iddebitoorigem < tepd.iddebitodestino)
           and not exists(select 1
                          from tcededucaoparcreabilitada tdpda
                          where tdpda.iddebitoparcelareceita = valores.iddebitoparcelareceita
                            and tdpda.idestornoparcelamento = tep.idestornoparcelamento)
           and valores.situacaolegal in (1, 2)
           and tep.dataestorno <> tep.datareabilitacao
         /* Reabilitação de estorno de parcelamento que voltou para a origem */
         UNION ALL
         select ttd.tipotce                                                                  as idTipoDeducaoCredito,
                tep.datareabilitacao                                                         as dtDeducao,
                case
                    when valores.parcela = valores.max_parcela then
                        valores.valordescontoprincipal + valores.valordescontojuros +
                        valores.valordescontomulta + valores.valordescontocorrecao -
                        coalesce((select sum(v.rateio_desconto_principal + v.rateio_desconto_juros +
                                             v.rateio_desconto_multa + v.rateio_desconto_correcao)
                                  from vw_desconto_parcelamento v
                                  where v.idparcelamento = tp.idparcelamento
                                    and v.iddebito = valores.iddebito
                                    and v.receitaorigem = valores.receitaorigem
                                    and v.parcela <> valores.parcela), 0)
                    else
                        valores.rateio_desconto_principal + valores.rateio_desconto_juros +
                        valores.rateio_desconto_multa + valores.rateio_desconto_correcao end as valor,
                substr(tmd.descricao, 0, 250)                                                as dsMotivo,
                td.entidade,
                td.exercicio,
                cast(null as integer)                                                        as idcancelamento,
                cast(null as integer)                                                        as idpagamentobloqueto,
                valores.iddebitoparcelareceita                                               as iddebitoparcelareceita,
                cast(null as integer)                                                        as idcreditocontribuinteitem,
                trt.classificacaoreceitatipo                                                 as idtipocredito,
                tmd.idato,
                tep.idparcelamento,
                tep.idestornoparcelamento,
                tida.nrdivida,
                tida.nranodivida,
                cast(null as integer)                                                        as estornoPagamento
         from tribestornoparcelamento tep
                  left join tribparcelamento tp on tep.idparcelamento = tp.idparcelamento
                  left join vw_desconto_parcelamento valores on tp.idparcelamento = valores.idparcelamento
                  left join tribdebito td on valores.iddebito = td.iddebito
                  left join tcedebitoinsccreditoda tdida
                            on tdida.iddebitoparcelareceita = valores.iddebitoparcelareceita
                  left join tceinsccreditoda tida on tdida.idtceinsccreditoda = tida.idtceinsccreditoda
                  left join tribreceita tr
                            on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = valores.receita
                  left join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
                  left join tribclassificacaoreceitatipo tcrt
                            on trt.classificacaoreceitatipo = tcrt.classificacaoreceitatipo
                  join tribParamParcelamento tpp on tpp.idparametroparcelamento = tp.idparametroparcelamento
                  left join tribmotivodesconto tmd on tmd.motivodesconto = tpp.motivodesconto
                  left join tribtipodeducao ttd on ttd.tipodeducao = tmd.tipodeducao
         where tep.datareabilitacao between :dataInicial and :dataFinal
           and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
           and exists(select 1
                      from tribestornoparcelamentodebito tepd
                      where tepd.idestornoparcelamento = tep.idestornoparcelamento
                        and tepd.iddebitoorigem > tepd.iddebitodestino)
           and not exists(select 1
                          from tcededucaoparcreabilitada tdpda
                          where tdpda.iddebitoparcelareceita = valores.iddebitoparcelareceita
                            and tdpda.idestornoparcelamento = tep.idestornoparcelamento)
           and valores.situacaolegal in (1, 2)
           and tep.dataestorno <> tep.datareabilitacao) filtro

order by filtro.nrdivida, filtro.nranodivida, filtro.idTipoDeducaoCredito, filtro.idAto, filtro.dtDeducao;