/*Cancelamento*/
select a.idtcededucaocredito as id,
       a.nrdeducao,
       a.nranodeducao,
       a.nranocredito,
       a.nrcredito,
       a.idtipodeducaocredito,
       a.cdControleLeiAto,
       a.dtdeducao,
       case
           when count(distinct md.motivodesconto) > 1 then 'Motivos: ' || string_agg(cast(md.motivodesconto as varchar),',')
           else string_agg(substr(md.descricao || '. ' || coalesce(cd.motivo, ''), 0, 250),',')
           end as dsMotivo,
       sum(coalesce(tcdi.valorAtualizado, tcdi.valor)) as valor
from tcededucaocredito a
         join tcededucaocancelamento b
              on a.idtcededucaocredito = b.idtcededucaocredito
         join tribcancelamentodebitoitem tcdi
              on tcdi.entidade = b.entidade
                  and tcdi.exercicio = b.exercicio
                  and tcdi.idcancelamento = b.idcancelamento
                  and tcdi.iddebitoparcelareceita = b.iddebitoparcelareceita
         join tribcancelamentodebito cd
              on cd.entidade = tcdi.entidade
                  and cd.exercicio = tcdi.exercicio
                  and cd.idcancelamento = tcdi.idcancelamento
         left join tribmotivodesconto md
                   on md.motivodesconto = cd.motivocancelamento
         left join tcedebitolanccredito tdlc
                   on b.iddebitoparcelareceita = tdlc.iddebitoparcelareceita
where (cd.datacancelamento between :dataInicial and :dataFinal) and cd.entidade = :entidade
group by a.nranocredito, a.nrcredito, a.idtipodeducaocredito, a.cdControleLeiAto, a.dtdeducao,
         a.idtcededucaocredito, a.nrdeducao, a.nranodeducao
union all
/*Pagamento*/
select a.idtcededucaocredito as id,
       a.nrdeducao,
       a.nranodeducao,
       a.nranocredito,
       a.nrcredito,
       a.idtipodeducaocredito,
       a.cdControleLeiAto,
       a.dtdeducao,
       case
           when count(distinct tpb.motivodesconto) > 1 then 'Motivos: ' || string_agg(cast(tpb.motivodesconto as varchar),',')
           else string_agg(substr(md.descricao  || '. ' || coalesce(tbad.observacao, ''), 0, 250),',')
           end as dsMotivo,
       sum(tpd.valordesconto) as valor
from tcededucaocredito a
         join tcededucaopagamento b
              on a.idtcededucaocredito = b.idtcededucaocredito
         join tribpagamentodebito tpd
              on tpd.idpagamentobloqueto  = b.idpagamentobloqueto
                  and tpd.iddebitoparcelareceita = b.iddebitoparcelareceita
         join tribpagamentobloqueto tpb
              on tpb.idpagamentobloqueto  = tpd.idpagamentobloqueto
         join tribpagamento tp
              on tp.entidade = tpb.entidade
                  and tp.exerciciopagamento = tpb.exerciciopagamento
                  and tp.pagamento = tpb.pagamento
         left join tribbaixaautomaticadetalhe tbad
                   on tbad.entidade = tp.entidade
                       and tbad.exerciciopagamento = tp.exerciciopagamento
                       and tbad.pagamento = tp.pagamento
         left join tribmotivodesconto md
                   on md.motivodesconto = tpb.motivodesconto
         left join tcedebitolanccredito tdlc
                   on tdlc.iddebitoparcelareceita = b.iddebitoparcelareceita
where tp.datalancamento between :dataInicial and :dataFinal and tp.entidade = :entidade
group by a.nranocredito, a.nrcredito, a.idtipodeducaocredito, a.cdControleLeiAto, a.dtdeducao,
         a.idtcededucaocredito, a.nrdeducao, a.nranodeducao
union all
/*Isenção*/
select
       x.id,
       x.nrdeducao,
       x.nranodeducao,
       x.nrcredito,
       x.nranocredito,
       x.idtipodeducaocredito,
       x.cdControleLeiAto,
       x.dtdeducao,
       case
           when count(distinct x.motivodesconto) > 1 then 'Motivos: ' || string_agg(distinct cast(x.motivodesconto as varchar),',')
           else string_agg(distinct substr(x.descricao, 0, 250),',')
           end as dsMotivo,
       sum(x.valor) as valor
from (
         select distinct
             a.idtcededucaocredito as id,
             a.nrdeducao,
             a.nranodeducao,
             a.nranocredito,
             a.nrcredito,
             a.idtipodeducaocredito,
             a.cdControleLeiAto,
             a.dtdeducao,
             i.motivodesconto,
             md.descricao,
             tdri.iddebitoreceitaisencao,
             tdri.valorisencao as valor
         from tcededucaocredito a
                  join tcededucaoisencao b
                       on a.idtcededucaocredito = b.idtcededucaocredito
                  join tribdebitoreceita tdr
                       on tdr.iddebitoreceita = b.iddebitoreceita
                  join tribdebitoparcelareceita tdpr
                       on tdpr.entidade = tdr.entidade
                           and tdpr.exercicio = tdr.exercicio
                           and tdpr.tipocadastro = tdr.tipocadastro
                           and tdpr.cadastrogeral = tdr.cadastrogeral
                           and tdpr.guiarecolhimento = tdr.guiarecolhimento
                           and tdpr.subdivida = tdr.subdivida
                           and tdpr.receita = tdr.receita
                  join tribdebitoreceitaisencao tdri
                       on tdr.entidade = tdri.entidade
                           and tdr.exercicio = tdri.exercicio
                           and tdr.tipocadastro = tdri.tipocadastro
                           and tdr.cadastrogeral = tdri.cadastrogeral
                           and tdr.guiarecolhimento = tdri.guiarecolhimento
                           and tdr.subdivida = tdri.subdivida
                           and tdr.receita = tdri.receita
                  join tribdebito td
                       on td.entidade = tdri.entidade
                           and td.exercicio = tdri.exercicio
                           and td.tipocadastro = tdri.tipocadastro
                           and td.cadastrogeral = tdri.cadastrogeral
                           and td.guiarecolhimento = tdri.guiarecolhimento
                           and td.subdivida = tdri.subdivida
                  join tribisencao i
                       on i.isencao = tdri.isencao
                  left join tribmotivodesconto md
                            on md.motivodesconto = i.motivodesconto
                  left join tcedebitolanccredito tdlc
                            on tdlc.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
         where td.datalancamento between :dataInicial and :dataFinal and td.entidade = :entidade
     ) x
group by x.nranocredito, x.nrcredito, x.idtipodeducaocredito, x.cdControleLeiAto, x.dtdeducao,
         x.id, x.nrdeducao, x.nranodeducao
union all
/*Crédito*/
select a.idtcededucaocredito as id,
       a.nrdeducao,
       a.nranodeducao,
       a.nranocredito,
       a.nrcredito,
       a.idtipodeducaocredito,
       a.cdControleLeiAto,
       a.dtdeducao,
       case
           when count(distinct md.motivodesconto) > 1 then 'Motivos: ' || string_agg(distinct cast(md.motivodesconto as varchar),',')
           else string_agg(substr(md.descricao, 0, 250),',')
           end as dsMotivo,
       sum(tcci.valordesconto) as valor
from tcededucaocredito a
         join tcededucaocreditocredito b
              on a.idtcededucaocredito = b.idtcededucaocredito
         join tribCreditoContribuinteItem tcci
              on tcci.idcreditocontribuinteitem = b.idcreditocontribuinteitem
                  and tcci.iddebitoparcelareceita = b.iddebitoparcelareceita
         join tribcreditocontribuinte tcc
              on tcci.entidade = tcc.entidade
                  and tcci.exercicio = tcc.exercicio
                  and tcci.creditocontribuinte = tcc.creditocontribuinte
         join tribdebitoparcelareceita tdpr
              on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
         join tribbaixaautomaticadetalhe tbad
              on tcc.entidade = tbad.entidade
                  and tcc.exercicio = tbad.exerciciocredito
                  and tcc.creditocontribuinte = tbad.creditocontribuinte
         join tribbloqueto tb
              on tb.entidade = tbad.entidade
                  and tb.exerciciobloqueto = tbad.exerciciobloqueto
                  and tb.bloqueto = tbad.bloqueto
         join tribGuiaRecolhimentoFormaPag tgrfp
              on tgrfp.entidade = tdpr.entidade
                  and tgrfp.exercicio = tdpr.exercicio
                  and tgrfp.guiarecolhimento = tdpr.guiarecolhimento
                  and tgrfp.formapagamento = tb.formapagamento
         left join tribMotivoDesconto md
                   on md.motivodesconto = coalesce(tgrfp.motivodesconto, tb.motivodesconto)
         left join tcedebitolanccredito tdlc
                   on b.iddebitoparcelareceita = tdlc.iddebitoparcelareceita
where tcc.entidade = :entidade and tcc.datacredito between :dataInicial and :dataFinal
group by a.nranocredito, a.nrcredito, a.idtipodeducaocredito, a.cdControleLeiAto, a.dtdeducao,
         a.idtcededucaocredito, a.nrdeducao, a.nranodeducao
order by 1