select * from
(
select filtro.nrdivida,
       filtro.nranodivida,
       filtro.idTipoCredito,
       coalesce(( select coalesce(sum(coalesce(saldo.valorSoma,0)),0) as ValorSoma
       from
       (
          select  icd.nrdivida,
                  icd.nranodivida,
                  icd.idTipoCredito,
                  coalesce(sum(coalesce(icd.vlinscricao,0)),0) as valorSoma
          from tceInscCreditoDA     icd
          where (extract(year from cast(:dataSaldo as date)) = :exercicioImplantacao
                  and extract(month from cast(:dataSaldo as date)) = 1
                  and icd.dtInscricao < :dataSaldo)
          group by icd.nrdivida,
                   icd.nranodivida,
                   icd.idTipoCredito
          union all
          select icd.nrdivida,
                 icd.nranodivida,
                 icd.idTipoCredito,
                 coalesce(sum(coalesce(icd.vlinscricao,0)),0) as valorSoma
          from tceInscCreditoDA icd
          where icd.dtInscricao >= :dataSaldo and icd.dtInscricao < :dataInicial
          group by icd.nrdivida,
                   icd.nranodivida,
                   icd.idTipoCredito
          union all
          select icd.nrdivida,
                 icd.nranodivida,
                 icd.idTipoCredito,
                 coalesce(sum(coalesce(icde.vlestorno,0)*-1),0) as valorSoma
          from tceInscCreditoDAEst icde
          join tceInscCreditoDA    icd on icd.nrDivida = icde.nrDivida and icd.nrAnoDivida = icde.nrAnoDivida
          where icde.dtEstorno >= :dataSaldo and icde.dtEstorno < :dataInicial
          group by icd.nrdivida,
                   icd.nranodivida,
                   icd.idTipoCredito
          union all
          select tam.nrdivida,
                 tam.nranodivida,
                 tam.idTipoCredito,
                 coalesce(sum(coalesce(tam.vlatualizacao,0)),0) as valorSoma
          from tceAtualizaMoneCredda tam
          where tam.dtatualizacao >= :dataSaldo and tam.dtatualizacao < :dataInicial
          group by tam.nrdivida,
                   tam.nranodivida,
                   tam.idTipoCredito
          union all
          select tamc.nrdivida,
                 tamc.nranodivida,
                 tamc.idTipoCredito,
                 coalesce(sum(coalesce(tam.vlestorno,0) *-1),0) as valorSoma
          from tceAtualizaMoneCreddaEst tam
          join tceatualizaMoneCredda    tamc  on tamc.nratualizacao = tam.nratualizacao and tamc.nranoatualizacao = tam.nranoatualizacao
          where tam.dtEstorno >= :dataSaldo and tam.dtEstorno < :dataInicial
          group by tamc.nrdivida,
                   tamc.nranodivida,
                   tamc.idTipoCredito
          union all
          select tdc.nrdivida,
                 tdc.nranodivida,
                 tdc.idTipoCredito,
                 coalesce(sum(coalesce(tdc.vldeducao,0)*-1),0) as valorSoma
          from tceDeducaoCreditoda  tdc
            where tdc.dtDeducao >= :dataSaldo and tdc.dtDeducao < :dataInicial
          group by tdc.nrdivida,
                   tdc.nranodivida,
                   tdc.idTipoCredito
          union all
          select tdco.nrdivida,
                 tdco.nranodivida,
                 tdco.idTipoCredito,
                 coalesce(sum(coalesce(tdc.vlestorno,0)),0) as valorSoma
          from tceDeducaoCreditodaEst tdc
          join tceDeducaoCreditoda    tdco  on tdco.nrdeducao = tdc.nrdeducao
          where tdc.dtEstorno >= :dataSaldo and tdc.dtEstorno < :dataInicial
          group by tdco.nrdivida,
                   tdco.nranodivida,
                   tdco.idTipoCredito
          union all
          select atc.nrdivida,
                 atc.nranodivida,
                 atc.idTipoCredito,
                 coalesce(sum(coalesce(atc.vlarrecadacao,0) *-1),0) as valorSoma
          from tceArrecadacaoTipoCredito     atc
          where atc.nrmes >= (extract(month from cast(:dataSaldo as date))) and atc.nrmes < (extract(month from cast(:dataInicial as date)))
            and atc.nrano = (extract(year from cast(:dataSaldo as date)))
            and atc.idtipoorigemreceita = 2
            and atc.idtipoarrecadacao  <> 3
            and ((atc.idtipoarrecadacao in (1,2)) or ((atc.idtipoarrecadacao  = 4)
            and not exists( select 1 from tceArrecadacaoTipoCredito atcd
                             where atcd.nrdivida = atc.nrdivida
                               and atcd.nranodivida = atc.nranodivida
                               and atcd.nrmes >= (extract(month from cast(:dataSaldo as date))) and atcd.nrmes < (extract(month from cast(:dataInicial as date)))
            				   and atcd.nrano = (extract(year from cast(:dataSaldo as date)))
                               and atcd.idtipoarrecadacao = 1)))
          group by atc.nrdivida,
                   atc.nranodivida,
                   atc.idTipoCredito
          union all
          select atc.nrdivida,
                 atc.nranodivida,
                 atc.idTipoCredito,
                 coalesce(sum(coalesce(atc.vlarrecadacao,0)),0) as valorSoma
          from tceArrecadacaoTipoCredito     atc
          where atc.nrmes >= (extract(month from cast(:dataSaldo as date))) and atc.nrmes < (extract(month from cast(:dataInicial as date)))
            and atc.nrano = (extract(year from cast(:dataSaldo as date)))
            and atc.idtipoorigemreceita = 2
            and atc.idtipoarrecadacao  = 3
          group by atc.nrdivida,
                   atc.nranodivida,
                   atc.idTipoCredito
          union all
          select atcr.nrdivida,
                 atcr.nranodivida,
                 atcr.idTipoCredito,
                 coalesce(sum(coalesce(atc.vlestorno,0)),0) as valorSoma
          from tceArrecadacaoTipoCreditoEst atc
          join tceArrecadacaoTipoCredito    atcr on atcr.nrarrecadacao  = atc.nrarrecadacao and atcr.nranoarrecadacao  = atc.nranoarrecadacao
          where atc.dtestorno >= :dataSaldo and atc.dtestorno < :dataInicial
            and atcr.idtipoorigemreceita = 2
            and atcr.idtipoarrecadacao  <> 3
          group by atcr.nrdivida,
                   atcr.nranodivida,
                   atcr.idTipoCredito
          union all
          select atcr.nrdivida,
                 atcr.nranodivida,
                 atcr.idTipoCredito,
                 coalesce(sum(coalesce(atc.vlestorno* -1,0)),0) as valorSoma
          from tceArrecadacaoTipoCreditoEst  atc
          join tceArrecadacaoTipoCredito     atcr on atcr.nrarrecadacao  = atc.nrarrecadacao and atcr.nranoarrecadacao  = atc.nranoarrecadacao
          where atc.dtestorno >= :dataSaldo and atc.dtestorno < :dataInicial
            and atcr.idtipoorigemreceita = 2
            and atcr.idtipoarrecadacao  = 3
          group by atcr.nrdivida,
                   atcr.nranodivida,
                   atcr.idTipoCredito
      ) saldo
      where saldo.nrdivida = filtro.nrdivida
        and saldo.nranodivida = filtro.nranodivida
      group by saldo.nrdivida,
               saldo.nranodivida
  ),0) as saldoMesAnterior,
  ( select coalesce(sum(coalesce(icd.vlinscricao,0)),0) as valorSoma
    from tceInscCreditoDA             icd
    where icd.dtInscricao between :dataInicial and :dataFinal
      and icd.nrdivida = filtro.nrdivida
      and icd.nranodivida = filtro.nranodivida
  ) as inscricaoDaMes,
  ( select coalesce(sum(coalesce(icd.vlestorno,0)*-1),0) as valorSoma
    from tceInscCreditoDAEst               icd
    where icd.dtEstorno between :dataInicial and :dataFinal
      and icd.nrdivida = filtro.nrdivida
      and icd.nranodivida = filtro.nranodivida
  ) as estornoInscricaoDaMes,
  ( select coalesce(sum(coalesce(tam.vlatualizacao,0)),0) as valorSoma
    from tceAtualizaMoneCredda           tam
    where tam.dtatualizacao between :dataInicial and :dataFinal
      and tam.nrdivida = filtro.nrdivida
      and tam.nranodivida = filtro.nranodivida
  ) as atualizacaoCreditoDaMes,
  ( select coalesce(sum(coalesce(tam.vlestorno,0) *-1),0) as valorSoma
    from tceAtualizaMoneCreddaEst tam
    join tceatualizaMoneCredda    tamc  on tamc.nratualizacao = tam.nratualizacao and tamc.nranoatualizacao = tam.nranoatualizacao
    where tam.dtEstorno between :dataInicial and :dataFinal
      and tamc.nrdivida = filtro.nrdivida
      and tamc.nranodivida = filtro.nranodivida
  ) as estornoAtualCreditoDaMes,
  ( select coalesce(sum(coalesce(tdc.vldeducao,0)*-1),0) as valorSoma
    from tceDeducaoCreditoda            tdc
    where tdc.dtDeducao between :dataInicial and :dataFinal
      and tdc.nrdivida = filtro.nrdivida
      and tdc.nranodivida = filtro.nranodivida
  ) as deducaoDaMes,
  ( select coalesce(sum(coalesce(tdc.vlestorno,0)),0) as valorSoma
    from tceDeducaoCreditodaEst         tdc
    join tceDeducaoCreditoda          tdco  on tdco.nrdeducao = tdc.nrdeducao
    where tdc.dtEstorno between :dataInicial and :dataFinal
      and tdco.nrdivida = filtro.nrdivida
      and tdco.nranodivida = filtro.nranodivida
  ) as estornoDeducaoDaMes,
  ( select coalesce(sum(coalesce(case when atc.idtipoarrecadacao = 3 then atc.vlarrecadacao else atc.vlarrecadacao * -1 end ,0)),0) as valorSoma
    from tceArrecadacaoTipoCredito     atc
    where atc.nrmes between (extract(month from cast(:dataSaldo as date))) and (extract(month from cast(:dataInicial as date)))
      and atc.nrano = (extract(year from cast(:dataSaldo as date)))
      and atc.idtipoorigemreceita = 2
      and atc.nrdivida = filtro.nrdivida
      and atc.nranodivida = filtro.nranodivida
      and ((atc.idtipoarrecadacao in (1,2,3)) or ((atc.idtipoarrecadacao  = 4)
      and not exists( select 1 from tceArrecadacaoTipoCredito atcd
                      where atcd.nrdivida = atc.nrdivida
                        and atcd.nranodivida = atc.nranodivida
                        and atcd.nrmes between (extract(month from cast(:dataSaldo as date))) and (extract(month from cast(:dataInicial as date)))
      					and atcd.nrano = (extract(year from cast(:dataSaldo as date)))
                        and atcd.idtipoarrecadacao = 1)))
  ) as arrecadacaoDaMes,
  ( select coalesce(sum(coalesce(case when atcr.idtipoarrecadacao = 3 then atc.vlestorno * -1 else atc.vlestorno end,0)),0) as valorSoma
    from tceArrecadacaoTipoCreditoEst  atc
    join tceArrecadacaoTipoCredito     atcr on atcr.nrarrecadacao  = atc.nrarrecadacao and atcr.nranoarrecadacao  = atc.nranoarrecadacao
    where atc.dtestorno between :dataInicial and :dataFinal
      and atcr.idtipoorigemreceita = 2
      and atcr.nrdivida = filtro.nrdivida
      and atcr.nranodivida = filtro.nranodivida
  ) as estornoArrecadacaoDaMes,
  coalesce((
    select coalesce(sum(coalesce(saldo.valorSoma,0)),0) as ValorSoma
    from
    (
      select icd.nrdivida,
             icd.nranodivida,
             icd.idTipoCredito,
             coalesce(sum(coalesce(icd.vlinscricao,0)),0) as valorSoma
      from tceInscCreditoDA    icd
      where (extract(year from cast(:dataSaldo as date)) = :exercicioImplantacao
        and extract(month from cast(:dataSaldo as date)) = 1
        and icd.dtInscricao < :dataSaldo)
      group by icd.nrdivida,
               icd.nranodivida,
               icd.idTipoCredito
      union all
      select icd.nrdivida,
             icd.nranodivida,
             icd.idTipoCredito,
             coalesce(sum(coalesce(icd.vlinscricao,0)),0) as valorSoma
      from tceInscCreditoDA icd
      where icd.dtInscricao >= :dataSaldo and icd.dtInscricao < :dataInicial
      group by icd.nrdivida,
               icd.nranodivida,
               icd.idTipoCredito
      union all
      select icd.nrdivida,
             icd.nranodivida,
             icd.idTipoCredito,
             coalesce(sum(coalesce(icde.vlestorno,0)*-1),0) as valorSoma
      from tceInscCreditoDAEst icde
      join tceInscCreditoDA    icd on icd.nrDivida = icde.nrDivida and icd.nrAnoDivida = icde.nrAnoDivida
      where icde.dtEstorno >= :dataSaldo and icde.dtEstorno < :dataInicial
      group by icd.nrdivida,
               icd.nranodivida,
               icd.idTipoCredito
      union all
      select tam.nrdivida,
             tam.nranodivida,
             tam.idTipoCredito,
             coalesce(sum(coalesce(tam.vlatualizacao,0)),0) as valorSoma
      from tceAtualizaMoneCredda tam
      where tam.dtatualizacao >= :dataSaldo and tam.dtatualizacao < :dataInicial
      group by tam.nrdivida,
               tam.nranodivida,
               tam.idTipoCredito
      union all
      select tamc.nrdivida,
             tamc.nranodivida,
             tamc.idTipoCredito,
             coalesce(sum(coalesce(tam.vlestorno,0) *-1),0) as valorSoma
      from tceAtualizaMoneCreddaEst tam
      join tceatualizaMoneCredda    tamc  on tamc.nratualizacao = tam.nratualizacao and tamc.nranoatualizacao = tam.nranoatualizacao
      where tam.dtEstorno >= :dataSaldo and tam.dtEstorno < :dataInicial
      group by tamc.nrdivida,
               tamc.nranodivida,
               tamc.idTipoCredito
      union all
      select tdc.nrdivida,
             tdc.nranodivida,
             tdc.idTipoCredito,
             coalesce(sum(coalesce(tdc.vldeducao,0)*-1),0) as valorSoma
      from tceDeducaoCreditoda tdc
      where tdc.dtDeducao >= :dataSaldo and tdc.dtDeducao < :dataInicial
      group by tdc.nrdivida,
               tdc.nranodivida,
               tdc.idTipoCredito
      union all
      select tdco.nrdivida,
             tdco.nranodivida,
             tdco.idTipoCredito,
             coalesce(sum(coalesce(tdc.vlestorno,0)),0) as valorSoma
      from tceDeducaoCreditodaEst tdc
      join tceDeducaoCreditoda    tdco  on tdco.nrdeducao = tdc.nrdeducao
      where tdc.dtEstorno >= :dataSaldo and tdc.dtEstorno < :dataInicial
      group by tdco.nrdivida,
               tdco.nranodivida,
               tdco.idTipoCredito
      union all
      select atc.nrdivida,
             atc.nranodivida,
             atc.idTipoCredito,
             coalesce(sum(coalesce(atc.vlarrecadacao,0) *-1),0) as valorSoma
      from tceArrecadacaoTipoCredito atc
      where atc.nrmes >= (extract(month from cast(:dataSaldo as date))) and atc.nrmes < (extract(month from cast(:dataInicial as date)))
        and atc.nrano = (extract(year from cast(:dataSaldo as date)))
        and atc.idtipoorigemreceita = 2
        and atc.idtipoarrecadacao  <> 3
        and ((atc.idtipoarrecadacao in (1,2)) or ((atc.idtipoarrecadacao  = 4)
        and not exists( select 1 from tceArrecadacaoTipoCredito atcd
                        where atcd.nrdivida = atc.nrdivida
                          and atcd.nranodivida = atc.nranodivida
                          and atcd.nrmes >= (extract(month from cast(:dataSaldo as date))) and atcd.nrmes < (extract(month from cast(:dataInicial as date)))
        				  and atcd.nrano = (extract(year from cast(:dataSaldo as date)))
                          and atcd.idtipoarrecadacao = 1)))
      group by atc.nrdivida,
               atc.nranodivida,
               atc.idTipoCredito
      union all
      select atc.nrdivida,
             atc.nranodivida,
             atc.idTipoCredito,
             coalesce(sum(coalesce(atc.vlarrecadacao,0)),0) as valorSoma
      from tceArrecadacaoTipoCredito     atc
      where atc.nrmes >= (extract(month from cast(:dataSaldo as date))) and atc.nrmes < (extract(month from cast(:dataInicial as date)))
        and atc.nrano = (extract(year from cast(:dataSaldo as date)))
        and atc.idtipoorigemreceita = 2
        and atc.idtipoarrecadacao  = 3
      group by atc.nrdivida,
               atc.nranodivida,
               atc.idTipoCredito
      union all
      select atcr.nrdivida,
             atcr.nranodivida,
             atcr.idTipoCredito,
             coalesce(sum(coalesce(atc.vlestorno,0)),0) as valorSoma
      from tceArrecadacaoTipoCreditoEst atc
      join tceArrecadacaoTipoCredito    atcr on atcr.nrarrecadacao  = atc.nrarrecadacao and atcr.nranoarrecadacao  = atc.nranoarrecadacao
      where atc.dtestorno >= :dataSaldo and atc.dtestorno < :dataInicial
        and atcr.idtipoorigemreceita = 2
        and atcr.idtipoarrecadacao  <> 3
      group by atcr.nrdivida,
               atcr.nranodivida,
               atcr.idTipoCredito
      union all
      select atcr.nrdivida,
             atcr.nranodivida,
             atcr.idTipoCredito,
             coalesce(sum(coalesce(atc.vlestorno * -1,0)),0) as valorSoma
      from tceArrecadacaoTipoCreditoEst atc
      join tceArrecadacaoTipoCredito    atcr on atcr.nrarrecadacao  = atc.nrarrecadacao and atcr.nranoarrecadacao  = atc.nranoarrecadacao
      where atc.dtestorno >= :dataSaldo and atc.dtestorno < :dataInicial
        and atcr.idtipoorigemreceita = 2
        and atcr.idtipoarrecadacao  = 3
      group by atcr.nrdivida,
               atcr.nranodivida,
               atcr.idTipoCredito
    ) saldo
    where saldo.nrdivida = filtro.nrdivida
      and saldo.nranodivida = filtro.nranodivida
    group by saldo.nrdivida,
          saldo.nranodivida
  ),0) +
  ( select coalesce(sum(coalesce(icd.vlinscricao,0)),0) as valorSoma
    from tceInscCreditoDA             icd
    where icd.dtInscricao between :dataInicial and :dataFinal
      and icd.nrdivida = filtro.nrdivida
      and icd.nranodivida = filtro.nranodivida
  ) +
  ( select coalesce(sum(coalesce(icd.vlestorno,0)*-1),0) as valorSoma
    from tceInscCreditoDAEst               icd
    where icd.dtEstorno between :dataInicial and :dataFinal
      and icd.nrdivida = filtro.nrdivida
      and icd.nranodivida = filtro.nranodivida
  ) +
  ( select coalesce(sum(coalesce(tam.vlatualizacao,0)),0) as valorSoma
    from tceAtualizaMoneCredda           tam
    where tam.dtatualizacao between :dataInicial and :dataFinal
      and tam.nrdivida = filtro.nrdivida
    and tam.nranodivida = filtro.nranodivida
  ) +
  ( select coalesce(sum(coalesce(tam.vlestorno,0) *-1),0) as valorSoma
    from tceAtualizaMoneCreddaEst tam
    join tceatualizaMoneCredda    tamc  on tamc.nratualizacao = tam.nratualizacao and tamc.nranoatualizacao = tam.nranoatualizacao
    where tam.dtEstorno between :dataInicial and :dataFinal
      and tamc.nrdivida = filtro.nrdivida
      and tamc.nranodivida = filtro.nranodivida
  ) +
  ( select coalesce(sum(coalesce(tdc.vldeducao,0)*-1),0) as valorSoma
    from tceDeducaoCreditoda            tdc
    where tdc.dtDeducao between :dataInicial and :dataFinal
      and tdc.nrdivida = filtro.nrdivida
      and tdc.nranodivida = filtro.nranodivida
  ) +
  ( select coalesce(sum(coalesce(tdc.vlestorno,0)),0) as valorSoma
    from tceDeducaoCreditodaEst         tdc
    join tceDeducaoCreditoda          tdco  on tdco.nrdeducao = tdc.nrdeducao
    where tdc.dtEstorno between :dataInicial and :dataFinal
      and tdco.nrdivida = filtro.nrdivida
      and tdco.nranodivida = filtro.nranodivida
  ) +
  ( select coalesce(sum(coalesce(case when atc.idtipoarrecadacao  = 3 then atc.vlarrecadacao else atc.vlarrecadacao * -1 end,0)),0) as valorSoma
    from tceArrecadacaoTipoCredito     atc
    where atc.nrmes between (extract(month from cast(:dataSaldo as date))) and (extract(month from cast(:dataInicial as date)))
      and atc.nrano = (extract(year from cast(:dataSaldo as date)))
      and atc.idtipoorigemreceita = 2
      and ((atc.idtipoarrecadacao in (1,2,3)) or ((atc.idtipoarrecadacao  = 4)
      and not exists(select 1 from tceArrecadacaoTipoCredito atcd
                      where atcd.nrdivida = atc.nrdivida
                        and atcd.nranodivida = atc.nranodivida
                        and atcd.nrmes between (extract(month from cast(:dataSaldo as date))) and (extract(month from cast(:dataInicial as date)))
      					and atcd.nrano = (extract(year from cast(:dataSaldo as date)))
                        and atcd.idtipoarrecadacao = 1)))
      and atc.nrdivida = filtro.nrdivida
      and atc.nranodivida = filtro.nranodivida
  ) +
  ( select coalesce(sum(coalesce(case when atcr.idtipoarrecadacao  = 3 then atc.vlestorno else atc.vlestorno * -1 end,0)),0) as valorSoma
    from tceArrecadacaoTipoCreditoEst  atc
    join tceArrecadacaoTipoCredito     atcr on atcr.nrarrecadacao  = atc.nrarrecadacao and atcr.nranoarrecadacao  = atc.nranoarrecadacao
    where atc.dtestorno between :dataInicial and :dataFinal
      and atcr.idtipoorigemreceita = 2
      and atcr.nrdivida = filtro.nrdivida
      and atcr.nranodivida = filtro.nranodivida
  ) as saldoAtual
from tceinsccreditoda filtro
) filtro
where filtro.nranodivida = :nranodivida
%s
