select * from
(
  select filtro.nrcredito,
         filtro.nranocredito,
         filtro.idTipoCredito,
  (
    select coalesce(sum(saldo.valorSoma),0) as ValorSoma
    from (
      select tlc.nrcredito,
             tlc.nranocredito,
             tlc.idtipoCredito,
             coalesce(sum(tlc.vllancamento),0) as valorSoma
      from tceLancCredito      tlc
      where (extract(year from cast(:dataSaldo as date)) = :exercicioImplantacao
              and extract(month from cast(:dataSaldo as date)) = 1
              and tlc.dtLancamento < :dataSaldo)
      and tlc.idtipooperacaocredito = 2
      group by tlc.nrcredito,
               tlc.nranocredito,
               tlc.idtipoCredito
      union all
      select tlc.nrcredito,
             tlc.nranocredito,
             tlc.idtipoCredito,
             coalesce(sum(coalesce(case when tlc.idtipooperacaocredito = 4 then tlc.vllancamento * -1 else tlc.vllancamento end,0)),0) as valorSoma
      from tceLancCredito  tlc
      where tlc.dtLancamento >= :dataSaldo and tlc.dtLancamento < :dataInicial
      and tlc.idtipooperacaocredito in (1,4)
      group by tlc.nrcredito,
               tlc.nranocredito,
               tlc.idtipoCredito
      union all
      select tlce.nrcredito,
             tlce.nranocredito,
             tlc.idtipoCredito,
             coalesce(sum(coalesce(case when tlc.idtipooperacaocredito = 4 then tlce.vlestorno else tlce.vlestorno * -1 end,0)),0) as valorSoma
      from tceLancCreditoEst   tlce
      left join tceLancCredito tlc on tlc.nrCredito = tlce.nrCredito and tlc.nrAnoCredito = tlce.nrAnoCredito
      where tlce.dtEstorno >= :dataSaldo and tlce.dtEstorno < :dataInicial
        and tlc.idtipooperacaocredito in (1,4)
      group by tlce.nrcredito,
               tlce.nranocredito,
               tlc.idtipoCredito
      union all
      select tam.nrcredito,
             tam.nranocredito,
             tam.idtipocredito,
             coalesce(sum(coalesce(tam.vlatualizacao,0)),0) as valorSoma
      from tceAtualizaMoneCred   tam
      where tam.dtatualizacao >= :dataSaldo and tam.dtatualizacao < :dataInicial
      group by tam.nrcredito,
               tam.nranocredito,
               tam.idtipocredito
      union all
      select tamc.nrcredito,
             tamc.nranocredito,
             tam.idtipocredito,
             coalesce(sum(coalesce(tam.vlestorno,0) *-1),0) as valorSoma
      from tceAtualizaMoneCredEst tam
      join tceatualizaMoneCred    tamc on tamc.nratualizacao = tam.nratualizacao and tamc.nranoatualizacao = tam.nranoatualizacao
      where tam.dtEstorno >= :dataSaldo and tam.dtEstorno < :dataInicial
      group by tamc.nrcredito,
               tamc.nranocredito,
               tam.idtipocredito
      union all
      select tdc.nrcredito,
             tdc.nranocredito,
             tdc.idtipocredito,
             coalesce(sum(coalesce(tdc.vldeducao,0)*-1),0) as valorSoma
      from tceDeducaoCredito tdc
        where tdc.dtDeducao >= :dataSaldo and tdc.dtDeducao < :dataInicial
      group by tdc.nrcredito,
               tdc.nranocredito,
               tdc.idtipocredito
      union all
      select tdco.nrcredito,
             tdco.nranocredito,
             tdc.idtipocredito,
             coalesce(sum(coalesce(tdc.vlestorno,0)),0) as valorSoma
      from tceDeducaoCreditoEst tdc
      join tceDeducaoCredito    tdco  on tdco.nrdeducao = tdc.nrdeducao
      where tdc.dtEstorno >= :dataSaldo and tdc.dtEstorno < :dataInicial
      group by tdco.nrcredito,
               tdco.nranocredito,
               tdc.idtipocredito
      union all
      select atc.nrcredito,
             atc.nranocredito,
             atc.idtipocredito,
             coalesce(sum(coalesce(atc.vlarrecadacao,0) *-1),0) as valorSoma
      from tceArrecadacaoTipoCredito atc
        where atc.nrmes >= (extract(month from cast(:dataSaldo as date))) and atc.nrmes < (extract(month from cast(:dataInicial as date)))
        and atc.nrano = (extract(year from cast(:dataSaldo as date)))
        and atc.idtipoorigemreceita = 1
        and ((atc.idtipoarrecadacao in (1,2)) or ((atc.idtipoarrecadacao  = 4)
        and not exists(select 1 from tceArrecadacaoTipoCredito atcd
                       where atcd.nrcredito = atc.nrcredito
                         and atcd.nranocredito = atc.nranocredito
                         and atcd.nrmes >= (extract(month from cast(:dataSaldo as date))) and atcd.nrmes < (extract(month from cast(:dataInicial as date)))
        				 and atcd.nrano = (extract(year from cast(:dataSaldo as date)))
                         and atcd.idtipoarrecadacao = 1)))
      group by atc.nrcredito,
               atc.nranocredito,
               atc.idtipocredito
      union all
      select atc.nrcredito,
             atc.nranocredito,
             atc.idtipocredito,
             coalesce(sum(coalesce(atc.vlarrecadacao,0)),0) as valorSoma
      from tceArrecadacaoTipoCredito atc
        where atc.nrmes >= (extract(month from cast(:dataSaldo as date))) and atc.nrmes < (extract(month from cast(:dataInicial as date)))
          and atc.nrano = (extract(year from cast(:dataSaldo as date)))
          and atc.idtipoorigemreceita = 1
          and atc.idtipoarrecadacao  = 3
      group by atc.nrcredito,
               atc.nranocredito,
               atc.idtipocredito
      union all
      select atcr.nrcredito,
             atcr.nranocredito,
             atc.idtipocredito,
             coalesce(sum(coalesce(atc.vlestorno,0)),0) as valorSoma
      from tceArrecadacaoTipoCreditoEst   atc
      join tceArrecadacaoTipoCredito atcr on atcr.nrarrecadacao  = atc.nrarrecadacao and atcr.nranoarrecadacao  = atc.nranoarrecadacao
      where atc.dtestorno >= :dataSaldo and atc.dtestorno < :dataInicial
        and atcr.idtipoorigemreceita = 1
        and atcr.idtipoarrecadacao  <> 3
      group by atcr.nrcredito,
               atcr.nranocredito,
               atc.idtipocredito
      union all
      select atcr.nrcredito,
             atcr.nranocredito,
             atc.idtipocredito,
             coalesce(sum(coalesce(atc.vlestorno,0)),0) * -1 as valorSoma
      from tceArrecadacaoTipoCreditoEst   atc
      join tceArrecadacaoTipoCredito atcr on atcr.nrarrecadacao  = atc.nrarrecadacao and atcr.nranoarrecadacao  = atc.nranoarrecadacao
      where atc.dtestorno >= :dataSaldo and atc.dtestorno < :dataInicial
        and atcr.idtipoorigemreceita = 1
        and atcr.idtipoarrecadacao  = 3
      group by atcr.nrcredito,
               atcr.nranocredito,
               atc.idtipocredito
      union all
      select icd.nrcredito,
             icd.nranocredito,
             icd.idtipocredito,
             coalesce(sum(coalesce(icd.vlinscricao,0)*-1),0) as valorSoma
      from tceInscCreditoDA icd
      where icd.idtipooperacaocredito = 3
        and icd.dtInscricao >= :dataSaldo and icd.dtInscricao < :dataInicial
      group by icd.nrcredito,
               icd.nranocredito,
               icd.idtipocredito
      union all
      select icdr.nrcredito,
             icdr.nranocredito,
             icdr.idtipocredito,
             coalesce(sum(coalesce(icd.vlestorno,0)),0) as valorSoma
      from tceInscCreditoDAEst icd
      join tceInscCreditoDA    icdr on icdr.nrdivida = icd.nrdivida and icdr.nranodivida = icd.nranodivida
      where icd.dtEstorno >= :dataSaldo and icd.dtEstorno < :dataInicial
        and icdr.idtipooperacaocredito = 3
      group by icdr.nrcredito,
               icdr.nranocredito,
               icdr.idtipocredito
    ) saldo
    where saldo.nrcredito = filtro.nrcredito
      and saldo.nranocredito = filtro.nranocredito
  ) as saldoMesAnterior,
  ( select coalesce(sum(coalesce(case when tlc.idtipooperacaocredito = 4 then tlc.vllancamento * -1 else tlc.vllancamento end,0)),0) as valorSoma
    from tceLancCredito               tlc
    where tlc.dtLancamento between :dataInicial and :dataFinal
      and tlc.idtipooperacaocredito  in (1,4)
      and tlc.nrcredito = filtro.nrcredito
      and tlc.nranocredito = filtro.nranocredito
  ) as lancamentoCreditoMes,
  ( select coalesce(sum(coalesce(case when tlc.idtipooperacaocredito = 4 then tlce.vlestorno else tlce.vlestorno * -1 end,0)),0) as valorSoma
    from tceLancCreditoEst tlce
    left join tceLancCredito tlc on tlc.NrCredito = tlce.nrCredito and tlc.nrAnoCredito = tlce.nrAnoCredito
    where tlce.dtEstorno between :dataInicial and :dataFinal
      and tlc.idtipooperacaocredito in (1,4)
      and tlce.nrcredito = filtro.nrcredito
      and tlce.nranocredito = filtro.nranocredito
  ) as estornoLancCreditoMes,
  ( select coalesce(sum(coalesce(tam.vlatualizacao,0)),0)
    from tceAtualizaMoneCred tam
    where tam.dtatualizacao between :dataInicial and :dataFinal
      and tam.nrcredito = filtro.nrcredito
      and tam.nranocredito = filtro.nranocredito
  ) as atualizacaoCreditoMes,
  ( select coalesce(sum(coalesce(tam.vlestorno,0) *-1),0)
    from tceAtualizaMoneCredEst tam
    join tceatualizaMoneCred    tamc  on tamc.nratualizacao = tam.nratualizacao and tamc.nranoatualizacao = tam.nranoatualizacao
    where tam.dtEstorno between :dataInicial and :dataFinal
      and tamc.nrcredito = filtro.nrcredito
      and tamc.nranocredito =  filtro.nranocredito
  ) as estornoAtualCreditoMes,
  ( select coalesce(sum(coalesce(tdc.vldeducao,0)*-1),0)
    from tceDeducaoCredito tdc
    where tdc.dtDeducao between :dataInicial and :dataFinal
      and tdc.nrcredito = filtro.nrcredito
      and tdc.nranocredito = filtro.nranocredito
  ) as deducaoCreditoMes,
  ( select coalesce(sum(coalesce(tdc.vlestorno,0)),0)
    from tceDeducaoCreditoEst tdc
    join tceDeducaoCredito    tdco  on tdco.nrdeducao = tdc.nrdeducao
    where tdc.dtEstorno between :dataInicial and :dataFinal
      and tdco.nrcredito = filtro.nrcredito
      and tdco.nranocredito = filtro.nranocredito
  ) as estornoDeducaoCreditoMes,
  ( select coalesce(sum(coalesce(case when atc.idtipoarrecadacao = 3 then atc.vlarrecadacao else atc.vlarrecadacao * -1 end,0)),0)
    from tceArrecadacaoTipoCredito     atc
    where atc.nrmes between (extract(month from cast(:dataSaldo as date))) and (extract(month from cast(:dataInicial as date)))
      and atc.nrano = (extract(year from cast(:dataSaldo as date)))
      and atc.idtipoorigemreceita = 1
      and ((atc.idtipoarrecadacao in (1,2,3)) or ((atc.idtipoarrecadacao  = 4)
      and not exists(select 1 from tceArrecadacaoTipoCredito atcd
                     where atcd.nrcredito = atc.nrcredito
                       and atcd.nranocredito = atc.nranocredito
                       and atcd.nrmes between (extract(month from cast(:dataSaldo as date))) and (extract(month from cast(:dataInicial as date)))
      				   and atcd.nrano = (extract(year from cast(:dataSaldo as date)))
                       and atcd.idtipoarrecadacao = 1)))
      and atc.nrcredito = filtro.nrcredito
      and atc.nranocredito = filtro.nranocredito
  ) as arrecadacaoMes,
  ( select coalesce(sum(coalesce(case when atcr.idtipoarrecadacao = 3 then atc.vlestorno * -1 else atc.vlestorno end,0)),0)
    from tceArrecadacaoTipoCreditoEst atc
    join tceArrecadacaoTipoCredito    atcr on atcr.nrarrecadacao  = atc.nrarrecadacao and atcr.nranoarrecadacao  = atc.nranoarrecadacao
    where atc.dtestorno between :dataInicial and :dataFinal
      and atcr.idtipoorigemreceita = 1
      and atcr.nrcredito = filtro.nrcredito
      and atcr.nranocredito = filtro.nranocredito
  ) as estornoArrecadacaoMes,
  ( select coalesce(sum(coalesce(icd.vlinscricao,0)*-1),0)
    from tceInscCreditoDA icd
    where icd.idtipooperacaocredito = 3
      and icd.dtInscricao between :dataInicial and :dataFinal
      and icd.nrcredito = filtro.nrcredito
      and icd.nranocredito = filtro.nranocredito
  ) as inscricaoDaMes,
  ( select coalesce(sum(coalesce(icd.vlestorno,0)),0)
    from tceInscCreditoDAEst icd
    join tceInscCreditoDA    icdr on icdr.nrdivida = icd.nrdivida and icdr.nranodivida = icd.nranodivida
    where icd.dtEstorno between :dataInicial and :dataFinal
      and icdr.idtipooperacaocredito = 3
      and icdr.nrcredito = filtro.nrcredito
      and icdr.nranocredito = filtro.nranocredito
  ) as estornoInscricaoDaMes,
  ( select coalesce(sum(coalesce(saldo.valorSoma,0)),0) as ValorSoma
    from
    (
      select tlc.nrcredito,
             tlc.nranocredito,
             tlc.idTipoCredito,
             coalesce(sum(coalesce(tlc.vllancamento,0)),0) as valorSoma
      from tceLancCredito      tlc
      where (extract(year from cast(:dataSaldo as date)) = :exercicioImplantacao
        and extract(month from cast(:dataSaldo as date)) = 1
        and tlc.dtLancamento < :dataSaldo)
        and tlc.idtipooperacaocredito = 2
      group by tlc.nrcredito,
               tlc.nranocredito,
               tlc.idTipoCredito
      union all
      select tlc.nrcredito,
             tlc.nranocredito,
             tlc.idTipoCredito,
             coalesce(sum(coalesce(case when tlc.idtipooperacaocredito = 4 then tlc.vllancamento * -1 else tlc.vllancamento end,0)),0) as valorSoma
      from tceLancCredito tlc
      where tlc.dtLancamento >= :dataSaldo and tlc.dtLancamento < :dataInicial
      and tlc.idtipooperacaocredito  in(1,4)
      group by tlc.nrcredito,
               tlc.nranocredito,
               tlc.idTipoCredito
      union all
      select tlce.nrcredito,
             tlce.nranocredito,
             tlc.idTipoCredito,
             coalesce(sum(coalesce(case when tlc.idtipooperacaocredito = 4 then tlce.vlestorno else tlce.vlestorno * -1 end,0)),0) as valorSoma
      from tceLancCreditoEst tlce
      left join tceLancCredito tlc on tlc.nrCredito = tlce.nrCredito and tlc.nrAnoCredito = tlce.nrAnoCredito
      where tlce.dtEstorno >= :dataSaldo and tlce.dtEstorno < :dataInicial
        and tlc.idtipooperacaocredito in (1,4)
      group by tlce.nrcredito,
               tlce.nranocredito,
               tlc.idTipoCredito
      union all
      select tam.nrcredito,
             tam.nranocredito,
             tam.idTipoCredito,
             coalesce(sum(coalesce(tam.vlatualizacao,0)),0) as valorSoma
      from tceAtualizaMoneCred tam
      where tam.dtatualizacao >= :dataSaldo and tam.dtatualizacao < :dataInicial
      group by tam.nrcredito,
               tam.nranocredito,
               tam.idTipoCredito
      union all
      select tamc.nrcredito,
             tamc.nranocredito,
             tamc.idTipoCredito,
             coalesce(sum(coalesce(tam.vlestorno,0) *-1),0) as valorSoma
      from tceAtualizaMoneCredEst       tam
        join tceatualizaMoneCred         tamc  on tamc.nratualizacao = tam.nratualizacao
                                              and tamc.nranoatualizacao = tam.nranoatualizacao
      where tam.dtEstorno >= :dataSaldo and tam.dtEstorno < :dataInicial
      group by tamc.nrcredito,
               tamc.nranocredito,
               tamc.idTipoCredito
      union all
      select tdc.nrcredito,
             tdc.nranocredito,
             tdc.idTipoCredito,
             coalesce(sum(coalesce(tdc.vldeducao,0)*-1),0) as valorSoma
      from tceDeducaoCredito tdc
        where tdc.dtDeducao >= :dataSaldo and tdc.dtDeducao < :dataInicial
      group by tdc.nrcredito,
               tdc.nranocredito,
               tdc.idTipoCredito
      union all
      select tdco.nrcredito,
             tdco.nranocredito,
             tdco.idTipoCredito,
             coalesce(sum(coalesce(tdc.vlestorno,0)),0) as valorSoma
      from tceDeducaoCreditoEst tdc
      join tceDeducaoCredito    tdco  on tdco.nrdeducao = tdc.nrdeducao
      where tdc.dtEstorno >= :dataSaldo and tdc.dtEstorno < :dataInicial
      group by tdco.nrcredito,
               tdco.nranocredito,
               tdco.idTipoCredito
      union all
      select atc.nrcredito,
             atc.nranocredito,
             atc.idtipocredito,
             coalesce(sum(coalesce(atc.vlarrecadacao,0) *-1),0) as valorSoma
      from tceArrecadacaoTipoCredito     atc
      where atc.nrmes >= (extract(month from cast(:dataSaldo as date))) and atc.nrmes < (extract(month from cast(:dataInicial as date)))
        and atc.nrano = (extract(year from cast(:dataSaldo as date)))
        and atc.idtipoorigemreceita = 1
        and ((atc.idtipoarrecadacao in (1,2)) or ((atc.idtipoarrecadacao  = 4)
        and not exists( select 1 from tceArrecadacaoTipoCredito atcd
                         where atcd.nrcredito = atc.nrcredito
                           and atcd.nranocredito = atc.nranocredito
                           and atcd.nrmes >= (extract(month from cast(:dataSaldo as date))) and atcd.nrmes < (extract(month from cast(:dataInicial as date)))
        				   and atcd.nrano = (extract(year from cast(:dataSaldo as date)))
                           and atcd.idtipoarrecadacao = 1)))
        group by atc.nrcredito,
                 atc.nranocredito,
                 atc.idtipocredito
        union all
        select atc.nrcredito,
               atc.nranocredito,
               atc.idtipocredito,
               coalesce(sum(coalesce(atc.vlarrecadacao,0)),0) as valorSoma
        from tceArrecadacaoTipoCredito     atc
        where atc.nrmes >= (extract(month from cast(:dataSaldo as date))) and atc.nrmes < (extract(month from cast(:dataInicial as date)))
          and atc.nrano = (extract(year from cast(:dataSaldo as date)))
          and atc.idtipoorigemreceita = 1
          and atc.idtipoarrecadacao  = 3
        group by atc.nrcredito,
                 atc.nranocredito,
                 atc.idtipocredito
        union all
        select atcr.nrcredito,
               atcr.nranocredito,
               atcr.idtipocredito,
               coalesce(sum(coalesce(atc.vlestorno,0)),0) as valorSoma
        from tceArrecadacaoTipoCreditoEst  atc
        join tceArrecadacaoTipoCredito     atcr on atcr.nrarrecadacao  = atc.nrarrecadacao and atcr.nranoarrecadacao  = atc.nranoarrecadacao
        where atc.dtestorno >= :dataSaldo and atc.dtestorno < :dataInicial
          and atcr.idtipoorigemreceita = 1
          and atcr.idtipoarrecadacao  <> 3
        group by atcr.nrcredito,
                 atcr.nranocredito,
                 atcr.idtipocredito
        union all
        select atcr.nrcredito,
               atcr.nranocredito,
               atcr.idtipocredito,
               coalesce(sum(coalesce(atc.vlestorno * -1,0)),0) as valorSoma
          from tceArrecadacaoTipoCreditoEst  atc
          join tceArrecadacaoTipoCredito     atcr on atcr.nrarrecadacao  = atc.nrarrecadacao and atcr.nranoarrecadacao  = atc.nranoarrecadacao
          where atc.dtestorno >= :dataSaldo and atc.dtestorno < :dataInicial
            and atcr.idtipoorigemreceita = 1
            and atcr.idtipoarrecadacao  = 3
        group by atcr.nrcredito,
                 atcr.nranocredito,
                 atcr.idtipocredito
        union all
        select icd.nrcredito,
               icd.nranocredito,
               icd.idtipocredito,
               coalesce(sum(coalesce(icd.vlinscricao,0)*-1),0) as valorSoma
        from tceInscCreditoDA             icd
        where icd.idtipooperacaocredito = 3
          and icd.dtInscricao >= :dataSaldo and icd.dtInscricao < :dataInicial
        group by icd.nrcredito,
                 icd.nranocredito,
                 icd.idtipocredito
        union all
        select icdr.nrcredito,
               icdr.nranocredito,
               icdr.idtipocredito,
               coalesce(sum(coalesce(icd.vlestorno,0)),0) as valorSoma
        from tceInscCreditoDAEst icd
        join tceInscCreditoDA    icdr on icdr.nrdivida = icd.nrdivida and icdr.nranodivida = icd.nranodivida
        where icd.dtEstorno >= :dataSaldo and icd.dtEstorno < :dataInicial
          and icdr.idtipooperacaocredito = 3
        group by icdr.nrcredito,
                 icdr.nranocredito,
                 icdr.idtipocredito
    ) saldo
    where saldo.nrcredito = filtro.nrcredito
      and saldo.nranocredito = filtro.nranocredito
  ) +
  ( select coalesce(sum(coalesce(case when tlc.idtipooperacaocredito = 4 then tlc.vllancamento * -1 else tlc.vllancamento end,0)),0) as valorSoma
    from tceLancCredito               tlc
    where tlc.dtLancamento between :dataInicial and :dataFinal
      and tlc.idtipooperacaocredito in(1,4)
      and tlc.nrcredito = filtro.nrcredito
      and tlc.nranocredito = filtro.nranocredito
  ) +
  ( select coalesce(sum(coalesce(case when tlc.idtipooperacaocredito = 4 then tlce.vlestorno else tlce.vlestorno * -1 end,0)),0) as valorSoma
    from tceLancCreditoEst tlce
    left join tceLancCredito tlc on tlc.nrCredito = tlce.nrCredito and tlc.nrAnoCredito = tlce.nrAnoCredito
    where tlce.dtEstorno between :dataInicial and :dataFinal
      and tlc.idtipooperacaocredito in(1,4)
      and tlce.nrcredito = filtro.nrcredito
      and tlce.nranocredito = filtro.nranocredito
  ) +
  ( select coalesce(sum(coalesce(tam.vlatualizacao,0)),0)
    from tceAtualizaMoneCred           tam
    where tam.dtatualizacao between :dataInicial and :dataFinal
      and tam.nrcredito = filtro.nrcredito
      and tam.nranocredito = filtro.nranocredito
  ) +
  ( select coalesce(sum(coalesce(tam.vlestorno,0) *-1),0)
    from tceAtualizaMoneCredEst tam
    join tceatualizaMoneCred    tamc  on tamc.nratualizacao = tam.nratualizacao and tamc.nranoatualizacao = tam.nranoatualizacao
    where tam.dtEstorno between :dataInicial and :dataFinal
      and tamc.nrcredito = filtro.nrcredito
      and tamc.nranocredito =  filtro.nranocredito
  ) +
  ( select coalesce(sum(coalesce(tdc.vldeducao,0)*-1),0)
    from tceDeducaoCredito            tdc
    where tdc.dtDeducao between :dataInicial and :dataFinal
      and tdc.nrcredito = filtro.nrcredito
      and tdc.nranocredito = filtro.nranocredito
  ) +
  ( select coalesce(sum(coalesce(tdc.vlestorno,0)),0)
    from tceDeducaoCreditoEst         tdc
    join tceDeducaoCredito            tdco  on tdco.nrdeducao = tdc.nrdeducao
    where tdc.dtEstorno between :dataInicial and :dataFinal
      and tdco.nrcredito = filtro.nrcredito
      and tdco.nranocredito = filtro.nranocredito
  ) +
  ( select coalesce(sum(coalesce(case when atc.idtipoarrecadacao  = 3 then atc.vlarrecadacao else atc.vlarrecadacao * -1 end ,0)),0)
    from tceArrecadacaoTipoCredito     atc
    where atc.nrmes between (extract(month from cast(:dataSaldo as date))) and (extract(month from cast(:dataInicial as date)))
      and atc.nrano = (extract(year from cast(:dataSaldo as date)))
      and atc.idtipoorigemreceita = 1
      and ((atc.idtipoarrecadacao in (1,2,3)) or ((atc.idtipoarrecadacao  = 4)
      and not exists( select 1 from tceArrecadacaoTipoCredito atcd
                      where atcd.nrcredito = atc.nrcredito
                        and atcd.nranocredito = atc.nranocredito
                        and atcd.nrmes between (extract(month from cast(:dataSaldo as date))) and (extract(month from cast(:dataInicial as date)))
      					and atcd.nrano = (extract(year from cast(:dataSaldo as date)))
                        and atcd.idtipoarrecadacao = 1)))
      and atc.nrcredito = filtro.nrcredito
      and atc.nranocredito = filtro.nranocredito
  ) +
  ( select coalesce(sum(coalesce(case when atcr.idtipoarrecadacao  = 3 then atc.vlestorno * -1 else atc.vlestorno end ,0)),0)
    from tceArrecadacaoTipoCreditoEst       atc
    join tceArrecadacaoTipoCredito     atcr on atcr.nrarrecadacao  = atc.nrarrecadacao and atcr.nranoarrecadacao  = atc.nranoarrecadacao
    where atc.dtestorno between :dataInicial and :dataFinal
      and atcr.idtipoorigemreceita = 1
      and atcr.nrcredito = filtro.nrcredito
      and atcr.nranocredito = filtro.nranocredito
  ) +
  ( select coalesce(sum(coalesce(icd.vlinscricao,0)*-1),0)
    from tceInscCreditoDA             icd
    where icd.idtipooperacaocredito = 3
      and icd.dtInscricao between :dataInicial and :dataFinal
      and icd.nrcredito = filtro.nrcredito
      and icd.nranocredito = filtro.nranocredito
  ) +
  ( select coalesce(sum(coalesce(icd.vlestorno,0)),0)
    from tceInscCreditoDAEst               icd
    join tceInscCreditoDA                  icdr on icdr.nrdivida = icd.nrdivida and icdr.nranodivida = icd.nranodivida
    where icd.dtEstorno between :dataInicial and :dataFinal
      and icdr.idtipooperacaocredito = 3
      and icdr.nrcredito = filtro.nrcredito
      and icdr.nranocredito = filtro.nranocredito
  ) as saldoAtual
  from tcelanccredito filtro
) filtro
where filtro.nranocredito = :nranocredito
%s
