select 01                                 as codigoArquivo,
       'Lançamento de Créditos'           as arquivo,
       'CREDITO'                          as tipoArquivo,
       sum(coalesce(arquivo.valor, 0))    as valorArquivo,
       sum(coalesce(integracao.valor, 0)) as valorIntegrado,
       sum(coalesce(retencao.valor, 0))   as valorRetencao,
       (select
        case when count(teis.idregistro) > 0 then 'true' else 'false' end
        from tcelanccredito tlc
        join triberrosimportacaosimam teis on
        teis.idregistro = tlc.idtcelanccredito
        and teis.identificadorarquivo = 'LANCAMENTO_CREDITO'
        where tlc.dtlancamento between :dataInicial and :dataFinal) as temerroimportacao,
        'false' as temerronrcreditodivida
from (select tipo, data, sum(valor) as valor
      from (select 'Integração'                as tipo,
                   ip.datamovimento            as data,
                   sum(coalesce(iip.valor, 0)) as valor
            from integracaopatrimonial ip
                     left join itemintegracaopatrimonial iip on ip.id = iip.idintegracaopatrimonial
                     left join tribreceita r
                               on r.receita = iip.tributo and r.exercicio = ip.exercicio and r.entidade = ip.entidade
                     JOIN tribreceitatipo trt
                          ON trt.tiporeceita = r.tiporeceita
            where ip.entidade = :entidade
              and ip.datamovimento between :dataInicial and :dataFinal
              and iip.tipomovimento = 'INSCRICAO'
              and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
              and iip.situacaolegal = 0
              and ip.situacaointegracaopatrimonial != 'ESTORNADO_CONTABILIDADE'
            group by ip.datamovimento
            union all
            select 'Integração',
                   lote.datalote                       as data,
                   sum(coalesce(item.valortributo, 0)) as valor
            from loteitemintegracaocontabil item
                     left join loteintegracaocontabil lote on item.idlote = lote.id
                     left join tribreceita r
                               on r.id = item.idtributo and r.exercicio = lote.exercicio and r.entidade = lote.entidade
                     JOIN tribreceitatipo trt
                          ON trt.tiporeceita = r.tiporeceita
            where lote.tipolote = 'RESTITUICAO'
              and lote.situacaointegracaocontabil != 'ESTORNADO_CONTABILIDADE'
              and lote.entidade = :entidade
              and lote.datalote between :dataInicial and :dataFinal
              and item.situacaolegal = 0
              and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
            group by lote.datalote) as filtro
      group by 1, 2) as integracao
         full outer join (select 'Arquivo', tlc.dtlancamento, sum(coalesce(tlc.vlLancamento, 0)) as valor
                          from tceLancCredito tlc
                          where tlc.dtlancamento between :dataInicial and :dataFinal
                            and tlc.idtipooperacaocredito <> 2
                          group by tlc.dtlancamento) as arquivo
                         on arquivo.dtlancamento = integracao.data
         full outer join (select 'Retenção', rc.dtlancamento, coalesce(sum(rc.valor), 0) as valor
                          from tceretencaocontabil rc
                          where dtlancamento between :dataInicial and :dataFinal
                            and coalesce(rc.devolucao, 'N') = 'N'
                          group by dtlancamento) as retencao
                         on retencao.dtlancamento = integracao.data