select 08                                                 as codigoArquivo,
       'Estorno da Inscrição de Créditos em Dívida Ativa' as arquivo,
       'CREDITO'                                          as tipoArquivo,
       arquivo.valor                           as valorArquivo,
       integracao.valor                        as valorIntegracao,
       0                                       as valorRetencao,
       (select
        case when count(teis.idregistro) > 0 then 'true' else 'false' end
        from tceinsccreditodaest tice
        join triberrosimportacaosimam teis on
        teis.idregistro = tice.idtceinsccreditodaest
        and teis.identificadorarquivo = 'ESTORNO_INSCRICAO_CREDITO_DIVIDA_ATIVA'
        where tice.dtestorno between :dataInicial and :dataFinal) as temerroimportacao,
                                                                                              'false' as temerronrcreditodivida
from (select sum(filtro.valor) as valor
         from (select coalesce(sum(tice.vlestorno), 0) as valor
               from tceinscCreditoDAEst tice
               where tice.dtestorno between :dataInicial and :dataFinal) filtro) as arquivo
cross join (select 0 as valor
                     from dual) as integracao