select 05                     as codigoArquivo,
       'Dedução dos Créditos' as arquivo,
       'DEBITO'               as tipoArquivo,
       coalesce(arquivo.valor,0)          as valorArquivo,
       coalesce(integracao.valor,0)       as valorIntegracao,
       0                                  as valorRetencao,
       (select
        case when count(teis.idregistro) > 0 then 'true' else 'false' end
        from tcededucaocredito tdc
        join triberrosimportacaosimam teis on
        teis.idregistro = tdc.idtcededucaocredito
        and teis.identificadorarquivo = 'DEDUCAO_CREDITO'
        where tdc.dtdeducao between :dataInicial and :dataFinal) as temerroimportacao,
       (select case when count(tdc.idtcededucaocredito) > 0 then 'true' else 'false' end
        from tcededucaocredito tdc
        where tdc.dtdeducao between :dataInicial and :dataFinal
        and (tdc.nrcredito is null or tdc.nranocredito is null)) as temerronrcreditodivida
from (
         select sum(coalesce(tdc.vlDeducao, 0)) as VALOR
         from tceDeducaoCredito tdc
         where tdc.dtdeducao between :dataInicial and :dataFinal
     ) as arquivo
         cross join (select sum(valor) as valor
                     from (
                              select iip.valor as valor
                              from integracaopatrimonial ip
                                       left join itemintegracaopatrimonial iip on ip.id = iip.idintegracaopatrimonial
                                       left join tribreceita r
                                                 on r.receita = iip.tributo and r.exercicio = ip.exercicio and
                                                    r.entidade = ip.entidade
                                       JOIN tribreceitatipo trt
                                            ON trt.tiporeceita = r.tiporeceita
                              where ip.entidade = :entidade
                                and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
                                and ip.datamovimento between :dataInicial and :dataFinal
                                and iip.tipomovimento in ('CANCELAMENTO', 'DACAO_PAGAMENTO', 'DESCONTO_PARCELAMENTO')
                                and iip.situacaolegal = 0
                                and ip.situacaointegracaopatrimonial != 'ESTORNADO_CONTABILIDADE'
                              union all
                              select liic.valordeducao
                              from loteintegracaocontabil lic
                                  left join loteitemintegracaocontabil liic
                              on lic.id = liic.idlote
                                  left join tribreceita tr on liic.idtributo = tr.id
                                  left JOIN tribreceitatipo trt ON trt.tiporeceita = tr.tiporeceita
                              where lic.datalote between :dataInicial and :dataFinal
                                and liic.situacaolegal = 0
                                and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
                                and lic.situacaointegracaocontabil != 'ESTORNADO_CONTABILIDADE'
                                and lic.tipolote in ('PAGAMENTO', 'REABILITACAO_PAGAMENTO')
                                and liic.valordeducao > 0) as dados
) as integracao