select 03                                                  as codigoArquivo,
       'Atualização Monetária de créditos'                 as arquivo,
       'CREDITO'                                           as tipoArquivo,
       coalesce(arquivo.valor,0)                           as valorArquivo,
       coalesce(integracao.valor,0)                        as valorIntegracao,
       0                                                   as valorRetencao,
       (select
        case when count(teis.idregistro) > 0 then 'true' else 'false' end
        from tceatualizamonecred tam
        join triberrosimportacaosimam teis on
        teis.idregistro = tam.idtceatualizamonecred
        and teis.identificadorarquivo = 'ATUALIZACAO_MONETARIA_CREDITO'
        where tam.dtatualizacao between :dataInicial and :dataFinal) as temerroimportacao,
       (select
               case when count(tam.idtceatualizamonecred) > 0 then 'true' else 'false' end
               from tceatualizamonecred tam
               where tam.dtatualizacao between :dataInicial and :dataFinal
               and (tam.nrcredito is null
                 or tam.nranocredito is null)) as temerronrcreditodivida
from (
         select sum(filtro.valor) as valor
         from(     SELECT SUM(COALESCE(tam.vlAtualizacao, 0)) AS valor
                   FROM tceAtualizaMoneCred tam
                   WHERE tam.dtatualizacao BETWEEN :dataInicial AND :dataFinal
             )  as filtro
     ) as arquivo
         cross join (
    select sum(filtro.valor) as valor
    from (
             select sum(coalesce(liic.valortributo ,0)) as valor
             from loteintegracaocontabil lic
                      join loteitemintegracaocontabil liic on lic.id = liic.idlote
                      join tribreceita tr on liic.idtributo = tr.id
                      join tribreceitatipo trt on tr.tiporeceita = trt.tiporeceita
             where (lic.datalote between :dataInicial and :dataFinal)
               and lic.entidade = :entidade
               and liic.situacaolegal = 0
               and liic.valortributo > 0
               and trt.classificacaoreceitatipo in (1,2,3,4,5,7)
               and liic.classificacaotributo in ('J','M','C','F')
               and liic.tributoprincipal = 'N'
               and lic.tipolote in( 'PAGAMENTO', 'REABILITACAO_PAGAMENTO')
               and lic.situacaointegracaocontabil != 'ESTORNADO_CONTABILIDADE'
             UNION ALL
             SELECT SUM(COALESCE(iip.valor, 0))
             FROM integracaopatrimonial ip
                 LEFT JOIN itemintegracaopatrimonial iip ON ip.id = iip.idintegracaopatrimonial
                 LEFT JOIN tribreceita r ON r.receita = iip.tributo AND r.exercicio = ip.exercicio
                 AND r.entidade = ip.entidade
                 JOIN tribreceitatipo trt ON trt.tiporeceita = r.tiporeceita
             WHERE ip.entidade = :entidade
               AND ip.datamovimento BETWEEN :dataInicial AND :dataFinal
               AND iip.tipomovimento = 'ACRESCIMOS_PARCELAMENTO'
               AND trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
               AND iip.situacaolegal = 0
               AND ip.situacaointegracaopatrimonial != 'ESTORNADO_CONTABILIDADE'
         ) as filtro
) as integracao