 select case when x.parcela = x.max_parcela
                then x.valorjuros + x.valorjurosfinan + x.juros_financiamento_extra -
                                 coalesce((select sum(y.rateio_juros + y.rateio_juros_financiamento)
                                           from vw_atualizacao_parcelamento y
                                           where y.idparcelamento = x.idparcelamento
                                             and y.iddebito = x.iddebito
                                             and y.receitaorigem = x.receitaorigem
                                             and y.parcela <> x.max_parcela), 0)
                else x.rateio_juros + x.rateio_juros_financiamento + x.juros_financiamento_extra end as valor,
        x.idparcelamento,
        x.iddebitoparcelareceita,
        1                           as tipoAtualizacao,
        x.receita,
        x.guiarecolhimento,
        x.situacaolegal
 from vw_atualizacao_parcelamento x
 where x.dataparcelamento between :dataInicial and :dataFinal
   and x.situacaolegal in (1, 2)
 union
 select case when x.parcela = x.max_parcela
                then x.valormulta - coalesce((select sum(y.rateio_multa)
                                              from vw_atualizacao_parcelamento y
                                              where y.idparcelamento = x.idparcelamento
                                                and y.iddebito = x.iddebito
                                                and y.receitaorigem = x.receitaorigem
                                                and y.parcela <> x.max_parcela), 0)
                 else x.rateio_multa end as valor,
        x.idparcelamento,
        x.iddebitoparcelareceita,
        2                           as tipoAtualizacao,
        x.receita,
        x.guiarecolhimento,
        x.situacaolegal
 from vw_atualizacao_parcelamento x
 where x.dataparcelamento between :dataInicial and :dataFinal
   and x.situacaolegal in (1, 2)
 union
 select case when x.parcela = x.max_parcela
                then x.valorcorrecao - coalesce((select sum(y.rateio_correcao)
                                                 from vw_atualizacao_parcelamento y
                                                 where y.idparcelamento = x.idparcelamento
                                                   and y.iddebito = x.iddebito
                                                   and y.receitaorigem = x.receitaorigem
                                                   and y.parcela <> x.max_parcela), 0)
                else x.rateio_correcao end as valor,
        x.idparcelamento,
        x.iddebitoparcelareceita,
        3                           as tipoAtualizacao,
        x.receita,
        x.guiarecolhimento,
        x.situacaolegal
 from vw_atualizacao_parcelamento x
 where x.dataparcelamento between :dataInicial and :dataFinal
   and x.situacaolegal in (1, 2)