select filtro.idTipoAtualizacaoCredito,
       filtro.dtAtualizacao,
       filtro.nrdivida,
       filtro.nranodivida,
       filtro.idpagamentobloqueto,
       filtro.iddebitoparcelareceita,
       filtro.idCreditoContribuinteItem,
       filtro.idparcelamento,
       filtro.idEstornoparcelamento,
       filtro.idmovimentacaosequencia,
       filtro.idDacaoPagamentodebito,
       filtro.idReajuste,
       filtro.iddebitoreceita,
       filtro.vlAtualizacao,
       filtro.idtipocredito,
       tg.fundamentolegal as cdControleLeiAto,
       filtro.entidade,
       filtro.exercicio,
       filtro.estornoPagamento
from (select 1                             as idTipoAtualizacaoCredito,
             tpd.valorjuros                as vlAtualizacao,
             tpd.idpagamentobloqueto,
             tpd.iddebitoparcelareceita,
             null::numeric                 as iddebitoreceita,
             null::numeric                 as idCreditoContribuinteItem,
             null::numeric                 as idparcelamento,
             null::numeric                 as idEstornoParcelamento,
             null::numeric                 as idmovimentacaosequencia,
             null::numeric                 as idDacaoPagamentodebito,
             null::numeric                 as idReajuste,
             tp.datalancamento             as dtAtualizacao,
             tid.nrdivida,
             tid.nranodivida,
             tcrt.classificacaoreceitatipo as idTipoCredito,
             tdpr.guiarecolhimento,
             null::numeric as exercicio,
             null::numeric as entidade,
             null::numeric as estornoPagamento
      from tribpagamento tp
      join tribpagamentobloqueto tpb on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento and tpb.pagamento = tp.pagamento
      join tribpagamentodebito tpd on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto and tpd.valorjuros > 0
      join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
      left join tribreceita tr on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = tdpr.receita
      join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
      join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
      left join contabancaria cb on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
      left join tcedebitoinsccreditoda tdic on tdic.iddebitoparcelareceita = tpd.IDDEBITOPARCELARECEITA
      left join tceinsccreditoda tid on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
      where tp.entidade = :entidade
        and tp.datalancamento BETWEEN :dataInicial and :dataFinal
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and tpd.situacaolegal in (1, 2)
        and not exists(select 1
                       from tceAtualizaMonePagamentoDA tampDA
                       where tampDA.idpagamentobloqueto = tpd.idpagamentobloqueto
                         and tampDA.iddebitoparcelareceita = tpd.iddebitoparcelareceita)
      union all
      select 1                             as idTipoAtualizacaoCredito,
             tpd.valorjuros                as vlAtualizacao,
             tpd.idpagamentobloqueto,
             tpd.iddebitoparcelareceita,
             null::numeric                 as iddebitoreceita,
             null::numeric                 as idCreditoContribuinteItem,
             null::numeric                 as idparcelamento,
             null::numeric                 as idEstornoParcelamento,
             null::numeric                 as idmovimentacaosequencia,
             null::numeric                 as idDacaoPagamentodebito,
             null::numeric                 as idReajuste,
             tp.datalancamento             as dtAtualizacao,
             tid.nrdivida,
             tid.nranodivida,
             tcrt.classificacaoreceitatipo as idTipoCredito,
             tdpr.guiarecolhimento,
             tep.exercicio                 as exercicio,
             tep.entidade                  as entidade,
             tep.estorno                   as estornoPagamento
       from tribpagamento tp
       join tribpagamentobloqueto tpb on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento and tpb.pagamento = tp.pagamento
       join tribpagamentodebito tpd on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto and tpd.valorjuros > 0
       join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
       left join tribreceita tr on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = tdpr.receita
       join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
       join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
       left join contabancaria cb on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
       left join tcedebitoinsccreditoda tdic on tdic.iddebitoparcelareceita = tpd.IDDEBITOPARCELARECEITA
       left join tceinsccreditoda tid on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
       left join tribestornopagamento tep on tep.entidade = tp.entidade and tep.exerciciopagamento = tp.exerciciopagamento and tep.pagamento = tp.pagamento
       where tp.entidade = :entidade
         and tep.datareabilitacao is not null
         and tep.datareabilitacao BETWEEN :dataInicial and :dataFinal
         and tep.datareabilitacao <> tep.data
         and coalesce(cb.integraarrecadacao, 'S') = 'S'
         and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
         and tpd.situacaolegal in (1, 2)
         and not exists (select 1 from tceatualizamonepagamentoreabda amcpr
                         where amcpr.exercicio = tep.exercicio
                           and amcpr.entidade = tep.entidade
                           and amcpr.estorno = tep.estorno
                           and amcpr.idpagamentobloqueto = tpd.idpagamentobloqueto
                           and amcpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita)
      union all
      select 2                             as idTipoAtualizacaoCredito,
             tpd.valormulta                as vlAtualizacao,
             tpd.idpagamentobloqueto,
             tpd.iddebitoparcelareceita,
             null::numeric                 as iddebitoreceita,
             null::numeric                 as idCreditoContribuinteItem,
             null::numeric                 as idparcelamento,
             null::numeric                 as idEstornoParcelamento,
             null::numeric                 as idmovimentacaosequencia,
             null::numeric                 as idDacaoPagamentodebito,
             null::numeric                 as idReajuste,
             tp.datalancamento             as dtAtualizacao,
             tid.nrdivida,
             tid.nranodivida,
             tcrt.classificacaoreceitatipo as idTipoCredito,
             tdpr.guiarecolhimento,
             null::numeric                 as exercicio,
             null::numeric                 as entidade,
             null::numeric                 as estornoPagamento
      from tribpagamento tp
      join tribpagamentobloqueto tpb on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento and tpb.pagamento = tp.pagamento
      join tribpagamentodebito tpd on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto and tpd.valormulta > 0
      join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
      left join tribreceita tr on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = tdpr.receita
      join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
      join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
      left join contabancaria cb on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
      left join tcedebitoinsccreditoda tdic on tdic.iddebitoparcelareceita = tpd.IDDEBITOPARCELARECEITA
      left join tceinsccreditoda tid on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
      where tp.entidade = :entidade
        and tp.datalancamento BETWEEN :dataInicial and :dataFinal
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and tpd.situacaolegal in (1, 2)
        and not exists(select 1
                       from tceAtualizaMonePagamentoDA tampDA
                       where tampDA.idpagamentobloqueto = tpd.idpagamentobloqueto
                         and tampDA.iddebitoparcelareceita = tpd.iddebitoparcelareceita)
      union all
      select 2                             as idTipoAtualizacaoCredito,
             tpd.valormulta                as vlAtualizacao,
             tpd.idpagamentobloqueto,
             tpd.iddebitoparcelareceita,
             null::numeric                 as iddebitoreceita,
             null::numeric                 as idCreditoContribuinteItem,
             null::numeric                 as idparcelamento,
             null::numeric                 as idEstornoParcelamento,
             null::numeric                 as idmovimentacaosequencia,
             null::numeric                 as idDacaoPagamentodebito,
             null::numeric                 as idReajuste,
             tp.datalancamento             as dtAtualizacao,
             tid.nrdivida,
             tid.nranodivida,
             tcrt.classificacaoreceitatipo as idTipoCredito,
             tdpr.guiarecolhimento,
             tep.exercicio                 as exercicio,
             tep.entidade                  as entidade,
             tep.estorno                   as estornoPagamento
      from tribpagamento tp
      join tribpagamentobloqueto tpb on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento and tpb.pagamento = tp.pagamento
      join tribpagamentodebito tpd on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto and tpd.valormulta > 0
      join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
      left join tribreceita tr on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = tdpr.receita
      join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
      join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
      left join contabancaria cb on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
      left join tcedebitoinsccreditoda tdic on tdic.iddebitoparcelareceita = tpd.IDDEBITOPARCELARECEITA
      left join tceinsccreditoda tid on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
      left join tribestornopagamento tep on tep.entidade = tp.entidade and tep.exerciciopagamento = tp.exerciciopagamento and tep.pagamento = tp.pagamento
      where tp.entidade = :entidade
        and tep.datareabilitacao is not null
        and tep.datareabilitacao BETWEEN :dataInicial and :dataFinal
        and tep.datareabilitacao <> tep.data
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and tpd.situacaolegal in (1, 2)
        and not exists (select 1 from tceatualizamonepagamentoreabda amcpr
                        where amcpr.exercicio = tep.exercicio
                          and amcpr.entidade = tep.entidade
                          and amcpr.estorno = tep.estorno
                          and amcpr.idpagamentobloqueto = tpd.idpagamentobloqueto
                          and amcpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita)
      union all
      select 3                             as idTipoAtualizacaoCredito,
             tpd.valorcorrecao             as vlAtualizacao,
             tpd.idpagamentobloqueto,
             tpd.iddebitoparcelareceita,
             null::numeric                 as iddebitoreceita,
             null::numeric                 as idCreditoContribuinteItem,
             null::numeric                 as idparcelamento,
             null::numeric                 as idEstornoParcelamento,
             null::numeric                 as idmovimentacaosequencia,
             null::numeric                 as idDacaoPagamentodebito,
             null::numeric                 as idReajuste,
             tp.datalancamento             as dtAtualizacao,
             tid.nrdivida,
             tid.nranodivida,
             tcrt.classificacaoreceitatipo as idTipoCredito,
             tdpr.guiarecolhimento,
             null::numeric                 as exercicio,
             null::numeric                 as entidade,
             null::numeric                 as estornoPagamento
      from tribpagamento tp
      join tribpagamentobloqueto tpb on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento and tpb.pagamento = tp.pagamento
      join tribpagamentodebito tpd on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto and tpd.valorcorrecao > 0
      join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
      left join tribreceita tr on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = tdpr.receita
      join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
      join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
      left join contabancaria cb on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
      left join tcedebitoinsccreditoda tdic on tdic.iddebitoparcelareceita = tpd.IDDEBITOPARCELARECEITA
      left join tceinsccreditoda tid on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
      where tp.entidade = :entidade
        and tp.datalancamento BETWEEN :dataInicial and :dataFinal
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and tpd.situacaolegal in (1, 2)
        and not exists(select 1
                       from tceAtualizaMonePagamentoDA tampDA
                       where tampDA.idpagamentobloqueto = tpd.idpagamentobloqueto
                         and tampDA.iddebitoparcelareceita = tpd.iddebitoparcelareceita)
      union all
      select 3                             as idTipoAtualizacaoCredito,
             tpd.valorcorrecao             as vlAtualizacao,
             tpd.idpagamentobloqueto,
             tpd.iddebitoparcelareceita,
             null::numeric                 as iddebitoreceita,
             null::numeric                 as idCreditoContribuinteItem,
             null::numeric                 as idparcelamento,
             null::numeric                 as idEstornoParcelamento,
             null::numeric                 as idmovimentacaosequencia,
             null::numeric                 as idDacaoPagamentodebito,
             null::numeric                 as idReajuste,
             tp.datalancamento             as dtAtualizacao,
             tid.nrdivida,
             tid.nranodivida,
             tcrt.classificacaoreceitatipo as idTipoCredito,
             tdpr.guiarecolhimento,
             tep.exercicio                 as exercicio,
             tep.entidade                  as entidade,
             tep.estorno                   as estornoPagamento
      from tribpagamento tp
      join tribpagamentobloqueto tpb on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento and tpb.pagamento = tp.pagamento
      join tribpagamentodebito tpd on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto and tpd.valorcorrecao > 0
      join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
      left join tribreceita tr on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = tdpr.receita
      join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
      join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
      left join contabancaria cb on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
      left join tcedebitoinsccreditoda tdic on tdic.iddebitoparcelareceita = tpd.IDDEBITOPARCELARECEITA
      left join tceinsccreditoda tid on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
      left join tribestornopagamento tep on tep.entidade = tp.entidade and tep.exerciciopagamento = tp.exerciciopagamento and tep.pagamento = tp.pagamento
      where tp.entidade = :entidade
        and tep.datareabilitacao is not null
        and tep.datareabilitacao BETWEEN :dataInicial and :dataFinal
        and tep.datareabilitacao <> tep.data
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and tpd.situacaolegal in (1, 2)
        and not exists (select 1 from tceatualizamonepagamentoreabda amcpr
                        where amcpr.exercicio = tep.exercicio
                          and amcpr.entidade = tep.entidade
                          and amcpr.estorno = tep.estorno
                          and amcpr.idpagamentobloqueto = tpd.idpagamentobloqueto
                          and amcpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita)
    union all
      select 1                             as idTipoAtualizacaoCredito,
             tcci.valorjuros               as vlAtualizacao,
             null::numeric                 as idpagamentobloqueto,
             tcci.iddebitoparcelareceita,
             null::numeric                 as iddebitoreceita,
             tcci.idcreditocontribuinteitem,
             null::numeric                 as idparcelamento,
             null::numeric                 as idEstornoParcelamento,
             null::numeric                 as idmovimentacaosequencia,
             null::numeric                 as idDacaoPagamentodebito,
             null::numeric                 as idReajuste,
             tcc.data                      as dtAtualizacao,
             tid.nrdivida,
             tid.nranodivida,
             tcrt.classificacaoreceitatipo as idTipoCredito,
             tdpr.guiarecolhimento,
             null::numeric                 as exercicio,
             null::numeric                 as entidade,
             null::numeric                 as estornoPagamento
      from tribcreditocontribuinte tcc
      join tribcreditocontribuinteitem tcci on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte
      join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
      join tribdebitoparcela tdp on tdp.entidade = tdpr.entidade and tdp.exercicio = tdpr.exercicio
          and tdp.tipocadastro = tdpr.tipocadastro and tdp.cadastrogeral = tdpr.cadastrogeral
          and tdp.guiarecolhimento = tdpr.guiarecolhimento and tdp.subdivida = tdpr.subdivida
          and tdp.parcela = tdpr.parcela
      left join tribreceita tr on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = tdpr.receita
      join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
      join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
      left join contabancaria cb on cb.entidade = tcc.entidade and cb.contabancaria = tcc.contabancaria
      left join tcedebitoinsccreditoda tdic on tdic.iddebitoparcelareceita = tcci.iddebitoparcelareceita
      left join tceinsccreditoda tid on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
      where tcc.entidade = :entidade
        and tcc.data BETWEEN :dataInicial and :dataFinal
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and tcci.valorjuros > 0
        and tdp.situacaolegal in (1, 2)
        and not exists(select 1
                       from tceAtualizaMoneCreditoDA tamcDA
                       where tamcDA.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
                         and tamcDA.iddebitoparcelareceita = tcci.iddebitoparcelareceita)
      union all
      select 2                             as idTipoAtualizacaoCredito,
             tcci.valormulta               as vlAtualizacao,
             null::numeric                 as idpagamentobloqueto,
             tcci.iddebitoparcelareceita,
             null::numeric                 as iddebitoreceita,
             tcci.idcreditocontribuinteitem,
             null::numeric                 as idparcelamento,
             null::numeric                 as idEstornoParcelamento,
             null::numeric                 as idmovimentacaosequencia,
             null::numeric                 as idDacaoPagamentodebito,
             null::numeric                 as idReajuste,
             tcc.data                      as dtAtualizacao,
             tid.nrdivida,
             tid.nranodivida,
             tcrt.classificacaoreceitatipo as idTipoCredito,
             tdpr.guiarecolhimento,
             null::numeric                 as exercicio,
             null::numeric                 as entidade,
             null::numeric                 as estornoPagamento
      from tribcreditocontribuinte tcc
      join tribcreditocontribuinteitem tcci on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte
      join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
      join tribdebitoparcela tdp on tdp.entidade = tdpr.entidade and tdp.exercicio = tdpr.exercicio
          and tdp.tipocadastro = tdpr.tipocadastro and tdp.cadastrogeral = tdpr.cadastrogeral
          and tdp.guiarecolhimento = tdpr.guiarecolhimento and tdp.subdivida = tdpr.subdivida
          and tdp.parcela = tdpr.parcela
      left join tribreceita tr on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = tdpr.receita
      join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
      join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
      join contabancaria cb on cb.entidade = tcc.entidade and cb.contabancaria = tcc.contabancaria
      left join tcedebitoinsccreditoda tdic on tdic.iddebitoparcelareceita = tcci.iddebitoparcelareceita
      left join tceinsccreditoda tid on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
      where tcc.entidade = :entidade
        and tcc.data BETWEEN :dataInicial and :dataFinal
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and tcci.valormulta > 0
        and tdp.situacaolegal in (1, 2)
        and not exists(select 1
                       from tceAtualizaMoneCreditoDA tamcDA
                       where tamcDA.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
                         and tamcDA.iddebitoparcelareceita = tcci.iddebitoparcelareceita)
      union all
      select 3                             as idTipoAtualizacaoCredito,
             tcci.valorcorrecao            as vlAtualizacao,
             null::numeric                             as idpagamentobloqueto,
             tcci.iddebitoparcelareceita,
             tcci.idcreditocontribuinteitem,
             null::numeric                             as idparcelamento,
             null::numeric                             as idEstornoParcelamento,
             null::numeric                             as idmovimentacaosequencia,
             null::numeric                             as idDacaoPagamentodebito,
             null::numeric                             as iddebitoreceita,
             null::numeric                             as idReajuste,
             tcc.data                      as dtAtualizacao,
             tid.nrdivida,
             tid.nranodivida,
             tcrt.classificacaoreceitatipo as idTipoCredito,
             tdpr.guiarecolhimento,
             null::numeric                          as exercicio,
             null::numeric                          as entidade,
             null::numeric                          as estornoPagamento
      from tribcreditocontribuinte tcc
      join tribcreditocontribuinteitem tcci on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte = tcc.creditocontribuinte
      join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
      join tribdebitoparcela tdp on tdp.entidade = tdpr.entidade and tdp.exercicio = tdpr.exercicio
          and tdp.tipocadastro = tdpr.tipocadastro and tdp.cadastrogeral = tdpr.cadastrogeral
          and tdp.guiarecolhimento = tdpr.guiarecolhimento and tdp.subdivida = tdpr.subdivida
          and tdp.parcela = tdpr.parcela
      left join tribreceita tr on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = tdpr.receita
      join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
      join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
      left join contabancaria cb on cb.entidade = tcc.entidade and cb.contabancaria = tcc.contabancaria
      left join tcedebitoinsccreditoda tdic on tdic.iddebitoparcelareceita = tcci.iddebitoparcelareceita
      left join tceinsccreditoda tid on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
      where tcc.entidade = :entidade
        and tcc.data BETWEEN :dataInicial and :dataFinal
        and coalesce(cb.integraarrecadacao, 'S') = 'S'
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and tcci.valorcorrecao > 0
        and tdp.situacaolegal in (1, 2)
        and not exists(select 1
                       from tceAtualizaMoneCreditoDA tamcDA
                       where tamcDA.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
                         and tamcDA.iddebitoparcelareceita = tcci.iddebitoparcelareceita)
      union all
      select 3                            as idTipoAtualizacaoCredito,
             dprr.VALORATUALIZACAO        as vlAtualizacao,
             null::numeric                as idpagamentobloqueto,
             DPRR.iddebitoparcelareceita,
             null::numeric                as iddebitoreceita,
             null::numeric                as idCreditoContribuinteItem,
             null::numeric                as idparcelamento,
             null::numeric                as idEstornoParcelamento,
             null::numeric                as idmovimentacaosequencia,
             null::numeric                as idDacaoPagamentodebito,
             dprr.idReajuste,
             r.data                       as dtAtualizacao,
             tid.nrdivida,
             tid.nranodivida,
             trt.classificacaoreceitatipo as idTipoCredito,
             d.guiarecolhimento,
             null::numeric                as exercicio,
             null::numeric                as entidade,
             null::numeric                as estornoPagamento
      FROM TRIBREAJUSTE R
               JOIN TRIBDEBITOPARCELARECREAJUSTE DPRR
                    ON DPRR.IDREAJUSTE = R.ID
               JOIN TRIBDEBITOPARCELARECEITA DPR
                    ON DPRR.IDDEBITOPARCELARECEITA = DPR.IDDEBITOPARCELARECEITA
               JOIN TRIBDEBITOPARCELA DP
                    on dpr.ENTIDADE = dp.ENTIDADE
                        AND dpr.EXERCICIO = dp.EXERCICIO
                        AND dpr.TIPOCADASTRO = dp.TIPOCADASTRO
                        AND dpr.CADASTROGERAL = dp.CADASTROGERAL
                        AND dpr.GUIARECOLHIMENTO = dp.GUIARECOLHIMENTO
                        AND dpr.SUBDIVIDA = dp.SUBDIVIDA
                        and dpr.parcela = dp.parcela
               JOIN TRIBDEBITO D
                    on dpr.ENTIDADE = d.ENTIDADE
                        AND dpr.EXERCICIO = d.EXERCICIO
                        AND dpr.TIPOCADASTRO = d.TIPOCADASTRO
                        AND dpr.CADASTROGERAL = d.CADASTROGERAL
                        AND dpr.GUIARECOLHIMENTO = d.GUIARECOLHIMENTO
                        AND dpr.SUBDIVIDA = d.SUBDIVIDA
               LEFT JOIN tribguiarecolhimento tgr
                         ON tgr.entidade = :entidade
                             AND tgr.exercicio = :exercicio
                             AND tgr.guiarecolhimento = dpr.guiarecolhimento
               LEFT JOIN tribreceita tr
                         ON tr.entidade = :entidade
                             AND tr.exercicio = :exercicio
                             AND tr.receita = dpr.receita
               LEFT JOIN tribreceitatipo trt
                         ON trt.tiporeceita = tr.tiporeceita
               JOIN TRIBPARCELAMENTO p
                    ON p.IDPARCELAMENTO = COALESCE(d.IDPARCELAMENTO, d.IDREPARCELAMENTO)
               LEFT JOIN TRIBPARAMPARCELAMENTO PP
                         ON PP.IDPARAMETROPARCELAMENTO = P.IDPARAMETROPARCELAMENTO
               LEFT JOIN CGATO ATO
                         ON PP.FUNDAMENTOLEGAL = ATO.IDATO
                             AND PP.ENTIDADE = ATO.ENTIDADE
               left join tcedebitoinsccreditoda tdic on tdic.iddebitoparcelareceita = dprr.IDDEBITOPARCELARECEITA
               left join tceinsccreditoda tid on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
      WHERE R.ENTIDADE = :entidade
        AND R.DATA BETWEEN :dataInicial and :dataFinal
        AND dp.SITUACAOLEGAL IN (1, 2)
        AND trt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and not exists (select 1 from tceatualizamonereajusteda tamr
                                 where tamr.idreajuste = r.id and tamr.iddebitoparcelareceita = dprr.iddebitoparcelareceita)
      union all
      select valores.tipoAtualizacao       as idTipoAtualizacaoCredito,
             valores.valor                 as vlAtualizacao,
             null::numeric                             as idpagamentobloqueto,
             valores.iddebitoparcelareceita,
             null::numeric                             as iddebitoreceita,
             null::numeric                             as idCreditoContribuinteItem,
             tp.idparcelamento,
             null::numeric                             as idEstornoParcelamento,
             null::numeric                             as movimentacaosequencia,
             null::numeric                             as idDacaoPagamentodebito,
             null::numeric                             as idReajuste,
             tp.dataparcelamento           as dtAtualizacao,
             tida.nrdivida,
             tida.nranodivida,
             tcrt.classificacaoreceitatipo as idtipocredito,
             valores.guiarecolhimento,
             null::numeric                          as exercicio,
             null::numeric                          as entidade,
             null::numeric                          as estornoPagamento
      from tribparcelamento tp
      left join tribatualizacaoparcelamento valores on valores.idparcelamento = tp.idparcelamento
      left join tcedebitoinsccreditoda tdida on tdida.iddebitoparcelareceita = valores.iddebitoparcelareceita
      left join tceinsccreditoda tida on tdida.idtceinsccreditoda = tida.idtceinsccreditoda
      left join tribreceita tr on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = valores.receita
      left join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
      left join tribclassificacaoreceitatipo tcrt on trt.classificacaoreceitatipo = tcrt.classificacaoreceitatipo
      where tp.dataparcelamento between :dataInicial and :dataFinal
        and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
        and valores.situacaolegal in (1, 2)
        and valores.valor <> 0
        and not exists (select 1 from tceatualizamoneparcda tampcd
                        where valores.idparcelamento = tampcd.idparcelamento
                          and tampcd.iddebitoparcelareceita = valores.iddebitoparcelareceita)
    union all
    /* Reabilitação de estorno de parcelamento que voltou para origem */
    select distinct valores.tipoAtualizacao       as idTipoAtualizacaoCredito,
                    valores.valor                 as vlAtualizacao,
                    null::numeric                 as idpagamentobloqueto,
                    valores.iddebitoparcelareceita,
                    null::numeric                 as iddebitoreceita,
                    null::numeric                 as idCreditoContribuinteItem,
                    tp.idparcelamento,
                    tep.idEstornoparcelamento,
                    null::numeric                 as movimentacaosequencia,
                    null::numeric                 as idDacaoPagamentodebito,
                    null::numeric                 as idReajuste,
                    tep.datareabilitacao          as dtAtualizacao,
                    tida.nrdivida,
                    tida.nranodivida,
                    tcrt.classificacaoreceitatipo as idtipocredito,
                    valores.guiarecolhimento,
                    null::numeric                 as exercicio,
                    null::numeric                 as entidade,
                    null::numeric                 as estornoPagamento
    from tribestornoparcelamento tep
    left join tribparcelamento tp on tp.idparcelamento = tep.idparcelamento
    left join tribatualizacaoparcelamento valores on valores.idparcelamento = tp.idparcelamento
    left join tcedebitoinsccreditoda tdida on tdida.iddebitoparcelareceita = valores.iddebitoparcelareceita
    left join tceinsccreditoda tida on tdida.idtceinsccreditoda = tida.idtceinsccreditoda
    left join tribreceita tr on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = valores.receita
    left join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
    left join tribclassificacaoreceitatipo tcrt on trt.classificacaoreceitatipo = tcrt.classificacaoreceitatipo
    left join tceatualizamoneparc tampcd on valores.idparcelamento = tampcd.idparcelamento and tampcd.iddebitoparcelareceita = valores.iddebitoparcelareceita
    where tep.datareabilitacao between :dataInicial and :dataFinal
      and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
      and tep.datareabilitacao != tep.dataestorno
      and exists (select 1
                  from tribestornoparcelamentodebito tepd
                  where tepd.idestornoparcelamento = tep.idestornoparcelamento
                    and tepd.iddebitoorigem > tepd.iddebitodestino)
      and tp.anocontrato = :exercicio
      and valores.situacaolegal in (1, 2)
      and not exists (select 1
                      from tceatualizamoneparcreabilitada tampde
                     where tampde.idestornoparcelamento = tep.idestornoparcelamento
                       and tampde.iddebitoparcelareceita = valores.iddebitoparcelareceita)
    union all
    /* Reabilitação de estorno de parcelamento que foi para a proxima subdivida */
    select distinct valores.tipoAtualizacao       as idTipoAtualizacaoCredito,
                    valores.valor                 as vlAtualizacao,
                    null::numeric                 as idpagamentobloqueto,
                    valores.iddebitoparcelareceita,
                    null::numeric                 as iddebitoreceita,
                    null::numeric                 as idCreditoContribuinteItem,
                    tp.idparcelamento,
                    tep.idEstornoparcelamento,
                    null::numeric                 as movimentacaosequencia,
                    null::numeric                 as idDacaoPagamentodebito,
                    null::numeric                 as idReajuste,
                    tep.datareabilitacao          as dtAtualizacao,
                    tida.nrdivida,
                    tida.nranodivida,
                    tcrt.classificacaoreceitatipo as idtipocredito,
                    valores.guiarecolhimento,
                    null::numeric                 as exercicio,
                    null::numeric                 as entidade,
                    null::numeric                 as estornoPagamento
    from tribestornoparcelamento tep
    left join tribparcelamento tp on tp.idparcelamento = tep.idparcelamento
    left join (select case when x.parcela = x.max_parcela
                             then x.valorjurosfinan + x.juros_financiamento_extra -
                                       coalesce((select sum(y.rateio_juros_financiamento)
                                                 from vw_atualizacao_parcelamento y
                                                 where y.idparcelamento = x.idparcelamento
                                                   and y.iddebito = x.iddebito
                                                   and y.receitaorigem = x.receitaorigem
                                                   and y.parcela <> x.max_parcela
                                                   and y.idestornoparcelamento = x.idestornoparcelamento), 0)
                             else x.rateio_juros_financiamento + x.juros_financiamento_extra end as valor,
                      x.idparcelamento,
                      x.iddebitoparcelareceita,
                      1                           as tipoAtualizacao,
                      x.receita,
                      x.guiarecolhimento,
                      x.situacaolegal,
                      'J'                         as classificacao
               from vw_atualizacao_parcelamento x
               where x.rateio_juros + x.rateio_juros_financiamento + x.juros_financiamento_extra > 0
                 and x.dataestorno between :dataInicial and :dataFinal
                 and x.situacaolegal in (1, 2)) as valores on valores.idparcelamento = tp.idparcelamento
    left join tcedebitoinsccreditoda tdida on tdida.iddebitoparcelareceita = valores.iddebitoparcelareceita
    left join tceinsccreditoda tida on tdida.idtceinsccreditoda = tida.idtceinsccreditoda
    left join tribreceita tr on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = valores.receita
    left join tribreceitatipo trt on trt.tiporeceita = tr.tiporeceita
    left join tribclassificacaoreceitatipo tcrt on trt.classificacaoreceitatipo = tcrt.classificacaoreceitatipo
    left join tceatualizamoneparc tampcd on valores.idparcelamento = tampcd.idparcelamento and tampcd.iddebitoparcelareceita = valores.iddebitoparcelareceita
    where tep.datareabilitacao between :dataInicial and :dataFinal
      and tcrt.classificacaoreceitatipo in (1, 2, 3, 4, 5, 7)
      and tep.datareabilitacao != tep.dataestorno
      and exists (select 1
                  from tribestornoparcelamentodebito tepd
                  where tepd.idestornoparcelamento = tep.idestornoparcelamento
                    and tepd.iddebitoorigem < tepd.iddebitodestino)
      and tp.anocontrato = :exercicio
      and valores.situacaolegal in (1, 2)
      and not exists (select 1
                      from tceatualizamoneparcreabilitada tampde
                      where tampde.idestornoparcelamento = tep.idestornoparcelamento
                        and tampde.iddebitoparcelareceita = valores.iddebitoparcelareceita)
) filtro
left join tribguiarecolhimento tg
 on tg.entidade = :entidade
and tg.exercicio = :exercicio
and tg.guiarecolhimento = filtro.guiarecolhimento
order by filtro.dtAtualizacao,
         filtro.nrdivida,
         filtro.nranodivida,
         filtro.idpagamentobloqueto,
         filtro.iddebitoparcelareceita,
         filtro.idTipoAtualizacaoCredito,
         filtro.idtipocredito