select filtro.idpagamentobloqueto,
       filtro.idcreditocontribuinteitem,
       filtro.idTipoOrigemReceita,
       filtro.idTipoArrecadacao,
       filtro.idDevolucaoCredito,
       filtro.sequenciaItem,
       filtro.sequenciaDebito,
       filtro.iddebitoparcelareceita,
       filtro.vlArrecadacao,
       filtro.nrCredito,
       filtro.nrAnoCredito,
       filtro.nrDivida,
       filtro.nrAnoDivida,
       filtro.IdRetencaoContabil,
       filtro.nrMes,
       filtro.nrAno,
       filtro.idTipoCredito,
       filtro.entidade,
       filtro.exercicio,
       filtro.estornoPagamento
from
    (
    -- Pagamento valor normal
        SELECT tpb.idpagamentobloqueto,
               null::numeric as idcreditocontribuinteitem,
               null::numeric as idDevolucaoCredito,
               null::numeric as sequenciaItem,
               null::numeric as sequenciaDebito,
               CASE WHEN tpd.situacaolegal = 0 THEN 1 ELSE 2 END AS idTipoOrigemReceita,
               1 AS idTipoArrecadacao,
               tpd.iddebitoparcelareceita,
               tpd.valorpago AS vlArrecadacao,
               case when (tpd.situacaolegal = 0) then tlc.nrcredito else null::numeric end as nrCredito,
               case when (tpd.situacaolegal = 0) then tlc.nranocredito else null::numeric end as nranocredito,
               case when (tpd.situacaolegal in (1,2)) then tid.nrdivida else null::numeric end as nrdivida,
               case when (tpd.situacaolegal in (1,2)) then tid.nranodivida else null::numeric end as nranodivida,
               null::numeric as IdRetencaoContabil,
               extract(month from tp.datalancamento) as nrMes,
               extract(year  from tp.datalancamento) as nrAno,
               trt.classificacaoreceitatipo as idTipoCredito,
               null::numeric as exercicio,
               null::numeric as entidade,
               null::numeric as estornoPagamento
        FROM tribpagamento tp
             JOIN tribpagamentobloqueto tpb ON tpb.entidade = tp.entidade AND tpb.exerciciopagamento = tp.exerciciopagamento AND tpb.pagamento = tp.pagamento
             JOIN tribpagamentodebito   tpd ON tpd.idpagamentobloqueto = tpb.idpagamentobloqueto
             left join tcedebitolanccredito          tdlc on tdlc.iddebitoparcelareceita = tpd.iddebitoparcelareceita
             left join tcelanccredito                tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito
             left join (select distinct a.idtceinsccreditoda, a.iddebitoparcelareceita from tcedebitoinsccreditoda a) tdic on tdic.iddebitoparcelareceita = tpd.iddebitoparcelareceita
             left join tceinsccreditoda              tid  on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
             left join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita  = tpd.iddebitoparcelareceita
             left join tribreceita tr on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = tdpr.receita
             left JOIN tribreceitatipo trt   ON trt.tiporeceita = tr.tiporeceita
             join contabancaria cb  on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
        WHERE tp.entidade = :entidade
          AND tp.datalancamento  BETWEEN :dataInicial AND :dataFinal
          and tpd.valorpago > 0
          and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
          and coalesce(cb.integraarrecadacao, 'S') = 'S'
          and not exists (select 1 from tcearrtipocreditopagamento atcp
                          where atcp.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                            and atcp.idPagamentoBloqueto = tpd.idPagamentoBloqueto)
        union all
        -- Reabilitacao Pagamento valor normal
        SELECT tpb.idpagamentobloqueto,
               null::numeric as idcreditocontribuinteitem,
               null::numeric as idDevolucaoCredito,
               null::numeric as sequenciaItem,
               null::numeric as sequenciaDebito,
               CASE WHEN tpd.situacaolegal = 0 THEN 1 ELSE 2 END AS idTipoOrigemReceita,
               1 AS idTipoArrecadacao,
               tpd.iddebitoparcelareceita,
               tpd.valorpago AS vlArrecadacao,
               case when (tpd.situacaolegal = 0) then tlc.nrcredito else null::numeric end as nrCredito,
               case when (tpd.situacaolegal = 0) then tlc.nranocredito else null::numeric end as nranocredito,
               case when (tpd.situacaolegal in (1,2)) then tid.nrdivida else null::numeric end as nrdivida,
               case when (tpd.situacaolegal in (1,2)) then tid.nranodivida else null::numeric end as nranodivida,
               null::numeric as IdRetencaoContabil,
               extract(month from tp.datalancamento) as nrMes,
               extract(year  from tp.datalancamento) as nrAno,
               trt.classificacaoreceitatipo as idTipoCredito,
               tep.exercicio as exercicio,
               tep.entidade as entidade,
               tep.estorno as estornoPagamento
        FROM tribpagamento tp
             JOIN tribpagamentobloqueto tpb ON tpb.entidade = tp.entidade AND tpb.exerciciopagamento = tp.exerciciopagamento AND tpb.pagamento = tp.pagamento
             JOIN tribpagamentodebito   tpd ON tpd.idpagamentobloqueto = tpb.idpagamentobloqueto
             left join tcedebitolanccredito          tdlc on tdlc.iddebitoparcelareceita = tpd.iddebitoparcelareceita
             left join tcelanccredito                tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito
             left join (select distinct a.idtceinsccreditoda, a.iddebitoparcelareceita from tcedebitoinsccreditoda a) tdic on tdic.iddebitoparcelareceita = tpd.iddebitoparcelareceita
             left join tceinsccreditoda              tid  on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
             left join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita  = tpd.iddebitoparcelareceita
             left join tribreceita tr on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = tdpr.receita
             left JOIN tribreceitatipo trt   ON trt.tiporeceita = tr.tiporeceita
             join contabancaria cb  on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
             join tribestornopagamento tep on tep.entidade = tp.entidade and tep.exerciciopagamento = tp.exerciciopagamento and tep.pagamento = tp.pagamento
        WHERE tp.entidade = :entidade
             AND tep.datareabilitacao is not null
             and tep.datareabilitacao BETWEEN :dataInicial AND :dataFinal
             and tep.datareabilitacao <> tep.data
             and tpd.valorpago > 0
             and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
             and coalesce(cb.integraarrecadacao, 'S') = 'S'
             and not exists (select 1 from tcearrtipocreditopagreab atcpr
                             where atcpr.exercicio = tep.exercicio
                               and atcpr.entidade = tep.entidade
                               and atcpr.estorno = tep.estorno
                               and atcpr.idpagamentobloqueto = tpd.idpagamentobloqueto
                               and atcpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita)
        union all
        --Pagamento valor pago a maior
        SELECT tpb.idpagamentobloqueto,
               null::numeric as idcreditocontribuinteitem,
               null::numeric as idDevolucaoCredito,
               null::numeric as sequenciaItem,
               null::numeric as sequenciaDebito,
               CASE WHEN tpd.situacaolegal = 0 THEN 1 ELSE 2 END AS idTipoOrigemReceita,
               4 AS idTipoArrecadacao,
               tpd.iddebitoparcelareceita,
               tpd.valorpagomaior	 AS vlArrecadacao,
               case when (tpd.situacaolegal = 0) then tlc.nrcredito else null::numeric end as nrCredito,
               case when (tpd.situacaolegal = 0) then tlc.nranocredito else null::numeric end as nranocredito,
               case when (tpd.situacaolegal in (1,2)) then tid.nrdivida else null::numeric end as nrdivida,
               case when (tpd.situacaolegal in (1,2)) then tid.nranodivida else null::numeric end as nranodivida,
               null::numeric as IdRetencaoContabil,
               extract(month from tp.datalancamento) as nrMes,
               extract(year  from tp.datalancamento) as nrAno,
               trt.classificacaoreceitatipo as idTipoCredito,
               null::numeric as exercicio,
               null::numeric as entidade,
               null::numeric as estornoPagamento
        FROM tribpagamento tp
                 JOIN tribpagamentobloqueto tpb ON tpb.entidade = tp.entidade AND tpb.exerciciopagamento = tp.exerciciopagamento AND tpb.pagamento = tp.pagamento
                 JOIN tribpagamentodebito   tpd ON tpd.idpagamentobloqueto = tpb.idpagamentobloqueto
                 left join tcedebitolanccredito          tdlc on tdlc.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                 left join tcelanccredito                tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito
                 left join (select distinct a.idtceinsccreditoda, a.iddebitoparcelareceita from tcedebitoinsccreditoda a) tdic on tdic.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                 left join tceinsccreditoda              tid  on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
                 left join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita  = tpd.iddebitoparcelareceita
                 left join tribreceita tr on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = tdpr.receita
                 left JOIN tribreceitatipo trt   ON trt.tiporeceita = tr.tiporeceita
                 join contabancaria cb  on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
        WHERE tp.entidade = :entidade
          AND tp.datalancamento  BETWEEN :dataInicial AND :dataFinal
          and tpd.valorpagomaior > 0
          and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
          and coalesce(cb.integraarrecadacao, 'S') = 'S'
          and not exists (select 1 from tcearrtipocreditopagamento atcp
                          where atcp.iddebitoparcelareceita = tpd.iddebitoparcelareceita
                            and atcp.idPagamentoBloqueto = tpd.idPagamentoBloqueto)
        union all
        -- Reabilitacao pagamento valor pago maior
        SELECT tpb.idpagamentobloqueto,
               null::numeric as idcreditocontribuinteitem,
               null::numeric as idDevolucaoCredito,
               null::numeric as sequenciaItem,
               null::numeric as sequenciaDebito,
               CASE WHEN tpd.situacaolegal = 0 THEN 1 ELSE 2 END AS idTipoOrigemReceita,
               4 AS idTipoArrecadacao,
               tpd.iddebitoparcelareceita,
               tpd.valorpagomaior	 AS vlArrecadacao,
               case when (tpd.situacaolegal = 0) then tlc.nrcredito else null::numeric end as nrCredito,
               case when (tpd.situacaolegal = 0) then tlc.nranocredito else null::numeric end as nranocredito,
               case when (tpd.situacaolegal in (1,2)) then tid.nrdivida else null::numeric end as nrdivida,
               case when (tpd.situacaolegal in (1,2)) then tid.nranodivida else null::numeric end as nranodivida,
               null::numeric as IdRetencaoContabil,
               extract(month from tp.datalancamento) as nrMes,
               extract(year  from tp.datalancamento) as nrAno,
               trt.classificacaoreceitatipo as idTipoCredito,
               tep.exercicio as exercicio,
               tep.entidade as entidade,
               tep.estorno as estornoPagamento
        FROM tribpagamento tp
             JOIN tribpagamentobloqueto tpb ON tpb.entidade = tp.entidade AND tpb.exerciciopagamento = tp.exerciciopagamento AND tpb.pagamento = tp.pagamento
             JOIN tribpagamentodebito   tpd ON tpd.idpagamentobloqueto = tpb.idpagamentobloqueto
             left join tcedebitolanccredito          tdlc on tdlc.iddebitoparcelareceita = tpd.iddebitoparcelareceita
             left join tcelanccredito                tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito
             left join (select distinct a.idtceinsccreditoda, a.iddebitoparcelareceita from tcedebitoinsccreditoda a) tdic on tdic.iddebitoparcelareceita = tpd.iddebitoparcelareceita
             left join tceinsccreditoda              tid  on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
             left join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita  = tpd.iddebitoparcelareceita
             left join tribreceita tr on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = tdpr.receita
             left JOIN tribreceitatipo trt   ON trt.tiporeceita = tr.tiporeceita
             join contabancaria cb  on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
             join tribestornopagamento tep on tep.entidade = tp.entidade and tep.exerciciopagamento = tp.exerciciopagamento and tep.pagamento = tp.pagamento
        WHERE tp.entidade = :entidade
             AND tep.datareabilitacao is not null
             and tep.datareabilitacao BETWEEN :dataInicial AND :dataFinal
             and tep.datareabilitacao <> tep.data
             and tpd.valorpagomaior > 0
             and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
             and coalesce(cb.integraarrecadacao, 'S') = 'S'
             and not exists (select 1 from tcearrtipocreditopagreab atcpr
                                         where atcpr.exercicio = tep.exercicio
                                           and atcpr.entidade = tep.entidade
                                           and atcpr.estorno = tep.estorno
                                           and atcpr.idpagamentobloqueto = tpd.idpagamentobloqueto
                                           and atcpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita)
        union all
        -- Credito contribuinte
        SELECT null::numeric as idpagamentobloqueto,
               tcci.idcreditocontribuinteitem,
               null::numeric as idDevolucaoCredito,
               null::numeric as sequenciaItem,
               null::numeric as sequenciaDebito,
               CASE WHEN tdp.situacaolegal = 0 THEN 1 ELSE 2 END AS idTipoOrigemReceita,
               4 AS idTipoArrecadacao,
               tcci.iddebitoparcelareceita,
               tcci.valorlancado AS valor,
               case when (tdp.situacaolegal = 0) then tlc.nrcredito else null::numeric end as nrCredito,
               case when (tdp.situacaolegal = 0) then tlc.nranocredito else null::numeric end as nranocredito,
               case when (tdp.situacaolegal in (1,2)) then tid.nrdivida else null::numeric end as nrdivida,
               case when (tdp.situacaolegal in (1,2)) then tid.nranodivida else null::numeric end as nranodivida,
               null::numeric as IdRetencaoContabil,
               extract(month from tcc.data) as nrMes,
               extract(year  from tcc.data) as nrAno,
               trt.classificacaoreceitatipo as idTipoCredito,
               null::numeric as exercicio,
               null::numeric as entidade,
               null::numeric as estornoPagamento
        FROM tribcreditocontribuinte tcc
                 JOIN tribcreditocontribuinteitem tcci on tcci.entidade = tcc.entidade  and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte  = tcc.creditocontribuinte
                 left outer join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita  = tcci.iddebitoparcelareceita
                 left outer join tribdebitoparcela tdp on tdp.entidade  = tdpr.entidade
            and tdp.exercicio = tdpr.exercicio
            and tdp.tipocadastro = tdpr.tipocadastro
            and tdp.cadastrogeral  = tdpr.cadastrogeral
            and tdp.guiarecolhimento  = tdpr.guiarecolhimento
            and tdp.subdivida  = tdpr.subdivida
            and tdp.parcela = tdpr.parcela
                 left join tcedebitolanccredito          tdlc on tdlc.iddebitoparcelareceita = tcci.iddebitoparcelareceita
                 left join tcelanccredito                tlc  on tlc.idtcelanccredito = tdlc.idtcelanccredito
                 left join (select distinct a.idtceinsccreditoda, a.iddebitoparcelareceita from tcedebitoinsccreditoda a) tdic on tdic.iddebitoparcelareceita = tcci.iddebitoparcelareceita
                 left join tceinsccreditoda              tid  on tid.idtceinsccreditoda = tdic.idtceinsccreditoda
                 left join tribreceita tr on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = tdpr.receita
                 left JOIN tribreceitatipo trt   ON trt.tiporeceita = tr.tiporeceita
                 join contabancaria cb  on cb.entidade = tcc.entidade and cb.contabancaria = tcc.contabancaria
        WHERE tcc.entidade = :entidade
          AND tcc.data BETWEEN :dataInicial AND :dataFinal
          and tcci.valorlancado > 0
          and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
          and coalesce(cb.integraarrecadacao, 'S') = 'S'
          and not exists (select 1 from tceArrTipocreditoCredito atcc
                          where atcc.idcreditocontribuinteitem = tcci.idcreditocontribuinteitem
                            and atcc.iddebitoparcelareceita = tcci.iddebitoparcelareceita)
        union all
        -- Retencao contabil
        SELECT
            null::numeric as idpagamentobloqueto,
            null::numeric as idcreditocontribuinteitem,
            null::numeric as idDevolucaoCredito,
            null::numeric as sequenciaItem,
            null::numeric as sequenciaDebito,
            1 as idTipoOrigemReceita,
            1 AS idTipoArrecadacao,
            null::numeric as iddebitoparcelareceita,
            trc.valor - coalesce(est.vlEstorno, 0) AS vlArrecadacao,
            tlc.nrcredito as nrCredito,
            tlc.nranocredito as nranocredito,
            null::numeric as nrDivida,
            null::numeric as nranodivida,
            trc.IdRetencaoContabil,
            extract(month from trc.dtlancamento) as nrMes,
            extract(year  from trc.dtlancamento) as nrAno,
            trc.idtipocredito                    as idtipocredito,
            null::numeric as exercicio,
            null::numeric as entidade,
            null::numeric as estornoPagamento
        from tceRetencaoContabil trc
                 join tceretencaolanccredito rlc on trc.idretencaocontabil = rlc.idretencaocontabil
                 join tcelanccredito tlc on rlc.idtcelanccredito = tlc.idtcelanccredito
                 left join (
                    select est.idtipocredito,
                           est.dtlancamento,
                           sum(est.valor) as vlEstorno
                    from tceRetencaoContabil est
                    where est.dtlancamento BETWEEN :dataInicial AND :dataFinal
                      and coalesce(est.devolucao, 'N') = 'S'
                    group by est.idtipocredito, est.dtlancamento
                 ) est on est.idtipocredito = trc.idtipocredito
                       and est.dtlancamento = trc.dtlancamento
        where (trc.dtlancamento BETWEEN :dataInicial AND :dataFinal)
          and coalesce(trc.devolucao, 'N') = 'N'
          and not exists (
            select 1 from tcearrtipocreditoretencao tatcr
            where tatcr.idretencaocontabil = trc.idRetencaoContabil
          )
          and trc.valor - coalesce(est.vlEstorno, 0) > 0
        union all
        -- Devolucao de credito
        select
            null::numeric as idpagamentobloqueto,
            null::numeric as idcreditocontribuinteitem,
            dd.idDevolucaoCredito,
            dd.sequenciaItem,
            dd.sequenciaDebito,
            CASE WHEN tdp.situacaolegal = 0 THEN 1 ELSE 2 END AS idTipoOrigemReceita,
            3 as idTipoArrecadacao,
            dd.iddebitoparcelareceita,
            dd.valordevolvido AS vlArrecadacao,
            case when (tpd.situacaolegal = 0) then tlc.nrcredito else null::numeric end as nrCredito,
            case when (tpd.situacaolegal = 0) then tlc.nranocredito else null::numeric end as nranocredito,
            case when (tpd.situacaolegal in (1,2)) then tid.nrdivida else null::numeric end as nrdivida,
            case when (tpd.situacaolegal in (1,2)) then tid.nranodivida else null::numeric end as nranodivida,
            null::numeric as IdRetencaoContabil,
            extract(month from d.data) as nrMes,
            extract(year  from d.data) as nrAno,
            trt.classificacaoreceitatipo as idtipocredito,
            null::numeric as exercicio,
            null::numeric as entidade,
            null::numeric as estornoPagamento
        from tribDevolucaoCredito            d
                 join tribDevolucaoCreditoItem     di   on di.iddevolucaocredito = d.iddevolucaocredito
                 join tribDevolucaoCreditoDebito   dd   on dd.iddevolucaocredito = di.iddevolucaocredito and dd.sequenciaitem = di.sequenciaitem
                 join tribDebitoParcelaReceita     tdpr on dd.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                 left join tcerestituicaolanccredito rt on rt.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                     and rt.sequenciaitem = di.sequenciaitem
                     and rt.sequenciadebito = dd.sequenciadebito
                     and rt.iddevolucaocredito = d.iddevolucaocredito
                 left join tcelanccredito                tlc  on tlc.idtcelanccredito = rt.idtcerestlanccredito
                 left join tcerestituicaoda   rtda on rtda.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                     and rtda.sequenciaitem = di.sequenciaitem
                     and rtda.sequenciadebito = dd.sequenciadebito
                     and rtda.iddevolucaocredito = d.iddevolucaocredito
                 left join tceinsccreditoda              tid  on tid.idtceinsccreditoda = rtda.idtcerestda
                 join tribdebitoparcela            tdp  on tdp.entidade  = tdpr.entidade and tdp.exercicio = tdpr.exercicio
                                                           and tdp.tipocadastro = tdpr.tipocadastro and tdp.cadastrogeral  = tdpr.cadastrogeral
                                                           and tdp.guiarecolhimento  = tdpr.guiarecolhimento and tdp.subdivida  = tdpr.subdivida
                                                           and tdp.parcela = tdpr.parcela
                 join tribreceita                  tr   on tr.entidade = :entidade and tr.exercicio = :exercicio and tr.receita = tdpr.receita
                 join tribreceitatipo              trt  on trt.tiporeceita = tr.tiporeceita
                 join tribclassificacaoreceitatipo tcrt on tcrt.classificacaoreceitatipo = trt.classificacaoreceitatipo
                 join contabancaria                cb   on cb.entidade = d.entidade and cb.contabancaria = d.contabancaria
                 join tribpagamentodebito tpd on tpd.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
        where d.entidade = :entidade
          and d.data between :dataInicial and :dataFinal
          and trt.classificacaoreceitatipo in (1,2,3,4,5,7)
          and coalesce(cb.integraarrecadacao, 'S') = 'S'
          and d.situacao = 'D'
          and not exists (
            select 1
            from tceArrTipoCreditoDevolucao x
            where x.idDevolucaoCredito = dd.idDevolucaoCredito
              and x.sequenciaItem = dd.sequenciaItem
              and x.sequenciaDebito = dd.sequenciaDebito
        )
    ) as filtro
ORDER by filtro.idTipoOrigemReceita