SELECT tdpr.iddebitoparcelareceita,
       trt.classificacaoreceitatipo as classificacaoreceita,
       CASE
           WHEN (tdp.situacaolegal in (1, 2)) AND (tdp.datadividaativa > :dataReferencia) THEN 0
           WHEN tdp.situacaolegal in (1, 2) THEN 1
           ELSE tdp.situacaolegal
           END                      AS situacaolegal,
       tdp.situacaodebito,
       CASE
           WHEN td.datacontabilizacao >= tdp.datalancamento then td.datacontabilizacao
           WHEN td.datainclusao > tdp.datalancamento then td.datainclusao
           ELSE tdp.datalancamento
           END                      AS datalancamento,
       tdp.datasituacao,
       tdp.datadividaativa,
       td.entidade,
       tdpr.exercicio,
       tgr.idkey                    AS idDivida,
       tdpr.guiarecolhimento        AS divida,
       td.formacorrecao,
       COALESCE(tdpr.valororiginal, tdpr.valor) AS valor,
       tgr.fundamentolegal
FROM tribdebitoparcelareceita tdpr
         JOIN tribdebitoparcela tdp ON tdp.entidade = tdpr.entidade
    AND tdp.exercicio = tdpr.exercicio
    AND tdp.tipocadastro = tdpr.tipocadastro
    AND tdp.cadastrogeral = tdpr.cadastrogeral
    AND tdp.guiarecolhimento = tdpr.guiarecolhimento
    AND tdp.subdivida = tdpr.subdivida
    AND tdp.parcela = tdpr.parcela
         JOIN tribdebito td ON td.entidade = tdp.entidade
    AND td.exercicio = tdp.exercicio
    AND td.tipocadastro = tdp.tipocadastro
    AND td.cadastrogeral = tdp.cadastrogeral
    AND td.guiarecolhimento = tdp.guiarecolhimento
    AND td.subdivida = tdp.subdivida
         JOIN tribguiarecolhimento tgr ON :entidade = tgr.entidade
    AND :exercicio = tgr.exercicio
    AND td.guiarecolhimento = tgr.guiarecolhimento
         JOIN tribreceita tr ON tr.receita = tdpr.receita
    AND tr.exercicio = :exercicio
    AND tr.entidade = tdpr.entidade
         JOIN tribreceitatipo trt ON trt.tiporeceita = tr.tiporeceita
         JOIN tribsituacaoparcela tsp ON tdp.situacaodebito = tsp.situacaoparcela
         JOIN tribtiposituacaoparcela ttsp ON tsp.tiposituacaoparcela = ttsp.tiposituacaoparcela
WHERE tdpr.entidade = :entidade
  AND COALESCE(tdpr.valororiginal, tdpr.valor) > 0
  AND ((td.datacontabilizacao is not null and td.datacontabilizacao <= :dataReferencia)
    OR (td.datacontabilizacao IS NULL and ((tgr.tipoguiarecolhimento <> 'H')) AND td.datainclusao <= :dataReferencia)
    OR (td.datacontabilizacao IS NULL and ((tgr.tipoguiarecolhimento = 'H')) AND tdp.datalancamento <= :dataReferencia))
  AND td.constituido = 'S'
  AND ((ttsp.tipo = 'A') or (ttsp.tipo <> 'A' AND tdp.datasituacao > :dataReferencia))