Select coalesce(Sum(dci.ValorDevolucao),0) as Valor
 From TribDevolucaoCreditoItem dci
 Left Outer JOin TribDevolucaoCredito tdc on
      dci.IDDevolucaoCredito = tdc.IDDevolucaoCredito
 where tdc.data >= :DataInicial and tdc.data <= :DataFinal
 and (exists (Select a.Entidade from tribCreditoContribuinte a
                 left outer join tribbloqueto tbloq on
                      a.Entidade = tbloq.entidade
                      and a.ExercicioBloqueto = tbloq.ExercicioBloqueto
                      and a.Bloqueto = tbloq.Bloqueto
                 left outer join TribCreditoContribuinteItem cci on
                      a.Entidade = cci.Entidade
                      and a.Exercicio = cci.Exercicio
                      and a.CreditoContribuinte = cci.CreditoContribuinte
                     left outer join tribDebitoParcelaReceita dpr on
                      cci.IDDebitoParcelaReceita = dpr.IDDebitoParcelaReceita
                  Where dpr.entidade = :Entidade
                    and dpr.Exercicio = :Exercicio
                    and dpr.guiarecolhimento in (1,2)
                    and tbloq.TipoBloqueto = 'U'
                    and dci.Entidade = a.Entidade
                    and dci.Exercicio = a.Exercicio
                    and dci.CreditoContribuinte = a.CreditoContribuinte)
 or exists (Select b.Entidade from tribpagamentodebito a
                  left outer join tribdebitoparcelareceita b on
                       a.IDDebitoParcelaReceita = b.IDDebitoParcelaReceita
                  left outer join tribpagamentobloqueto tpb on
                       a.IDPagamentoBloqueto = tpb.IDPagamentoBloqueto
                  left outer join tribbloqueto tbloq on
                       tpb.Entidade = tbloq.entidade
                       and tpb.ExercicioBloqueto = tbloq.ExercicioBloqueto
                       and tpb.Bloqueto = tbloq.Bloqueto
                  left outer join tribpagamento pag on
                       tpb.Entidade = pag.Entidade and
                       tpb.ExercicioPagamento = pag.ExercicioPagamento and
                       tpb.Pagamento = pag.Pagamento
                   where b.Entidade = :Entidade
                     and b.exercicio = :Exercicio
                     and b.guiarecolhimento in (1,2)
                     and tbloq.TipoBloqueto = 'U'
                     and dci.Entidade = pag.Entidade
                     and dci.ExercicioPagamento = pag.ExercicioPagamento
                     and dci.Pagamento = pag.Pagamento))