select distinct
    tlr.entidade,
    tlr.exercicio,
    tlr.livro as id,
    tcg.idkey as idCadastro,
    tlr.pessoacontribuinte as codigoPessoa,
    tlr.nomecontribuinte as nomePessoa,
    tlr.tipocadastro as tipocadastro,
    tlr.cadastrogeral as cadastrogeral
from triblivroregistro tlr
         left join triblivroparcelareceita tlpr on tlr.entidade = tlpr.entidade and tlr.exercicio = tlpr.exercicio
                                                and tlr.livro = tlpr.livro and tlr.sequencia = tlpr.sequencia
         left join tribcadastrogeral tcg on tlr.tipocadastro = tcg.tipocadastro and tlr.cadastrogeral = tcg.cadastrogeral
                                        and tlr.pessoacontribuinte = tcg.pessoa
         left join tribdebitoparcelareceita tdpr on tlpr.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
         left join tribdebito td on tdpr.entidade = td.entidade and tdpr.exercicio = td.exercicio
                                and tdpr.tipocadastro = td.tipocadastro and tdpr.cadastrogeral = td.cadastrogeral
                                and tdpr.guiarecolhimento = td.guiarecolhimento and tdpr.subdivida = td.subdivida
         left join triblivro l on l.entidade = tlr.entidade and l.exercicio = tlr.exercicio
                              and l.livro = tlr.livro
where tlr.entidade = %s
  and tlr.exercicio = %s
  and tlr.livro = %s
  and l.tipolivro = 'EFETIVO'
