SELECT TPI.CATEGORIA as categoria,
	   TPI.DESTINACAO as destinacao,
	   TPI.TIPOOBRA as tipoObra,
       TPI.TIPOCONSTRUCAO as tipoConstrucao,
	   SUM(TPI.AREA) as area,
	   SUM(TPI.AREACOBERTA) as areaCoberta,
       SUM(TPI.AREADESCOBERTA) as AreaDescoberta,
	   MIN(TPI.SEQUENCIAAREA) as sequenciaArea,
	   TPI.QTDETOTALUNIDADE as qtdeTotalUnidade,
	   TTS.TIPOAREASISOBRA as tipoAreaSisObra,
       TTS.IDTIPOAREASISOBRA as idTipoAreaSisObra
FROM TRIBPROJETO TP
JOIN TRIBPROJETOITEM TPI ON TPI.ENTIDADE = TP.ENTIDADE AND TPI.EXERCICIO = TP.EXERCICIO AND TPI.PROJETO = TP.PROJETO
LEFT OUTER JOIN TRIBTIPOSEGMENTO TTS ON TTS.TIPOSEGMENTO = TPI.TIPOSEGMENTO
WHERE TP.ENTIDADE = :entidade
  AND TP.EXERCICIO = :exercicio
  AND TP.PROJETO = :projeto
GROUP BY TPI.CATEGORIA,
         TPI.DESTINACAO,
         TPI.TIPOOBRA,
         TPI.TIPOCONSTRUCAO,
         TPI.QTDETOTALUNIDADE,
         TTS.TIPOAREASISOBRA,
         TTS.IDTIPOAREASISOBRA
ORDER BY TTS.TIPOAREASISOBRA DESC,MIN(TPI.SEQUENCIAAREA)