SELECT
    A.NRO_ALVARA_HABITESE as NROALVARAHABITESE,
    A.DATA_ALVARA_HABITESE as DATAALVARAHABITESE,
    A.ANO_ALVARA_HABITESE as ANOALVARAHABITESE,
    A.EXERCICIO_DOCUMENTO as EXERCICIODOCUMENTO,
    A.TIPODOCUMENTO,
    A.DOCUMENTO,
    A.DATAEMISSAO,
    A.CERT_DATAEMISSAO as CERTDATAEMISSAO,
    A.TIPOCADASTRO,
    A.CADASTROGERAL,
    A.EXERCICIO AS EXERCICIOPROJETO,
    A.PROJETO,
    A.DATAINICIO,
    A.DATAENCERRAMENTO,
    A.SITUACAO,
    A.APROVADO,
    CASE WHEN A.IDPROCESSO IS NOT NULL AND A.EXERCICIOPROTOCOLO IS NOT NULL THEN A.IDPROCESSO||'/'||A.EXERCICIOPROTOCOLO ELSE '' END AS NUMEROPROCESSO,
    A.PESSOA,
    A.PESSOARESPONSAVEL,
    A.TIPOVINCULO,
    A.DATAEMISSAO_DOC,
    A.OBRA_NOME as OBRANOME,
    A.OBRA_TIPOLOGRADOURO as OBRATIPOLOGRADOURO,
    A.OBRA_LOGRADOURO as OBRALOGRADOURO,
    A.OBRA_NUMERO as OBRANUMERO,
    A.OBRA_COMPLEMENTO as OBRACOMPLEMENTO,
    A.OBRA_BAIRRO as OBRABAIRRO,
    A.OBRA_CEP as OBRACEP,
    SUM(A.AREA_TOTAL) AS AREATOTAL,
    SUM(A.AREA) AS AREA,
    A.CNPJ_PROPRIETARIO_OBRA as CNPJPROPRIETARIOOBRA,
    A.CPF_PROPRIETARIO_OBRA as CPFPROPRIETARIOOBRA,
    A.NOME_RESP_PROJETO as NOMERESPPROJETO,
    A.NRO_CARTEIRA_RESP_PROJETO as NROCARTEIRARESPPROJETO ,
    A.TIPO_CARTEIRA_RESP_PROJETO as TIPOCARTEIRARESPPROJETO,
    A.NOME_RESP_EXEC as NOMERESPEXEC,
    A.NRO_CARTEIRA_RESP_EXEC as NROCARTEIRARESPEXEC,
    A.TIPO_CARTEIRA_RESP_EXEC as TIPOCARTEIRARESPEXEC,
    CASE WHEN A.TIPO_CARTEIRA_RESP_PROJETO = 'CAU'  THEN A.NOME_RESP_PROJETO ELSE '' END AS NOMEARQUITETORESPPROJ,
    CASE WHEN A.TIPO_CARTEIRA_RESP_PROJETO = 'CREA'  THEN A.NOME_RESP_PROJETO ELSE '' END AS NOMEENGENHEIRORESPPROJ,
    CASE WHEN A.TIPO_CARTEIRA_RESP_PROJETO = 'CAU'  THEN A.NRO_CARTEIRA_RESP_PROJETO ELSE '' END AS CAUARQUITETORESPPROJ,
    CASE WHEN A.TIPO_CARTEIRA_RESP_PROJETO = 'CREA'  THEN A.NRO_CARTEIRA_RESP_PROJETO ELSE '' END AS CREAENGENHEIRORESPPROJ,
    CASE WHEN A.TIPO_CARTEIRA_RESP_EXEC = 'CAU'  THEN A.NOME_RESP_EXEC ELSE '' END AS NOMEARQUITETORESPEXEC,
    CASE WHEN A.TIPO_CARTEIRA_RESP_EXEC = 'CREA'  THEN A.NOME_RESP_EXEC ELSE '' END AS NOMEENGENHEIRORESPEXEC,
    CASE WHEN A.TIPO_CARTEIRA_RESP_EXEC = 'CAU'  THEN A.NRO_CARTEIRA_RESP_EXEC ELSE '' END AS CAUARQUITETORESPEXEC,
    CASE WHEN A.TIPO_CARTEIRA_RESP_EXEC = 'CREA'  THEN A.NRO_CARTEIRA_RESP_EXEC ELSE '' END AS CREAENGENHEIRORESPEXEC,
    A.ART_ENGENHEIRO as ARTENGENHEIRO,
    A.RRT_ARQUITETO as RRTARQUITETO,
    A.PROPRIETARIO_IMOVEL as PROPRIETARIOIMOVEL,
    A.CPF_DONO_OBRA as CPFDONOOBRA,
    A.CNPJ_DONO_OBRA as CNPJDONOOBRA,
    A.CPF_CONSTRUTORA as CPFCONSTRUTORA,
    A.CNPJ_CONSTRUTORA as CNPJCONSTRUTORA,
    A.CPF_INCORPORADORA as CPFINCORPORADORA,
    A.CNPJ_INCORPORADORA as CNPJINCORPORADORA,
    A.CPF_LIDER_CONSORCIO as CPFLIDERCONSORCIO,
    A.CNPJ_LIDER_CONSORCIO as CNPJLIDERCONSORCIO,
    A.CPF_CONSORCIO as CPFCONSORCIO,
	A.CNPJ_CONSORCIO as CNPJCONSORCIO,
	A.CNPJ_CPF as CNPJCPFDOCUMENTO,
	A.ENVIADO,
    A.ENVIADOCOMSUCESSO,
    A.IDSISOBRAHABITESE,
    A.TIPODOCUMENTOALVARA
FROM (
SELECT DISTINCT
		DOC.EXERCICIO AS EXERCICIO_DOCUMENTO,
        DOC.TIPODOCUMENTO,
        DOC.DOCUMENTO,
        DOC.DATAEMISSAO,
        DOCCERTIDAO.DATAEMISSAO AS CERT_DATAEMISSAO,
        PJ.TIPOCADASTRO,
        PJ.CADASTROGERAL,
        PJ.EXERCICIO,
        PJ.PROJETO,
        CASE WHEN (CI.NROALVARA IS NOT NULL) AND (DOCALVARA.DATAEMISSAO IS NOT NULL) AND (DOCALVARA.DATAEMISSAO > '1900-01-01') AND (DOC.TIPODOCUMENTO IN (15,52)) THEN DOCALVARA.DATAEMISSAO
        	 WHEN (CI.NROALVARA IS NOT NULL) AND (DOCALVARA.DATAEMISSAO IS NULL) AND (DOCALVARA.DATAEMISSAO > '1900-01-01') AND (DOC.TIPODOCUMENTO IN (15,52)) THEN CI.DATAAPROVACAO
             WHEN (CI.NROALVARA IS NULL) AND (DOC.DATAPRIMEIROALVARA IS NOT NULL) AND (DOC.DATAPRIMEIROALVARA > '1900-01-01')AND (DOC.TIPODOCUMENTO IN (15,52)) THEN DOC.DATAPRIMEIROALVARA
             ELSE DOC.DATAEMISSAO
        END AS DATAINICIO,
        CASE WHEN DOC.TIPODOCUMENTO IN (15, 52, 53) THEN DOC.DATAEMISSAO ELSE PJ.DATAENCERRAMENTO END AS DATAENCERRAMENTO,
        PJ.SITUACAO,
        PJ.APROVADO,
        PJ.EXERCICIOPROTOCOLO,
        PJ.IDPROCESSO,
        PJ.PESSOA,
        PJ.PESSOARESPONSAVEL,
        CASE WHEN PJ.TIPOVINCULO IS NULL THEN 51 ELSE PJ.TIPOVINCULO END AS TIPOVINCULO,
        CASE WHEN (CI.NROALVARA IS NOT NULL) AND (DOCALVARA.DATAEMISSAO IS NOT NULL) AND (DOCALVARA.DATAEMISSAO > '1900-01-01') AND (DOC.TIPODOCUMENTO IN (15,52)) THEN DOCALVARA.DATAEMISSAO
             WHEN (CI.NROALVARA IS NOT NULL) AND (DOCALVARA.DATAEMISSAO IS NULL) AND (DOCALVARA.DATAEMISSAO > '1900-01-01') AND (DOC.TIPODOCUMENTO IN (15,52)) THEN CI.DATAAPROVACAO
             WHEN (CI.NROALVARA IS NULL) AND (DOC.DATAPRIMEIROALVARA IS NOT NULL) AND (DOC.DATAPRIMEIROALVARA > '1900-01-01') AND (DOC.TIPODOCUMENTO IN (15,52)) THEN DOC.DATAPRIMEIROALVARA
        	 ELSE DOC.DATAEMISSAO
        END AS DATAEMISSAO_DOC,
        CASE WHEN PJ.TIPOVINCULO = 51 THEN RESP_EXEC_OBRA.NOME WHEN PJ.PROJETO IS NULL THEN PESO.NOME ELSE '' END AS PROPRIETARIO_IMOVEL,
        CASE WHEN PJ.TIPOVINCULO = 52 AND RESP_EXEC_OBRA.TIPOPESSOA = 'F' THEN RESP_EXEC_OBRA.CNPJ_CPF ELSE '' END AS CPF_DONO_OBRA,
        CASE WHEN PJ.TIPOVINCULO = 52 AND RESP_EXEC_OBRA.TIPOPESSOA = 'J' THEN RESP_EXEC_OBRA.CNPJ_CPF ELSE '' END AS CNPJ_DONO_OBRA,
        CASE WHEN PJ.TIPOVINCULO = 53 AND RESP_EXEC_OBRA.TIPOPESSOA = 'F' THEN RESP_EXEC_OBRA.CNPJ_CPF ELSE '' END AS CPF_CONSTRUTORA,
        CASE WHEN PJ.TIPOVINCULO=53 AND RESP_EXEC_OBRA.TIPOPESSOA = 'J' THEN RESP_EXEC_OBRA.CNPJ_CPF ELSE '' END AS CNPJ_CONSTRUTORA,
        CASE WHEN PJ.TIPOVINCULO=54 AND RESP_EXEC_OBRA.TIPOPESSOA = 'F' THEN RESP_EXEC_OBRA.CNPJ_CPF ELSE '' END AS CPF_INCORPORADORA,
        CASE WHEN PJ.TIPOVINCULO=54 AND RESP_EXEC_OBRA.TIPOPESSOA = 'J' THEN RESP_EXEC_OBRA.CNPJ_CPF ELSE '' END AS CNPJ_INCORPORADORA,
        CASE WHEN PJ.TIPOVINCULO=55 AND RESP_EXEC_OBRA.TIPOPESSOA = 'F' THEN RESP_EXEC_OBRA.CNPJ_CPF ELSE '' END AS CPF_LIDER_CONSORCIO,
        CASE WHEN PJ.TIPOVINCULO=55 AND RESP_EXEC_OBRA.TIPOPESSOA = 'J' THEN RESP_EXEC_OBRA.CNPJ_CPF ELSE '' END AS CNPJ_LIDER_CONSORCIO,
        CASE WHEN PJ.TIPOVINCULO=56 AND RESP_EXEC_OBRA.TIPOPESSOA = 'F' THEN RESP_EXEC_OBRA.CNPJ_CPF ELSE '' END AS CPF_CONSORCIO,
        CASE WHEN PJ.TIPOVINCULO=56 AND RESP_EXEC_OBRA.TIPOPESSOA = 'J' THEN RESP_EXEC_OBRA.CNPJ_CPF ELSE '' END AS CNPJ_CONSORCIO,
        CASE WHEN DOC.TIPODOCUMENTO IN (15,52) THEN
                 (CASE WHEN (DOC.NUMEROPRIMEIROALVARA IS NOT NULL) AND (TRIM(DOC.NUMEROPRIMEIROALVARA) <> '') THEN DOC.NUMEROPRIMEIROALVARA
                       WHEN (CI.NROALVARA IS NOT NULL) AND (TRIM(CI.NROALVARA) <> '') THEN CI.NROALVARA
                       ELSE
	                    (SELECT CAST(MAX(ALV.DOCUMENTO) AS VARCHAR(20)) FROM TRIBDOCUMENTO ALV
	                    WHERE ALV.ENTIDADE = 1
	                      AND ALV.TIPODOCUMENTO IN (14,50,51)
	                      AND ALV.TIPOCADASTRO = DOC.TIPOCADASTRO
	                      AND ALV.CADASTROGERAL = DOC.CADASTROGERAL
	                      AND ALV.DATAEMISSAO <= DOC.DATAEMISSAO
	                      AND ALV.DOCUMENTO = (SELECT MAX(ALV1.DOCUMENTO) FROM TRIBDOCUMENTO ALV1
											 WHERE ALV1.ENTIDADE = 1
											   AND ALV1.TIPODOCUMENTO IN (14,49,50,51)
											   AND ALV1.TIPOCADASTRO = DOC.TIPOCADASTRO
											   AND ALV1.CADASTROGERAL = DOC.CADASTROGERAL
											   AND ALV1.EXERCICIO = ( SELECT MAX(ALV2.EXERCICIO) FROM TRIBDOCUMENTO ALV2
                                                                      WHERE ALV2.ENTIDADE = 1
                                                                      AND ALV2.TIPODOCUMENTO IN (14,49,50,51)
                                                                      AND ALV2.TIPOCADASTRO = DOC.TIPOCADASTRO
                                                                      AND ALV2.CADASTROGERAL = DOC.CADASTROGERAL
                                                                      AND ALV2.DATAEMISSAO <= DOC.DATAEMISSAO)
											   AND ALV1.DATAEMISSAO <= DOC.DATAEMISSAO))
	                   END)
             ELSE ''
        END AS NRO_ALVARA_HABITESE,
		CASE WHEN DOC.ANOEMISSAOALVARA IS NOT NULL THEN DOC.ANOEMISSAOALVARA
             ELSE (SELECT CAST(MAX(ALV.EXERCICIO) AS VARCHAR(20)) FROM TRIBDOCUMENTO ALV
                   WHERE ALV.ENTIDADE = 1
                      AND ALV.TIPODOCUMENTO IN (14,50,51)
                      AND ALV.TIPOCADASTRO = DOC.TIPOCADASTRO
                      AND ALV.CADASTROGERAL = DOC.CADASTROGERAL
                      AND ALV.DATAEMISSAO <= DOC.DATAEMISSAO
                      AND ALV.DOCUMENTO = (SELECT MAX(ALV1.DOCUMENTO) FROM TRIBDOCUMENTO ALV1
											 WHERE ALV1.ENTIDADE = 1
											   AND ALV1.TIPODOCUMENTO IN (14,49,50,51)
											   AND ALV1.TIPOCADASTRO = DOC.TIPOCADASTRO
											   AND ALV1.CADASTROGERAL = DOC.CADASTROGERAL
											   AND ALV1.EXERCICIO = ( SELECT MAX(ALV2.EXERCICIO) FROM TRIBDOCUMENTO ALV2
                                                                      WHERE ALV2.ENTIDADE = 1
                                                                      AND ALV2.TIPODOCUMENTO IN (14,49,50,51)
                                                                      AND ALV2.TIPOCADASTRO = DOC.TIPOCADASTRO
                                                                      AND ALV2.CADASTROGERAL = DOC.CADASTROGERAL
                                                                      AND ALV2.DATAEMISSAO <= DOC.DATAEMISSAO)
											   AND ALV1.DATAEMISSAO <= DOC.DATAEMISSAO))
        END AS ANO_ALVARA_HABITESE,
        CASE WHEN (ALVORIGEM.DATAEMISSAO IS NOT NULL) AND (ALVORIGEM.DATAEMISSAO > '1900-01-01') THEN ALVORIGEM.DATAEMISSAO
			 WHEN (DOC.DATAPRIMEIROALVARA IS NOT NULL) AND (DOC.DATAPRIMEIROALVARA > '1900-01-01') THEN DOC.DATAPRIMEIROALVARA
			 ELSE (SELECT MAX(ALV.DATAEMISSAO) FROM TRIBDOCUMENTO ALV
				   LEFT JOIN TRIBDOCUMENTO ALVORIGEM ON ALV.NUMEROPRIMEIROALVARA = CAST(ALVORIGEM.DOCUMENTO AS VARCHAR(20))
					  AND ALV.ANOEMISSAOALVARA = CAST(ALVORIGEM.EXERCICIO AS VARCHAR(20))
					  AND ALV.TIPODOCUMENTO IN (14,50,51)
				   WHERE ALV.ENTIDADE = 1
					  AND ALV.TIPODOCUMENTO IN (14,49,50,51)
					  AND ALV.TIPOCADASTRO = DOC.TIPOCADASTRO
					  AND ALV.CADASTROGERAL = DOC.CADASTROGERAL
					  AND ALV.DATAEMISSAO <= DOC.DATAEMISSAO
					  AND ALV.DOCUMENTO = (SELECT MAX(ALV1.DOCUMENTO) FROM TRIBDOCUMENTO ALV1
											 WHERE ALV1.ENTIDADE = 1
											   AND ALV1.TIPODOCUMENTO IN (14,49,50,51)
											   AND ALV1.TIPOCADASTRO = DOC.TIPOCADASTRO
											   AND ALV1.CADASTROGERAL = DOC.CADASTROGERAL
											   AND ALV1.EXERCICIO = ( SELECT MAX(ALV2.EXERCICIO) FROM TRIBDOCUMENTO ALV2
                                                                      WHERE ALV2.ENTIDADE = 1
                                                                      AND ALV2.TIPODOCUMENTO IN (14,49,50,51)
                                                                      AND ALV2.TIPOCADASTRO = DOC.TIPOCADASTRO
                                                                      AND ALV2.CADASTROGERAL = DOC.CADASTROGERAL
                                                                      AND ALV2.DATAEMISSAO <= DOC.DATAEMISSAO)
											   AND ALV1.DATAEMISSAO <= DOC.DATAEMISSAO))
        END AS DATA_ALVARA_HABITESE,
		CASE
			WHEN (ALVORIGEM.TIPODOCUMENTO IS NOT NULL)
			THEN ALVORIGEM.TIPODOCUMENTO
			ELSE (
			SELECT
				MAX(ALV.TIPODOCUMENTO)
			FROM
				TRIBDOCUMENTO ALV
			LEFT JOIN TRIBDOCUMENTO ALVORIGEM ON
				ALV.NUMEROPRIMEIROALVARA = CAST(ALVORIGEM.DOCUMENTO AS VARCHAR(20))
					AND ALV.ANOEMISSAOALVARA = CAST(ALVORIGEM.EXERCICIO AS VARCHAR(20))
						AND ALV.TIPODOCUMENTO IN (14, 50, 51)
					WHERE
						ALV.ENTIDADE = 1
						AND ALV.TIPODOCUMENTO IN (14, 49, 50, 51)
							AND ALV.TIPOCADASTRO = DOC.TIPOCADASTRO
							AND ALV.CADASTROGERAL = DOC.CADASTROGERAL
							AND ALV.DATAEMISSAO <= DOC.DATAEMISSAO
							AND ALV.DOCUMENTO = (
							SELECT
								MAX(ALV1.DOCUMENTO)
							FROM
								TRIBDOCUMENTO ALV1
							WHERE
								ALV1.ENTIDADE = 1
								AND ALV1.TIPODOCUMENTO IN (14, 49, 50, 51)
									AND ALV1.TIPOCADASTRO = DOC.TIPOCADASTRO
									AND ALV1.CADASTROGERAL = DOC.CADASTROGERAL
									AND ALV1.EXERCICIO = (
									SELECT
										MAX(ALV2.EXERCICIO)
									FROM
										TRIBDOCUMENTO ALV2
									WHERE
										ALV2.ENTIDADE = 1
										AND ALV2.TIPODOCUMENTO IN (14, 49, 50, 51)
											AND ALV2.TIPOCADASTRO = DOC.TIPOCADASTRO
											AND ALV2.CADASTROGERAL = DOC.CADASTROGERAL
											AND ALV2.DATAEMISSAO <= DOC.DATAEMISSAO)
									AND ALV1.DATAEMISSAO <= DOC.DATAEMISSAO))
		END AS TIPODOCUMENTOALVARA,
        RESPONSAVEL.NOME AS OBRA_NOME,
        TILOGO.DESCRICAO AS OBRA_TIPOLOGRADOURO,
        CASE WHEN LOGO.LOGRADOURO IS NULL THEN 'NAO CADASTRADO' ELSE LOGO.DESCRICAO END AS OBRA_LOGRADOURO,
        TCG.NUMERO AS OBRA_NUMERO,
        SUBSTR(TCG.COMPLEMENTO,1,60) AS OBRA_COMPLEMENTO,
        CASE WHEN BAIO.BAIRRO IS NULL THEN 'NAO CADASTRADO' ELSE BAIO.DESCRICAO END AS OBRA_BAIRRO,
        RPAD(CAST(TCG.CEP AS VARCHAR(10)),8,'0') AS OBRA_CEP,
        CASE WHEN (UTIL.TIPO = 'R' AND DOC.TIPODOCUMENTO NOT IN (11,53) AND (IPIR.TIPOITEMCONSTRUCAOCIVIL <> 3 OR IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL) AND (DOC.SUBTIPO <> '4' OR DOC.TIPODOCUMENTO <> 14)) THEN 1
             WHEN (UTIL.TIPO IN ('C') AND DOC.TIPODOCUMENTO NOT IN (11,53) AND (IPIR.TIPOITEMCONSTRUCAOCIVIL <> 3 OR IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL) AND (DOC.SUBTIPO <> '4' OR DOC.TIPODOCUMENTO <> 14)) THEN 3
             WHEN (UTIL.TIPO IN ('I') AND DOC.TIPODOCUMENTO NOT IN (11,53) AND (IPIR.TIPOITEMCONSTRUCAOCIVIL <> 3 OR IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL) AND (DOC.SUBTIPO <> '4' OR DOC.TIPODOCUMENTO <> 14)) THEN 5
          	 ELSE 0
        END AS DESTINACAO,
        CASE WHEN TCI.CONDOMINIO > 0 OR UTIL.UTILIZACAO = 39 THEN 2 ELSE 0 END AS DESTINACAO_MULTI,
        CASE WHEN (DOCIT.TIPOCONSTRUCAO IN ('A', 'T', 'C') AND DOC.TIPODOCUMENTO NOT IN (11,53) AND (IPIR.TIPOITEMCONSTRUCAOCIVIL <> 3 OR IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL) AND (DOC.SUBTIPO <> '4' OR DOC.TIPODOCUMENTO <> 14)) THEN 1
             WHEN (DOCIT.TIPOCONSTRUCAO = 'M' AND DOC.TIPODOCUMENTO NOT IN (11,53) AND (IPIR.TIPOITEMCONSTRUCAOCIVIL <> 3 OR IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL) AND (DOC.SUBTIPO <> '4' OR DOC.TIPODOCUMENTO <> 14)) THEN 2
             WHEN (DOCIT.TIPOCONSTRUCAO = 'I' AND DOC.TIPODOCUMENTO NOT IN (11,53) AND (IPIR.TIPOITEMCONSTRUCAOCIVIL <> 3 OR IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL) AND (DOC.SUBTIPO <> '4' OR DOC.TIPODOCUMENTO <> 14)) THEN 3
             ELSE 0
        END AS TIPOCONSTRUCAO,
        CASE WHEN (DOC.TIPODOCUMENTO NOT IN (11,53) AND (IPIR.TIPOITEMCONSTRUCAOCIVIL <> 3 OR IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL) AND (DOC.SUBTIPO <> '4' OR DOC.TIPODOCUMENTO <> 14)) THEN DOCIT.AREA ELSE 0 END AS AREA,
        CASE WHEN (DOCIT.AREA IS NULL OR DOCIT.AREA = 0) THEN
                 (SELECT SUM(CASE WHEN COALESCE(TPI.AREA,0) > 0 THEN TPI.AREA ELSE COALESCE(TPI.AREACOBERTA,0) + COALESCE(TPI.AREADESCOBERTA,0) END)
                  FROM TRIBPROJETOITEM TPI
                  WHERE TPI.ENTIDADE = DOC.ENTIDADE
             	     AND TPI.EXERCICIO = DOC.EXERCICIOPROJETO
                     AND TPI.PROJETO = DOC.PROJETO)
             ELSE 0
        END AS AREA_TOTAL,
        CASE WHEN (DOC.TIPODOCUMENTO IN (11,53) AND UTIL.TIPO = 'R' AND IPJI2.TIPOITEMCONSTRUCAOCIVIL <> 3) THEN 1
             WHEN (DOC.TIPODOCUMENTO IN (11,53) AND UTIL.TIPO = 'C' AND IPJI2.TIPOITEMCONSTRUCAOCIVIL <> 3) THEN 3
             WHEN (DOC.TIPODOCUMENTO IN (11,53) AND UTIL.TIPO = 'I' AND IPJI2.TIPOITEMCONSTRUCAOCIVIL <> 3) THEN 5
             ELSE 0
        END AS DESTINACAO_DEMOLICAO,
        CASE WHEN (TCI.CONDOMINIO > 0) OR (UTIL.UTILIZACAO = 39) OR
                 ((SELECT COUNT(1) FROM TRIBIMOBILIARIOSEGMENTO TISEG
                   INNER JOIN TRIBTIPOSEGMENTO TTIPOSEG ON TTIPOSEG.TIPOSEGMENTO = TISEG.TIPOSEGMENTO
                   WHERE TISEG.TIPOCADASTRO = DOC.TIPOCADASTRO
                       AND TISEG.CADASTROGERAL = DOC.CADASTROGERAL
                       AND TTIPOSEG.UTILIZACAO = 1) > 1) THEN 2
             ELSE 0
        END AS DESTINACAO_DEMOLICAO_MULTI,
        CASE WHEN (DOC.TIPODOCUMENTO IN (11,53) AND DOCIT.TIPOCONSTRUCAO IN ('A', 'T', 'C')) THEN 1
             WHEN (DOC.TIPODOCUMENTO IN (11,53) AND DOCIT.TIPOCONSTRUCAO = 'M') THEN 2
             WHEN (DOC.TIPODOCUMENTO IN (11,53) AND DOCIT.TIPOCONSTRUCAO = 'I') THEN 3
             ELSE 0
        END AS TIPOCONSTRUCAO_DEMOLICAO,
        CASE WHEN DOC.TIPODOCUMENTO IN (11,53) THEN DOCIT.AREA ELSE 0 END AS AREA_DEMOLICAO,
        0 AS DESTINACAO_ACRESCIMO,
        0 AS TIPOCONSTRUCAO_ACRESCIMO,
        0 AS AREAACRESCIMO,
        CASE WHEN (IPIR.TIPOITEMCONSTRUCAOCIVIL = 3 AND UTIL.TIPO = 'R') OR (IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL AND DOC.SUBTIPO = '4' AND UTIL.TIPO = 'R' AND DOC.TIPODOCUMENTO = 14) THEN 1
             WHEN (IPIR.TIPOITEMCONSTRUCAOCIVIL = 3 AND UTIL.TIPO = 'C') OR (IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL AND DOC.SUBTIPO = '4' AND UTIL.TIPO = 'C' AND DOC.TIPODOCUMENTO = 14) THEN 3
             WHEN (IPIR.TIPOITEMCONSTRUCAOCIVIL = 3 AND UTIL.TIPO = 'I') OR (IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL AND DOC.SUBTIPO = '4' AND UTIL.TIPO = 'I' AND DOC.TIPODOCUMENTO = 14) THEN 5
             ELSE 0
        END AS DESTINACAO_REFORMA,
        CASE WHEN (TCI.CONDOMINIO > 0) OR (UTIL.UTILIZACAO = 39) OR
             	((SELECT COUNT(1) FROM TRIBIMOBILIARIOSEGMENTO TISEG
                  INNER JOIN TRIBTIPOSEGMENTO TTIPOSEG ON TTIPOSEG.TIPOSEGMENTO = TISEG.TIPOSEGMENTO
            	  WHERE TISEG.TIPOCADASTRO = DOC.TIPOCADASTRO
              	      AND TISEG.CADASTROGERAL = DOC.CADASTROGERAL
                      AND TTIPOSEG.UTILIZACAO = 1) > 1) THEN 2
             ELSE 0
        END AS DESTINACAO_REFORMA_MULTI,
        CASE WHEN (IPIR.TIPOITEMCONSTRUCAOCIVIL = 3 AND DOCIT.TIPOCONSTRUCAO IN ('A', 'T', 'C')) OR (IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL AND DOC.SUBTIPO = '4' AND DOCIT.TIPOCONSTRUCAO IN ('A', 'T', 'C') AND DOC.TIPODOCUMENTO = 14) THEN 1
             WHEN (IPIR.TIPOITEMCONSTRUCAOCIVIL = 3 AND DOCIT.TIPOCONSTRUCAO = 'M') OR (IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL AND DOC.SUBTIPO = '4' AND DOCIT.TIPOCONSTRUCAO = 'M' AND DOC.TIPODOCUMENTO = 14) THEN 2
             WHEN (IPIR.TIPOITEMCONSTRUCAOCIVIL = 3 AND DOCIT.TIPOCONSTRUCAO = 'I') OR (IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL AND DOC.SUBTIPO = '4' AND DOCIT.TIPOCONSTRUCAO = 'I' AND DOC.TIPODOCUMENTO = 14) THEN 3
             ELSE 0
        END AS TIPOCONSTRUCAO_REFORMA,
        CASE WHEN (IPIR.TIPOITEMCONSTRUCAOCIVIL = 3) OR (IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL AND DOC.SUBTIPO = '4' AND DOC.TIPODOCUMENTO = 14) THEN DOCIT.AREA ELSE 0 END AS AREA_REFORMA,
        CASE WHEN PESO.TIPOPESSOA = 'J' THEN PESO.CNPJ_CPF ELSE '' END AS CNPJ_PROPRIETARIO_OBRA,
        CASE WHEN PESO.TIPOPESSOA = 'F' THEN PESO.CNPJ_CPF ELSE '' END AS CPF_PROPRIETARIO_OBRA,
        (SELECT TEC.NOME FROM TRIBPROJETO TP
			 LEFT OUTER JOIN TRIBPROJETORESPONSAVEL TPR ON
			 	 TPR.ENTIDADE = TP.ENTIDADE
				 AND TPR.EXERCICIO = TP.EXERCICIO
				 AND TPR.PROJETO = TP.PROJETO
			 LEFT OUTER JOIN PESSOA TEC ON
				 TPR.PESSOA = TEC.PESSOA
			 LEFT OUTER JOIN PROFISSIONALPROFISSAO PP ON
				 PP.PESSOA = TPR.PESSOA
				 AND PP.SEQUENCIA = TPR.SEQUENCIAPROFISSAO
			 LEFT OUTER JOIN PARAMETROGERAL PG ON
			 	 PG.MODULO = '90'
				 AND (PG.PARAMETRO = 'PROFISSAOENGENHEIROSISOBRA' OR PG.PARAMETRO = 'PROFISSAOARQUITETOSISOBRA')
			 WHERE TP.ENTIDADE = DOC.ENTIDADE
				 AND TP.EXERCICIO = DOC.EXERCICIOPROJETO
				 AND TP.PROJETO = DOC.PROJETO
				 AND (TPR.TIPO = 'P' OR TPR.TIPO = 'A')
				 AND PG.VALOR = CAST(PP.PROFISSAO AS VARCHAR(10))
				 AND TPR.SEQUENCIA = (SELECT MAX(TPR1.SEQUENCIA) FROM TRIBPROJETORESPONSAVEL TPR1
										WHERE TPR1.ENTIDADE = TPR.ENTIDADE
						   AND TPR1.EXERCICIO = TPR.EXERCICIO
						   AND TPR1.PROJETO = TPR.PROJETO
						   AND TPR1.TIPORESPONSAVEL = TPR.TIPORESPONSAVEL)) AS NOME_RESP_PROJETO,
        (SELECT PP.CAUCREA FROM TRIBPROJETO TP
			 LEFT OUTER JOIN TRIBPROJETORESPONSAVEL TPR ON
			 	 TPR.ENTIDADE = TP.ENTIDADE
				 AND TPR.EXERCICIO = TP.EXERCICIO
				 AND TPR.PROJETO = TP.PROJETO
			 LEFT OUTER JOIN PROFISSIONALPROFISSAO PP ON
				 PP.PESSOA = TPR.PESSOA
				 AND PP.SEQUENCIA = TPR.SEQUENCIAPROFISSAO
			 LEFT OUTER JOIN PARAMETROGERAL PG ON
			 	 PG.MODULO = '90'
				 AND (PG.PARAMETRO = 'PROFISSAOENGENHEIROSISOBRA' OR PG.PARAMETRO = 'PROFISSAOARQUITETOSISOBRA')
			 WHERE TP.ENTIDADE = DOC.ENTIDADE
				 AND TP.EXERCICIO = DOC.EXERCICIOPROJETO
				 AND TP.PROJETO = DOC.PROJETO
				 AND (TPR.TIPO = 'P' OR TPR.TIPO = 'A')
				 AND PG.VALOR = CAST(PP.PROFISSAO AS VARCHAR(10))
				 AND TPR.SEQUENCIA = (SELECT MAX(TPR1.SEQUENCIA) FROM TRIBPROJETORESPONSAVEL TPR1
										WHERE TPR1.ENTIDADE = TPR.ENTIDADE
						   AND TPR1.EXERCICIO = TPR.EXERCICIO
						   AND TPR1.PROJETO = TPR.PROJETO
						   AND TPR1.TIPORESPONSAVEL = TPR.TIPORESPONSAVEL)) AS NRO_CARTEIRA_RESP_PROJETO,
        (SELECT CASE WHEN PG.PARAMETRO = 'PROFISSAOARQUITETOSISOBRA'  THEN 'CAU' ELSE 'CREA' END FROM TRIBPROJETO TP
			 LEFT OUTER JOIN TRIBPROJETORESPONSAVEL TPR ON
			 	 TPR.ENTIDADE = TP.ENTIDADE
				 AND TPR.EXERCICIO = TP.EXERCICIO
				 AND TPR.PROJETO = TP.PROJETO
			 LEFT OUTER JOIN PROFISSIONALPROFISSAO PP ON
				 PP.PESSOA = TPR.PESSOA
				 AND PP.SEQUENCIA = TPR.SEQUENCIAPROFISSAO
			 LEFT OUTER JOIN PARAMETROGERAL PG ON
			 	 PG.MODULO = '90'
				 AND (PG.PARAMETRO = 'PROFISSAOENGENHEIROSISOBRA' OR PG.PARAMETRO = 'PROFISSAOARQUITETOSISOBRA')
			 WHERE TP.ENTIDADE = DOC.ENTIDADE
				 AND TP.EXERCICIO = DOC.EXERCICIOPROJETO
				 AND TP.PROJETO = DOC.PROJETO
				 AND (TPR.TIPO = 'P' OR TPR.TIPO = 'A')
				 AND PG.VALOR = CAST(PP.PROFISSAO AS VARCHAR(10))
				 AND TPR.SEQUENCIA = (SELECT MAX(TPR1.SEQUENCIA) FROM TRIBPROJETORESPONSAVEL TPR1
										WHERE TPR1.ENTIDADE = TPR.ENTIDADE
						   AND TPR1.EXERCICIO = TPR.EXERCICIO
						   AND TPR1.PROJETO = TPR.PROJETO
						   AND TPR1.TIPORESPONSAVEL = TPR.TIPORESPONSAVEL)) AS TIPO_CARTEIRA_RESP_PROJETO,
        (SELECT TEC.NOME FROM TRIBPROJETO TP
			 LEFT OUTER JOIN TRIBPROJETORESPONSAVEL TPR ON
			 	 TPR.ENTIDADE = TP.ENTIDADE
				 AND TPR.EXERCICIO = TP.EXERCICIO
				 AND TPR.PROJETO = TP.PROJETO
			 LEFT OUTER JOIN PESSOA TEC ON
				 TPR.PESSOA = TEC.PESSOA
			 LEFT OUTER JOIN PROFISSIONALPROFISSAO PP ON
				 PP.PESSOA = TPR.PESSOA
				 AND PP.SEQUENCIA = TPR.SEQUENCIAPROFISSAO
			 LEFT OUTER JOIN PARAMETROGERAL PG ON
			 	 PG.MODULO = '90'
				 AND (PG.PARAMETRO = 'PROFISSAOENGENHEIROSISOBRA' OR PG.PARAMETRO = 'PROFISSAOARQUITETOSISOBRA')
			 WHERE TP.ENTIDADE = DOC.ENTIDADE
				 AND TP.EXERCICIO = DOC.EXERCICIOPROJETO
				 AND TP.PROJETO = DOC.PROJETO
				 AND (TPR.TIPO = 'T' OR TPR.TIPO = 'A')
				 AND PG.VALOR = CAST(PP.PROFISSAO AS VARCHAR(10))
				 AND TPR.SEQUENCIA = (SELECT MAX(TPR1.SEQUENCIA) FROM TRIBPROJETORESPONSAVEL TPR1
										WHERE TPR1.ENTIDADE = TPR.ENTIDADE
						   AND TPR1.EXERCICIO = TPR.EXERCICIO
						   AND TPR1.PROJETO = TPR.PROJETO
						   AND TPR1.TIPORESPONSAVEL = TPR.TIPORESPONSAVEL)) AS NOME_RESP_EXEC,
        (SELECT PP.CAUCREA FROM TRIBPROJETO TP
			 LEFT OUTER JOIN TRIBPROJETORESPONSAVEL TPR ON
			 	 TPR.ENTIDADE = TP.ENTIDADE
				 AND TPR.EXERCICIO = TP.EXERCICIO
				 AND TPR.PROJETO = TP.PROJETO
			 LEFT OUTER JOIN PROFISSIONALPROFISSAO PP ON
				 PP.PESSOA = TPR.PESSOA
				 AND PP.SEQUENCIA = TPR.SEQUENCIAPROFISSAO
			 LEFT OUTER JOIN PARAMETROGERAL PG ON
			 	 PG.MODULO = '90'
				 AND (PG.PARAMETRO = 'PROFISSAOENGENHEIROSISOBRA' OR PG.PARAMETRO = 'PROFISSAOARQUITETOSISOBRA')
			 WHERE TP.ENTIDADE = DOC.ENTIDADE
				 AND TP.EXERCICIO = DOC.EXERCICIOPROJETO
				 AND TP.PROJETO = DOC.PROJETO
				 AND (TPR.TIPO = 'T' OR TPR.TIPO = 'A')
				 AND PG.VALOR = CAST(PP.PROFISSAO AS VARCHAR(10))
				 AND TPR.SEQUENCIA = (SELECT MAX(TPR1.SEQUENCIA) FROM TRIBPROJETORESPONSAVEL TPR1
										WHERE TPR1.ENTIDADE = TPR.ENTIDADE
						   AND TPR1.EXERCICIO = TPR.EXERCICIO
						   AND TPR1.PROJETO = TPR.PROJETO
						   AND TPR1.TIPORESPONSAVEL = TPR.TIPORESPONSAVEL)) AS NRO_CARTEIRA_RESP_EXEC,
        (SELECT CASE WHEN PG.PARAMETRO = 'PROFISSAOARQUITETOSISOBRA'  THEN 'CAU' ELSE 'CREA' END FROM TRIBPROJETO TP
			 LEFT OUTER JOIN TRIBPROJETORESPONSAVEL TPR ON
			 	 TPR.ENTIDADE = TP.ENTIDADE
				 AND TPR.EXERCICIO = TP.EXERCICIO
				 AND TPR.PROJETO = TP.PROJETO
			 LEFT OUTER JOIN PROFISSIONALPROFISSAO PP ON
				 PP.PESSOA = TPR.PESSOA
				 AND PP.SEQUENCIA = TPR.SEQUENCIAPROFISSAO
			 LEFT OUTER JOIN PARAMETROGERAL PG ON
			 	 PG.MODULO = '90'
				 AND (PG.PARAMETRO = 'PROFISSAOENGENHEIROSISOBRA' OR PG.PARAMETRO = 'PROFISSAOARQUITETOSISOBRA')
			 WHERE TP.ENTIDADE = DOC.ENTIDADE
				 AND TP.EXERCICIO = DOC.EXERCICIOPROJETO
				 AND TP.PROJETO = DOC.PROJETO
				 AND (TPR.TIPO = 'T' OR TPR.TIPO = 'A')
				 AND PG.VALOR = CAST(PP.PROFISSAO AS VARCHAR(10))
				 AND TPR.SEQUENCIA = (SELECT MAX(TPR1.SEQUENCIA) FROM TRIBPROJETORESPONSAVEL TPR1
										WHERE TPR1.ENTIDADE = TPR.ENTIDADE
						   AND TPR1.EXERCICIO = TPR.EXERCICIO
						   AND TPR1.PROJETO = TPR.PROJETO
						   AND TPR1.TIPORESPONSAVEL = TPR.TIPORESPONSAVEL)) AS TIPO_CARTEIRA_RESP_EXEC,
        PJ.ART AS ART_ENGENHEIRO,
        PJ.RRT AS RRT_ARQUITETO,
        DOCUMENTOHABITESE.CNPJ_CPF,
        CASE WHEN COALESCE(SOH.ENVIADO,'N') = 'S' THEN TRUE ELSE FALSE END AS ENVIADO,
        CASE WHEN COALESCE(SOH.ENVIADOCOMSUCESSO,'N') = 'S' THEN TRUE ELSE FALSE END AS ENVIADOCOMSUCESSO,
        coalesce(SOH.ID,0) as idSisObraHabitese
FROM TRIBDOCUMENTO DOC
	LEFT OUTER JOIN TRIBPROJETO PJ ON DOC.ENTIDADE = PJ.ENTIDADE AND DOC.EXERCICIOPROJETO = PJ.EXERCICIO AND DOC.PROJETO = PJ.PROJETO
	LEFT OUTER JOIN TRIBCADASTROGERAL TCG ON DOC.TIPOCADASTRO = TCG.TIPOCADASTRO AND DOC.CADASTROGERAL = TCG.CADASTROGERAL
	LEFT OUTER JOIN TRIBCADASTROIMOBILIARIO TCI ON TCG.TIPOCADASTRO = TCI.TIPOCADASTRO AND TCG.CADASTROGERAL = TCI.CADASTROGERAL
	LEFT OUTER JOIN (SELECT B.ENTIDADE,B.EXERCICIO,B.DOCUMENTO,B.TIPODOCUMENTO,B.UTILIZACAO,CAST('A' AS VARCHAR(1)) TIPOCONSTRUCAO,
	                   SUM (CASE WHEN B.TIPODOCUMENTO IN (50,51,52) THEN
	                             CASE WHEN (COALESCE(B.AREACOBERTA,0)+COALESCE(B.AREADESCOBERTA,0)) > 0 THEN (COALESCE(B.AREACOBERTA,0)+COALESCE(B.AREADESCOBERTA,0))
	                                  WHEN (COALESCE(B.AREACOBERTA_PARCIAL,0)+COALESCE(B.AREADESCOBERTA_PARCIAL,0)) > 0 THEN (COALESCE(B.AREACOBERTA_PARCIAL,0)+COALESCE(B.AREADESCOBERTA_PARCIAL,0))
	                             ELSE (COALESCE(B.AREACOBERTA_APROVADA,0)+COALESCE(B.AREADESCOBERTA_APROVADA,0))
	                             END
	                             WHEN B.TIPODOCUMENTO = 53 THEN COALESCE(B.AREACOBERTA_DEMOLIDA,0)+COALESCE(B.AREADESCOBERTA_DEMOLIDA,0)
	                             WHEN B.TIPODOCUMENTO IN (11,14,15) AND ((COALESCE(B.AREACOBERTA,0)+COALESCE(B.AREADESCOBERTA,0)) > 0) THEN (COALESCE(B.AREACOBERTA,0)+COALESCE(B.AREADESCOBERTA,0))
	                             ELSE B.AREA
	                        END) AREA,
	                   SUM(B.AREACOBERTA) AS AREA_COBERTA,
	                   SUM(B.AREADESCOBERTA) AS AREA_DESCOBERTA
	                 FROM TRIBDOCUMENTOITEMCERTIDAO B
	                 WHERE B.ENTIDADE = ENTIDADE
	                 	AND B.EXERCICIO = EXERCICIO
	                    AND B.DOCUMENTO = DOCUMENTO
	                    AND B.TIPODOCUMENTO = TIPODOCUMENTO
	                 GROUP BY B.ENTIDADE,B.EXERCICIO,B.DOCUMENTO,B.TIPODOCUMENTO,B.UTILIZACAO) DOCIT
		ON DOC.ENTIDADE  = DOCIT.ENTIDADE
		AND DOC.EXERCICIO = DOCIT.EXERCICIO
		AND DOC.TIPODOCUMENTO = DOCIT.TIPODOCUMENTO
		AND DOC.DOCUMENTO = DOCIT.DOCUMENTO
	LEFT OUTER JOIN TRIBUTILIZACAO UTIL ON UTIL.UTILIZACAO = DOCIT.UTILIZACAO
	LEFT OUTER JOIN PESSOA RESPONSAVEL ON RESPONSAVEL.PESSOA = (CASE WHEN PJ.PESSOA IS NULL THEN DOC.PESSOA ELSE PJ.PESSOA END)
	LEFT OUTER JOIN ENDERECOPESSOA ENDER ON ENDER.PESSOA = RESPONSAVEL.PESSOA AND ENDER.SEQUENCIA = RESPONSAVEL.SEQUENCIAENDERECO
	LEFT OUTER JOIN CONTATOPESSOA CP ON CP.PESSOA = RESPONSAVEL.PESSOA AND CP.SEQUENCIA = RESPONSAVEL.SEQUENCIACONTATO
	LEFT OUTER JOIN ENDERECOPESSOA END2 ON END2.PESSOA = RESPONSAVEL.PESSOA AND END2.SEQUENCIA = RESPONSAVEL.SEQUENCIAENDERECO AND END2.TIPOENDERECO = '3'
	LEFT OUTER JOIN CIDADE CID ON ENDER.CIDADE = CID.CIDADE
	LEFT OUTER JOIN LOGRADOURO LOG ON ENDER.LOGRADOURO = LOG.LOGRADOURO AND ENDER.CIDADE = LOG.CIDADE
	LEFT OUTER JOIN BAIRRO BAI ON ENDER.BAIRRO = BAI.BAIRRO AND ENDER.CIDADE = BAI.CIDADE
	LEFT OUTER JOIN PESSOA RESP_EXEC_OBRA ON RESP_EXEC_OBRA.PESSOA = PJ.PESSOARESPONSAVEL
	LEFT OUTER JOIN PESSOA PESO ON TCG.PESSOA = PESO.PESSOA
	LEFT OUTER JOIN LOGRADOURO LOGO ON TCG.LOGRADOURO = LOGO.LOGRADOURO AND TCG.CIDADE = LOGO.CIDADE
	LEFT OUTER JOIN TIPOLOGRADOURO TILOGO ON TILOGO.TIPOLOGRADOURO = LOGO.TIPOLOGRADOURO
	LEFT OUTER JOIN CIDADE CIDO ON TCG.CIDADE = CIDO.CIDADE
	LEFT OUTER JOIN BAIRRO BAIO ON TCG.BAIRRO = BAIO.BAIRRO AND TCG.CIDADE = BAIO.CIDADE
	LEFT OUTER JOIN ENDERECOPESSOA ENDO ON PESO.PESSOA = ENDO.PESSOA AND PESO.SEQUENCIAENDERECO = ENDO.SEQUENCIA
	LEFT OUTER JOIN TRIBPROJETOITEM PIR ON PJ.ENTIDADE = PIR.ENTIDADE AND PJ.EXERCICIO = PIR.EXERCICIO AND PJ.PROJETO = PIR.PROJETO AND (PJ.TIPOPROJETO IN (1)) AND DOC.SUBTIPO = '4' AND DOC.TIPODOCUMENTO = 14
	LEFT OUTER JOIN TRIBITEMCONSTRUCAOCIVIL IPIR ON IPIR.ITEMCONSTRUCAOCIVIL = PIR.ITEMCONSTRUCAOCIVIL AND IPIR.TIPOITEMCONSTRUCAOCIVIL = 3
	LEFT OUTER JOIN TRIBPROJETOITEM PJI1 ON PJ.ENTIDADE = PJI1.ENTIDADE AND PJ.EXERCICIO = PJI1.EXERCICIO AND PJ.PROJETO = PJI1.PROJETO AND (PJ.TIPOPROJETO IN (1))
	LEFT OUTER JOIN TRIBITEMCONSTRUCAOCIVIL IPJI1 ON IPJI1.ITEMCONSTRUCAOCIVIL = PJI1.ITEMCONSTRUCAOCIVIL AND IPJI1.TIPOITEMCONSTRUCAOCIVIL = 1
	LEFT OUTER JOIN TRIBPROJETOITEM PJI2 ON PJ.ENTIDADE = PJI2.ENTIDADE AND PJ.EXERCICIO = PJI2.EXERCICIO AND PJ.PROJETO = PJI2.PROJETO AND PJ.TIPOPROJETO = 5
	LEFT OUTER JOIN TRIBITEMCONSTRUCAOCIVIL IPJI2 ON IPJI2.ITEMCONSTRUCAOCIVIL = PJI2.ITEMCONSTRUCAOCIVIL
	LEFT OUTER JOIN TRIBDOCUMENTOITEMCERTIDAO CI ON CI.ENTIDADE = DOC.ENTIDADE AND CI.EXERCICIO = DOC.EXERCICIO AND CI.TIPODOCUMENTO = DOC.TIPODOCUMENTO AND CI.DOCUMENTO = DOC.DOCUMENTO AND CI.NROALVARA IS NOT NULL AND CI.NROALVARA NOT LIKE 'ATUAL%'
	LEFT OUTER JOIN TRIBDOCUMENTO DOCCERTIDAO ON CI.ENTIDADE = DOCCERTIDAO.ENTIDADE AND CI.EXERCICIO = DOCCERTIDAO.EXERCICIO AND CI.TIPODOCUMENTO = DOCCERTIDAO.TIPODOCUMENTO AND CI.DOCUMENTO = DOCCERTIDAO.DOCUMENTO
	LEFT OUTER JOIN TRIBDOCUMENTO DOCALVARA ON CI.ENTIDADE = DOCALVARA.ENTIDADE AND DOCALVARA.EXERCICIO = (CASE WHEN CI.ANOALVARA IS NOT NULL THEN CI.ANOALVARA ELSE EXTRACT(YEAR FROM CI.DATAAPROVACAO) END) AND CI.NROALVARA = CAST(DOCALVARA.DOCUMENTO AS VARCHAR(15)) AND DOCALVARA.TIPODOCUMENTO IN (14,50,51)
	LEFT JOIN TRIBDOCUMENTO ALVORIGEM ON DOC.NUMEROPRIMEIROALVARA = CAST(ALVORIGEM.DOCUMENTO AS VARCHAR(20)) AND DOC.ANOEMISSAOALVARA = CAST(ALVORIGEM.EXERCICIO AS VARCHAR(20)) AND ALVORIGEM.TIPODOCUMENTO IN (14,49,50,51)
	LEFT OUTER JOIN TRIBDOCUMENTO DOCUMENTOHABITESE ON DOCUMENTOHABITESE.TIPODOCUMENTO = DOC.TIPODOCUMENTO and cast (DOCUMENTOHABITESE.DOCUMENTO AS VARCHAR(20)) = CAST(DOC.DOCUMENTO AS VARCHAR(20)) AND DOC.DATAEMISSAO  = DOCUMENTOHABITESE.DATAEMISSAO
	LEFT OUTER JOIN SISOBRAHABITESE SOH ON CAST ( SOH.NUMEROHABITESE AS NUMERIC(10)) = DOC.DOCUMENTO AND SOH.DATAHABITESE  = DOC.DATAEMISSAO
WHERE DOC.TIPODOCUMENTO IN (15,52)
    AND DOC.SITUACAO NOT IN (2,3)
    [FILTRO_SELECIONADOS]
	AND DOC.DATAEMISSAO >= :dataInicial
    AND DOC.DATAEMISSAO <= :dataFinal ) A
GROUP BY
   A.DATA_ALVARA_HABITESE,
   A.NRO_ALVARA_HABITESE,
   A.ANO_ALVARA_HABITESE,
   A.EXERCICIO_DOCUMENTO,
   A.TIPODOCUMENTO,
   A.DOCUMENTO,
   A.DATAEMISSAO,
   A.CERT_DATAEMISSAO,
   A.TIPOCADASTRO,
   A.CADASTROGERAL,
   A.EXERCICIO,
   A.PROJETO,
   A.DATAINICIO,
   A.DATAENCERRAMENTO,
   A.SITUACAO,
   A.APROVADO,
   CASE WHEN A.IDPROCESSO IS NOT NULL AND A.EXERCICIOPROTOCOLO IS NOT NULL THEN A.IDPROCESSO||'/'||A.EXERCICIOPROTOCOLO ELSE '' END,
   A.PESSOA,
   A.PESSOARESPONSAVEL,
   A.TIPOVINCULO,
   A.DATAEMISSAO_DOC,
   A.OBRA_NOME,
   A.OBRA_TIPOLOGRADOURO,
   A.OBRA_LOGRADOURO,
   A.OBRA_NUMERO,
   A.OBRA_COMPLEMENTO,
   A.OBRA_BAIRRO,
   A.OBRA_CEP,
   A.CNPJ_PROPRIETARIO_OBRA,
   A.CPF_PROPRIETARIO_OBRA,
   A.NOME_RESP_PROJETO,
   A.NRO_CARTEIRA_RESP_PROJETO,
   A.TIPO_CARTEIRA_RESP_PROJETO,
   A.NOME_RESP_EXEC,
   A.NRO_CARTEIRA_RESP_EXEC,
   A.TIPO_CARTEIRA_RESP_EXEC,
   CASE WHEN A.TIPO_CARTEIRA_RESP_PROJETO = 'CAU'  THEN A.NOME_RESP_PROJETO ELSE '' END,
   CASE WHEN A.TIPO_CARTEIRA_RESP_PROJETO = 'CREA'  THEN A.NOME_RESP_PROJETO ELSE '' END,
   CASE WHEN A.TIPO_CARTEIRA_RESP_PROJETO = 'CAU'  THEN A.NRO_CARTEIRA_RESP_PROJETO ELSE '' END,
   CASE WHEN A.TIPO_CARTEIRA_RESP_PROJETO = 'CREA'  THEN A.NRO_CARTEIRA_RESP_PROJETO ELSE '' END,
   CASE WHEN A.TIPO_CARTEIRA_RESP_EXEC = 'CAU'  THEN A.NOME_RESP_EXEC ELSE '' END,
   CASE WHEN A.TIPO_CARTEIRA_RESP_EXEC = 'CREA'  THEN A.NOME_RESP_EXEC ELSE '' END,
   CASE WHEN A.TIPO_CARTEIRA_RESP_EXEC = 'CAU'  THEN A.NRO_CARTEIRA_RESP_EXEC ELSE '' END,
   CASE WHEN A.TIPO_CARTEIRA_RESP_EXEC = 'CREA'  THEN A.NRO_CARTEIRA_RESP_EXEC ELSE '' END,
   A.ART_ENGENHEIRO,
   A.RRT_ARQUITETO,
   A.PROPRIETARIO_IMOVEL,
   A.CPF_DONO_OBRA,
   A.CNPJ_DONO_OBRA,
   A.CPF_CONSTRUTORA,
   A.CNPJ_CONSTRUTORA,
   A.CPF_INCORPORADORA,
   A.CNPJ_INCORPORADORA,
   A.CPF_LIDER_CONSORCIO,
   A.CNPJ_LIDER_CONSORCIO,
   A.CPF_CONSORCIO,
   A.CNPJ_CONSORCIO,
   A.CNPJ_CPF,
   A.ENVIADO,
   A.ENVIADOCOMSUCESSO,
   A.IDSISOBRAHABITESE,
   A.TIPODOCUMENTOALVARA
ORDER BY A.EXERCICIO_DOCUMENTO, A.TIPODOCUMENTO, A.DOCUMENTO