SELECT COUNT(DISTINCT DOC.DOCUMENTO) AS total
FROM TRIBDOCUMENTO DOC
LEFT OUTER JOIN SISOBRAALVARA SOA ON cast(SOA.NUMEROALVARA as numeric(10)) = DOC.DOCUMENTO AND SOA.DATAALVARA = DOC.DATAEMISSAO
LEFT OUTER JOIN SISOBRAHABITESE SOH ON cast(SOH.NUMEROHABITESE as numeric(10)) = DOC.DOCUMENTO AND SOH.DATAHABITESE = DOC.DATAEMISSAO
LEFT OUTER JOIN SISOBRAALTERACAOSITUACAO SAS ON SAS.ANO  = DOC.EXERCICIO AND SAS.TIPODOCUMENTOORIGINAL = DOC.TIPODOCUMENTO AND CAST( SAS.NUMERODOCUMENTO AS NUMERIC(10)) = DOC.DOCUMENTO
WHERE DOC.CANCELADO = 'S'
AND DOC.TIPODOCUMENTO IN (11,14,15,49,50,51,52,53)
AND NOT (DOC.TIPODOCUMENTO = 14 AND DOC.SUBTIPO IN ('3','5','7'))
AND NOT ((DOC.TIPODOCUMENTO IN (50,51)) AND DOC.SUBTIPO = '1')
AND ((DOC.DATACANCELAMENTO >= :dataInicial) AND  (DOC.DATACANCELAMENTO <= :dataFinal))