SELECT COUNT(DISTINCT A.DOCUMENTO) AS TOTAL
FROM (
SELECT DISTINCT
                DOC.EXERCICIO AS EXERCICIO_DOCUMENTO,
                 DOC.TIPODOCUMENTO TIPODOCUMENTO,
                DOC.DOCUMENTO,
                DOC.DATAEMISSAO,
                DOCCERTIDAO.DATAEMISSAO as CERT_DATAEMISSAO,
                PJ.TIPOCADASTRO,
                PJ.CADASTROGERAL,
                PJ.EXERCICIO EXERCICIO,
                PJ.PROJETO,
                CASE WHEN (CI.NROALVARA IS NOT NULL) AND (DOCALVARA.DATAEMISSAO IS NOT NULL) AND (DOCALVARA.DATAEMISSAO > '1900-01-01') AND (DOC.TIPODOCUMENTO IN (15,52)) THEN DOCALVARA.DATAEMISSAO
                     WHEN (CI.NROALVARA IS NOT NULL) AND (DOCALVARA.DATAEMISSAO IS NULL) AND (DOCALVARA.DATAEMISSAO > '1900-01-01') AND (DOC.TIPODOCUMENTO IN (15,52)) THEN CI.DATAAPROVACAO
                     WHEN (CI.NROALVARA IS NULL) AND (DOC.DATAPRIMEIROALVARA IS NOT NULL) AND (DOC.DATAPRIMEIROALVARA > '1900-01-01')AND (DOC.TIPODOCUMENTO IN (15,52)) THEN DOC.DATAPRIMEIROALVARA
                ELSE DOC.DATAEMISSAO
                END AS DATAINICIO,
                CASE WHEN DOC.TIPODOCUMENTO IN (15, 52, 53) THEN DOC.DATAEMISSAO
                  ELSE PJ.DATAENCERRAMENTO
                END AS DATAENCERRAMENTO,
                PJ.SITUACAO,
                PJ.APROVADO,
                PJ.EXERCICIOPROTOCOLO,
                PJ.IDPROCESSO,
                PJ.PESSOA,
                PJ.PESSOARESPONSAVEL,
                CASE
                  WHEN PJ.TIPOVINCULO IS NULL THEN 51
                ELSE PJ.TIPOVINCULO
                END AS TIPOVINCULO,
                CASE WHEN (CI.NROALVARA IS NOT NULL) AND (DOCALVARA.DATAEMISSAO IS NOT NULL) AND (DOCALVARA.DATAEMISSAO > '1900-01-01') AND (DOC.TIPODOCUMENTO IN (15,52)) THEN DOCALVARA.DATAEMISSAO
                     WHEN (CI.NROALVARA IS NOT NULL) AND (DOCALVARA.DATAEMISSAO IS NULL) AND (DOCALVARA.DATAEMISSAO > '1900-01-01') AND (DOC.TIPODOCUMENTO IN (15,52)) THEN CI.DATAAPROVACAO
                     WHEN (CI.NROALVARA IS NULL) AND (DOC.DATAPRIMEIROALVARA IS NOT NULL) AND (DOC.DATAPRIMEIROALVARA > '1900-01-01') AND (DOC.TIPODOCUMENTO IN (15,52)) THEN DOC.DATAPRIMEIROALVARA
                ELSE DOC.DATAEMISSAO
                END AS DATAEMISSAO_DOC,
                CASE WHEN PJ.TIPOVINCULO=51 THEN RESP_EXEC_OBRA.NOME
                     WHEN PJ.PROJETO IS NULL THEN PESO.NOME
                ELSE '' END AS PROPRIETARIO_IMOVEL,
                CASE WHEN PJ.TIPOVINCULO=52 AND RESP_EXEC_OBRA.TIPOPESSOA = 'F' THEN RESP_EXEC_OBRA.CNPJ_CPF
                ELSE '' END AS CPF_DONO_OBRA,
                CASE WHEN PJ.TIPOVINCULO=52 AND RESP_EXEC_OBRA.TIPOPESSOA = 'J' THEN RESP_EXEC_OBRA.CNPJ_CPF
                ELSE '' END AS CNPJ_DONO_OBRA,
                CASE WHEN PJ.TIPOVINCULO=53 AND RESP_EXEC_OBRA.TIPOPESSOA = 'F' THEN RESP_EXEC_OBRA.CNPJ_CPF
                ELSE '' END AS CPF_CONSTRUTORA,
                CASE WHEN PJ.TIPOVINCULO=53 AND RESP_EXEC_OBRA.TIPOPESSOA = 'J' THEN RESP_EXEC_OBRA.CNPJ_CPF
                ELSE '' END AS CNPJ_CONSTRUTORA,
                CASE WHEN PJ.TIPOVINCULO=54 AND RESP_EXEC_OBRA.TIPOPESSOA = 'F' THEN RESP_EXEC_OBRA.CNPJ_CPF
                ELSE '' END AS CPF_INCORPORADORA,
                CASE WHEN PJ.TIPOVINCULO=54 AND RESP_EXEC_OBRA.TIPOPESSOA = 'J' THEN RESP_EXEC_OBRA.CNPJ_CPF
                ELSE '' END AS CNPJ_INCORPORADORA,
                CASE WHEN PJ.TIPOVINCULO=55 AND RESP_EXEC_OBRA.TIPOPESSOA = 'F' THEN RESP_EXEC_OBRA.CNPJ_CPF
                ELSE '' END AS CPF_LIDER_CONSORCIO,
                CASE WHEN PJ.TIPOVINCULO=55 AND RESP_EXEC_OBRA.TIPOPESSOA = 'J' THEN RESP_EXEC_OBRA.CNPJ_CPF
                ELSE '' END AS CNPJ_LIDER_CONSORCIO,
                CASE WHEN PJ.TIPOVINCULO=56 AND RESP_EXEC_OBRA.TIPOPESSOA = 'F' THEN RESP_EXEC_OBRA.CNPJ_CPF
                ELSE '' END AS CPF_CONSORCIO,
                CASE WHEN PJ.TIPOVINCULO=56 AND RESP_EXEC_OBRA.TIPOPESSOA = 'J' THEN RESP_EXEC_OBRA.CNPJ_CPF
                ELSE '' END AS CNPJ_CONSORCIO,
                CASE WHEN DOC.TIPODOCUMENTO IN (15,52) THEN
                  (SELECT CAST(MAX(ALV.DOCUMENTO) AS VARCHAR(20)) FROM TRIBDOCUMENTO ALV
                  WHERE ALV.ENTIDADE = 1
                    AND ALV.TIPODOCUMENTO IN (14,49,50,51)
                    AND ALV.TIPOCADASTRO = DOC.TIPOCADASTRO
                    AND ALV.CADASTROGERAL = DOC.CADASTROGERAL
                    AND ALV.DATAEMISSAO < DOC.DATAEMISSAO)
              ELSE '' END AS NRO_ALVARA_HABITESE,
                CASE WHEN DOC.TIPODOCUMENTO IN (15,52) THEN
                  (SELECT CAST(MAX(ALV.DATAEMISSAO) AS VARCHAR(20)) FROM TRIBDOCUMENTO ALV
                  WHERE ALV.ENTIDADE = 1
                    AND ALV.TIPODOCUMENTO IN (14,49,50,51)
                    AND ALV.TIPOCADASTRO = DOC.TIPOCADASTRO
                    AND ALV.CADASTROGERAL = DOC.CADASTROGERAL
                    AND ALV.DATAEMISSAO < DOC.DATAEMISSAO
                    AND ALV.DOCUMENTO = (SELECT MAX(ALV1.DOCUMENTO) FROM TRIBDOCUMENTO ALV1
                                         WHERE ALV1.ENTIDADE = 1
                                           AND ALV1.TIPODOCUMENTO IN (14,49,50,51)
                                           AND ALV1.TIPOCADASTRO = DOC.TIPOCADASTRO
                                           AND ALV1.CADASTROGERAL = DOC.CADASTROGERAL
                                           AND ALV1.DATAEMISSAO < DOC.DATAEMISSAO))
                ELSE '' END AS DATA_ALVARA_HABITESE,
                RESPONSAVEL.NOME AS OBRA_NOME,
                TILOGO.DESCRICAO AS OBRA_TIPOLOGRADOURO,
                CASE
                  WHEN LOGO.LOGRADOURO IS NULL THEN 'NAO CADASTRADO'
                  ELSE LOGO.DESCRICAO
                END AS OBRA_LOGRADOURO,
                TCG.NUMERO AS OBRA_NUMERO,
                SUBSTR(TCG.COMPLEMENTO,1,60) AS OBRA_COMPLEMENTO,
                CASE
                  WHEN BAIO.BAIRRO IS NULL THEN 'NAO CADASTRADO'
                  ELSE BAIO.DESCRICAO
                END AS OBRA_BAIRRO,
                RPAD(cast(TCG.CEP as varchar(10)),8,'0') AS OBRA_CEP,
                CASE
                  WHEN (UTIL.TIPO = 'R' AND DOC.TIPODOCUMENTO NOT IN (11,53) AND
                       (IPIR.TIPOITEMCONSTRUCAOCIVIL <> 3 OR
                       IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL) AND
                       (DOC.SUBTIPO <> '4' OR DOC.TIPODOCUMENTO <> 14)) THEN
                   1
                  WHEN (UTIL.TIPO IN ('C') AND DOC.TIPODOCUMENTO NOT IN (11,53) AND
                       (IPIR.TIPOITEMCONSTRUCAOCIVIL <> 3 OR
                       IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL) AND
                       (DOC.SUBTIPO <> '4' OR DOC.TIPODOCUMENTO <> 14)) THEN
                   3
                  WHEN (UTIL.TIPO IN ('I') AND DOC.TIPODOCUMENTO NOT IN (11,53) AND
                       (IPIR.TIPOITEMCONSTRUCAOCIVIL <> 3 OR
                       IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL) AND
                       (DOC.SUBTIPO <> '4' OR DOC.TIPODOCUMENTO <> 14)) THEN
                   5
                  ELSE 0
                END AS DESTINACAO,
                CASE
                  WHEN TCI.CONDOMINIO > 0 OR UTIL.UTILIZACAO = 39 /*OR
                       ((SELECT COUNT(1) FROM TRIBIMOBILIARIOSEGMENTO TISEG
                                 INNER JOIN TRIBTIPOSEGMENTO TTIPOSEG ON TTIPOSEG.TIPOSEGMENTO = TISEG.TIPOSEGMENTO
                        WHERE TISEG.TIPOCADASTRO = DOC.TIPOCADASTRO
                          AND TISEG.CADASTROGERAL = DOC.CADASTROGERAL
                          AND TTIPOSEG.UTILIZACAO = 1) > 1)*/ THEN
                    2
                  ELSE 0
                END AS DESTINACAO_MULTI,
                CASE
                  WHEN (DOCIT.TIPOCONSTRUCAO IN ('A', 'T', 'C') AND
                       DOC.TIPODOCUMENTO NOT IN (11,53) AND
                       (IPIR.TIPOITEMCONSTRUCAOCIVIL <> 3 OR
                       IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL) AND
                       (DOC.SUBTIPO <> '4' OR DOC.TIPODOCUMENTO <> 14)) THEN
                   1
                  WHEN (DOCIT.TIPOCONSTRUCAO = 'M' AND
                       DOC.TIPODOCUMENTO NOT IN (11,53) AND
                       (IPIR.TIPOITEMCONSTRUCAOCIVIL <> 3 OR
                       IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL) AND
                       (DOC.SUBTIPO <> '4' OR DOC.TIPODOCUMENTO <> 14)) THEN
                   2
                  WHEN (DOCIT.TIPOCONSTRUCAO = 'I' AND
                       DOC.TIPODOCUMENTO NOT IN (11,53) AND
                       (IPIR.TIPOITEMCONSTRUCAOCIVIL <> 3 OR
                       IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL) AND
                       (DOC.SUBTIPO <> '4' OR DOC.TIPODOCUMENTO <> 14)) THEN
                   3
                  ELSE 0
                END AS TIPOCONSTRUCAO,
                CASE
                  WHEN (DOC.TIPODOCUMENTO NOT IN (11,53) AND
                       (IPIR.TIPOITEMCONSTRUCAOCIVIL <> 3 OR
                       IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL) AND
                       (DOC.SUBTIPO <> '4' OR DOC.TIPODOCUMENTO <> 14)) THEN
                   DOCIT.AREA
                  ELSE 0
                END AS AREA,
                CASE WHEN (DOCIT.AREA IS NULL OR DOCIT.AREA = 0) THEN
                   (SELECT SUM(CASE WHEN COALESCE(TPI.AREA,0) > 0 THEN
                                TPI.AREA
                              ELSE COALESCE(TPI.AREACOBERTA,0) + COALESCE(TPI.AREADESCOBERTA,0) END)
                     FROM TRIBPROJETOITEM TPI
                     WHERE TPI.ENTIDADE = DOC.ENTIDADE
                       AND TPI.EXERCICIO = DOC.EXERCICIOPROJETO
                       AND TPI.PROJETO = DOC.PROJETO)
                ELSE 0 END AS AREA_TOTAL,
                CASE
                  WHEN (DOC.TIPODOCUMENTO IN (11,53) AND UTIL.TIPO = 'R' AND
                       IPJI2.TIPOITEMCONSTRUCAOCIVIL <> 3) THEN
                   1
                  WHEN (DOC.TIPODOCUMENTO IN (11,53) AND UTIL.TIPO = 'C' AND
                       IPJI2.TIPOITEMCONSTRUCAOCIVIL <> 3) THEN
                   3
                  WHEN (DOC.TIPODOCUMENTO IN (11,53) AND UTIL.TIPO = 'I' AND
                       IPJI2.TIPOITEMCONSTRUCAOCIVIL <> 3) THEN
                   5
                  ELSE 0
                END AS DESTINACAO_DEMOLICAO,
                CASE
                  WHEN (TCI.CONDOMINIO > 0) OR (UTIL.UTILIZACAO = 39) OR
                       ((SELECT COUNT(1) FROM TRIBIMOBILIARIOSEGMENTO TISEG
                                 INNER JOIN TRIBTIPOSEGMENTO TTIPOSEG ON TTIPOSEG.TIPOSEGMENTO = TISEG.TIPOSEGMENTO
                        WHERE TISEG.TIPOCADASTRO = DOC.TIPOCADASTRO
                          AND TISEG.CADASTROGERAL = DOC.CADASTROGERAL
                          AND TTIPOSEG.UTILIZACAO = 1) > 1) THEN
                    2
                  ELSE 0
                END AS DESTINACAO_DEMOLICAO_MULTI,
                CASE
                  WHEN (DOC.TIPODOCUMENTO IN (11,53) AND
                       DOCIT.TIPOCONSTRUCAO IN ('A', 'T', 'C')) THEN
                   1
                  WHEN (DOC.TIPODOCUMENTO IN (11,53) AND
                       DOCIT.TIPOCONSTRUCAO = 'M') THEN
                   2
                  WHEN (DOC.TIPODOCUMENTO IN (11,53) AND
                       DOCIT.TIPOCONSTRUCAO = 'I') THEN
                   3
                  ELSE 0
                END AS TIPOCONSTRUCAO_DEMOLICAO,
                CASE
                  WHEN DOC.TIPODOCUMENTO IN (11,53) THEN
                   DOCIT.AREA
                  ELSE 0
                END AS AREA_DEMOLICAO,
                0 AS DESTINACAO_ACRESCIMO,
                0 AS TIPOCONSTRUCAO_ACRESCIMO,
                0 AS AREAACRESCIMO,
                CASE
                  WHEN (IPIR.TIPOITEMCONSTRUCAOCIVIL = 3 AND UTIL.TIPO = 'R') OR
                       (IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL AND DOC.SUBTIPO = '4' AND UTIL.TIPO = 'R' AND DOC.TIPODOCUMENTO = 14) THEN
                   1
                  WHEN (IPIR.TIPOITEMCONSTRUCAOCIVIL = 3 AND UTIL.TIPO = 'C') OR
                       (IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL AND DOC.SUBTIPO = '4' AND UTIL.TIPO = 'C' AND DOC.TIPODOCUMENTO = 14) THEN
                   3
                  WHEN (IPIR.TIPOITEMCONSTRUCAOCIVIL = 3 AND UTIL.TIPO = 'I') OR
                       (IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL AND DOC.SUBTIPO = '4' AND UTIL.TIPO = 'I' AND DOC.TIPODOCUMENTO = 14) THEN
                   5
                  ELSE 0
                END AS DESTINACAO_REFORMA,
                CASE
                  WHEN (TCI.CONDOMINIO > 0) OR (UTIL.UTILIZACAO = 39) OR
                       ((SELECT COUNT(1) FROM TRIBIMOBILIARIOSEGMENTO TISEG
                                 INNER JOIN TRIBTIPOSEGMENTO TTIPOSEG ON TTIPOSEG.TIPOSEGMENTO = TISEG.TIPOSEGMENTO
                        WHERE TISEG.TIPOCADASTRO = DOC.TIPOCADASTRO
                          AND TISEG.CADASTROGERAL = DOC.CADASTROGERAL
                          AND TTIPOSEG.UTILIZACAO = 1) > 1) THEN
                    2
                  ELSE 0
                END AS DESTINACAO_REFORMA_MULTI,
                CASE
                  WHEN (IPIR.TIPOITEMCONSTRUCAOCIVIL = 3 AND DOCIT.TIPOCONSTRUCAO IN ('A', 'T', 'C')) OR
                       (IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL AND DOC.SUBTIPO = '4' AND DOCIT.TIPOCONSTRUCAO IN ('A', 'T', 'C') AND DOC.TIPODOCUMENTO = 14) THEN
                   1
                  WHEN (IPIR.TIPOITEMCONSTRUCAOCIVIL = 3 AND DOCIT.TIPOCONSTRUCAO = 'M') OR
                       (IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL AND DOC.SUBTIPO = '4' AND DOCIT.TIPOCONSTRUCAO = 'M' AND DOC.TIPODOCUMENTO = 14) THEN
                   2
                  WHEN (IPIR.TIPOITEMCONSTRUCAOCIVIL = 3 AND DOCIT.TIPOCONSTRUCAO = 'I') OR
                       (IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL AND DOC.SUBTIPO = '4' AND DOCIT.TIPOCONSTRUCAO = 'I' AND DOC.TIPODOCUMENTO = 14) THEN
                   3
                  ELSE 0
                END AS TIPOCONSTRUCAO_REFORMA,
                CASE
                  WHEN (IPIR.TIPOITEMCONSTRUCAOCIVIL = 3) OR
                       (IPIR.TIPOITEMCONSTRUCAOCIVIL IS NULL AND DOC.SUBTIPO = '4' AND DOC.TIPODOCUMENTO = 14) THEN DOCIT.AREA
                 ELSE 0
                END AS AREA_REFORMA,
          CASE WHEN PESO.TIPOPESSOA = 'J' THEN PESO.CNPJ_CPF ELSE '' END AS CNPJ_PROPRIETARIO_OBRA,
          CASE WHEN PESO.TIPOPESSOA = 'F' THEN PESO.CNPJ_CPF ELSE '' END AS CPF_PROPRIETARIO_OBRA,
        (SELECT CASE WHEN  PG.VALOR is not null then 'ENGENHEIRO'
                     WHEN PG2.VALOR is not null then 'ARQUITETO'
                     WHEN PG3.VALOR is not null then 'TECNOLOGO'
                     WHEN PG4.VALOR is not null then 'TECNICOIND' ELSE '' END
         FROM TRIBPROJETO TP
         LEFT OUTER JOIN TRIBPROJETORESPONSAVEL TPR ON TPR.ENTIDADE = TP.ENTIDADE AND TPR.EXERCICIO = TP.EXERCICIO AND TPR.PROJETO = TP.PROJETO
         LEFT OUTER JOIN PESSOA                 TEC ON TPR.PESSOA = TEC.PESSOA
         LEFT OUTER JOIN PROFISSIONALPROFISSAO  PP  ON PP.PESSOA = TPR.PESSOA AND PP.SEQUENCIA = (SELECT MIN(SEQUENCIA) FROM PROFISSIONALPROFISSAO WHERE PESSOA = PP.PESSOA)
         LEFT OUTER JOIN PARAMETROGERAL PG  ON PG.MODULO  = '90' AND PG.PARAMETRO = 'ProfissaoEngenheiroSISOBRA' AND PG.VALOR = CAST(PP.PROFISSAO AS VARCHAR(10))
         LEFT OUTER JOIN PARAMETROGERAL PG2 ON PG2.MODULO = '90' AND PG2.PARAMETRO = 'ProfissaoArquitetoSISOBRA' AND PG2.VALOR = CAST(PP.PROFISSAO AS VARCHAR(10))
         LEFT OUTER JOIN PARAMETROGERAL PG3 ON PG3.MODULO = '90' AND PG3.PARAMETRO = 'ProfissaoTecnologoSISOBRA' AND PG3.VALOR = CAST(PP.PROFISSAO AS VARCHAR(10))
         LEFT OUTER JOIN PARAMETROGERAL PG4 ON PG4.MODULO = '90' AND PG4.PARAMETRO = 'ProfissaoTecnicoIndSISOBRA' AND PG4.VALOR = CAST(PP.PROFISSAO AS VARCHAR(10))
         WHERE TP.ENTIDADE = DOC.ENTIDADE
           AND TP.EXERCICIO = DOC.EXERCICIOPROJETO
           AND TP.PROJETO = DOC.PROJETO
           AND (TPR.TIPO = 'T' or TPR.TIPO = 'A')
           AND TPR.SEQUENCIA = (SELECT MAX(TPR1.SEQUENCIA) FROM TRIBPROJETORESPONSAVEL TPR1
                  WHERE TPR1.ENTIDADE = TPR.ENTIDADE
             AND TPR1.EXERCICIO = TPR.EXERCICIO
             AND TPR.TIPO = TPR1.TIPO
             AND TPR1.PROJETO = TPR.PROJETO)) AS TIPO_RESP_EXEC,
        (SELECT CASE WHEN  PG.VALOR is not null then 'ENGENHEIRO'
                     WHEN PG2.VALOR is not null then 'ARQUITETO'
                     WHEN PG4.VALOR is not null then 'TECNICOIND' ELSE '' END
         FROM TRIBPROJETO TP
         LEFT OUTER JOIN TRIBPROJETORESPONSAVEL TPR ON TPR.ENTIDADE = TP.ENTIDADE AND TPR.EXERCICIO = TP.EXERCICIO AND TPR.PROJETO = TP.PROJETO
         LEFT OUTER JOIN PESSOA                 TEC ON TPR.PESSOA = TEC.PESSOA
         LEFT OUTER JOIN PROFISSIONALPROFISSAO  PP  ON PP.PESSOA = TPR.PESSOA  AND PP.SEQUENCIA = (SELECT MIN(SEQUENCIA) FROM PROFISSIONALPROFISSAO WHERE PESSOA = PP.PESSOA)
         LEFT OUTER JOIN PARAMETROGERAL PG  ON PG.MODULO  = '90' AND PG.PARAMETRO = 'ProfissaoEngenheiroSISOBRA' AND PG.VALOR = CAST(PP.PROFISSAO AS VARCHAR(10))
         LEFT OUTER JOIN PARAMETROGERAL PG2 ON PG2.MODULO = '90' AND PG2.PARAMETRO = 'ProfissaoArquitetoSISOBRA' AND PG2.VALOR = CAST(PP.PROFISSAO AS VARCHAR(10))
         LEFT OUTER JOIN PARAMETROGERAL PG4 ON PG4.MODULO = '90' AND PG4.PARAMETRO = 'ProfissaoTecnicoIndSISOBRA' AND PG4.VALOR = CAST(PP.PROFISSAO AS VARCHAR(10))
         WHERE TP.ENTIDADE = DOC.ENTIDADE
           AND TP.EXERCICIO = DOC.EXERCICIOPROJETO
           AND TP.PROJETO = DOC.PROJETO
           AND (TPR.TIPO = 'P' or TPR.TIPO = 'A')
           AND TPR.SEQUENCIA = (SELECT MAX(TPR1.SEQUENCIA) FROM TRIBPROJETORESPONSAVEL TPR1
                  WHERE TPR1.ENTIDADE = TPR.ENTIDADE
             AND TPR1.EXERCICIO = TPR.EXERCICIO
             AND TPR.TIPO = TPR1.TIPO
             AND TPR1.PROJETO = TPR.PROJETO)) AS TIPO_RESP_PROJETO,
        (SELECT TEC.NOME FROM TRIBPROJETO TP
     LEFT OUTER JOIN TRIBPROJETORESPONSAVEL TPR ON
       TPR.ENTIDADE = TP.ENTIDADE
       AND TPR.EXERCICIO = TP.EXERCICIO
       AND TPR.PROJETO = TP.PROJETO
     LEFT OUTER JOIN PESSOA TEC ON
       TPR.PESSOA = TEC.PESSOA
     LEFT OUTER JOIN PROFISSIONALPROFISSAO PP ON
       PP.PESSOA = TPR.PESSOA
       AND PP.SEQUENCIA = (SELECT MIN(SEQUENCIA) FROM PROFISSIONALPROFISSAO WHERE PESSOA = PP.PESSOA)
     LEFT OUTER JOIN PARAMETROGERAL PG ON
       PG.MODULO = '90' AND (PG.PARAMETRO = 'ProfissaoEngenheiroSISOBRA' OR PG.PARAMETRO = 'ProfissaoArquitetoSISOBRA' OR PG.PARAMETRO = 'ProfissaoTecnicoIndSISOBRA')
     WHERE TP.ENTIDADE = DOC.ENTIDADE
       AND TP.EXERCICIO = DOC.EXERCICIOPROJETO
       AND TP.PROJETO = DOC.PROJETO
       AND (TPR.TIPO = 'P' or TPR.TIPO = 'A')
       AND PG.VALOR = CAST(PP.PROFISSAO AS VARCHAR(10))
       AND TPR.SEQUENCIA = (SELECT MAX(TPR1.SEQUENCIA) FROM TRIBPROJETORESPONSAVEL TPR1
                  WHERE TPR1.ENTIDADE = TPR.ENTIDADE
             AND TPR1.EXERCICIO = TPR.EXERCICIO
             AND TPR.TIPO = TPR1.TIPO
             AND TPR1.PROJETO = TPR.PROJETO)) AS NOME_RESP_PROJETO,
        (SELECT PP.CAUCREA FROM TRIBPROJETO TP
     LEFT OUTER JOIN TRIBPROJETORESPONSAVEL TPR ON
       TPR.ENTIDADE = TP.ENTIDADE
       AND TPR.EXERCICIO = TP.EXERCICIO
       AND TPR.PROJETO = TP.PROJETO
     LEFT OUTER JOIN PROFISSIONALPROFISSAO PP ON
       PP.PESSOA = TPR.PESSOA
       AND PP.SEQUENCIA = (SELECT MIN(SEQUENCIA) FROM PROFISSIONALPROFISSAO WHERE PESSOA = PP.PESSOA)
     LEFT OUTER JOIN PARAMETROGERAL PG ON
       PG.MODULO = '90'
       AND (PG.PARAMETRO = 'ProfissaoEngenheiroSISOBRA' OR PG.PARAMETRO = 'ProfissaoArquitetoSISOBRA' OR PG.PARAMETRO = 'ProfissaoTecnicoIndSISOBRA')
     WHERE TP.ENTIDADE = DOC.ENTIDADE
       AND TP.EXERCICIO = DOC.EXERCICIOPROJETO
       AND TP.PROJETO = DOC.PROJETO
       AND (TPR.TIPO = 'P' or TPR.TIPO = 'A')
       AND PG.VALOR = CAST(PP.PROFISSAO AS VARCHAR(10))
       AND TPR.SEQUENCIA = (SELECT MAX(TPR1.SEQUENCIA) FROM TRIBPROJETORESPONSAVEL TPR1
                  WHERE TPR1.ENTIDADE = TPR.ENTIDADE
             AND TPR1.EXERCICIO = TPR.EXERCICIO
             AND TPR.TIPO = TPR1.TIPO
             AND TPR1.PROJETO = TPR.PROJETO)) AS NRO_CARTEIRA_RESP_PROJETO,
        (SELECT CASE WHEN PG.PARAMETRO = 'ProfissaoArquitetoSISOBRA'  THEN 'CAU' ELSE 'CREA' END FROM TRIBPROJETO TP
     LEFT OUTER JOIN TRIBPROJETORESPONSAVEL TPR ON
       TPR.ENTIDADE = TP.ENTIDADE
       AND TPR.EXERCICIO = TP.EXERCICIO
       AND TPR.PROJETO = TP.PROJETO
     LEFT OUTER JOIN PROFISSIONALPROFISSAO PP ON
       PP.PESSOA = TPR.PESSOA
       AND PP.SEQUENCIA = (SELECT MIN(SEQUENCIA) FROM PROFISSIONALPROFISSAO WHERE PESSOA = PP.PESSOA)
     LEFT OUTER JOIN PARAMETROGERAL PG ON
       PG.MODULO = '90'
       AND (PG.PARAMETRO = 'ProfissaoEngenheiroSISOBRA' OR PG.PARAMETRO = 'ProfissaoArquitetoSISOBRA' OR PG.PARAMETRO = 'ProfissaoTecnicoIndSISOBRA')
     WHERE TP.ENTIDADE = DOC.ENTIDADE
       AND TP.EXERCICIO = DOC.EXERCICIOPROJETO
       AND TP.PROJETO = DOC.PROJETO
       AND (TPR.TIPO = 'P' or TPR.TIPO = 'A')
       AND PG.VALOR = CAST(PP.PROFISSAO AS VARCHAR(10))
       AND TPR.SEQUENCIA = (SELECT MAX(TPR1.SEQUENCIA) FROM TRIBPROJETORESPONSAVEL TPR1
                  WHERE TPR1.ENTIDADE = TPR.ENTIDADE
             AND TPR1.EXERCICIO = TPR.EXERCICIO
             AND TPR.TIPO = TPR1.TIPO
             AND TPR1.PROJETO = TPR.PROJETO)) AS TIPO_CARTEIRA_RESP_PROJETO,
        (SELECT TEC.NOME FROM TRIBPROJETO TP
     LEFT OUTER JOIN TRIBPROJETORESPONSAVEL TPR ON
       TPR.ENTIDADE = TP.ENTIDADE
       AND TPR.EXERCICIO = TP.EXERCICIO
       AND TPR.PROJETO = TP.PROJETO
     LEFT OUTER JOIN PESSOA TEC ON
       TPR.PESSOA = TEC.PESSOA
     LEFT OUTER JOIN PROFISSIONALPROFISSAO PP ON
       PP.PESSOA = TPR.PESSOA
       AND PP.SEQUENCIA = (SELECT MIN(SEQUENCIA) FROM PROFISSIONALPROFISSAO WHERE PESSOA = PP.PESSOA)
     LEFT OUTER JOIN PARAMETROGERAL PG ON
       PG.MODULO = '90'
       AND (PG.PARAMETRO = 'ProfissaoEngenheiroSISOBRA' OR PG.PARAMETRO = 'ProfissaoArquitetoSISOBRA' OR PG.PARAMETRO = 'ProfissaoTecnologoSISOBRA' OR PG.PARAMETRO = 'ProfissaoTecnicoIndSISOBRA')
     WHERE TP.ENTIDADE = DOC.ENTIDADE
       AND TP.EXERCICIO = DOC.EXERCICIOPROJETO
       AND TP.PROJETO = DOC.PROJETO
       AND (TPR.TIPO = 'T' or TPR.TIPO = 'A')
       AND PG.VALOR = CAST(PP.PROFISSAO AS VARCHAR(10))
       AND TPR.SEQUENCIA = (SELECT MAX(TPR1.SEQUENCIA) FROM TRIBPROJETORESPONSAVEL TPR1
                  WHERE TPR1.ENTIDADE = TPR.ENTIDADE
             AND TPR1.EXERCICIO = TPR.EXERCICIO
             AND TPR.TIPO = TPR1.TIPO
             AND TPR1.PROJETO = TPR.PROJETO)) AS NOME_RESP_EXEC,
        (SELECT PP.CAUCREA FROM TRIBPROJETO TP
     LEFT OUTER JOIN TRIBPROJETORESPONSAVEL TPR ON
       TPR.ENTIDADE = TP.ENTIDADE
       AND TPR.EXERCICIO = TP.EXERCICIO
       AND TPR.PROJETO = TP.PROJETO
     LEFT OUTER JOIN PROFISSIONALPROFISSAO PP ON
       PP.PESSOA = TPR.PESSOA
       AND PP.SEQUENCIA = (SELECT MIN(SEQUENCIA) FROM PROFISSIONALPROFISSAO WHERE PESSOA = PP.PESSOA)
     LEFT OUTER JOIN PARAMETROGERAL PG ON
       PG.MODULO = '90'
       AND (PG.PARAMETRO = 'ProfissaoEngenheiroSISOBRA' OR PG.PARAMETRO = 'ProfissaoArquitetoSISOBRA' OR PG.PARAMETRO = 'ProfissaoTecnologoSISOBRA' OR PG.PARAMETRO = 'ProfissaoTecnicoIndSISOBRA')
     WHERE TP.ENTIDADE = DOC.ENTIDADE
       AND TP.EXERCICIO = DOC.EXERCICIOPROJETO
       AND TP.PROJETO = DOC.PROJETO
       AND (TPR.TIPO = 'T' or TPR.TIPO = 'A')
       AND PG.VALOR = CAST(PP.PROFISSAO AS VARCHAR(10))
       AND TPR.SEQUENCIA = (SELECT MAX(TPR1.SEQUENCIA) FROM TRIBPROJETORESPONSAVEL TPR1
                  WHERE TPR1.ENTIDADE = TPR.ENTIDADE
             AND TPR1.EXERCICIO = TPR.EXERCICIO
             AND TPR.TIPO = TPR1.TIPO
             AND TPR1.PROJETO = TPR.PROJETO)) AS NRO_CARTEIRA_RESP_EXEC,
        (SELECT CASE WHEN PG.PARAMETRO = 'ProfissaoArquitetoSISOBRA'  THEN 'CAU' ELSE 'CREA' END FROM TRIBPROJETO TP
     LEFT OUTER JOIN TRIBPROJETORESPONSAVEL TPR ON
       TPR.ENTIDADE = TP.ENTIDADE
       AND TPR.EXERCICIO = TP.EXERCICIO
       AND TPR.PROJETO = TP.PROJETO
     LEFT OUTER JOIN PROFISSIONALPROFISSAO PP ON
       PP.PESSOA = TPR.PESSOA
       AND PP.SEQUENCIA = (SELECT MIN(SEQUENCIA) FROM PROFISSIONALPROFISSAO WHERE PESSOA = PP.PESSOA)
     LEFT OUTER JOIN PARAMETROGERAL PG ON
       PG.MODULO = '90'
       AND (PG.PARAMETRO = 'ProfissaoEngenheiroSISOBRA' OR PG.PARAMETRO = 'ProfissaoArquitetoSISOBRA' OR PG.PARAMETRO = 'ProfissaoTecnologoSISOBRA' OR PG.PARAMETRO = 'ProfissaoTecnicoIndSISOBRA')
     WHERE TP.ENTIDADE = DOC.ENTIDADE
       AND TP.EXERCICIO = DOC.EXERCICIOPROJETO
       AND TP.PROJETO = DOC.PROJETO
       AND (TPR.TIPO = 'T' or TPR.TIPO = 'A')
       AND PG.VALOR = CAST(PP.PROFISSAO AS VARCHAR(10))
       AND TPR.SEQUENCIA = (SELECT MAX(TPR1.SEQUENCIA) FROM TRIBPROJETORESPONSAVEL TPR1
                  WHERE TPR1.ENTIDADE = TPR.ENTIDADE
             AND TPR1.EXERCICIO = TPR.EXERCICIO
             AND TPR.TIPO = TPR1.TIPO
             AND TPR1.PROJETO = TPR.PROJETO)) AS TIPO_CARTEIRA_RESP_EXEC,
       PJ.ART AS ART_ENGENHEIRO,
       PJ.TRT AS TRT_TECNICOIND,
       PJ.RRT AS RRT_ARQUITETO,
       tdt.descricao as descricao_documento,
       case when coalesce(soa.enviado,'N') = 'S' then true else false end as enviado,
       case when coalesce(soa.enviadoComSucesso,'N') = 'S' then true else false end as enviadoComSucesso,
       coalesce(soa.id,0) as idSisObraAlvara
  FROM TRIBDOCUMENTO DOC
  LEFT OUTER JOIN TRIBPROJETO PJ ON DOC.ENTIDADE = PJ.ENTIDADE
                                AND DOC.EXERCICIOPROJETO = PJ.EXERCICIO
                                AND DOC.PROJETO = PJ.PROJETO
  LEFT OUTER JOIN TRIBCADASTROGERAL TCG ON DOC.TIPOCADASTRO = TCG.TIPOCADASTRO
                                       AND DOC.CADASTROGERAL = TCG.CADASTROGERAL
  LEFT OUTER JOIN TRIBCADASTROIMOBILIARIO TCI ON TCG.TIPOCADASTRO = TCI.TIPOCADASTRO
                                             AND TCG.CADASTROGERAL = TCI.CADASTROGERAL
  LEFT OUTER JOIN (SELECT B.ENTIDADE,B.EXERCICIO,B.DOCUMENTO,B.TIPODOCUMENTO,B.UTILIZACAO,cast('A' as varchar(1)) TIPOCONSTRUCAO,
                   SUM (CASE WHEN B.TIPODOCUMENTO IN (50,51,52)
                            THEN CASE WHEN (COALESCE(B.AREACOBERTA,0)+COALESCE(B.AREADESCOBERTA,0)) > 0
                            THEN (COALESCE(B.AREACOBERTA,0)+COALESCE(B.AREADESCOBERTA,0))
                            ELSE (COALESCE(B.AREACOBERTA_APROVADA,0)+COALESCE(B.AREADESCOBERTA_APROVADA,0)) END
                            WHEN B.TIPODOCUMENTO = 53
                            THEN COALESCE(B.AREACOBERTA_DEMOLIDA,0)+COALESCE(B.AREADESCOBERTA_DEMOLIDA,0)
                            WHEN B.TIPODOCUMENTO IN (11,14,15) AND ((COALESCE(B.AREACOBERTA,0)+COALESCE(B.AREADESCOBERTA,0)) > 0)
                            THEN (COALESCE(B.AREACOBERTA,0)+COALESCE(B.AREADESCOBERTA,0))
                            ELSE B.AREA
                            END) AREA,
                            SUM(B.AREACOBERTA) AS AREA_COBERTA,
                            SUM(B.AREADESCOBERTA) AS AREA_DESCOBERTA
                            FROM TRIBDOCUMENTOITEMCERTIDAO B
                            WHERE B.ENTIDADE = ENTIDADE
                            AND B.EXERCICIO = EXERCICIO
                            AND B.DOCUMENTO = DOCUMENTO
                            AND B.TIPODOCUMENTO = TIPODOCUMENTO
                            GROUP BY B.ENTIDADE,B.EXERCICIO,B.DOCUMENTO,B.TIPODOCUMENTO,B.UTILIZACAO) DOCIT
                            ON DOC.ENTIDADE  = DOCIT.ENTIDADE
                            AND DOC.EXERCICIO = DOCIT.EXERCICIO
                            AND DOC.TIPODOCUMENTO = DOCIT.TIPODOCUMENTO
                            AND DOC.DOCUMENTO = DOCIT.DOCUMENTO
  LEFT OUTER JOIN TRIBUTILIZACAO UTIL ON UTIL.UTILIZACAO = DOCIT.UTILIZACAO
  LEFT OUTER JOIN PESSOA RESPONSAVEL ON RESPONSAVEL.PESSOA = (CASE WHEN PJ.PESSOA IS NULL THEN DOC.PESSOA
                                                              ELSE PJ.PESSOA END)
  LEFT OUTER JOIN ENDERECOPESSOA ENDER ON ENDER.PESSOA = RESPONSAVEL.PESSOA
                                    AND ENDER.SEQUENCIA = RESPONSAVEL.SEQUENCIAENDERECO
  LEFT OUTER JOIN CONTATOPESSOA CP ON CP.PESSOA = RESPONSAVEL.PESSOA
                                  AND CP.SEQUENCIA = RESPONSAVEL.SEQUENCIACONTATO
  LEFT OUTER JOIN ENDERECOPESSOA END2 ON END2.PESSOA = RESPONSAVEL.PESSOA
                                     AND END2.SEQUENCIA = RESPONSAVEL.SEQUENCIAENDERECO
                                     AND END2.TIPOENDERECO = '3'
  LEFT OUTER JOIN CIDADE CID ON ENDER.CIDADE = CID.CIDADE
  LEFT OUTER JOIN LOGRADOURO LOG ON ENDER.LOGRADOURO = LOG.LOGRADOURO
                                AND ENDER.CIDADE = LOG.CIDADE
  LEFT OUTER JOIN BAIRRO BAI ON ENDER.BAIRRO = BAI.BAIRRO
                            AND ENDER.CIDADE = BAI.CIDADE
  LEFT OUTER JOIN PESSOA RESP_EXEC_OBRA ON RESP_EXEC_OBRA.PESSOA = PJ.PESSOARESPONSAVEL
  LEFT OUTER JOIN PESSOA PESO ON TCG.PESSOA = PESO.PESSOA
  LEFT OUTER JOIN LOGRADOURO LOGO ON TCG.LOGRADOURO = LOGO.LOGRADOURO
                                  AND TCG.CIDADE = LOGO.CIDADE
  LEFT OUTER JOIN TIPOLOGRADOURO TILOGO ON TILOGO.TIPOLOGRADOURO = LOGO.TIPOLOGRADOURO
  LEFT OUTER JOIN CIDADE CIDO ON TCG.CIDADE = CIDO.CIDADE
  LEFT OUTER JOIN BAIRRO BAIO ON TCG.BAIRRO = BAIO.BAIRRO
                                                     AND TCG.CIDADE = BAIO.CIDADE
  LEFT OUTER JOIN ENDERECOPESSOA ENDO ON PESO.PESSOA = ENDO.PESSOA
                                                     AND PESO.SEQUENCIAENDERECO = ENDO.SEQUENCIA
  LEFT OUTER JOIN TRIBPROJETOITEM PIR ON PJ.ENTIDADE = PIR.ENTIDADE
                                                     AND PJ.EXERCICIO = PIR.EXERCICIO
                                                     AND PJ.PROJETO = PIR.PROJETO
                                                     AND (PJ.TIPOPROJETO IN (1))
                                                     AND DOC.SUBTIPO = '4'
                                                     AND DOC.TIPODOCUMENTO = 14
  LEFT OUTER JOIN TRIBITEMCONSTRUCAOCIVIL IPIR ON IPIR.ITEMCONSTRUCAOCIVIL = PIR.ITEMCONSTRUCAOCIVIL
                                              AND IPIR.TIPOITEMCONSTRUCAOCIVIL = 3
  LEFT OUTER JOIN TRIBPROJETOITEM PJI1 ON PJ.ENTIDADE = PJI1.ENTIDADE
                                                     AND PJ.EXERCICIO = PJI1.EXERCICIO
                                                     AND PJ.PROJETO = PJI1.PROJETO
                                                     AND (PJ.TIPOPROJETO IN (1))
  LEFT OUTER JOIN TRIBITEMCONSTRUCAOCIVIL IPJI1 ON IPJI1.ITEMCONSTRUCAOCIVIL = PJI1.ITEMCONSTRUCAOCIVIL
                                              AND IPJI1.TIPOITEMCONSTRUCAOCIVIL = 1
  LEFT OUTER JOIN TRIBPROJETOITEM PJI2 ON PJ.ENTIDADE = PJI2.ENTIDADE
                                      AND PJ.EXERCICIO = PJI2.EXERCICIO
                                      AND PJ.PROJETO = PJI2.PROJETO
                                      AND PJ.TIPOPROJETO = 5
  LEFT OUTER JOIN TRIBITEMCONSTRUCAOCIVIL IPJI2 ON IPJI2.ITEMCONSTRUCAOCIVIL = PJI2.ITEMCONSTRUCAOCIVIL
  LEFT OUTER JOIN TRIBDOCUMENTOITEMCERTIDAO CI ON CI.ENTIDADE = DOC.ENTIDADE
                                              AND CI.EXERCICIO = DOC.EXERCICIO
                                              AND CI.TIPODOCUMENTO = DOC.TIPODOCUMENTO
                                              AND CI.DOCUMENTO = DOC.DOCUMENTO
                                              AND CI.NROALVARA IS NOT NULL
                                              AND CI.NROALVARA NOT LIKE 'ATUAL%'
  LEFT OUTER JOIN TRIBDOCUMENTO DOCCERTIDAO ON CI.ENTIDADE = DOCCERTIDAO.ENTIDADE
                                           AND CI.EXERCICIO = DOCCERTIDAO.EXERCICIO
                                           AND CI.TIPODOCUMENTO = DOCCERTIDAO.TIPODOCUMENTO
                                           AND CI.DOCUMENTO = DOCCERTIDAO.DOCUMENTO
  LEFT OUTER JOIN TRIBDOCUMENTO DOCALVARA ON CI.ENTIDADE = DOCALVARA.ENTIDADE
                                           AND DOCALVARA.EXERCICIO = (CASE WHEN CI.ANOALVARA IS NOT NULL THEN CI.ANOALVARA
                                                                      ELSE EXTRACT(YEAR FROM CI.DATAAPROVACAO) END)
                                           AND CI.NROALVARA = CAST(DOCALVARA.DOCUMENTO AS VARCHAR(15))
                                           AND DOCALVARA.TIPODOCUMENTO IN (14,50,51)
  left outer join tribdocumentotipo tdt on doc.tipodocumento = tdt.tipodocumento
  left outer join sisobraalvara soa on cast(soa.numeroalvara as numeric(10)) = doc.documento and soa.dataalvara  = doc.dataemissao
WHERE DOC.TIPODOCUMENTO IN (11,14,50,51)
AND DOC.SITUACAO <> 2
AND DOC.DATAEMISSAO >= :dataInicial
AND DOC.DATAEMISSAO <= :dataFinal ) A