SELECT
    tarefa.id AS id,
    tarefa.tipo AS tipo,
    execucao.id AS execucaoId,
    execucao.situacao AS situacao,
    execucao.datainicio AS dataInicio,
    execucao.datafim AS dataFim
FROM tarefaassincrona tarefa
JOIN (
    SELECT
        execucao.*,
        ROW_NUMBER() OVER (
            PARTITION BY execucao.tarefaassincrona
            ORDER BY execucao.id DESC
        ) AS mostRecentOrder
    FROM tarefaassincronaexecucao execucao
) execucao
  ON tarefa.id = execucao.tarefaassincrona
WHERE execucao.mostRecentOrder = 1