Select distinct a.TipoCadastro,
                a.CadastroGeral,
                a.idKey as idCadastro,
                a.cnpj_cpf as cpfCnpj,
                case when a.tipopessoa = 'J' 
                     then 'Jurídica'
                     else 'Física'
                end as tipoPessoa,
                a.nome,
                a.pessoa,
                a.VinculoDescricao,
                a.tipovinculo,
                a.principal,
                a.coResponsavelPrincipal,
                tl.descricao as tipoLogradouro,
                lg.descricao as logradouro,
                a.numero as numero,
                ba.descricao as bairro,
                ci.descricao as cidade,
                ci.unidadefederacao as unidadeFederacao,
                coalesce(sitimob.descricao, sitmob.descricao, 'OK') as situacao,
                a.inscricaoCadastral,
                case when coalesce(a.convencaoCondominio,'N') = 'S' then 1 else 0 end as convencaoCondominio
  from (Select distinct a.TipoCadastro,
                        a.CadastroGeral,
                        a.idKey,
                        b.cnpj_cpf,
                        b.tipopessoa,
                        b.nome,
                        b.pessoa,
                        a.logradouro,
                        a.numero,
                        a.bairro,
                        a.cidade,
                        case when a.Tipocadastro = 1
                             then tv.Descricao
                             else 'PROPRIETÁRIO'
                        end as VinculoDescricao,
                        tv.tipovinculo,
                        case when tb.principal = 'S' 
                     		then 1
                     		else 0
                		end as principal,
                        case when tb.coresponsavelprincipal = 'S'
                            then 1
                            else 0
                        end as coResponsavelPrincipal,
                        tci.inscricaoCadastral,
                        tci.convencaoCondominio
          from tribCadastroGeral a
         inner join tribViewProprietario tb on a.TipoCadastro = tb.TipoCadastro
                                           and a.CadastroGeral = tb.CadastroGeral
          left outer join pessoa b on ((tb.pessoa = b.pessoa and a.TipoCadastro = 1) or
                                      (a.pessoa = b.pessoa and a.TipoCadastro in (:tiposCadastroExcetoImobiliario)))
          left outer join tribVinculo tv on tb.Vinculo = tv.Vinculo
          left outer join tribCadastroImobiliario tci on tci.tipocadastro = a.tipocadastro and tci.cadastrogeral = a.cadastrogeral
         Where a.ExclusaoLogica = 'N'
           and not exists
         (select 1
                  from tribViewProprietario tb2
                 inner join tribvinculo tv2 on (tv2.vinculo = tb2.vinculo)
                 where tb2.tipocadastro = tb.tipocadastro
                   and tb2.cadastrogeral = tb.cadastrogeral
                   and tb2.pessoa = tb.pessoa
                   and tv2.tipovinculo = 5)
           and a.tipocadastro in (:tiposCadastro)
           :filtroRastreamento
        union
        Select distinct a.TipoCadastro,
                        a.CadastroGeral,
                        a.idKey,
                        b.cnpj_cpf,
                        b.tipopessoa,
                        b.nome,
                        b.pessoa,
                        a.logradouro,
                        a.numero,
                        a.bairro,
                        a.cidade,
                        cast('PROPRIETÁRIO' as varchar(20)) as VinculoDescricao,
                        cast(0 as numeric) as tipovinculo,
                        cast(1 as numeric) as principal,
                        cast(0 as numeric) as coResponsavelPrincipal,
                        tci.inscricaoCadastral,
                        tci.convencaoCondominio
          from tribCadastroGeral a
          left outer join pessoa b on (a.pessoa = b.pessoa and a.TipoCadastro in (:tiposCadastroExcetoImobiliario))
          left outer join tribCadastroImobiliario tci on tci.tipocadastro = a.tipocadastro and tci.cadastrogeral = a.cadastrogeral
         Where a.ExclusaoLogica = 'N'
           and not exists (select 1
                  from tribViewProprietario tb
                 where tb.tipocadastro = a.tipocadastro
                   and tb.cadastrogeral = a.cadastrogeral)
           and a.tipocadastro in (:tiposCadastro)
           :filtroRastreamento
        ) a
 left outer join tribmobiliariosituacao mobsit
  on a.tipocadastro = mobsit.tipocadastro
  and a.cadastrogeral = mobsit.cadastrogeral
  and mobsit.atual = 'S'
 left outer join tribsituacaomobiliario sitmob
  on sitmob.situacaomobiliario = mobsit.situacaomobiliario
 left outer join tribimobiliariosituacao imobsit
  on a.tipocadastro = imobsit.tipocadastro
  and a.cadastrogeral = imobsit.cadastrogeral
  and imobsit.atual = 'S'
 left outer join tribsituacaoimobiliario sitimob
  on sitimob.situacaoimobiliario = imobsit.situacaoimobiliario
 left outer join logradouro lg on lg.cidade = a.cidade
                               and lg.logradouro = a.logradouro
 left outer join tipologradouro tl on tl.tipologradouro = lg.tipologradouro
 left outer join bairro ba on ba.cidade = a.cidade
                           and ba.bairro = a.bairro
 left outer join cidade ci on ci.cidade = a.cidade
