Select dp.entidade,
        dp.exercicio,
        dp.tipocadastro,
        dp.cadastrogeral,
        tcg.idkey as idCadastro,
        dp.guiarecolhimento as divida,
        dp.subdivida,
        dp.parcela,
        case when dp.situacaodebito = coalesce((select t.situacaoParcela from tribparametrototem t left join tribsituacaoparcela tsp ON tsp.situacaoparcela = t.situacaoparcela  where entidade = 1),-99) then
	        current_date + 30
         else
         	dp.DataVencimento
        end DataVencimento,
        max((select max(tgrfp.Vencimento) from tribguiarecolhimentoformapag tgrfp
                                          left outer join tribformapagamento tfp
                                             on tfp.formapagamento = tgrfp.formapagamento
                                          where tgrfp.Entidade = d.Entidade
                                            and tgrfp.Exercicio = d.Exercicio
                                            and tgrfp.guiarecolhimento = d.Guiarecolhimento
                                            and tfp.tipoformapagamento = 'U'
                                            and tgrfp.vencimento between :dataVencimentoCotaUnicaIni and :dataVencimentoCotaUnicaFim))  as DataVencimentoCotaUnica,
        case when d.Parcelado = 'S'
        	then 1
            else 0
        end as parcelado,
       	case when d.Reparcelado = 'S'
       		then 1
            else 0
        end as reparcelado,
        d.idcontencioso,
        case when sp.tiposituacaoparcela in (22, 23, 24)
          then 1
          else 0
        end recursoAdministrativo,
        d.datalancamento,
        d.dataprimeiraparcela,
        d.datacorrecaoigpm,
        d.formacorrecao,
        dp.situacaolegal,
        dpr.receita,
        dpr.iddebitoparcelareceita as idDebitoParcelaTributo,
        dpr.valor
   from tribdebito d
   join tribcadastrogeral tcg on d.TipoCadastro = tcg.TipoCadastro
                             and d.CadastroGeral = tcg.CadastroGeral
   join tribdebitoparcela dp on dp.entidade = d.entidade
                            and dp.exercicio = d.exercicio
                            and dp.tipocadastro = d.tipocadastro
                            and dp.cadastrogeral = d.cadastrogeral
                            and dp.guiarecolhimento = d.guiarecolhimento
                            and dp.subdivida = d.subdivida
   join tribsituacaoparcela sp on sp.situacaoparcela = dp.situacaodebito
   join tribTipoSituacaoparcela ttsp on sp.Tiposituacaoparcela = ttsp.Tiposituacaoparcela
   join tribdebitoparcelareceita dpr on dpr.entidade = dp.entidade
                                    and dpr.exercicio = dp.exercicio
                                    and dpr.tipocadastro = dp.tipocadastro
                                    and dpr.cadastrogeral = dp.cadastrogeral
                                    and dpr.guiarecolhimento = dp.guiarecolhimento
                                    and dpr.subdivida = dp.subdivida
                                    and dpr.parcela = dp.parcela
   join pessoa p on tcg.pessoa = p.pessoa
  where ttsp.Tipo = 'A'
    and d.Constituido = 'S'
    and tcg.ExclusaoLogica = 'N'
    and tcg.idkey in (:ids)
  group by dp.entidade,
           dp.exercicio,
           dp.tipocadastro,
           dp.cadastrogeral,
           tcg.idkey,
           dp.guiarecolhimento,
           dp.subdivida,
           dp.parcela,
           dp.DataVencimento,
           d.REPARCELADO,
           d.PARCELADO,
           d.idcontencioso,
           sp.tiposituacaoparcela,
           d.datalancamento,
           d.dataprimeiraparcela,
           d.datacorrecaoigpm,
           d.formacorrecao,
           dp.situacaolegal,
           dpr.receita,
           dpr.iddebitoparcelareceita,
           dpr.valor