SELECT debitoOrigem.idDebito,
       debito.entidade,
       debito.exercicio,
       debito.tipoCadastro,
       debito.cadastroGeral,
       debito.guiaRecolhimento,
       debito.subDivida,
       debito.dataLancamento,
       guiarecolhimento.descricao as descricaoDivida,
       SUM(espelho.valor) valor,
       SUM(espelho.valorJuros) AS valorJuros,
       SUM(espelho.valorMulta) AS valorMulta,
       SUM(espelho.valorCorrecao) AS valorCorrecao,
       SUM(espelho.valorDescontoPrincipal
           + espelho.valorDescontoJuros
           + espelho.valorDescontoMulta
           + espelho.valorDescontoCorrecao
       ) AS valorDesconto,
       SUM(espelho.valorJurosFinan) as valorJurosFinanciamento,
       tdida.idCertidao,
       tdida.numeroCertidao,
       tdida.exercicioCertidao
FROM TribParcelamentoDebitoOrigem debitoOrigem
         LEFT OUTER JOIN TribDebito debito
                         ON    debitoOrigem.IdDebito = debito.idDebito
         LEFT OUTER JOIN TribParcelamentoReceitaEspelho espelho
                         ON debitoOrigem.idParcelamento = espelho.idParcelamento
                             AND debitoOrigem.idDebito = espelho.idDebito
         LEFT JOIN TribGuiaRecolhimento guiarecolhimento
                               on guiarecolhimento.entidade = debito.entidade
                             and guiarecolhimento.exercicio = debito.exercicio
                             and guiarecolhimento.guiarecolhimento = debito.guiarecolhimento
        LEFT OUTER JOIN TRIBDEBITOPARCELARECEITA TRIBDEBITOPARCELARECEITA
                 ON TRIBDEBITOPARCELARECEITA.ENTIDADE = debito.ENTIDADE
                AND TRIBDEBITOPARCELARECEITA.EXERCICIO = debito.EXERCICIO
                AND TRIBDEBITOPARCELARECEITA.TIPOCADASTRO = debito.TIPOCADASTRO
                AND TRIBDEBITOPARCELARECEITA.CADASTROGERAL = debito.CADASTROGERAL
                AND TRIBDEBITOPARCELARECEITA.GUIARECOLHIMENTO = debito.GUIARECOLHIMENTO
                AND TRIBDEBITOPARCELARECEITA.SUBDIVIDA = debito.SUBDIVIDA
        left outer join (select tdidajoin.entidade,
                                 tdidajoin.exercicio,
                                 tdidajoin.tipodocumento,
                                 tdidajoin.documento,
                                 tdidajoin.exerciciodebito,
                                 tdidajoin.tipocadastro,
                                 tdidajoin.cadastrogeral,
                                 tdidajoin.guiarecolhimento,
                                 tdidajoin.subdivida,
                                 tdidajoin.parcela,
                                 tdidajoin.receita,
                                 doc.idkey as IDCERTIDAO,
                                 doc.documento as NUMEROCERTIDAO,
                                 doc.EXERCICIO AS EXERCICIOCERTIDAO,
                                 doc.cancelado
                          from  tribdocumentoitemdividaativa tdidajoin
                                    inner join tribdocumento doc on (tdidajoin.entidade  = doc.entidade
                              and tdidajoin.exercicio = doc.exercicio
                              and tdidajoin.tipodocumento = doc.tipodocumento
                              and tdidajoin.documento     = doc.documento)
                          where tdidajoin.tipodocumento = 26
                            and (tdidajoin.exercicio, tdidajoin.documento) in
                                (select max(tdidamax.exercicio), max(tdidamax.documento) as ultimodocumento
                                 from tribdocumentoitemdividaativa tdidamax
                                          join tribdocumento docmax on (docmax.entidade = tdidamax.entidade
                                     and  docmax.exercicio = tdidamax.exercicio
                                     and  docmax.tipodocumento = tdidamax.tipodocumento
                                     and  docmax.documento     = tdidamax.documento
                                     and  docmax.cancelado     = 'N')
                                 where tdidamax.entidade       = tdidajoin.entidade
                                   and tdidamax.exerciciodebito  = tdidajoin.exerciciodebito
                                   and tdidamax.tipocadastro     = tdidajoin.tipocadastro
                                   and tdidamax.cadastrogeral    = tdidajoin.cadastrogeral
                                   and tdidamax.guiarecolhimento = tdidajoin.guiarecolhimento
                                   and tdidamax.subdivida        = tdidajoin.subdivida
                                   and tdidamax.parcela          = tdidajoin.parcela
                                   and tdidamax.receita          = tdidajoin.receita
                                   and tdidamax.tipodocumento    = tdidajoin.tipodocumento
                                   and tdidamax.exercicio = (
                                     select max(tdidaexercicio.exercicio)
                                     from tribdocumentoitemdividaativa tdidaexercicio
                                              join tribdocumento docexercicio on (docexercicio.entidade = tdidaexercicio.entidade
                                         and  docexercicio.exercicio = tdidaexercicio.exercicio
                                         and  docexercicio.tipodocumento = tdidaexercicio.tipodocumento
                                         and  docexercicio.documento     = tdidaexercicio.documento
                                         and  docexercicio.cancelado     = 'N')
                                     where tdidaexercicio.entidade       = tdidajoin.entidade
                                       and tdidaexercicio.exerciciodebito  = tdidajoin.exerciciodebito
                                       and tdidaexercicio.tipocadastro     = tdidajoin.tipocadastro
                                       and tdidaexercicio.cadastrogeral    = tdidajoin.cadastrogeral
                                       and tdidaexercicio.guiarecolhimento = tdidajoin.guiarecolhimento
                                       and tdidaexercicio.subdivida        = tdidajoin.subdivida
                                       and tdidaexercicio.parcela          = tdidajoin.parcela
                                       and tdidaexercicio.receita          = tdidajoin.receita
                                       and tdidaexercicio.tipodocumento    = tdidajoin.tipodocumento
                                 )
                                )
                            and doc.cancelado = 'N'
) tdida on (TRIBDEBITOPARCELARECEITA.entidade         = tdida.entidade
    and TRIBDEBITOPARCELARECEITA.exercicio        = tdida.exerciciodebito
    and TRIBDEBITOPARCELARECEITA.tipocadastro     = tdida.tipocadastro
    and TRIBDEBITOPARCELARECEITA.cadastrogeral    = tdida.cadastrogeral
    and TRIBDEBITOPARCELARECEITA.guiarecolhimento = tdida.guiarecolhimento
    and TRIBDEBITOPARCELARECEITA.subdivida        = tdida.subdivida
    and TRIBDEBITOPARCELARECEITA.receita          = tdida.receita
    and TRIBDEBITOPARCELARECEITA.parcela          = tdida.parcela)
where
    debitoOrigem.idParcelamento = ?
    AND TRIBDEBITOPARCELARECEITA.parcela = (
                SELECT MAX(tdp.PARCELA)
                FROM TRIBDEBITOPARCELA tdp
                WHERE tdp.ENTIDADE = debito.ENTIDADE
                    AND tdp.EXERCICIO = debito.EXERCICIO
                    AND tdp.TIPOCADASTRO = debito.TIPOCADASTRO
                    AND tdp.CADASTROGERAL = debito.CADASTROGERAL
                    AND tdp.GUIARECOLHIMENTO = debito.GUIARECOLHIMENTO
                    AND tdp.SUBDIVIDA = debito.SUBDIVIDA
            )
GROUP BY debitoOrigem.idDebito,
         debito.entidade,
         debito.exercicio,
         debito.tipoCadastro,
         debito.cadastroGeral,
         debito.guiaRecolhimento,
         debito.subDivida,
         debito.dataLancamento,
         guiarecolhimento.descricao,
         tdida.IDCERTIDAO,
         tdida.NUMEROCERTIDAO,
         tdida.EXERCICIOCERTIDAO
ORDER BY debito.exercicio DESC, debito.guiaRecolhimento, debito.subdivida
