SELECT DISTINCT
       GER.TIPOCADASTRO,
       GER.CADASTROGERAL,
       PES.PESSOA,
       PES.NOME,
       PES.CNPJ_CPF AS CPFCNPJ,
       LOGR.DESCRICAO AS RUA,
       GER.NUMERO,
       GER.COMPLEMENTO,
       GER.CEP,
       CID.DESCRICAO AS CIDADE,
       UNI.DESCRICAO AS ESTADO,
       GER.IDCADASTROGERALISS,
       COALESCE(SIT_IMOB.SITUACAOIMOBILIARIO, SIT_MOB.SITUACAOMOBILIARIO) AS SITUACAO,
       COALESCE(TS_IMOB.DESCRICAO, TS_MOB.DESCRICAO) AS DESCSITUACAO,
       CAD_MOB.NUMEROALVARA,
       CAD_MOB.EXERCICIOALVARA,
       CLOB_SUBSTR(CAD_MOB.ATIVIDADEPRINCIPAL, 1, 4000) AS ATIVIDADEPRINCIPAL,
       CAD_MOB.OBSERVACAOALVARA,
       CAD_MOB.DATAABERTURA,
       CAD_MOB.DATAENCERRAMENTO,
       CAD_MOB.DATAVALIDADEALVARA,
       CAD_MOB.DATAULTIMAFISCALIZACAO,
       CASE
       WHEN (SELECT COUNT(*)
             FROM TRIBREPRESENTANTELEGAL A
             WHERE A.PESSOA = PES.PESSOA
               AND A.TIPOCADASTRO = GER.TIPOCADASTRO
               AND A.CADASTROGERAL = GER.CADASTROGERAL) = 1 THEN 'S' ELSE 'N'
       END AS REPRESENTANTELEGAL,
       P.NOME as EMPRESANOME,
       P.CNPJ_CPF as EMPRESACNPJ
FROM PESSOA PES
INNER JOIN (SELECT P.PESSOA,
                   P.CNPJ_CPF,
                   A.TIPOCADASTRO,
                   A.CADASTROGERAL
            FROM PESSOA P
            INNER JOIN TRIBREPRESENTANTELEGAL A ON P.PESSOA = A.PESSOA
            LEFT JOIN TRIBTIPOREPRESENTANTE B ON A.TIPOREPRESENTANTE = B.TIPOREPRESENTANTE
                                             AND B.ADMINISTRADOR = 'S'
            UNION
            SELECT P.PESSOA,
                   P.CNPJ_CPF,
                   A.TIPOCADASTRO,
                   A.CADASTROGERAL
            FROM PESSOA P
            INNER JOIN TRIBPROPRIETARIO A ON P.PESSOA = A.PESSOA) CAD ON PES.PESSOA = CAD.PESSOA
                                                                     AND PES.CNPJ_CPF = CAD.CNPJ_CPF
INNER JOIN TRIBCADASTROGERAL GER ON GER.TIPOCADASTRO = CAD.TIPOCADASTRO
                                AND GER.CADASTROGERAL = CAD.CADASTROGERAL
LEFT OUTER JOIN LOGRADOURO LOGR ON LOGR.CIDADE     = GER.CIDADE
                               AND LOGR.LOGRADOURO = GER.LOGRADOURO
LEFT OUTER JOIN CIDADE CID ON CID.CIDADE = GER.CIDADE
LEFT OUTER JOIN UNIDADEFEDERACAO UNI ON UNI.UNIDADEFEDERACAO = CID.UNIDADEFEDERACAO
                                    AND UNI.PAIS = CID.PAIS
LEFT OUTER JOIN TRIBCADASTROIMOBILIARIO CAD_IMOB ON GER.TIPOCADASTRO = CAD_IMOB.TIPOCADASTRO
                                                AND GER.CADASTROGERAL = CAD_IMOB.CADASTROGERAL
LEFT OUTER JOIN (SELECT A.TIPOCADASTRO,
                        A.CADASTROGERAL,
                        MAX(A.SEQUENCIA) AS SEQUENCIA
                 FROM TRIBIMOBILIARIOSITUACAO A
                 WHERE A.ATUAL = 'S'
                 GROUP BY A.TIPOCADASTRO,
                          A.CADASTROGERAL) S_IMOB ON CAD_IMOB.TIPOCADASTRO = S_IMOB.TIPOCADASTRO
                                                                 AND CAD_IMOB.CADASTROGERAL = S_IMOB.CADASTROGERAL
LEFT OUTER JOIN TRIBIMOBILIARIOSITUACAO SIT_IMOB ON S_IMOB.TIPOCADASTRO = SIT_IMOB.TIPOCADASTRO
                                                AND S_IMOB.CADASTROGERAL = SIT_IMOB.CADASTROGERAL
                                                AND S_IMOB.SEQUENCIA = SIT_IMOB.SEQUENCIA
LEFT OUTER JOIN TRIBSITUACAOIMOBILIARIO TS_IMOB ON SIT_IMOB.SITUACAOIMOBILIARIO = TS_IMOB.SITUACAOIMOBILIARIO
LEFT OUTER JOIN TRIBCADASTROMOBILIARIO CAD_MOB ON GER.TIPOCADASTRO = CAD_MOB.TIPOCADASTRO
                                              AND GER.CADASTROGERAL = CAD_MOB.CADASTROGERAL
LEFT OUTER JOIN (SELECT A.TIPOCADASTRO,
                        A.CADASTROGERAL,
                        MAX(A.SEQUENCIA) AS SEQUENCIA
                 FROM TRIBMOBILIARIOSITUACAO A
                 WHERE A.ATUAL = 'S'
                 GROUP BY A.TIPOCADASTRO,
                          A.CADASTROGERAL) S_MOB ON CAD_MOB.TIPOCADASTRO = S_MOB.TIPOCADASTRO
                                                AND CAD_MOB.CADASTROGERAL = S_MOB.CADASTROGERAL
LEFT OUTER JOIN TRIBMOBILIARIOSITUACAO SIT_MOB ON S_MOB.TIPOCADASTRO = SIT_MOB.TIPOCADASTRO
                                              AND S_MOB.CADASTROGERAL = SIT_MOB.CADASTROGERAL
                                              AND S_MOB.SEQUENCIA = SIT_MOB.SEQUENCIA
LEFT OUTER JOIN TRIBSITUACAOMOBILIARIO TS_MOB ON SIT_MOB.SITUACAOMOBILIARIO = TS_MOB.SITUACAOMOBILIARIO
LEFT OUTER JOIN PESSOA P ON P.PESSOA = GER.PESSOA
WHERE GER.EXCLUSAOLOGICA = 'N'
$[FILTROS]
ORDER BY GER.TIPOCADASTRO, GER.CADASTROGERAL