SELECT GER.TIPOCADASTRO,
       GER.CADASTROGERAL,
       PES.PESSOA,
       PES.NOME,
       PES.CNPJ_CPF AS CPFCNPJ,
       DEB.IDDEBITO,
       GUIA.DESCRICAO,
       PAR.PARCELA,
       PAR.DATAVENCIMENTO,
       (SELECT SUM(VALOR)
        FROM TRIBDEBITOPARCELARECEITA REC
        WHERE REC.ENTIDADE = PAR.ENTIDADE
          AND REC.EXERCICIO = PAR.EXERCICIO
          AND REC.TIPOCADASTRO = PAR.TIPOCADASTRO
          AND REC.CADASTROGERAL = PAR.CADASTROGERAL
          AND REC.GUIARECOLHIMENTO = PAR.GUIARECOLHIMENTO
          AND REC.SUBDIVIDA = PAR.SUBDIVIDA
          AND REC.PARCELA = PAR.PARCELA) AS VALOR
FROM PESSOA PES
INNER JOIN (SELECT P.PESSOA,
                   P.CNPJ_CPF,
                   A.TIPOCADASTRO,
                   A.CADASTROGERAL
            FROM PESSOA P
            INNER JOIN TRIBREPRESENTANTELEGAL A ON P.PESSOA = A.PESSOA
            LEFT JOIN TRIBTIPOREPRESENTANTE B ON A.TIPOREPRESENTANTE = B.TIPOREPRESENTANTE
                                             AND B.ADMINISTRADOR = 'S'
            UNION
            SELECT P.PESSOA,
                   P.CNPJ_CPF,
                   A.TIPOCADASTRO,
                   A.CADASTROGERAL
            FROM PESSOA P
            INNER JOIN TRIBPROPRIETARIO A ON P.PESSOA = A.PESSOA) CAD ON PES.PESSOA = CAD.PESSOA
                                                                     AND PES.CNPJ_CPF = CAD.CNPJ_CPF
INNER JOIN TRIBCADASTROGERAL GER ON GER.TIPOCADASTRO  = CAD.TIPOCADASTRO
                                AND GER.CADASTROGERAL = CAD.CADASTROGERAL
INNER JOIN TRIBDEBITO DEB ON DEB.TIPOCADASTRO = GER.TIPOCADASTRO
                         AND DEB.CADASTROGERAL = GER.CADASTROGERAL
INNER JOIN TRIBGUIARECOLHIMENTO GUIA ON GUIA.ENTIDADE = DEB.ENTIDADE
                                    AND GUIA.EXERCICIO = DEB.EXERCICIO
                                    AND GUIA.GUIARECOLHIMENTO = DEB.GUIARECOLHIMENTO
INNER JOIN TRIBDEBITOPARCELA PAR ON PAR.ENTIDADE         = DEB.ENTIDADE
                                AND PAR.EXERCICIO        = DEB.EXERCICIO
                                AND PAR.TIPOCADASTRO     = DEB.TIPOCADASTRO
                                AND PAR.CADASTROGERAL    = DEB.CADASTROGERAL
                                AND PAR.GUIARECOLHIMENTO = DEB.GUIARECOLHIMENTO
                                AND PAR.SUBDIVIDA        = DEB.SUBDIVIDA
INNER JOIN TRIBSITUACAOPARCELA SIT ON SIT.SITUACAOPARCELA = PAR.SITUACAODEBITO
INNER JOIN TRIBTIPOSITUACAOPARCELA TIP ON TIP.TIPOSITUACAOPARCELA = SIT.SITUACAOPARCELA
WHERE PES.CNPJ_CPF = ?
  AND DEB.CONSTITUIDO = 'S'
  AND TIP.TIPO = 'A'
  AND GER.EXCLUSAOLOGICA = 'N'
