select
    cr.TRIBCADASTROGERAL_IDKEY as "id",
       cr.tipoCadastro as "tipoCadastro",
    cr.CADASTROGERAL as "cadastro",
    cr.nome as "nome",
    cr.endereco as "enderecoDescrito",
    cr.NUMEROIMOVELRECEITA as "numeroReceita",
    cr.CODIGOINCRA as "numeroIncra",
    cr.QTDEALQUEIRES as "alqueires",
    cr.QTDEHECTARES as "hectares",
    cr.areatotal as "areaTotal",
    tl.DESCRICAO as "tipoLogradouro",
    l.descricao as "logradouro",
    b.descricao as "bairro",
    cg.COMPLEMENTO as "complemento",
    cr.lote as "lote",
    d.DESCRICAO as "distrito",
    s.APELIDO as "setor",
    case when coalesce(cg.exclusaologica, 'N') = 'S' then 'true' else 'false' end as "exclusaoLogica"
from TRIBCADASTRORURAL cr
     inner join tribcadastrogeral cg on cr.TRIBCADASTROGERAL_IDKEY = cg.IDKEY
     left outer join logradouro l
                     on cg.logradouro = l.logradouro and
                        cg.cidade = l.cidade
     left outer join TIPOLOGRADOURO tl on l.TIPOLOGRADOURO = tl.TIPOLOGRADOURO
     left outer join bairro b
                     on cg.cidade = b.cidade and
                        cg.bairro = b.bairro
     left outer join TRIBDISTRITO d on cr.DISTRITO = d.DISTRITO
     left outer join tribsetor  s on  cr.TRIBSETOR_IDKEY = s.IDKEY
where cg.tipocadastro = 3
