select cg.idkey as "id",
       cg.tipocadastro as "tipoCadastro",
       cg.cadastrogeral as "cadastro",
       ci.inscricaocadastral as "inscricaoCadastral",
       ci.setor_inscricaocadastral as "zona",
       ci.quadra_inscricaocadastral as "quadra",
       ci.lote_inscricaocadastral as "lote",
       ci.unidade_inscricaocadastral as "unidade",
       ci.arealote as "areaTerreno",
       ci.areatotalconstruida as "areaConstruida",
       ci.complementolote as "complementoLote",
       cg.cep as "cep",
       l.logradouro as "codigoLogradouro",
       l.descricao as "endereco",
       c.cidade as "codigoCidade",
       c.descricao as "cidade",
       cg.numero as "numero",
       c.unidadefederacao as "estado",
       cg.complemento as "complemento",
       b.bairro as "codigoBairro",
       b.descricao as "bairro",
       lot.descricao as "loteamento",
       ci.latitude as "latitude",
       ci.longitude as "longitude",
       ci.grausul as "grauSul" ,
       ci.minutosul as "minutoSul",
       ci.segundosul as "segundoSul",
       ci.grauoeste as "grauOeste",
       ci.minutooeste as "minutoOeste",
       ci.segundooeste as "segundoOeste",
       case when coalesce(cg.exclusaologica, 'N') = 'S' then 'true' else 'false' end "exclusaoLogica",
       p.nome as "proprietario",
       tc.condominio as "condominio",
       tc.descricao as "descricaoCondominio"
  from tribcadastrogeral cg
inner join tribcadastroimobiliario ci
  on cg.tipocadastro = ci.tipocadastro and
     cg.cadastrogeral = ci.cadastrogeral
left outer join cidade c
  on cg.cidade = c.cidade
left outer join logradouro l
  on cg.logradouro = l.logradouro and
     cg.cidade = l.cidade
left outer join bairro b
  on cg.cidade = b.cidade and
     cg.bairro = b.bairro
left outer join tribloteamento lot
  on lot.distrito = ci.distrito_inscricaocadastral and
     lot.setor = ci.setor_inscricaocadastral and
     lot.loteamento = ci.loteamento
left outer join tribproprietario prop
  on cg.tipocadastro = prop.tipocadastro and
     cg.cadastrogeral = prop.cadastrogeral and
     prop.principal = 'S'
left outer join pessoa p
  on prop.pessoa = p.pessoa
left outer join tribcondominio tc on ci.tribcondominio_idkey = tc.idkey
where cg.tipocadastro = 1
