select integracaopixpagolog.dataintegracao as datahoraprocessamentowebhook,
trunc(integracaopixpagolog.datareferencia) as datapagamentodopix,
tribpagamento.datalancamento as datapagamento,
tribconvenio.convenio,
tribconvenio.descricao as descricaoconvenio,
tribbloqueto.entidade,
tribbloqueto.idkey as idbloqueto,
tribbloqueto.exerciciobloqueto,
tribbloqueto.bloqueto,
tribbloqueto.datavencimento,
tribbloqueto.dataemissao,
tribbloqueto.tipocadastro,
tribbloqueto.cadastrogeral,
tribbloqueto.pessoa,
tribbloqueto.nossonumero,
case when coalesce(tribbloqueto.pago, 'N') = 'S' then 1 else 0 end as pago,
pessoa.nome as nomepessoa,
sum(tribbloquetodebito.valorprincipal + tribbloquetodebito.valorjuros + tribbloquetodebito.valormulta + tribbloquetodebito.valorcorrecao - tribbloquetodebito.valordesconto) as valorbloqueto
from integracaopixpagolog integracaopixpagolog
join integracaopixpagodetalhe integracaopixpagodetalhe
on integracaopixpagodetalhe.log_id = integracaopixpagolog.id
join tribconvenio tribconvenio
on tribconvenio.id = integracaopixpagolog.convenio
join tribbloqueto tribbloqueto
on tribbloqueto.entidade = integracaopixpagodetalhe.entidade
and tribbloqueto.exerciciobloqueto = integracaopixpagodetalhe.exercicioboleto
and tribbloqueto.bloqueto = integracaopixpagodetalhe.boleto
join tribbloquetodebito tribbloquetodebito
on tribbloquetodebito.entidade = tribbloqueto.entidade
and tribbloquetodebito.exerciciobloqueto = tribbloqueto.exerciciobloqueto
and tribbloquetodebito.bloqueto = tribbloqueto.bloqueto
join tribdebitoparcelareceita tribdebitoparcelareceita
on tribdebitoparcelareceita.iddebitoparcelareceita = tribbloquetodebito.iddebitoparcelareceita
join pessoa pessoa
on pessoa.pessoa = tribbloqueto.pessoa
left join tribpagamentobloqueto tribpagamentobloqueto
on tribpagamentobloqueto.entidade = tribbloquetodebito.entidade
and tribpagamentobloqueto.exerciciobloqueto = tribbloquetodebito.exerciciobloqueto
and tribpagamentobloqueto.bloqueto = tribbloquetodebito.bloqueto
left join tribpagamento tribpagamento
on tribpagamento.entidade = tribpagamentobloqueto.entidade
and tribpagamento.exerciciopagamento = tribpagamentobloqueto.exerciciopagamento
and tribpagamento.pagamento = tribpagamentobloqueto.pagamento
where integracaopixpagodetalhe.mensagemerro is null
and integracaopixpagolog.erro is null
%s
group by integracaopixpagolog.dataintegracao,
integracaopixpagolog.datareferencia,
tribpagamento.datalancamento,
tribconvenio.convenio,
tribconvenio.descricao,
tribbloqueto.entidade,
tribbloqueto.idkey,
tribbloqueto.exerciciobloqueto,
tribbloqueto.bloqueto,
tribbloqueto.datavencimento,
tribbloqueto.dataemissao,
tribbloqueto.tipocadastro,
tribbloqueto.cadastrogeral,
tribbloqueto.pessoa,
tribbloqueto.nossonumero,
tribbloqueto.pago,
pessoa.nome