WITH socio AS (
  SELECT
    distinct tcg.tipocadastro,
    tcg.cadastrogeral
  FROM tribproprietario tcsp
  LEFT JOIN tribcadastrogeral tcg
    ON tcsp.tipocadastro = tcg.tipocadastro
   AND tcsp.cadastrogeral = tcg.cadastrogeral
  WHERE tcg.tipocadastro = 2
%s
),
socios_agg AS (
  WITH base AS (
    SELECT
      s.tipocadastro,
      s.cadastrogeral,
      p.nome,
      tv.vinculo,
      tcsp.principal,
      tv.descricao                  AS descvinculo,
      tcsp.percentual               AS percentual,
      tlog.sigla,
      log.descricao                 AS logradouro,
      pe.numero,
      br.descricao                  AS bairro,
      cid.descricao                 AS cidade,
      cid.unidadefederacao          AS uf,
      p.cnpj_cpf,
      p.rg,
      p.orgaoemissor,
      cp.telefoneresidencial,
      cp.telefonecomercial,
      cp.telefonecelular,
      cp.email,
      p.tipopessoa,
      pe.complemento                AS complementoendereco,
      pe.cep,
      p.pessoa
    FROM socio s
    JOIN tribproprietario tcsp
      ON tcsp.tipocadastro  = s.tipocadastro
     AND tcsp.cadastrogeral = s.cadastrogeral
    LEFT JOIN pessoa p
      ON p.pessoa = tcsp.pessoa
    LEFT JOIN enderecopessoa pe
      ON pe.pessoa    = p.pessoa
     AND pe.sequencia = 1
    LEFT JOIN logradouro log
      ON log.logradouro = pe.logradouro
     AND log.cidade     = pe.cidade
    LEFT JOIN tipologradouro tlog
      ON tlog.tipologradouro = log.tipologradouro
    LEFT JOIN cidade cid
      ON cid.cidade = pe.cidade
    LEFT JOIN bairro br
      ON br.cidade = pe.cidade
     AND br.bairro = pe.bairro
    LEFT JOIN tribvinculo tv
      ON tv.vinculo = tcsp.vinculo
    LEFT JOIN contatopessoa cp
      ON cp.pessoa    = pe.pessoa
     AND cp.sequencia = pe.sequencia
  ),
  dup AS (
    SELECT DISTINCT
      tipocadastro,
      cadastrogeral,
      nome,
      vinculo,
      principal,
      descvinculo,
      percentual,
      sigla,
      logradouro,
      numero,
      bairro,
      cidade,
      uf,
      cnpj_cpf,
      rg,
      orgaoemissor,
      telefoneresidencial,
      telefonecomercial,
      telefonecelular,
      email,
      tipopessoa,
      complementoendereco,
      cep,
      pessoa
    FROM base
  )
  SELECT
    tipocadastro,
    cadastrogeral,
    ARRAY_AGG(
      ROW(
        tipocadastro,     
        cadastrogeral,    
        nome,             
        vinculo,          
        principal,        
        descvinculo,      
        percentual,       
        sigla,            
        logradouro,       
        numero,           
        bairro,           
        cidade,           
        uf,               
        cnpj_cpf,         
        rg,               
        orgaoemissor,     
        telefoneresidencial,
        telefonecomercial,  
        telefonecelular,    
        email,              
        tipopessoa,         
        complementoendereco,
        cep,                
        pessoa              
      )
      ORDER BY
          tipocadastro, cadastrogeral, nome
    ) AS socios
  FROM dup
  GROUP BY tipocadastro, cadastrogeral
)
SELECT
  s.tipocadastro,
  s.cadastrogeral,
  sa.socios
FROM socio s
LEFT JOIN socios_agg sa
  ON (sa.tipocadastro, sa.cadastrogeral) = (s.tipocadastro, s.cadastrogeral)
ORDER BY s.tipocadastro, s.cadastrogeral
%s