WITH
projeto AS (
  SELECT
    P.entidade,
    P.exercicio              AS exercicioprojeto,
    P.projeto,
    P.tipocadastro,
    P.cadastrogeral,
    P.tipoprojeto,
    P.data,
    P.situacao,
    P.aprovado,
    P.exercicioprotocolo,
    P.idprocesso,
    P.projetosubstituido,
    P.exercicioprojetosubstituido,
    P.idprocessoisencao,
    P.exercicioprotocoloisencao,
    P.isencao,
    PESRP.tipopessoa         AS tipopessoaconstrutor,
    PESRP.pessoa             AS construtor,
    PESRP.nome               AS nomeconstrutor,
    PESRP.cnpj_cpf           AS cnpjcpf,
    TLOG.sigla,
    LOGRP.descricao          AS descrlogradouro,
    ENDRP.numero,
    ENDRP.complemento,
    BAIRP.descricao          AS bairrodescr,
    ENDRP.cep,
    CID.descricao            AS cidade,
    ENDRP.unidadefederacao,
    CONT.telefoneresidencial
  FROM tribprojeto P
  LEFT JOIN tribprojetoresponsavel TPR
         ON P.entidade = TPR.entidade
        AND P.exercicio = TPR.exercicio
        AND P.projeto   = TPR.projeto
        AND TPR.sequencia = 1
  LEFT JOIN pessoa PESRP
         ON TPR.pessoa = PESRP.pessoa
  LEFT JOIN enderecopessoa ENDRP
         ON PESRP.pessoa = ENDRP.pessoa
        AND PESRP.sequenciaendereco = ENDRP.sequencia
  LEFT JOIN cidade CID
         ON CID.cidade = ENDRP.cidade
  LEFT JOIN logradouro LOGRP
         ON ENDRP.logradouro = LOGRP.logradouro
        AND ENDRP.cidade     = LOGRP.cidade
  LEFT JOIN tipologradouro TLOG
         ON LOGRP.tipologradouro = TLOG.tipologradouro
  LEFT JOIN bairro BAIRP
         ON ENDRP.bairro = BAIRP.bairro
        AND ENDRP.cidade = BAIRP.cidade
  LEFT JOIN contatopessoa CONT
         ON CONT.pessoa = PESRP.pessoa
        AND CONT.sequencia = 1
  LEFT JOIN tribdocumento DOC
         ON DOC.entidade = P.entidade
        AND DOC.exercicioprojeto = P.exercicio
        AND DOC.tipodocumento IN (11,14,15)
        AND DOC.projeto = P.projeto
:filtro
),
itens_agg AS (
  WITH base AS (
    SELECT DISTINCT
      P.entidade,
      P.exercicio            AS exercicioprojeto,
      P.projeto,
      P.tipocadastro,
      P.cadastrogeral,
      P.tipoprojeto,
      P.data,
      PI.projetoitem,
      PI.itemconstrucaocivil,
      PI.utilizacao,
      PI.tipoconstrucao,
      (PI.area)              AS area
    FROM tribprojeto P
    LEFT JOIN tribdocumento DOC
           ON DOC.entidade = P.entidade
          AND DOC.exercicioprojeto = P.exercicio
          AND DOC.tipodocumento IN (11,14,15)
          AND DOC.projeto = P.projeto
    LEFT JOIN tribprojetoitem PI
           ON PI.entidade = P.entidade
          AND PI.exercicio = P.exercicio
          AND PI.projeto   = P.projeto
  :filtro
  )
  SELECT
    entidade,
    exercicioprojeto,
    projeto,
    ARRAY_AGG(
      ROW(
        entidade,
        exercicioprojeto,
        projeto,
        tipocadastro,
        cadastrogeral,
        tipoprojeto,
        data,
        projetoitem,
        itemconstrucaocivil,
        utilizacao,
        tipoconstrucao,
        area
      )
      ORDER BY projetoitem
    ) AS itens
  FROM base
  GROUP BY entidade, exercicioprojeto, projeto
),
debitos_agg AS (
  WITH base AS (
    SELECT DISTINCT
      PD.entidade,
      PD.exercicioprojeto,
      PD.projeto,
      DP.exercicio,
      DP.guiarecolhimento,
      DP.subdivida,
      DP.parcela,
      DP.datavencimento,
      (
        SELECT SUM(valor)
        FROM tribdebitoparcelareceita TDPR
        WHERE DP.entidade = TDPR.entidade
          AND DP.exercicio = TDPR.exercicio
          AND DP.tipocadastro = TDPR.tipocadastro
          AND DP.cadastrogeral = TDPR.cadastrogeral
          AND DP.guiarecolhimento = TDPR.guiarecolhimento
          AND DP.subdivida = TDPR.subdivida
          AND DP.parcela = TDPR.parcela
      ) AS valor,
      SP.sigla,
      DP.situacaodebito,
      D.parcelado,
      D.reparcelado,
      DP.mesreferencia,
      TSP.tipo
    FROM tribprojetodebito PD
    LEFT JOIN tribdocumento DOC
           ON DOC.entidade = PD.entidade
          AND DOC.exercicioprojeto = PD.exercicioprojeto
          AND DOC.tipodocumento IN (11,14,15)
          AND DOC.projeto = PD.projeto
    LEFT JOIN tribprojeto P
           ON DOC.entidade = P.entidade
          AND DOC.exercicioprojeto = P.exercicio
          AND DOC.tipodocumento IN (11,14,15)
          AND DOC.projeto = P.projeto
    INNER JOIN tribdebito D
            ON D.entidade = PD.entidade
           AND D.exercicio = PD.exerciciodebito
           AND D.tipocadastro = PD.tipocadastro
           AND D.cadastrogeral = PD.cadastrogeral
           AND D.guiarecolhimento = PD.guiarecolhimento
           AND D.subdivida = PD.subdivida
    INNER JOIN tribdebitoparcela DP
            ON DP.entidade = PD.entidade
           AND DP.exercicio = PD.exerciciodebito
           AND DP.tipocadastro = PD.tipocadastro
           AND DP.cadastrogeral = PD.cadastrogeral
           AND DP.guiarecolhimento = PD.guiarecolhimento
           AND DP.subdivida = PD.subdivida
    INNER JOIN tribsituacaoparcela SP
            ON DP.situacaodebito = SP.situacaoparcela
    INNER JOIN tribtiposituacaoparcela TSP
            ON TSP.tiposituacaoparcela = SP.tiposituacaoparcela
  :filtro
  )
  SELECT
    entidade,
    exercicioprojeto,
    projeto,
    ARRAY_AGG(
      ROW(
        entidade,
        exercicioprojeto,
        projeto,
        exercicio,
        guiarecolhimento,
        subdivida,
        parcela,
        datavencimento,
        valor,
        sigla,
        situacaodebito,
        parcelado,
        reparcelado,
        mesreferencia,
        tipo
      )
      ORDER BY exercicio DESC, guiarecolhimento, subdivida, parcela
    ) AS debitos
  FROM base
  GROUP BY entidade, exercicioprojeto, projeto
),
documentos_agg AS (
  WITH base AS (
    SELECT DISTINCT
      DOC.entidade,
      DOC.tipodocumento,
      DOC.documento,
      DOC.exercicio          AS exercicio_documento,
      DOC.dataemissao        AS dataemissao_doc,
      DOC.exercicioprojeto   AS exercicioprojeto,
      DOC.projeto,
      DOC.cancelado
    FROM tribdocumento DOC
    LEFT JOIN tribprojeto P
           ON DOC.entidade = P.entidade
          AND DOC.exercicioprojeto = P.exercicio
          AND DOC.tipodocumento IN (11,14,15)
          AND DOC.projeto = P.projeto
  :filtro
  )
  SELECT
    exercicioprojeto,
    entidade,
    projeto,
    ARRAY_AGG(
      ROW(
        entidade,
        tipodocumento,
        documento,
        exercicio_documento,
        dataemissao_doc,
        exercicioprojeto,
        projeto,
        cancelado
      )
      ORDER BY exercicio_documento, documento
    ) AS documentos
  FROM base
  GROUP BY exercicioprojeto, entidade, projeto
)
SELECT
  projeto.entidade,
  projeto.exercicioprojeto,
  projeto.projeto,
  projeto.tipocadastro,
  projeto.cadastrogeral,
  projeto.tipoprojeto,
  projeto.data,
  projeto.situacao,
  projeto.aprovado,
  projeto.exercicioprotocolo,
  projeto.idprocesso,
  projeto.projetosubstituido,
  projeto.exercicioprojetosubstituido,
  projeto.idprocessoisencao,
  projeto.exercicioprotocoloisencao,
  projeto.isencao,
  projeto.tipopessoaconstrutor,
  projeto.construtor,
  projeto.nomeconstrutor,
  projeto.cnpjcpf,
  projeto.sigla,
  projeto.descrlogradouro,
  projeto.numero,
  projeto.complemento,
  projeto.bairrodescr,
  projeto.cep,
  projeto.cidade,
  projeto.unidadefederacao,
  projeto.telefoneresidencial,
  ia.itens,
  da.debitos,
  doa.documentos
FROM projeto
LEFT JOIN itens_agg      ia ON (ia.entidade, ia.exercicioprojeto, ia.projeto)
                           = (projeto.entidade, projeto.exercicioprojeto, projeto.projeto)
LEFT JOIN debitos_agg    da ON (da.entidade, da.exercicioprojeto, da.projeto)
                           = (projeto.entidade, projeto.exercicioprojeto, projeto.projeto)
LEFT JOIN documentos_agg doa ON (doa.entidade, doa.exercicioprojeto, doa.projeto)
                           = (projeto.entidade, projeto.exercicioprojeto, projeto.projeto)
ORDER BY projeto.entidade, projeto.exercicioprojeto, projeto.projeto
:pageable