WITH
pes AS (
  SELECT
    p.pessoa,
    p.nome,
    p.nomefantasia,
    p.tipopessoa,
    p.cnpj_cpf,
    p.rg,
    p.orgaoemissor,
    p.estadoemissor,
    p.dataemissao,
    p.inscricaoestadual,
    p.dataalteracao,
    p.datainclusao,
    p.observacao,
    p.usuarioinclusao,
    p.inativo,
    p.sequenciaendereco,
    p.sequenciacontato
  FROM pessoa p
  %s
),
enderecos_agg AS (
  WITH base AS (
    SELECT
      pes.pessoa,
      ep.sequencia,
      CASE
        WHEN ep.tipoendereco = '1' THEN 'Residencial'
        WHEN ep.tipoendereco = '2' THEN 'Comercial'
        WHEN ep.tipoendereco = '3' THEN 'Correspondência'
        ELSE 'Nenhum'
      END                                 AS tipoendereco,
      ep.logradouro,
      l.descricao                         AS logradouro_descr,
      b.bairro,
      b.descricao                         AS bairro_descr,
      c.cidade,
      c.descricao                         AS cidade_descr,
      ep.numero,
      ep.complemento,
      ep.cep,
      ep.unidadefederacao,
      l.tipologradouro,
      tl.sigla                            AS tipologradouro_descr,
      CASE WHEN pes.sequenciaendereco = ep.sequencia THEN 'S' ELSE 'N' END AS principal,
      c.codigoibge
    FROM pes
    JOIN enderecopessoa ep ON ep.pessoa = pes.pessoa
    LEFT JOIN logradouro l
      ON l.cidade = ep.cidade AND l.logradouro = ep.logradouro
    LEFT JOIN bairro b
      ON b.cidade = ep.cidade AND b.bairro = ep.bairro
    LEFT JOIN cidade c
      ON c.cidade = ep.cidade
    LEFT JOIN tipologradouro tl
      ON tl.tipologradouro = l.tipologradouro
  ),
  dup AS (
    SELECT DISTINCT
      pessoa, sequencia, tipoendereco, logradouro, logradouro_descr,
      bairro, bairro_descr, cidade, cidade_descr, numero, complemento,
      cep, unidadefederacao, tipologradouro, tipologradouro_descr,
      principal, codigoibge
    FROM base
  )
  SELECT
    pessoa,
    ARRAY_AGG(
      ROW(
        pessoa,
        sequencia,
        tipoendereco,
        logradouro,
        logradouro_descr,
        bairro,
        bairro_descr,
        cidade,
        cidade_descr,
        numero,
        complemento,
        cep,
        unidadefederacao,
        tipologradouro,
        tipologradouro_descr,
        principal,
        codigoibge
      )
      ORDER BY sequencia
    ) AS enderecopessoa
  FROM dup
  GROUP BY pessoa
),
contatos_agg AS (
  WITH base AS (
    SELECT
      pes.pessoa,
      cp.sequencia,
      cp.nome,
      cp.telefoneresidencial,
      cp.telefonecomercial,
      cp.telefonefax,
      cp.telefonecelular,
      cp.email,
      cp.homepage,
      cp.representantelegal,
      CASE WHEN pes.sequenciacontato = cp.sequencia THEN 'S' ELSE 'N' END AS principal
    FROM pes
    JOIN contatopessoa cp ON cp.pessoa = pes.pessoa
  ),
  dup AS (
    SELECT DISTINCT
      pessoa, sequencia, nome, telefoneresidencial, telefonecomercial,
      telefonefax, telefonecelular, email, homepage, representantelegal, principal
    FROM base
  )
  SELECT
    pessoa,
    ARRAY_AGG(
      ROW(
        pessoa,
        sequencia,
        nome,
        telefoneresidencial,
        telefonecomercial,
        telefonefax,
        telefonecelular,
        email,
        homepage,
        representantelegal,
        principal
      )
      ORDER BY sequencia
    ) AS contatopessoa
  FROM dup
  GROUP BY pessoa
)
SELECT
  pes.pessoa,
  pes.nome,
  pes.nomefantasia,
  pes.tipopessoa,
  pes.cnpj_cpf,
  pes.rg,
  pes.orgaoemissor,
  pes.estadoemissor,
  pes.dataemissao,
  pes.inscricaoestadual,
  pes.dataalteracao,
  pes.datainclusao,
  pes.observacao,
  pes.usuarioinclusao,
  pes.inativo,
  pes.sequenciaendereco,
  pes.sequenciacontato,
  ea.enderecopessoa,
  ca.contatopessoa
FROM pes
LEFT JOIN enderecos_agg ea ON ea.pessoa = pes.pessoa
LEFT JOIN contatos_agg ca  ON ca.pessoa = pes.pessoa
ORDER BY pes.pessoa
%s
