WITH
cadastro AS (
  SELECT tcg.tipocadastro, tcg.cadastrogeral
  FROM tribcadastrogeral tcg
  WHERE tcg.tipocadastro = 2
%s
),
mobiliario AS (
  SELECT
       TCM.DATAALVARA,
       TCM.SUPERSIMPLES,
       CASE
         WHEN TCM.SUBSTITUICAOTRIBUTARIA = 'N' OR TCM.SUBSTITUICAOTRIBUTARIA IS NULL THEN 'N'
         ELSE 'S'
       END AS SUBSTITUICAOTRIBUTARIA,
       CASE WHEN TCM.DISPENSANOTAFISCAL = 'S' THEN 'S' ELSE 'N' END AS DISPENSANOTAFISCAL,
       CASE WHEN TCG.EXCLUSAOLOGICA = 'S' THEN 'E' ELSE 'I' END AS TIPOOPERACAO,
       TCM.IDNOTIFICACAOFISCALIZACAO,
       TCM.TipoCadastro,
       TCM.CadastroGeral,
       TCM.PESSOAMOBILIARIO,
       P.cnpj_Cpf AS cnpjCpf,
       P.NOME,
       CASE WHEN TS.BASECALCULO = 'E' THEN 'S' ELSE 'N' END AS ESTIMADO,
       (
         SELECT CASE WHEN COUNT(*) > 0 THEN 'S' ELSE 'N' END
         FROM TRIBMOBILIARIOATIVIDADE AT
         WHERE AT.TIPOCADASTRO = TCM.TIPOCADASTRO
           AND AT.CADASTROGERAL = TCM.CADASTROGERAL
           AND AT.ATIVIDADEPRINCIPAL = 'S'
           AND AT.ATIVIDADE = 9999
       ) AS MUNICIPIO,
       TVBM2.DESCRICAORESPOSTA AS ARBIT,
       TVBM3.DESCRICAORESPOSTA AS ARBIT2,
       TVBM4.DESCRICAORESPOSTA AS ARBIT3,
       TLOG.SIGLA AS TIPOLOGRADOURO,
       L.DESCRICAO AS LOGRADOURO,
       TCG.NUMERO,
       TCG.COMPLEMENTO AS COMPLEMENTOCADGERAL,
       BAI.DESCRICAO AS BAIRRO,
       C.DESCRICAO AS CIDADE,
       C.UNIDADEFEDERACAO AS UF,
       TCG.CEP,
       P.PESSOA AS CODIGOCGCM,
       TCI.CADASTROGERAL AS INSCRICAOCADASTRAL,
       TCI.SETOR_DESCR AS ZONAINSC,
       TCI.QUADRA_DESCR AS QUADRAINSC,
       TCI.LOTE_DESCR AS DATAINSC,
       TVBM.MODELORESPOSTA AS TAXALOCALIZACAO,
       TCM.AREAUTILIZADA,
       TVBMBOMB.DESCRICAORESPOSTA AS CODIGOBOMBEIRO,
       TCM.AREABOMBEIRO,
       TVBMAPTOS.DESCRICAORESPOSTA AS QTDAPTOS,
       (CAST(COALESCE(TVBMQLFICA_SUP.DESCRICAORESPOSTA, '0') AS NUMERIC)
        + CAST(COALESCE(TVBMQLFICA_TEC.DESCRICAORESPOSTA, '0') AS NUMERIC)) AS NUMEMPREGADOS,
       TVBMQLFICA_SUP.DESCRICAORESPOSTA AS QUALISUPER,
       TVBMQLFICA_TEC.DESCRICAORESPOSTA AS QUALITEC,
       TVBMCOM_AMB.MODELORESPOSTA AS COMAMB,
       TVBMQTD_COM_AMB.DESCRICAORESPOSTA AS QTDCOMAMB,
       TVBMOCUP_SOLO.MODELORESPOSTA AS OCUPSOLO,
       TVBMQTD_OCUP_SOLO.DESCRICAORESPOSTA AS QTDOCUPSOLO,
       TVBMNUM_SOCIOS.DESCRICAORESPOSTA AS NUMSOCIOS,
       TMSSIT.SITUACAOMOBILIARIO AS SITUACAOESTABELECIMENTO,
       TCM.NUMEROALVARA,
       TCM.DATAVALIDADEALVARA,
       TCM.DATAABERTURA,
       TCM.DATAENCERRAMENTO,
       PTC.PROCESSO AS PROTOCOLOABERTURA,
       trunc(PTC.DATAPROCESSO) AS DATAPROTOCOLOABERTURA,
       TCM.DATAAUDITORIAINICIO,
       TCM.DATAAUDITORIAFIM,
       TCM.DATAHOMOLOGACAO,
       TNF.FISCAL AS CODIGOFISCAL,
       TF.NOME AS NOMEFISCAL,
       TNF.NOTIFICACAO,
       TNF.EXERCICIO AS ANONOTIFICACAO,
       (
         SELECT MIN(TAIF.IDAUTOINFRACAOFISCAL)
         FROM TRIBAUTOINFRACAOFISCAL TAIF
         WHERE TAIF.IDNOTIFICACAOFISCALIZACAO = TNF.IDNOTIFICACAOFISCALIZACAO
       ) AS IDAUTOINFRACAOFISCAL,
       CASE WHEN TCM.DISPENSANOTAFISCAL = 'S' THEN 'N' ELSE 'S' END AS EMITENOTAFISCAL,
       TCM.CMCRESPONSAVEL,
       CP.EMAIL,
       TCM.TELEFONE,
       TCG.DATAALTERACAO,
       COALESCE((
         SELECT MIN(a.Atividade)
         FROM TribMobiliarioAtividade a
         WHERE a.TipoCadastro = TCM.Tipocadastro
           AND a.cadastrogeral = TCM.CadastroGeral
           AND a.atividadeprincipal = 'S'
       ), 0) AS Atividade1,
       COALESCE((
         SELECT MIN(a.Atividade)
         FROM TribMobiliarioAtividade a
         WHERE a.TipoCadastro = TCM.Tipocadastro
           AND a.cadastrogeral = TCM.CadastroGeral
           AND a.atividadeprincipal <> 'S'
           AND a.Atividade IN (
             SELECT b.Atividade
             FROM TribMobiliarioAtividade b
             WHERE b.TipoCadastro = TCM.Tipocadastro
               AND b.cadastrogeral = TCM.CadastroGeral
               AND b.atividadeprincipal <> 'S'
             LIMIT 1
           )
         LIMIT 1
       ), 0) AS Atividade2,
       COALESCE((
         SELECT MIN(a.Atividade)
         FROM TribMobiliarioAtividade a
         WHERE a.TipoCadastro = TCM.Tipocadastro
           AND a.cadastrogeral = TCM.CadastroGeral
           AND a.atividadeprincipal <> 'S'
           AND a.Atividade NOT IN (
             SELECT b.Atividade
             FROM TribMobiliarioAtividade b
             WHERE b.TipoCadastro = TCM.Tipocadastro
               AND b.cadastrogeral = TCM.CadastroGeral
               AND b.atividadeprincipal <> 'S'
             LIMIT 1
           )
         LIMIT 1
       ), 0) AS Atividade3,
       COALESCE((
         SELECT MIN(a.Atividade)
         FROM TribMobiliarioAtividade a
         WHERE a.TipoCadastro = TCM.Tipocadastro
           AND a.cadastrogeral = TCM.CadastroGeral
           AND a.atividadeprincipal <> 'S'
           AND a.Atividade NOT IN (
             SELECT b.Atividade
             FROM TribMobiliarioAtividade b
             WHERE b.TipoCadastro = TCM.Tipocadastro
               AND b.cadastrogeral = TCM.CadastroGeral
               AND b.atividadeprincipal <> 'S'
             LIMIT 2
           )
       ), 0) AS Atividade4,
       COALESCE((
         SELECT MIN(a.Servico)
         FROM TribMobiliarioServico a
         WHERE a.tipocadastro = TCM.tipocadastro
           AND a.cadastrogeral = TCM.CadastroGeral
           AND a.entidade = :entidade
           AND a.exercicio = :exercicio
           AND a.Principal = 'S'
       ), 0) AS CodigoISS1,
       COALESCE((
         SELECT a.Servico
         FROM TribMobiliarioServico a
         WHERE a.tipocadastro = TCM.tipocadastro
           AND a.cadastrogeral = TCM.CadastroGeral
           AND a.entidade = :entidade
           AND a.exercicio = :exercicio
           AND a.Principal <> 'S'
           AND a.Servico IN (
             SELECT b.Servico
             FROM TribMobiliarioServico b
             WHERE b.tipocadastro = TCM.tipocadastro
               AND b.cadastrogeral = TCM.CadastroGeral
               AND b.entidade = a.entidade
               AND b.exercicio = a.exercicio
               AND b.Principal <> 'S'
             LIMIT 1
           )
         LIMIT 1
       ), 0) AS CodigoISS2,
       COALESCE((
         SELECT MAX(a.Servico)
         FROM TribMobiliarioServico a
         WHERE a.tipocadastro = TCM.tipocadastro
           AND a.cadastrogeral = TCM.CadastroGeral
           AND a.entidade = :entidade
           AND a.exercicio = :exercicio
           AND a.Principal <> 'S'
           AND a.Servico NOT IN (
             SELECT b.Servico
             FROM TribMobiliarioServico b
             WHERE b.tipocadastro = TCM.tipocadastro
               AND b.cadastrogeral = TCM.CadastroGeral
               AND b.entidade = a.entidade
               AND b.exercicio = a.exercicio
               AND b.Principal <> 'S'
             LIMIT 1
           )
       ), 0) AS CodigoISS3,
       TCG.EXCLUSAOLOGICA,
       replace(replace(TCM.ATIVIDADEPRINCIPAL, chr(13), ''), chr(10), '') AS ATIVIDADEPRINCIPAL,
       replace(replace(TCM.OBSERVACAOALVARA, chr(13), ''), chr(10), '') AS OBSERVACAOALVARA,
       TCM.tipocadastroimobiliario,
       TCM.cadastrogeralimobiliario,
       TCM.ramoatividade
  FROM cadastro k
  JOIN TRIBCADASTROMOBILIARIO TCM
    ON TCM.TIPOCADASTRO = k.tipocadastro
   AND TCM.CADASTROGERAL = k.cadastrogeral
  LEFT OUTER JOIN TRIBCADASTROGERAL TCG
    ON TCG.TIPOCADASTRO = TCM.TIPOCADASTRO
   AND TCG.CADASTROGERAL = TCM.CADASTROGERAL
  LEFT OUTER JOIN PESSOA P
    ON P.PESSOA = TCG.PESSOA
  LEFT OUTER JOIN LOGRADOURO L
    ON L.CIDADE = TCG.CIDADE
   AND L.LOGRADOURO = TCG.LOGRADOURO
  LEFT OUTER JOIN TIPOLOGRADOURO TLOG
    ON TLOG.TIPOLOGRADOURO = L.TIPOLOGRADOURO
  LEFT OUTER JOIN CIDADE C
    ON C.CIDADE = TCG.CIDADE
  LEFT OUTER JOIN CONTATOPESSOA CP
    ON CP.PESSOA = P.PESSOA
   AND CP.SEQUENCIA = P.SEQUENCIACONTATO
  LEFT OUTER JOIN TRIBMOBILIARIOSERVICO TMS
    ON TMS.TIPOCADASTRO = TCM.TIPOCADASTRO
   AND TMS.CADASTROGERAL = TCM.CADASTROGERAL
   AND TMS.PRINCIPAL = 'S'
   AND TMS.entidade = :entidade
   AND TMS.exercicio = :exercicio
  LEFT OUTER JOIN TRIBSERVICO TS
    ON TS.ENTIDADE = TMS.ENTIDADE
   AND TS.EXERCICIO = TMS.EXERCICIO
   AND TS.SERVICO = TMS.SERVICO
  LEFT OUTER JOIN TRIBCADASTROIMOBILIARIO TCI
    ON TCI.TIPOCADASTRO = TCM.TIPOCADASTROIMOBILIARIO
   AND TCI.CADASTROGERAL = TCM.CADASTROGERALIMOBILIARIO
  LEFT OUTER JOIN TRIBNOTIFICACAOFISCALIZACAO TNF
    ON TCM.IDNOTIFICACAOFISCALIZACAO = TNF.IDNOTIFICACAOFISCALIZACAO
  LEFT OUTER JOIN TRIBFISCAL TF
    ON TF.TIPOFISCAL = TNF.TIPOFISCAL
   AND TF.FISCAL = TNF.FISCAL
  LEFT OUTER JOIN TRIBLOTEAMENTO TLOTE
    ON TLOTE.DISTRITO = TCI.DISTRITO_INSCRICAOCADASTRAL
   AND TLOTE.SETOR = TCI.SETOR_INSCRICAOCADASTRAL
   AND TLOTE.LOTEAMENTO = TCI.LOTEAMENTO
  LEFT OUTER JOIN BAIRRO BAI
    ON BAI.CIDADE = TCG.CIDADE
   AND BAI.BAIRRO = TCG.BAIRRO
  LEFT JOIN (
      SELECT cad.tipocadastro, cad.cadastrogeral, a.codigo AS modeloresposta
      FROM aise.respostamobiliario r
      LEFT JOIN aise.campo c ON c.id = r.idcampo
      LEFT JOIN aise.alternativa a ON a.id = r.idalternativa
      LEFT JOIN aise.tribcadastrogeral cad ON cad.idkey = r.referencia
      WHERE c.identificador = 'taxadelocalizacao'
  ) TVBM
    ON TVBM.tipocadastro = TCM.tipocadastro
   AND TVBM.cadastrogeral = TCM.cadastrogeral
  LEFT JOIN (
      SELECT cad.tipocadastro, cad.cadastrogeral, r.valor AS descricaoresposta
      FROM aise.respostamobiliario r
      LEFT JOIN aise.campo c ON c.id = r.idcampo
      LEFT JOIN aise.alternativa a ON a.id = r.idalternativa
      LEFT JOIN aise.tribcadastrogeral cad ON cad.idkey = r.referencia
      WHERE c.identificador = 'percentualarbitradoiss1'
  ) TVBM2
    ON TVBM2.tipocadastro = TCM.tipocadastro
   AND TVBM2.cadastrogeral = TCM.cadastrogeral
  LEFT JOIN (
      SELECT cad.tipocadastro, cad.cadastrogeral, r.valor AS descricaoresposta
      FROM aise.respostamobiliario r
      LEFT JOIN aise.campo c ON c.id = r.idcampo
      LEFT JOIN aise.alternativa a ON a.id = r.idalternativa
      LEFT JOIN aise.tribcadastrogeral cad ON cad.idkey = r.referencia
      WHERE c.identificador = 'percentualarbitradoiss2'
  ) TVBM3
    ON TVBM3.tipocadastro = TCM.tipocadastro
   AND TVBM3.cadastrogeral = TCM.cadastrogeral
  LEFT JOIN (
      SELECT cad.tipocadastro, cad.cadastrogeral, r.valor AS descricaoresposta
      FROM aise.respostamobiliario r
      LEFT JOIN aise.campo c ON c.id = r.idcampo
      LEFT JOIN aise.alternativa a ON a.id = r.idalternativa
      LEFT JOIN aise.tribcadastrogeral cad ON cad.idkey = r.referencia
      WHERE c.identificador = 'percentualarbitradoiss3'
  ) TVBM4
    ON TVBM4.tipocadastro = TCM.tipocadastro
   AND TVBM4.cadastrogeral = TCM.cadastrogeral
  LEFT JOIN (
      SELECT cad.tipocadastro, cad.cadastrogeral, r.valor AS descricaoresposta
      FROM aise.respostamobiliario r
      LEFT JOIN aise.campo c ON c.id = r.idcampo
      LEFT JOIN aise.alternativa a ON a.id = r.idalternativa
      LEFT JOIN aise.tribcadastrogeral cad ON cad.idkey = r.referencia
      WHERE c.identificador = 'codigobombeiro'
  ) TVBMBOMB
    ON TVBMBOMB.tipocadastro = TCM.tipocadastro
   AND TVBMBOMB.cadastrogeral = TCM.cadastrogeral
  LEFT JOIN (
      SELECT cad.tipocadastro, cad.cadastrogeral, r.valor AS descricaoresposta
      FROM aise.respostamobiliario r
      LEFT JOIN aise.campo c ON c.id = r.idcampo
      LEFT JOIN aise.alternativa a ON a.id = r.idalternativa
      LEFT JOIN aise.tribcadastrogeral cad ON cad.idkey = r.referencia
      WHERE c.identificador = 'quantidadeapartamento'
  ) TVBMAPTOS
    ON TVBMAPTOS.tipocadastro = TCM.tipocadastro
   AND TVBMAPTOS.cadastrogeral = TCM.cadastrogeral
  LEFT JOIN (
      SELECT cad.tipocadastro, cad.cadastrogeral, r.valor AS descricaoresposta
      FROM aise.respostamobiliario r
      LEFT JOIN aise.campo c ON c.id = r.idcampo
      LEFT JOIN aise.alternativa a ON a.id = r.idalternativa
      LEFT JOIN aise.tribcadastrogeral cad ON cad.idkey = r.referencia
      WHERE c.identificador = 'qualificacaosuperior'
  ) TVBMQLFICA_SUP
    ON TVBMQLFICA_SUP.tipocadastro = TCM.tipocadastro
   AND TVBMQLFICA_SUP.cadastrogeral = TCM.cadastrogeral
  LEFT JOIN (
      SELECT cad.tipocadastro, cad.cadastrogeral, r.valor AS descricaoresposta
      FROM aise.respostamobiliario r
      LEFT JOIN aise.campo c ON c.id = r.idcampo
      LEFT JOIN aise.alternativa a ON a.id = r.idalternativa
      LEFT JOIN aise.tribcadastrogeral cad ON cad.idkey = r.referencia
      WHERE c.identificador = 'qualificacaotecnica'
  ) TVBMQLFICA_TEC
    ON TVBMQLFICA_TEC.tipocadastro = TCM.tipocadastro
   AND TVBMQLFICA_TEC.cadastrogeral = TCM.cadastrogeral
  LEFT JOIN (
      SELECT cad.tipocadastro, cad.cadastrogeral, a.codigo AS modeloresposta
      FROM aise.respostamobiliario r
      LEFT JOIN aise.campo c ON c.id = r.idcampo
      LEFT JOIN aise.alternativa a ON a.id = r.idalternativa
      LEFT JOIN aise.tribcadastrogeral cad ON cad.idkey = r.referencia
      WHERE c.identificador = 'comercioambulante'
  ) TVBMCOM_AMB
    ON TVBMCOM_AMB.tipocadastro = TCM.tipocadastro
   AND TVBMCOM_AMB.cadastrogeral = TCM.cadastrogeral
  LEFT JOIN (
      SELECT cad.tipocadastro, cad.cadastrogeral, r.valor AS descricaoresposta
      FROM aise.respostamobiliario r
      LEFT JOIN aise.campo c ON c.id = r.idcampo
      LEFT JOIN aise.alternativa a ON a.id = r.idalternativa
      LEFT JOIN aise.tribcadastrogeral cad ON cad.idkey = r.referencia
      WHERE c.identificador = 'quantidadecomercioambulante'
  ) TVBMQTD_COM_AMB
    ON TVBMQTD_COM_AMB.tipocadastro = TCM.tipocadastro
   AND TVBMQTD_COM_AMB.cadastrogeral = TCM.cadastrogeral
  LEFT JOIN (
      SELECT cad.tipocadastro, cad.cadastrogeral, a.codigo AS modeloresposta
      FROM aise.respostamobiliario r
      LEFT JOIN aise.campo c ON c.id = r.idcampo
      LEFT JOIN aise.alternativa a ON a.id = r.idalternativa
      LEFT JOIN aise.tribcadastrogeral cad ON cad.idkey = r.referencia
      WHERE c.identificador = 'ocupacaodesolo'
  ) TVBMOCUP_SOLO
    ON TVBMOCUP_SOLO.tipocadastro = TCM.tipocadastro
   AND TVBMOCUP_SOLO.cadastrogeral = TCM.cadastrogeral
  LEFT JOIN (
      SELECT cad.tipocadastro, cad.cadastrogeral, r.valor AS descricaoresposta
      FROM aise.respostamobiliario r
      LEFT JOIN aise.campo c ON c.id = r.idcampo
      LEFT JOIN aise.alternativa a ON a.id = r.idalternativa
      LEFT JOIN aise.tribcadastrogeral cad ON cad.idkey = r.referencia
      WHERE c.identificador = 'quantidadeocupacaosolo'
  ) TVBMQTD_OCUP_SOLO
    ON TVBMQTD_OCUP_SOLO.tipocadastro = TCM.tipocadastro
   AND TVBMQTD_OCUP_SOLO.cadastrogeral = TCM.cadastrogeral
  LEFT JOIN (
      SELECT cad.tipocadastro, cad.cadastrogeral, r.valor AS descricaoresposta
      FROM aise.respostamobiliario r
      LEFT JOIN aise.campo c ON c.id = r.idcampo
      LEFT JOIN aise.alternativa a ON a.id = r.idalternativa
      LEFT JOIN aise.tribcadastrogeral cad ON cad.idkey = r.referencia
      WHERE c.identificador = 'numerodesocios'
  ) TVBMNUM_SOCIOS
    ON TVBMNUM_SOCIOS.tipocadastro = TCM.tipocadastro
   AND TVBMNUM_SOCIOS.cadastrogeral = TCM.cadastrogeral
  LEFT OUTER JOIN TRIBMOBILIARIOSITUACAO TMSSIT
    ON TMSSIT.TIPOCADASTRO = TCM.tipocadastro
   AND TMSSIT.CADASTROGERAL = TCM.CADASTROGERAL
   AND TMSSIT.ATUAL = 'S'
  LEFT OUTER JOIN PTCPROCESSO PTC
    ON PTC.ENTIDADE  = TCM.ENTIDADE
   AND PTC.EXERCICIO = TCM.EXERCPROCESSOABERTURA
   AND PTC.IDPROCESSO = TCM.IDPROCESSOABERTURA
),
atividades_agg AS (
  WITH base AS (
    SELECT
      k.tipocadastro,
      k.cadastrogeral,
      tma.atividade,
      ativ.descricao AS desc_atividade,
      tma.atividadeprincipal
    FROM cadastro k
    JOIN tribmobiliarioatividade tma
      ON tma.tipocadastro = k.tipocadastro
     AND tma.cadastrogeral = k.cadastrogeral
    LEFT JOIN tribatividade ativ
      ON ativ.atividade = tma.atividade
  ),
  dup AS (
    SELECT DISTINCT
      tipocadastro, cadastrogeral, atividade, desc_atividade, atividadeprincipal
    FROM base
  )
  SELECT
    tipocadastro,
    cadastrogeral,
    ARRAY_AGG(
      ROW(
        tipocadastro,
        cadastrogeral,
        atividade,
        desc_atividade,
        atividadeprincipal
      )
      ORDER BY
        CASE WHEN atividadeprincipal = 'S' THEN 0 ELSE 1 END,
        atividade,
        desc_atividade
    ) AS atividades
  FROM dup
  GROUP BY tipocadastro, cadastrogeral
),
cnaes_agg AS (
  WITH base AS (
    SELECT
      k.tipocadastro,
      k.cadastrogeral,
      cnae.codigo,
      cnae.descricao AS desc_cnae,
      tmc.cnaeprincipal,
      cnae.inativo,
      cnae.graurisco
    FROM cadastro k
    JOIN tribmobiliariocnae tmc
      ON tmc.tipocadastro = k.tipocadastro
     AND tmc.cadastrogeral = k.cadastrogeral
    LEFT JOIN cnae cnae
      ON cnae.cnae = tmc.cnae
  ),
  dup AS (
    SELECT DISTINCT
      tipocadastro, cadastrogeral, codigo, desc_cnae, cnaeprincipal, inativo, graurisco
    FROM base
  )
  SELECT
    tipocadastro,
    cadastrogeral,
    ARRAY_AGG(
      ROW(
        tipocadastro,
        cadastrogeral,
        codigo,
        desc_cnae,
        cnaeprincipal,
        inativo,
        graurisco
      )
      ORDER BY
        CASE WHEN cnaeprincipal = 'S' THEN 0 ELSE 1 END,
        codigo,
        desc_cnae
    ) AS cnaes
  FROM dup
  GROUP BY tipocadastro, cadastrogeral
)
SELECT
mobiliario.DATAALVARA,
mobiliario.SUPERSIMPLES,
mobiliario.SUBSTITUICAOTRIBUTARIA,
mobiliario.DISPENSANOTAFISCAL,
mobiliario.TIPOOPERACAO,
mobiliario.IDNOTIFICACAOFISCALIZACAO,
mobiliario.TipoCadastro,
mobiliario.CadastroGeral,
mobiliario.PESSOAMOBILIARIO,
mobiliario.cnpjCpf,
mobiliario.NOME,
mobiliario.ESTIMADO,
mobiliario.MUNICIPIO,
mobiliario.ARBIT,
mobiliario.ARBIT2,
mobiliario.ARBIT3,
mobiliario.TIPOLOGRADOURO,
mobiliario.LOGRADOURO,
mobiliario.NUMERO,
mobiliario.COMPLEMENTOCADGERAL,
mobiliario.BAIRRO,
mobiliario.CIDADE,
mobiliario.UF,
mobiliario.CEP,
mobiliario.CODIGOCGCM,
mobiliario.INSCRICAOCADASTRAL,
mobiliario.ZONAINSC,
mobiliario.QUADRAINSC,
mobiliario.DATAINSC,
mobiliario.TAXALOCALIZACAO,
mobiliario.AREAUTILIZADA,
mobiliario.CODIGOBOMBEIRO,
mobiliario.AREABOMBEIRO,
mobiliario.QTDAPTOS,
mobiliario.NUMEMPREGADOS,
mobiliario.QUALISUPER,
mobiliario.QUALITEC,
mobiliario.COMAMB,
mobiliario.QTDCOMAMB,
mobiliario.OCUPSOLO,
mobiliario.QTDOCUPSOLO,
mobiliario.NUMSOCIOS,
mobiliario.SITUACAOESTABELECIMENTO,
mobiliario.NUMEROALVARA,
mobiliario.DATAVALIDADEALVARA,
mobiliario.DATAABERTURA,
mobiliario.DATAENCERRAMENTO,
mobiliario.PROTOCOLOABERTURA,
mobiliario.DATAPROTOCOLOABERTURA,
mobiliario.DATAAUDITORIAINICIO,
mobiliario.DATAAUDITORIAFIM,
mobiliario.DATAHOMOLOGACAO,
mobiliario.CODIGOFISCAL,
mobiliario.NOMEFISCAL,
mobiliario.NOTIFICACAO,
mobiliario.ANONOTIFICACAO,
mobiliario.IDAUTOINFRACAOFISCAL,
mobiliario.EMITENOTAFISCAL,
mobiliario.CMCRESPONSAVEL,
mobiliario.EMAIL,
mobiliario.TELEFONE,
mobiliario.DATAALTERACAO,
mobiliario.Atividade1,
mobiliario.Atividade2,
mobiliario.Atividade3,
mobiliario.Atividade4,
mobiliario.CodigoISS1,
mobiliario.CodigoISS2,
mobiliario.CodigoISS3,
mobiliario.EXCLUSAOLOGICA,
mobiliario.ATIVIDADEPRINCIPAL,
mobiliario.OBSERVACAOALVARA,
mobiliario.tipocadastroimobiliario,
mobiliario.cadastrogeralimobiliario,
aa.atividades,
ca.cnaes
FROM mobiliario
LEFT JOIN atividades_agg aa
  ON (aa.tipocadastro, aa.cadastrogeral) = (mobiliario.tipocadastro, mobiliario.cadastrogeral)
LEFT JOIN cnaes_agg ca
  ON (ca.tipocadastro, ca.cadastrogeral) = (mobiliario.tipocadastro, mobiliario.cadastrogeral)
ORDER BY mobiliario.tipocadastro, mobiliario.cadastrogeral
%s