WITH
cadastro AS (
  SELECT tcg.tipocadastro, tcg.cadastrogeral
  FROM tribcadastrogeral tcg
  WHERE tcg.tipocadastro = 1
%s
),
imobiliario AS (
  SELECT
      tcg.tipocadastro,
      tcg.cadastrogeral,
      CASE WHEN tcg.exclusaologica = 'S' THEN 'E' ELSE 'I' END AS tipooperacao,
      pe1.pessoa,
      pe1.nome,
      pe1.tipopessoa,
      pe1.cnpj_cpf,
      ci.complementolote AS complemento,
      tcg.codigosistemaanterior,
      tcg.suspensoemissao,
      tcg.exclusaologica,
      tcg.englobado,
      tcg.datainclusao,
      tcg.dataalteracao,
      tcg.logradouro,
      tl.sigla AS tipologradouro,
      lg.descricao AS desclogradouro,
      tcg.numero,
      tcg.bairro,
      tcg.cep,
      cd.descricao AS desccidade,
      ba.descricao AS descbairro,
      ci.inscricaocadastral,
      ci.inscricaocadastralanterior,
      ci.trecho_inscricaocadastral,
      ci.quadra_inscricaocadastral,
      ci.lote_inscricaocadastral,
      ci.distrito_inscricaocadastral,
      ci.setor_inscricaocadastral,
      ci.unidade_inscricaocadastral,
      ci.distrito_descr,
      di1.descricao AS descdistrito,
      ci.setor_descr,
      ci.trecho_descr,
      ci.quadra_descr,
      ci.lote_descr,
      ci.unidade_descr,
      ci.imobiliaria,
      ci.condominio,
      co.descricao AS desccondominio,
      ci.loteamento,
      lo.descricao AS descloteamento,
      ci.tipoimovel,
      ci.anoaliquotaprogressiva,
      trunc(ci.arealote,2) AS arealote,
      ci.profundidademedia,
      trunc(ci.areatotalconstruida,2) AS areatotalconstruida,
      ci.limitacercamuro,
      ci.imovelproprio,
      ci.matricula,
      ci.cartorio,
      ci.datamatricula,
      ci.livro,
      ci.folha,
      ci.facequadra,
      ci.caucionado,
      ci.latitude,
      ci.longitude,
      trunc(ci.areautillote,2) AS areautillote,
      trunc(ci.areaprivativa,2) AS areaprivativa,
      trunc(ci.areacomum,2) AS areacomum,
      ci.complementolote,
      ise.isencao AS codisencao,
      ise.descricao AS descisencao,
      COALESCE((
        SELECT SUM(trunc(area,2))
        FROM tribimobiliarioareaverde tia
        WHERE tia.tipocadastro = tcg.tipocadastro
          AND tia.cadastrogeral = tcg.cadastrogeral
      ),0) AS areaverde
  FROM cadastro k
  JOIN tribcadastrogeral tcg
    ON tcg.tipocadastro = k.tipocadastro
   AND tcg.cadastrogeral = k.cadastrogeral
  LEFT JOIN tribisencao ise
         ON ise.isencao = tcg.codigoisencao
  LEFT JOIN tribcadastroimobiliario ci
         ON ci.tipocadastro = tcg.tipocadastro
        AND ci.cadastrogeral = tcg.cadastrogeral
  LEFT JOIN tribdistrito di1
         ON di1.distrito = ci.distrito_inscricaocadastral
  LEFT JOIN tribloteamento lo
         ON lo.distrito = ci.distrito_inscricaocadastral
        AND lo.setor    = ci.setor_inscricaocadastral
        AND lo.loteamento = ci.loteamento
  LEFT JOIN tribcondominio co
         ON co.distrito  = ci.distrito_inscricaocadastral
        AND co.setor     = ci.setor_inscricaocadastral
        AND co.condominio = ci.condominio
  LEFT JOIN pessoa pe1
         ON pe1.pessoa = tcg.pessoa
  LEFT JOIN logradouro lg
         ON lg.cidade = tcg.cidade
        AND lg.logradouro = tcg.logradouro
  LEFT JOIN tipologradouro tl
         ON tl.tipologradouro = lg.tipologradouro
  LEFT JOIN bairro ba
         ON ba.cidade = tcg.cidade
        AND ba.bairro = tcg.bairro
  LEFT JOIN cidade cd
         ON cd.cidade = tcg.cidade
),
patrimonio_e_situacao AS (
  SELECT
    cad.tipocadastro,
    cad.cadastrogeral,
    MAX(CASE WHEN c.identificador = 'patrimonio'   THEN r.idalternativa END) AS patrimonio,
    MAX(CASE WHEN c.identificador = 'situacaolote' THEN r.idalternativa END) AS situacaolote
  FROM cadastro k
  JOIN aise.tribcadastrogeral cad
    ON cad.tipocadastro = k.tipocadastro
   AND cad.cadastrogeral = k.cadastrogeral
  JOIN aise.respostaterreno r ON r.referencia = cad.idkey
  JOIN aise.campo c ON c.id = r.idcampo
  WHERE c.identificador IN ('patrimonio','situacaolote')
  GROUP BY cad.tipocadastro, cad.cadastrogeral
),
proprietarios_agg AS (
  SELECT
    CI.tipocadastro,
    CI.cadastrogeral,
    ARRAY_AGG(
      ROW(
        CI.tipocadastro,
        CI.cadastrogeral,
        PR.pessoa,
        PE3.tipopessoa,
        PE3.nome,
        PE3.nomefantasia,
        PE3.cnpj_cpf,
        PE3.rg,
        PE3.orgaoemissor,
        CASE WHEN PR.vinculo = 1
             THEN PR.principal
             ELSE PR.coresponsavelprincipal
        END,
        PR.vinculo,
        TV.descricao,
        trunc(PR.percentual, 3),
        TPLO.sigla,
        LOG.descricao,
        ENDE.numero,
        ENDE.cep,
        ENDE.complemento,
        ENDE.unidadefederacao,
        BAI.descricao,
        CID.descricao,
        CP.telefoneresidencial,
        CP.telefonecomercial,
        CP.telefonecelular,
        CP.email
      )
      ORDER BY PR.principal DESC, PE3.nome, PR.pessoa
    ) AS proprietarios
  FROM cadastro k
  JOIN tribcadastroimobiliario CI
    ON CI.tipocadastro = k.tipocadastro
   AND CI.cadastrogeral = k.cadastrogeral
  LEFT JOIN tribproprietario PR
    ON PR.tipocadastro = CI.tipocadastro
   AND PR.cadastrogeral = CI.cadastrogeral
  LEFT JOIN pessoa PE3
    ON PE3.pessoa = PR.pessoa
  LEFT JOIN enderecopessoa ENDE
    ON ENDE.pessoa = PE3.pessoa
   AND ENDE.sequencia = COALESCE(PE3.sequenciaendereco, 1)
  LEFT JOIN contatopessoa CP
    ON CP.pessoa = PE3.pessoa
   AND CP.sequencia = PE3.sequenciacontato
  LEFT JOIN tribvinculo TV
    ON TV.vinculo = PR.vinculo
  LEFT JOIN logradouro LOG
    ON LOG.cidade = ENDE.cidade
   AND LOG.logradouro = ENDE.logradouro
  LEFT JOIN tipologradouro TPLO
    ON TPLO.tipologradouro = LOG.tipologradouro
  LEFT JOIN bairro BAI
    ON BAI.cidade = ENDE.cidade
   AND BAI.bairro = ENDE.bairro
  LEFT JOIN cidade CID
    ON CID.cidade = ENDE.cidade
  GROUP BY CI.tipocadastro, CI.cadastrogeral
),
terrenos_agg AS (
  WITH base AS (
    SELECT
      cad.tipocadastro,
      cad.cadastrogeral,
      UPPER(c.descricao) AS campo,
      UPPER(a.descricao) AS resposta
    FROM cadastro k
    JOIN aise.tribcadastrogeral cad
      ON cad.tipocadastro = k.tipocadastro
     AND cad.cadastrogeral = k.cadastrogeral
    JOIN aise.respostaterreno r
      ON r.referencia = cad.idkey
    LEFT JOIN aise.campo c
      ON c.id = r.idcampo
    LEFT JOIN aise.alternativa a
      ON a.id = r.idalternativa
    WHERE c.identificador IN ('situacao', 'cod.aliquota')
  ),
  dup AS (
    SELECT DISTINCT
      tipocadastro, cadastrogeral, campo, resposta
    FROM base
  )
  SELECT
    tipocadastro,
    cadastrogeral,
    ARRAY_AGG(
      ROW(tipocadastro, cadastrogeral, campo, resposta)
      ORDER BY campo, resposta
    ) AS terrenos
  FROM dup
  GROUP BY tipocadastro, cadastrogeral
),
segmentos_agg AS (
  WITH base AS (
    SELECT
      iseg.tipocadastro,
      iseg.cadastrogeral,
      iseg.sequencia,
      UPPER(seg.descricao)               AS tiposegmento,
      iseg.areaconstruida,
      iseg.principal,
      UPPER(c.descricao)                 AS campo,
      UPPER(COALESCE(r.valor, a.descricao)) AS resposta,
      s.descricao                        AS situacaosegmento
    FROM cadastro k
    JOIN aise.tribimobiliariosegmento iseg
      ON iseg.tipocadastro = k.tipocadastro
     AND iseg.cadastrogeral = k.cadastrogeral
    LEFT JOIN aise.respostasegmento r ON r.referencia = iseg.idkey
    LEFT JOIN aise.campo c ON c.id = r.idcampo
    LEFT JOIN aise.alternativa a ON a.id = r.idalternativa
    LEFT JOIN aise.tribtiposegmento seg ON seg.tiposegmento = iseg.tiposegmento
    LEFT JOIN aise.tribsituacaosegmentoimob s ON s.idsituacaosegmento = iseg.idsituacaosegmento
  ),
  dup AS (
    SELECT DISTINCT
      tipocadastro, cadastrogeral, sequencia, tiposegmento, areaconstruida,
      principal, campo, resposta, situacaosegmento
    FROM base
  )
  SELECT
    tipocadastro,
    cadastrogeral,
    ARRAY_AGG(
      ROW(
        tipocadastro,
        cadastrogeral,
        sequencia,
        tiposegmento,
        areaconstruida,
        principal,
        campo,
        resposta,
        situacaosegmento
      )
      ORDER BY sequencia, campo, resposta
    ) AS segmentos
  FROM dup
  GROUP BY tipocadastro, cadastrogeral
),
areasverdes_agg AS (
  SELECT
    A.tipocadastro,
    A.cadastrogeral,
    ARRAY_AGG(
      ROW(
        A.tipocadastro,
        A.cadastrogeral,
        A.sequencia,
        CAST(A.area AS numeric(16,4)),
        B.sigla,
        UPPER(B.descricao)
      )
      ORDER BY A.sequencia
    ) AS areasverdes
  FROM cadastro k
  JOIN tribimobiliarioareaverde A
    ON A.tipocadastro = k.tipocadastro
   AND A.cadastrogeral = k.cadastrogeral
  LEFT JOIN tribtipoareaverde B
    ON A.tipoareaverde = B.tipoareaverde
  GROUP BY A.tipocadastro, A.cadastrogeral
),
testadas_agg AS (
  WITH base AS (
    SELECT
      A.tipocadastro,
      A.cadastrogeral,
      A.idlogradourotestada,
      A.principal,
      TL.sigla,
      B.logradouro,
      LOG1.descricao AS desc_logradouro,
      B.logradourotrecho,
      LOG2.descricao AS desc_logradouro_trecho,
      (CAST(A.tamanhotestada AS numeric(16,2)) * 100) AS tamanhotestada
    FROM cadastro k
    JOIN tribimobiliariotestada A
      ON A.tipocadastro = k.tipocadastro
     AND A.cadastrogeral = k.cadastrogeral
    LEFT JOIN triblogradourotestada B
           ON A.idlogradourotestada = B.idlogradourotestada
    LEFT JOIN triblogradourotrecho TLT
           ON B.setor = TLT.setor
          AND B.logradourotrecho = TLT.logradourotrecho
    LEFT JOIN logradouro LOG1
           ON B.cidade = LOG1.cidade
          AND B.logradouro = LOG1.logradouro
    LEFT JOIN logradouro LOG2
           ON TLT.cidade = LOG2.cidade
          AND TLT.logradouro = LOG2.logradouro
    LEFT JOIN tipologradouro TL
           ON TL.tipologradouro = LOG1.tipologradouro
  ),
  dup AS (
    SELECT DISTINCT
      tipocadastro,
      cadastrogeral,
      idlogradourotestada,
      principal,
      sigla,
      logradouro,
      desc_logradouro,
      logradourotrecho,
      desc_logradouro_trecho,
      tamanhotestada
    FROM base
  )
  SELECT
    tipocadastro,
    cadastrogeral,
    ARRAY_AGG(
      ROW(
        tipocadastro,
        cadastrogeral,
        idlogradourotestada,
        principal,
        sigla,
        logradouro,
        desc_logradouro,
        logradourotrecho,
        desc_logradouro_trecho,
        tamanhotestada
      )
      ORDER BY idlogradourotestada
    ) AS testadas
  FROM dup
  GROUP BY tipocadastro, cadastrogeral
)
SELECT
  i.tipocadastro,
  i.cadastrogeral,
  i.tipooperacao,
  i.pessoa,
  i.nome,
  i.tipopessoa,
  i.cnpj_cpf,
  i.complemento,
  i.codigosistemaanterior,
  i.suspensoemissao,
  i.exclusaologica,
  i.englobado,
  i.datainclusao,
  i.dataalteracao,
  i.logradouro,
  i.tipologradouro,
  i.desclogradouro,
  i.numero,
  i.bairro,
  i.cep,
  i.desccidade,
  i.descbairro,
  i.inscricaocadastral,
  i.inscricaocadastralanterior,
  i.trecho_inscricaocadastral,
  i.quadra_inscricaocadastral,
  i.lote_inscricaocadastral,
  i.distrito_inscricaocadastral,
  i.setor_inscricaocadastral,
  i.unidade_inscricaocadastral,
  i.distrito_descr,
  i.descdistrito,
  i.setor_descr,
  i.trecho_descr,
  i.quadra_descr,
  i.lote_descr,
  i.unidade_descr,
  i.imobiliaria,
  i.condominio,
  i.desccondominio,
  i.loteamento,
  i.descloteamento,
  i.tipoimovel,
  i.anoaliquotaprogressiva,
  i.arealote,
  i.profundidademedia,
  i.areatotalconstruida,
  i.limitacercamuro,
  i.imovelproprio,
  i.matricula,
  i.cartorio,
  i.datamatricula,
  i.livro,
  i.folha,
  i.facequadra,
  i.caucionado,
  i.latitude,
  i.longitude,
  i.areautillote,
  i.areaprivativa,
  i.areacomum,
  i.complementolote,
  i.codisencao,
  i.descisencao,
  af.patrimonio,
  i.areaverde,
  af.situacaolote,
  pa.proprietarios,
  ta.terrenos,
  sa.segmentos,
  ava.areasverdes,
  tsa.testadas
FROM imobiliario i
LEFT JOIN patrimonio_e_situacao af ON (af.tipocadastro, af.cadastrogeral) = (i.tipocadastro, i.cadastrogeral)
LEFT JOIN proprietarios_agg pa ON (pa.tipocadastro, pa.cadastrogeral) = (i.tipocadastro, i.cadastrogeral)
LEFT JOIN terrenos_agg ta ON (ta.tipocadastro, ta.cadastrogeral) = (i.tipocadastro, i.cadastrogeral)
LEFT JOIN segmentos_agg sa ON (sa.tipocadastro, sa.cadastrogeral) = (i.tipocadastro, i.cadastrogeral)
LEFT JOIN areasverdes_agg ava ON (ava.tipocadastro, ava.cadastrogeral) = (i.tipocadastro, i.cadastrogeral)
LEFT JOIN testadas_agg tsa ON (tsa.tipocadastro, tsa.cadastrogeral) = (i.tipocadastro, i.cadastrogeral)
ORDER BY i.tipocadastro, i.cadastrogeral
%s
