	select tp.entidade,
	       tdc.IDDEVOLUCAOCREDITO,
	       TDC.DATA as databaixa,
	       tdpr.exercicio,
	       CASE
	         WHEN (tdpr.GUIARECOLHIMENTO = 62) AND
	              (tp.MESREFERENCIA IS NULL) AND
	              (tpb.CODIGOBARRASEXTERNO IS NULL) AND
	              (TBAD.MESMOVIMENTO IS NULL)
	           THEN CASE
	                  WHEN EXTRACT(MONTH FROM tdp.DATAVENCIMENTO) = 1
	                    THEN tdpr.EXERCICIO - 1
	                    ELSE tdpr.EXERCICIO
	                END
	           ELSE tdpr.EXERCICIO
	       END AS EXERCICIOREFERENCIA,
	       '03' AS TIPOPAGTO,
	       'Z' as TIPOOPERACAO,
	       tdpr.TipoCadastro,
	       tdpr.CadastroGeral,
	       tdpr.GuiaRecolhimento,
	       tdpr.SubDivida,
	       tdpr.Parcela AS PARCELAORIGINAL,
	       CASE
	         WHEN TP.PARCELAANTERIOR IS NOT NULL
	           THEN TP.PARCELAANTERIOR
	           ELSE TDPR.PARCELA
	       END AS PARCELA,
	       tp.ExercicioLote,
	       CASE
	         WHEN TP.LOTEPREF IS NULL
	           THEN CASE
	                  WHEN TP.LOTE IS NULL
	                    THEN CASE
	                           WHEN TCCON.LOTEPREF IS NULL
	                             THEN CASE
	                                    WHEN TCCON.LOTE IS NULL
	                                      THEN NULL
	                                      ELSE TCCON.LOTE
	                                  END
	                             ELSE TCCON.LOTEPREF
	                         END
	                    ELSE TP.LOTE
	                END
	           ELSE TP.LOTEPREF
	       END AS LOTE,
	       COALESCE(TP.LOTEPREF, TCCON.LOTEPREF) AS LOTEPREF,
	       CASE
	         WHEN TP.LOTEPREF IS NULL
	           THEN CASE
	                  WHEN TP.LOTE IS NULL
	                    THEN CASE
	                           WHEN TCCON.LOTEPREF IS NULL
	                             THEN CASE
	                                    WHEN TCCON.LOTE IS NULL
	                                      THEN NULL
	                                      ELSE TCCON.SEQUENCIAARQUIVO
	                                  END
	                             ELSE TCCON.SEQUENCIAPREF
	                         END
	                    ELSE TBAD.SEQUENCIAARQUIVO
	                END
	           ELSE TP.SEQUENCIAPREF
	       END AS SEQUENCIALOTE,
	       COALESCE( TP.DATAPAGAMENTO, TCCON.DATAPAGAMENTO ) as DataPagamento,
	       CASE
	         WHEN TP.LOTE IS NULL
	           THEN CASE
	                  WHEN TCCON.LOTE IS NULL
	                    THEN CASE
	                           WHEN TP.LOTEPREF IS NULL
	                             THEN CASE
	                                    WHEN TCCON.LOTEPREF IS NULL
	                                      THEN NULL
	                                      ELSE TCCON.DATACREDITO
	                                  END
	                             ELSE TP.DATALANCAMENTO
	                         END
	                  ELSE TCCON.DATACREDITO
	                END
	           ELSE TP.DATALANCAMENTO
	       END AS DATAMOVIMENTO,
	       CASE
	         WHEN TPD.SITUACAOLEGAL IS NULL
	           THEN TDP.SITUACAOLEGAL
	           ELSE TPD.SITUACAOLEGAL
	       END AS SITUACAOBAIXA,
	       tp.ContaBancaria,
	       cb.Descricao ContaBancariaDescr,
	       tp.banco,
	       cb.agencia,
	       tp.ocorrencia,
	       tb.Tipobloqueto,
	       tb.nossonumero,
           COALESCE(tb.CODIGOBARRASEXTERNO, tb.CODIGOBARRAS) as CodigoBarras,
	       TD.PARCELADO AS TIPODEBITO,
	       TAIF.AUTOINFRACAOFISCAL,
	       TAIF.EXERCICIO AS EXERCICIOAUTOINFRACAO,
	       tapi.idacertopagamento,
	       CASE
	         WHEN TPL.TIPOARQUIVO = 3
	           THEN 'S'
	         WHEN TPL.TIPOARQUIVO = 5
	           THEN 'R'
	           ELSE ' '
	       END AS TIPODOCUMENTO,
	       COMPLETASTRING((CASE
	            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 101) THEN '01'
	            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 102) THEN '02'
	            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 103) THEN '03'
	            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 104) THEN '04'
	            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 105) THEN '05'
	            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 106) THEN '06'
	            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 107) THEN '07'
	            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 108) THEN '08'
	            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 109) THEN '09'
	            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 110) THEN '10'
	            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 111) THEN '11'
	            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 112) THEN '12'
	            WHEN tdpr.GUIARECOLHIMENTO IN (41, 91, 93, 94) THEN
	              CASE
	                WHEN EXTRACT(MONTH FROM tdp.DATAVENCIMENTO) = 1
	                  THEN '12'
	                  ELSE CAST((EXTRACT(MONTH FROM tdp.DATAVENCIMENTO) - 1) AS VARCHAR(2))
	              END
	            WHEN (tdpr.GUIARECOLHIMENTO = 92) THEN ''
	            WHEN tdpr.GUIARECOLHIMENTO = 62 THEN
	              CASE
	                WHEN TP.MESREFERENCIA IS NOT NULL THEN CAST(TP.MESREFERENCIA AS VARCHAR(2))
	                WHEN tb.CODIGOBARRASEXTERNO IS NOT NULL THEN substring(tb.CODIGOBARRASEXTERNO, 31, 2)
	                WHEN TBAD.MESMOVIMENTO IS NOT NULL
	                  THEN CAST(TBAD.MESMOVIMENTO AS VARCHAR(2))
	                  ELSE CASE
	                         WHEN EXTRACT(MONTH FROM tdp.DATAVENCIMENTO) = 1
	                           THEN '12'
	                           ELSE CAST((EXTRACT(MONTH FROM tdp.DATAVENCIMENTO) - 1) AS VARCHAR(2))
	                       END
	       END END),'0','E','2') AS MESREFERENCIA,
	       CASE
	         WHEN (tp.LOTEPREF IS NULL) AND (tccon.LOTEPREF IS NULL)
	           THEN 'A'
	           ELSE 'N'
	       END AS SISTEMAGERACAO,
	       CASE
	         WHEN TDC.IDDEVOLUCAOCREDITO IS NULL
	           THEN NULL
	           ELSE CASE
	                  WHEN TDCI.CREDITOCONTRIBUINTE IS NULL
	                    THEN COMPLETASTRING(CAST(TP.ENTIDADE AS VARCHAR(2)), '0', 'E', '2') ||
	                                        TP.EXERCICIOPAGAMENTO ||
	                                        COMPLETASTRING(CAST(TP.PAGAMENTO AS VARCHAR(10)), '0', 'E', '10') ||
	                                        COMPLETASTRING(substring(CAST(TDPR.EXERCICIO AS VARCHAR(4)), 3, 2), '0', 'E', '2') ||
	                                        COMPLETASTRING(CAST(TDPR.TIPOCADASTRO AS VARCHAR(2)), '0', 'E', '2') ||
	                                        COMPLETASTRING(CAST(TDPR.CADASTROGERAL AS VARCHAR(10)), '0', 'E', '10') ||
	                                        COMPLETASTRING(CAST(TDPR.GUIARECOLHIMENTO AS VARCHAR(3)), '0', 'E', '3') ||
	                                        COMPLETASTRING(CAST(CASE WHEN TDPR.SUBDIVIDA >= 1000 THEN 999 ELSE TDPR.SUBDIVIDA END AS VARCHAR(3)), '0', 'E', '3') ||
	                                        COMPLETASTRING(CAST(TDPR.PARCELA AS VARCHAR(4)), '0', 'E', '4')
	                    ELSE COMPLETASTRING(CAST(TCCON.ENTIDADE AS VARCHAR(2)), '0', 'E', '2') ||
	                                        TCCON.EXERCICIO ||
	                                        COMPLETASTRING(CAST(TCCON.CREDITOCONTRIBUINTE AS VARCHAR(10)), '0', 'E', '10') ||
	                                        COMPLETASTRING(substring(CAST(TDPR.EXERCICIO AS VARCHAR(4)), 3, 2), '0', 'E', '2') ||
	                                        COMPLETASTRING(CAST(TDPR.TIPOCADASTRO AS VARCHAR(2)), '0', 'E', '2') ||
	                                        COMPLETASTRING(CAST(TDPR.CADASTROGERAL AS VARCHAR(10)), '0', 'E', '10') ||
	                                        COMPLETASTRING(CAST(TDPR.GUIARECOLHIMENTO AS VARCHAR(3)), '0', 'E', '3') ||
	                                        COMPLETASTRING(CAST(CASE WHEN TDPR.SUBDIVIDA >= 1000 THEN 999 ELSE TDPR.SUBDIVIDA END AS VARCHAR(3)), '0', 'E', '3') ||
	                                        COMPLETASTRING(CAST(TDPR.PARCELA AS VARCHAR(4)), '0', 'E', '4')
	                END
	       END AS CHAVEPAGAMENTOAISE,
	       substring(TBAD.DETALHE,462,17) AS CODIGODAS,
	       tb.CODIGOBARRASEXTERNO as CodigoGuiaISSe,
	       SUM(TDCD.VALORDEVOLVIDO) AS VALORPAGO,
	       SUM(TDCD.VALORPRINCIPAL) AS VALORPRINCIPAL,
	       SUM(TDCD.VALORMULTA) AS VALORMULTA,
	       SUM(TDCD.VALORJUROS) AS VALORJUROS,
	       SUM(TDCD.VALORCORRECAO) AS VALORCORRECAO
	from TRIBDEVOLUCAOCREDITO TDC
	  LEFT OUTER JOIN TRIBDEVOLUCAOCREDITOITEM TDCI
	             ON TDCI.IDDEVOLUCAOCREDITO = TDC.IDDEVOLUCAOCREDITO
	  LEFT OUTER JOIN TRIBDEVOLUCAOCREDITODEBITO TDCD
	             ON TDCD.IDDEVOLUCAOCREDITO = TDCI.IDDEVOLUCAOCREDITO
	             AND TDCD.SEQUENCIAITEM = TDCI.SEQUENCIAITEM
	  LEFT OUTER JOIN TRIBPAGAMENTO TP
	             ON TP.ENTIDADE = TDCI.ENTIDADE
	            AND TP.EXERCICIOPAGAMENTO = TDCI.EXERCICIOPAGAMENTO
	            AND TP.PAGAMENTO = TDCI.PAGAMENTO
	  LEFT OUTER JOIN TRIBCREDITOCONTRIBUINTE TCCON
	             ON TCCON.ENTIDADE = TDCI.ENTIDADE
	            AND TCCON.EXERCICIO = TDCI.EXERCICIO
	            AND TCCON.CREDITOCONTRIBUINTE = TDCI.CREDITOCONTRIBUINTE
	  LEFT OUTER JOIN TRIBCREDITOCONTRIBUINTEITEM TCCI
	             ON TCCON.ENTIDADE = TDCI.ENTIDADE
	            AND TCCON.EXERCICIO = TDCI.EXERCICIO
	            AND TCCON.CREDITOCONTRIBUINTE = TDCI.CREDITOCONTRIBUINTE
	  LEFT OUTER JOIN Tribpagamentolote tpl on
	        tpl.entidade = tp.entidade and
	        tpl.exercicio = tp.exerciciolote and
	        tpl.lote = tp.lote
	   Left outer join tribPagamentoBloqueto tpb
	       on tpb.Entidade = tp.Entidade
	      and tpb.ExercicioPagamento = tp.Exerciciopagamento
	      and tpb.Pagamento = tp.Pagamento
	   Left outer join TribBloqueto tb
	     on tb.Entidade = tpb.Entidade
	    and tb.Exerciciobloqueto = tpb.Exerciciobloqueto
	    and tb.Bloqueto = tpb.Bloqueto
	   Left outer join tribPagamentoDebito tpd
	       on tpd.IdPagamentoBloqueto = tpb.IdPagamentoBloqueto
	   Left outer join TribDebitoParcelaReceita tdpr
	       on tdpr.IdDebitoParcelaReceita = tpd.IdDebitoParcelaReceita
	   Left outer join tribDebitoParcela tdp on
	       tdp.entidade = tdpr.entidade and
	       tdp.exercicio = tdpr.exercicio and
	       tdp.tipocadastro = tdpr.tipocadastro and
	       tdp.cadastrogeral = tdpr.cadastrogeral and
	       tdp.guiarecolhimento = tdpr.guiarecolhimento and
	       tdp.subdivida = tdpr.subdivida and
	       tdp.parcela = tdpr.parcela
	   Left outer join ContaBancaria cb
	       on cb.Entidade = tp.Entidade
	      and cb.ContaBancaria = tp.ContaBancaria
	   LEFT OUTER JOIN TRIBAUTOINFRACAODEBITO TAID
	            ON TAID.ENTIDADE = TDp.ENTIDADE
	           AND TAID.EXERCICIO = TDp.EXERCICIO
	           AND TAID.TIPOCADASTRO = TDp.TIPOCADASTRO
	           AND TAID.CADASTROGERAL = TDp.CADASTROGERAL
	           AND TAID.GUIARECOLHIMENTO = TDp.GUIARECOLHIMENTO
	           AND TAID.SUBDIVIDA = TDp.SUBDIVIDA
	   LEFT OUTER JOIN TRIBAUTOINFRACAOFISCAL TAIF
	            ON TAIF.IDAUTOINFRACAOFISCAL = TAID.IDAUTOINFRACAOFISCAL
	   LEFT OUTER JOIN TRIBACERTOPAGAMENTOITEM TAPI
	           ON TAPI.PAGAMENTONOVO = TP.PAGAMENTO
	   LEFT OUTER JOIN TRIBBAIXAAUTOMATICADETALHE TBAD
	            ON TBAD.ENTIDADE = TP.ENTIDADE
	           AND TBAD.EXERCICIO = TP.EXERCICIOLOTE
	           AND TBAD.LOTE = TP.LOTE
	           AND TBAD.EXERCICIOPAGAMENTO = TP.EXERCICIOPAGAMENTO
	           AND TBAD.PAGAMENTO = TP.PAGAMENTO
	   LEFT OUTER JOIN TRIBDEBITO TD ON
	          tdp.entidade = td.entidade and
	          tdp.exercicio = td.exercicio and
	          tdp.tipocadastro = td.tipocadastro and
	          tdp.cadastrogeral = td.cadastrogeral and
	          tdp.guiarecolhimento = td.guiarecolhimento and
	          tdp.subdivida = td.subdivida
	   LEFT OUTER JOIN TRIBCADASTROGERAL TCG ON
	         td.TipoCadastro = tcg.TipoCadastro and
	         td.CadastroGeral = tcg.CadastroGeral
	   WHERE TD.GUIARECOLHIMENTO IN (3, 5, 6, 7, 8, 9, 10, 15, 16, 17, 18, 23, 24, 26, 27, 28, 29, 30 ,31, 33, 35, 36, 37, 41, 44, 45, 49, 56, 62, 91, 92, 93, 94, 98, 101, 105,132,152)
   	   %s
	   AND NOT EXISTS(
	          SELECT 1 FROM TRIBDEBITORECEITA TD_ISENCAO
	          WHERE TD_ISENCAO.ENTIDADE = TDP.ENTIDADE
	          AND  TD_ISENCAO.EXERCICIO = TDP.EXERCICIO
	          AND  TD_ISENCAO.TIPOCADASTRO = TDP.TIPOCADASTRO
	          AND  TD_ISENCAO.CADASTROGERAL = TDP.CADASTROGERAL
	          AND  TD_ISENCAO.GUIARECOLHIMENTO = TDP.GUIARECOLHIMENTO
	          AND  TD_ISENCAO.SUBDIVIDA = TDP.SUBDIVIDA
	         HAVING (SUM(TD_ISENCAO.VALORRECEITA) - SUM(TD_ISENCAO.VALORRENUNCIA) = 0)
	            AND NOT (SUM(TD_ISENCAO.VALORRECEITA) = 0 AND SUM(TD_ISENCAO.VALORRENUNCIA) = 0))
	group by
	       tp.entidade,
	       tdc.IDDEVOLUCAOCREDITO,
	       COMPLETASTRING(CAST(TCCON.ENTIDADE AS VARCHAR(2)), '0', 'E', '2'),
	       TDC.DATA,
	       tdpr.Exercicio,
	       CASE
	         WHEN (tdpr.GUIARECOLHIMENTO = 62) AND
	              (tp.MESREFERENCIA IS NULL) AND
	              (tpb.CODIGOBARRASEXTERNO IS NULL) AND
	              (TBAD.MESMOVIMENTO IS NULL)
	           THEN CASE
	                  WHEN EXTRACT(MONTH FROM tdp.DATAVENCIMENTO) = 1
	                    THEN tdpr.EXERCICIO - 1
	                    ELSE tdpr.EXERCICIO
	                END
	           ELSE tdpr.EXERCICIO
	       END,
	       tdpr.TipoCadastro,
	       tdpr.CadastroGeral,
	       tdpr.GuiaRecolhimento,
	       tdpr.SubDivida,
	       tdpr.Parcela,
	       CASE
	         WHEN TP.PARCELAANTERIOR IS NOT NULL
	           THEN TP.PARCELAANTERIOR
	            ELSE TDPR.PARCELA
	          END,
           tp.ExercicioLote,
	       CASE
	         WHEN TP.LOTEPREF IS NULL
	           THEN CASE
	                  WHEN TP.LOTE IS NULL
	                    THEN CASE
	                           WHEN TCCON.LOTEPREF IS NULL
	                             THEN CASE
	                                    WHEN TCCON.LOTE IS NULL
	                                      THEN NULL
	                                      ELSE TCCON.LOTE
	                                  END
	                             ELSE TCCON.LOTEPREF
	                         END
	                    ELSE TP.LOTE
	                END
	           ELSE TP.LOTEPREF
	       END,
	       COALESCE(TP.LOTEPREF, TCCON.LOTEPREF),
	       CASE WHEN TP.LOTEPREF IS NULL THEN
	         CASE WHEN TP.LOTE IS NULL THEN
	           CASE WHEN TCCON.LOTEPREF IS NULL THEN
	             CASE WHEN TCCON.LOTE IS NULL THEN NULL
	             ELSE TCCON.SEQUENCIAARQUIVO END
	           ELSE TCCON.SEQUENCIAPREF END
	         ELSE TBAD.SEQUENCIAARQUIVO END
	       ELSE TP.SEQUENCIAPREF END,

	       COALESCE(tp.DataPagamento,tccon.Datapagamento),
	       CASE WHEN TP.LOTE IS NULL THEN
	         CASE WHEN TCCON.LOTE IS NULL THEN
	           CASE WHEN TP.LOTEPREF IS NULL THEN
	             CASE WHEN TCCON.LOTEPREF IS NULL THEN NULL
	             ELSE TCCON.DATACREDITO END
	           ELSE TP.DATALANCAMENTO END
	         ELSE TCCON.DATACREDITO END
	       ELSE TP.DATALANCAMENTO END,
	       CASE WHEN TPD.SITUACAOLEGAL IS NULL THEN
	          TDP.SITUACAOLEGAL
	       ELSE TPD.SITUACAOLEGAL END,
	       tp.ContaBancaria,
	       cb.Descricao,
	       tp.banco,
	       cb.agencia,
	       tp.ocorrencia,
	       tb.Tipobloqueto,
	       tb.nossonumero,
	       tb.CODIGOBARRASEXTERNO,
	       TD.PARCELADO,
	       TAIF.AUTOINFRACAOFISCAL,
	       TAIF.EXERCICIO,
	       tapi.idacertopagamento,
	       CASE WHEN TPL.TIPOARQUIVO = 3 THEN 'S'
	            WHEN TPL.TIPOARQUIVO = 5 THEN 'R'
	       ELSE ' ' END,
	       COMPLETASTRING((CASE
	            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 101) THEN '01'
	            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 102) THEN '02'
	            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 103) THEN '03'
	            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 104) THEN '04'
	            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 105) THEN '05'
	            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 106) THEN '06'
	            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 107) THEN '07'
	            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 108) THEN '08'
	            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 109) THEN '09'
	            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 110) THEN '10'
	            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 111) THEN '11'
	            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 112) THEN '12'
	            WHEN tdpr.GUIARECOLHIMENTO IN (41, 91, 93, 94) THEN
	              CASE WHEN EXTRACT(MONTH FROM tdp.DATAVENCIMENTO) = 1 THEN '12'
	              ELSE CAST((EXTRACT(MONTH FROM tdp.DATAVENCIMENTO) - 1) AS VARCHAR(2)) END
	            WHEN (tdpr.GUIARECOLHIMENTO = 92) THEN ''
	            WHEN tdpr.GUIARECOLHIMENTO = 62 THEN
	              CASE WHEN TP.MESREFERENCIA IS NOT NULL THEN CAST(TP.MESREFERENCIA AS VARCHAR(2))
	                   WHEN tb.CODIGOBARRASEXTERNO IS NOT NULL THEN substring(tb.CODIGOBARRASEXTERNO, 31, 2)
	                   WHEN TBAD.MESMOVIMENTO IS NOT NULL THEN CAST(TBAD.MESMOVIMENTO AS VARCHAR(2))
	              ELSE
	                CASE WHEN EXTRACT(MONTH FROM tdp.DATAVENCIMENTO) = 1 THEN '12'
	                 ELSE CAST((EXTRACT(MONTH FROM tdp.DATAVENCIMENTO) - 1) AS VARCHAR(2)) END
	       END END),'0','E','2'),
	       CASE WHEN (tp.LOTEPREF IS NULL) AND (tccon.LOTEPREF IS NULL) THEN 'A'
	       ELSE 'N' END,
	       CASE
	         WHEN TDC.IDDEVOLUCAOCREDITO IS NULL
	           THEN NULL
	           ELSE
	             CASE
	               WHEN TDCI.CREDITOCONTRIBUINTE IS NULL
	                 THEN COMPLETASTRING(CAST(TP.ENTIDADE AS VARCHAR(2)), '0', 'E', '2') ||
	                                     TP.EXERCICIOPAGAMENTO ||
	                                     COMPLETASTRING(CAST(TP.PAGAMENTO AS VARCHAR(10)), '0', 'E', '10') ||
	                                     COMPLETASTRING(substring(CAST(TDPR.EXERCICIO AS VARCHAR(4)), 3, 2), '0', 'E', '2') ||
	                                     COMPLETASTRING(CAST(TDPR.TIPOCADASTRO AS VARCHAR(2)), '0', 'E', '2') ||
	                                     COMPLETASTRING(CAST(TDPR.CADASTROGERAL AS VARCHAR(10)), '0', 'E', '10') ||
	                                     COMPLETASTRING(CAST(TDPR.GUIARECOLHIMENTO AS VARCHAR(3)), '0', 'E', '3') ||
	                                     COMPLETASTRING(CAST(CASE WHEN TDPR.SUBDIVIDA >= 1000 THEN 999 ELSE TDPR.SUBDIVIDA END AS VARCHAR(3)), '0', 'E', '3') ||
	                                     COMPLETASTRING(CAST(TDPR.PARCELA AS VARCHAR(3)), '0', 'E', '4')
	                 ELSE COMPLETASTRING(CAST(TCCON.ENTIDADE AS VARCHAR(2)), '0', 'E', '2') ||
	                                     TCCON.EXERCICIO ||
	                                     COMPLETASTRING(CAST(TCCON.CREDITOCONTRIBUINTE AS VARCHAR(10)), '0', 'E', '10') ||
	                                     COMPLETASTRING(substring(CAST(TDPR.EXERCICIO AS VARCHAR(4)), 3, 2), '0', 'E', '2') ||
	                                     COMPLETASTRING(CAST(TDPR.TIPOCADASTRO AS VARCHAR(2)), '0', 'E', '2') ||
	                                     COMPLETASTRING(CAST(TDPR.CADASTROGERAL AS VARCHAR(10)), '0', 'E', '10') ||
	                                     COMPLETASTRING(CAST(TDPR.GUIARECOLHIMENTO AS VARCHAR(3)), '0', 'E', '3') ||
	                                     COMPLETASTRING(CAST(CASE WHEN TDPR.SUBDIVIDA >= 1000 THEN 999 ELSE TDPR.SUBDIVIDA END AS VARCHAR(3)), '0', 'E', '3') ||
	                                     COMPLETASTRING(CAST(TDPR.PARCELA AS VARCHAR(3)), '0', 'E', '4')
	             END
	       END,
	       substring(tbad.detalhe, 462, 17),
	       tb.codigobarrasexterno,
           tb.CODIGOBARRAS,
	       tccon.exercicio,
	       COMPLETASTRING(CAST(TCCON.CREDITOCONTRIBUINTE AS VARCHAR(10)), '0', 'E', '10'),
	       tdc.iddevolucaocredito,
	       tdci.creditocontribuinte,
	       tp.exerciciopagamento,
	       COMPLETASTRING(CAST(TP.PAGAMENTO AS VARCHAR(10)), '0', 'E', '10')
	ORDER BY tdc.IDDEVOLUCAOCREDITO,
	         TDC.DATA,
	         tdpr.exercicio,
	         tdpr.TipoCadastro,
	         tdpr.CadastroGeral,
	         tdpr.GuiaRecolhimento,
	         tdpr.SubDivida,
	         tdpr.Parcela
    %s