SELECT TCG.TIPOCADASTRO,
       TCG.CADASTROGERAL,
       TDP.EXERCICIO,
       TGR.GUIARECOLHIMENTO,
       TDP.SUBDIVIDA,
       TDP.PARCELA,
       trunc(TD.DATALANCAMENTO) DATALANCAMENTO,
       TDP.DATAVENCIMENTO,
       (SELECT SUM(TDPR.VALOR)
          FROM TRIBDEBITOPARCELARECEITA TDPR
         WHERE TDPR.ENTIDADE = TDP.ENTIDADE
           AND TDPR.EXERCICIO = TDP.EXERCICIO
           AND TDPR.TIPOCADASTRO = TDP.TIPOCADASTRO
           AND TDPR.CADASTROGERAL = TDP.CADASTROGERAL
           AND TDPR.GUIARECOLHIMENTO = TDP.GUIARECOLHIMENTO
           AND TDPR.SUBDIVIDA = TDP.SUBDIVIDA
           AND TDPR.PARCELA = TDP.PARCELA) AS VALOR,
       (CASE
         WHEN TDP.SITUACAOLEGAL = 0 THEN
          'N'
         WHEN TDP.SITUACAOLEGAL = 1 THEN
          'S'
         WHEN TDP.SITUACAOLEGAL = 2 THEN
          'N'
       END) AS ATIVA,
       (CASE
         WHEN TDP.SITUACAOLEGAL = 0 THEN
          'N'
         WHEN TDP.SITUACAOLEGAL = 1 THEN
          'N'
         WHEN TDP.SITUACAOLEGAL = 2 THEN
          'S'
       END) AS JUIZO,
       COMPLETASTRING(SITUACAODEBITO,'0','E','3')   AS SITUACAODEBITO,
       (TD.PERCENTUALISS) AS ALIQUOTA,
       case
         when td.tipoconversao is null then
          'A'
         else
          'N'
       END as SISTEMAGERACAO,
       TD.PARCELADO,
       TD.REPARCELADO,
       TDP.MESREFERENCIA
  FROM TRIBDEBITO TD
  LEFT OUTER JOIN TRIBCADASTROGERAL TCG
                                        ON TCG.TIPOCADASTRO = TD.TIPOCADASTRO
                                       AND TCG.CADASTROGERAL = TD.CADASTROGERAL
  LEFT OUTER JOIN TRIBDEBITOPARCELA TDP ON TDP.ENTIDADE = TD.ENTIDADE
                                       AND TDP.EXERCICIO = TD.EXERCICIO
                                       AND TDP.TIPOCADASTRO =
                                           TD.TIPOCADASTRO
                                       AND TDP.CADASTROGERAL =
                                           TD.CADASTROGERAL
                                       AND TDP.GUIARECOLHIMENTO =
                                           TD.GUIARECOLHIMENTO
                                       AND TDP.SUBDIVIDA = TD.SUBDIVIDA
  LEFT OUTER JOIN TRIBGUIARECOLHIMENTO TGR ON TGR.ENTIDADE = TD.ENTIDADE
                                          AND TGR.EXERCICIO = TD.EXERCICIO
                                          AND TGR.GUIARECOLHIMENTO =
                                              TD.GUIARECOLHIMENTO
 WHERE TD.TIPOCADASTRO in (1,2,3,9)
   and td.guiarecolhimento in (5, 7, 16, 27,33, 41, 44, 49, 62, 91, 92, 93, 94, 105)
%s
ORDER BY TCG.TIPOCADASTRO,
      TCG.CADASTROGERAL,
      TDP.EXERCICIO,
      TGR.GUIARECOLHIMENTO,
      TDP.SUBDIVIDA,
      TDP.PARCELA
%s