--pagamentos-por-tributo
SELECT RECEITA.DESCRICAO                     AS tributo,
       SUM(COALESCE(PAGAMENTODEBITO.VALORPRINCIPAL, 0) + COALESCE(PAGAMENTODEBITO.VALORPAGOMAIOR, 0)) AS valorPrincipal,
       SUM(COALESCE(PAGAMENTODEBITO.VALORJUROS, 0))     AS valorJuros,
       SUM(COALESCE(PAGAMENTODEBITO.VALORMULTA, 0))     AS valorMulta,
       SUM(COALESCE(PAGAMENTODEBITO.VALORCORRECAO, 0))  AS valorCorrecao,
       CASE WHEN SUM(COALESCE(PAGAMENTODEBITO.VALORDESCONTOPRINCIPAL,0)) + SUM(COALESCE(PAGAMENTODEBITO.VALORDESCONTOJUROS,0)) + SUM(COALESCE(PAGAMENTODEBITO.VALORDESCONTOMULTA,0)) + SUM(COALESCE(PAGAMENTODEBITO.VALORDESCONTOCORRECAO,0)) + SUM(COALESCE(PAGAMENTODEBITO.VALORDESCONTOJUROSFINAN, 0)) > 0
       THEN SUM(COALESCE(PAGAMENTODEBITO.VALORDESCONTOPRINCIPAL,0)) + SUM(COALESCE(PAGAMENTODEBITO.VALORDESCONTOJUROS,0)) + SUM(COALESCE(PAGAMENTODEBITO.VALORDESCONTOMULTA,0)) + SUM(COALESCE(PAGAMENTODEBITO.VALORDESCONTOCORRECAO,0)) + SUM(COALESCE(PAGAMENTODEBITO.VALORDESCONTOJUROSFINAN, 0))
       ELSE SUM(COALESCE(PAGAMENTODEBITO.VALORDESCONTO,0)) + SUM(COALESCE(PAGAMENTODEBITO.VALORPAGOMENOR,0)) END AS valorDesconto
FROM TRIBPAGAMENTO PAGAMENTO
         LEFT JOIN TRIBPAGAMENTOBLOQUETO PAGAMENTOBLOQUETO
              ON PAGAMENTO.ENTIDADE = PAGAMENTOBLOQUETO.ENTIDADE AND
                 PAGAMENTO.EXERCICIOPAGAMENTO = PAGAMENTOBLOQUETO.EXERCICIOPAGAMENTO AND
                 PAGAMENTO.PAGAMENTO = PAGAMENTOBLOQUETO.PAGAMENTO
         LEFT JOIN TRIBPAGAMENTODEBITO PAGAMENTODEBITO
              ON PAGAMENTOBLOQUETO.IDPAGAMENTOBLOQUETO = PAGAMENTODEBITO.IDPAGAMENTOBLOQUETO
         LEFT JOIN CONTABANCARIA
              ON PAGAMENTO.ENTIDADE = CONTABANCARIA.ENTIDADE AND
                 PAGAMENTO.CONTABANCARIA = CONTABANCARIA.CONTABANCARIA
         LEFT JOIN TRIBDEBITOPARCELARECEITA DEBITOPARCELARECEITA
              ON PAGAMENTODEBITO.IDDEBITOPARCELARECEITA = DEBITOPARCELARECEITA.IDDEBITOPARCELARECEITA
         LEFT JOIN TRIBRECEITA RECEITA ON RECEITA.ENTIDADE = DEBITOPARCELARECEITA.ENTIDADE AND
                                     RECEITA.EXERCICIO = DEBITOPARCELARECEITA.EXERCICIO AND
                                     RECEITA.RECEITA = DEBITOPARCELARECEITA.RECEITA
         LEFT JOIN TRIBRECEITATIPO TIPORECEITA ON RECEITA.TIPORECEITA = TIPORECEITA.TIPORECEITA
WHERE CONTABANCARIA.INTEGRAARRECADACAO = 'S'
AND PAGAMENTO.DATALANCAMENTO between :dataInicio and :dataFim
:FILTRO
GROUP BY RECEITA.DESCRICAO
UNION ALL
--estorno-pagamentos-por-tributo
SELECT RECEITA.DESCRICAO                          AS tributo,
       SUM(COALESCE(PAGAMENTODEBITO.VALORPRINCIPAL, 0)) * -1 AS valorPrincipal,
       SUM(COALESCE(PAGAMENTODEBITO.VALORJUROS, 0)) * -1     AS valorJuros,
       SUM(COALESCE(PAGAMENTODEBITO.VALORMULTA, 0)) * -1     AS valorMulta,
       SUM(COALESCE(PAGAMENTODEBITO.VALORCORRECAO, 0)) * -1  AS valorCorrecao,
       SUM(COALESCE(PAGAMENTODEBITO.VALORDESCONTO, 0)) * -1  AS valorDesconto
FROM TRIBESTORNOPAGAMENTO ESTORNOPAGAMENTO
         JOIN TRIBESTORNOPAGAMENTOITEM ESTORNOPAGAMENTOITEM ON
        ESTORNOPAGAMENTO.ENTIDADE = ESTORNOPAGAMENTOITEM.ENTIDADE AND
        ESTORNOPAGAMENTO.EXERCICIO = ESTORNOPAGAMENTOITEM.EXERCICIO AND
        ESTORNOPAGAMENTO.ESTORNO = ESTORNOPAGAMENTOITEM.ESTORNO
         JOIN TRIBPAGAMENTODEBITO PAGAMENTODEBITO
              ON ESTORNOPAGAMENTOITEM.IDPAGAMENTOBLOQUETO = PAGAMENTODEBITO.IDPAGAMENTOBLOQUETO AND
                 ESTORNOPAGAMENTOITEM.IDDEBITOPARCELARECEITA = PAGAMENTODEBITO.IDDEBITOPARCELARECEITA
         JOIN TRIBDEBITOPARCELARECEITA DEBITOPARCELARECEITA
              ON PAGAMENTODEBITO.IDDEBITOPARCELARECEITA = DEBITOPARCELARECEITA.IDDEBITOPARCELARECEITA
         JOIN CONTABANCARIA ON ESTORNOPAGAMENTO.ENTIDADE = CONTABANCARIA.ENTIDADE AND
                               ESTORNOPAGAMENTO.CONTABANCARIAESTORNO = CONTABANCARIA.CONTABANCARIA
         JOIN TRIBRECEITA RECEITA ON RECEITA.ENTIDADE = DEBITOPARCELARECEITA.ENTIDADE AND
                                     RECEITA.EXERCICIO = DEBITOPARCELARECEITA.EXERCICIO AND
                                     RECEITA.RECEITA = DEBITOPARCELARECEITA.RECEITA
         JOIN TRIBRECEITATIPO TIPORECEITA ON TIPORECEITA.TIPORECEITA = RECEITA.TIPORECEITA
WHERE CONTABANCARIA.INTEGRAARRECADACAO = 'S'
AND ESTORNOPAGAMENTO.DATA between :dataInicio and :dataFim
:FILTRO
GROUP BY RECEITA.DESCRICAO
UNION ALL
--creditos-por-tributo
SELECT RECEITA.DESCRICAO AS tributo,
       SUM(COALESCE(CREDITOCONTRIBUINTEITEM.VALORPRINCIPAL, 0)) AS valorPrincipal,
       SUM(COALESCE(CREDITOCONTRIBUINTEITEM.VALORJUROS, 0)) AS valorJuros,
       SUM(COALESCE(CREDITOCONTRIBUINTEITEM.VALORMULTA, 0)) AS valorMulta,
       SUM(COALESCE(CREDITOCONTRIBUINTEITEM.VALORCORRECAO, 0)) AS valorCorrecao,
       SUM(COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTOPRINCIPAL,0) +
           COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTOJUROS,0) +
           COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTOJUROSFINAN,0) +
           COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTOMULTA,0) +
           COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTOCORRECAO,0)) valorDesconto
FROM TRIBCREDITOCONTRIBUINTE CREDITOCONTRIBUINTE
LEFT JOIN TRIBCREDITOCONTRIBUINTEITEM CREDITOCONTRIBUINTEITEM
        ON CREDITOCONTRIBUINTE.ENTIDADE = CREDITOCONTRIBUINTEITEM.ENTIDADE AND
           CREDITOCONTRIBUINTE.EXERCICIO = CREDITOCONTRIBUINTEITEM.EXERCICIO AND
           CREDITOCONTRIBUINTE.CREDITOCONTRIBUINTE = CREDITOCONTRIBUINTEITEM.CREDITOCONTRIBUINTE
LEFT JOIN CONTABANCARIA
        ON CREDITOCONTRIBUINTE.ENTIDADE = CONTABANCARIA.ENTIDADE AND
           CREDITOCONTRIBUINTE.CONTABANCARIA = CONTABANCARIA.CONTABANCARIA
LEFT JOIN TRIBDEBITOPARCELARECEITA DEBITOPARCELARECEITA
        ON CREDITOCONTRIBUINTEITEM.IDDEBITOPARCELARECEITA = DEBITOPARCELARECEITA.IDDEBITOPARCELARECEITA
LEFT JOIN TRIBRECEITA RECEITA ON DEBITOPARCELARECEITA.ENTIDADE = RECEITA.ENTIDADE AND
                                 DEBITOPARCELARECEITA.EXERCICIO = RECEITA.EXERCICIO AND
                                 DEBITOPARCELARECEITA.RECEITA = RECEITA.RECEITA
LEFT JOIN TRIBRECEITATIPO TIPORECEITA ON RECEITA.TIPORECEITA = TIPORECEITA.TIPORECEITA
WHERE CREDITOCONTRIBUINTE.DATA between :dataInicio and :dataFim
AND CONTABANCARIA.INTEGRAARRECADACAO = 'S'
:FILTRO
GROUP BY RECEITA.DESCRICAO
UNION ALL
--estorno-creditos-por-tributo
SELECT RECEITA.DESCRICAO                                 AS tributo,
       SUM(COALESCE(CREDITOCONTRIBUINTEITEM.VALORPRINCIPAL, 0)) * -1 AS valorPrincipal,
       SUM(COALESCE(CREDITOCONTRIBUINTEITEM.VALORJUROS, 0)) * -1     AS valorJuros,
       SUM(COALESCE(CREDITOCONTRIBUINTEITEM.VALORMULTA, 0)) * -1     AS valorMulta,
       SUM(COALESCE(CREDITOCONTRIBUINTEITEM.VALORCORRECAO, 0)) * -1  AS valorCorrecao,
       CASE
           WHEN SUM(COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTOPRINCIPAL, 0) +
                    COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTOJUROS, 0) +
                    COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTOMULTA, 0) +
                    COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTOCORRECAO, 0)) > 0
               THEN SUM(COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTOPRINCIPAL, 0) +
                        COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTOJUROS, 0) +
                        COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTOMULTA, 0) +
                        COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTOCORRECAO, 0)) * -1
           ELSE SUM(COALESCE(CREDITOCONTRIBUINTEITEM.VALORDESCONTO, 0)) * -1
           END                                                  AS valorDesconto
FROM TRIBCREDITOCONTRIBUINTE CREDITOCONTRIBUINTE
         LEFT OUTER JOIN TRIBCREDITOCONTRIBUINTEITEM CREDITOCONTRIBUINTEITEM
                         ON CREDITOCONTRIBUINTE.ENTIDADE = CREDITOCONTRIBUINTEITEM.ENTIDADE AND
                            CREDITOCONTRIBUINTE.EXERCICIO = CREDITOCONTRIBUINTEITEM.EXERCICIO AND
                            CREDITOCONTRIBUINTE.CREDITOCONTRIBUINTE = CREDITOCONTRIBUINTEITEM.CREDITOCONTRIBUINTE
         LEFT OUTER JOIN CONTABANCARIA ON CREDITOCONTRIBUINTE.ENTIDADE = CONTABANCARIA.ENTIDADE AND
                                          CREDITOCONTRIBUINTE.CONTABANCARIA = CONTABANCARIA.CONTABANCARIA
         LEFT OUTER JOIN TRIBDEBITOPARCELARECEITA DEBITOPARCELARECEITA
                         ON CREDITOCONTRIBUINTEITEM.IDDEBITOPARCELARECEITA = DEBITOPARCELARECEITA.IDDEBITOPARCELARECEITA
         LEFT OUTER JOIN TRIBRECEITA RECEITA ON DEBITOPARCELARECEITA.ENTIDADE = RECEITA.ENTIDADE AND
                                                DEBITOPARCELARECEITA.EXERCICIO = RECEITA.EXERCICIO AND
                                                DEBITOPARCELARECEITA.RECEITA = RECEITA.RECEITA
         LEFT OUTER JOIN TRIBRECEITATIPO TIPORECEITA ON RECEITA.TIPORECEITA = TIPORECEITA.TIPORECEITA
WHERE CREDITOCONTRIBUINTE.DATAESTORNO between :dataInicio and :dataFim
AND CONTABANCARIA.INTEGRAARRECADACAO = 'S'
AND EXISTS(SELECT 1
         FROM TRIBCREDITOCONTRIBUINTEITEMMOV CREDITOCONTRIBUINTEITEMMOV
         WHERE CREDITOCONTRIBUINTEITEMMOV.IDCREDITOCONTRIBUINTEITEM =
               CREDITOCONTRIBUINTEITEM.IDCREDITOCONTRIBUINTEITEM
           AND CREDITOCONTRIBUINTEITEMMOV.TIPO = 'E')
:FILTRO
GROUP BY RECEITA.DESCRICAO
UNION ALL
--reabilitacao-estorno-pagamentos-por-tributo
SELECT RECEITA.DESCRICAO                     AS tributo,
       SUM(COALESCE(PAGAMENTODEBITO.VALORPRINCIPAL, 0) * -1) AS valorPrincipal,
       SUM(COALESCE(PAGAMENTODEBITO.VALORJUROS, 0) * -1)     AS valorJuros,
       SUM(COALESCE(PAGAMENTODEBITO.VALORMULTA, 0) * -1)     AS valorMulta,
       SUM(COALESCE(PAGAMENTODEBITO.VALORCORRECAO, 0) * -1)  AS valorCorrecao,
       CASE
           WHEN SUM(COALESCE(PAGAMENTODEBITO.VALORDESCONTOPRINCIPAL, 0) +
                    COALESCE(PAGAMENTODEBITO.VALORDESCONTOJUROS, 0) +
                    COALESCE(PAGAMENTODEBITO.VALORDESCONTOMULTA, 0)
               + COALESCE(VALORDESCONTOCORRECAO, 0)) > 0
               THEN SUM(COALESCE(PAGAMENTODEBITO.VALORDESCONTOPRINCIPAL, 0) +
                        COALESCE(PAGAMENTODEBITO.VALORDESCONTOJUROS, 0) +
                        COALESCE(PAGAMENTODEBITO.VALORDESCONTOMULTA, 0) +
                        COALESCE(VALORDESCONTOCORRECAO, 0)) * -1
           ELSE SUM(COALESCE(PAGAMENTODEBITO.VALORDESCONTO, 0) * -1)
           END                                          AS valorDesconto
FROM TRIBESTORNOPAGAMENTO ESTORNOPAGAMENTO
         LEFT OUTER JOIN TRIBESTORNOPAGAMENTOITEM ESTORNOPAGAMENTOITEM
                         ON ESTORNOPAGAMENTO.ENTIDADE = ESTORNOPAGAMENTOITEM.ENTIDADE AND
                            ESTORNOPAGAMENTO.EXERCICIO = ESTORNOPAGAMENTOITEM.EXERCICIO AND
                            ESTORNOPAGAMENTO.ESTORNO = ESTORNOPAGAMENTOITEM.ESTORNO
         LEFT OUTER JOIN TRIBPAGAMENTODEBITO PAGAMENTODEBITO
                         ON ESTORNOPAGAMENTOITEM.IDPAGAMENTOBLOQUETO = PAGAMENTODEBITO.IDPAGAMENTOBLOQUETO AND
                            ESTORNOPAGAMENTOITEM.IDDEBITOPARCELARECEITA = PAGAMENTODEBITO.IDDEBITOPARCELARECEITA
         LEFT OUTER JOIN CONTABANCARIA
         				 ON CONTABANCARIA.ENTIDADE = ESTORNOPAGAMENTO.ENTIDADE AND
         				    CONTABANCARIA.CONTABANCARIA = ESTORNOPAGAMENTO.CONTABANCARIAESTORNO
         LEFT OUTER JOIN TRIBDEBITOPARCELARECEITA DEBITOPARCELARECEITA
                         ON PAGAMENTODEBITO.IDDEBITOPARCELARECEITA = DEBITOPARCELARECEITA.IDDEBITOPARCELARECEITA
         LEFT OUTER JOIN TRIBRECEITA RECEITA
                         ON RECEITA.ENTIDADE = DEBITOPARCELARECEITA.ENTIDADE AND
                            RECEITA.EXERCICIO = DEBITOPARCELARECEITA.EXERCICIO AND
                            RECEITA.RECEITA = DEBITOPARCELARECEITA.RECEITA
WHERE ESTORNOPAGAMENTO.DATAREABILITACAO between :dataInicio and :dataFim
  AND ESTORNOPAGAMENTO.REABILITADO = 'S'
:FILTRO
GROUP BY RECEITA.DESCRICAO
UNION ALL
--devolucao-creditos
SELECT RECEITA.DESCRICAO                    AS tributo,
       SUM(COALESCE(DEVOLUCAOCREDITODEBITO.VALORDEVOLVIDO, 0)) * -1 AS valorPrincipal,
       SUM(COALESCE(DEVOLUCAOCREDITODEBITO.VALORJUROS, 0)) * -1  	AS valorJuros,
       SUM(COALESCE(DEVOLUCAOCREDITODEBITO.VALORMULTA, 0)) * -1     AS valorMulta,
       SUM(COALESCE(DEVOLUCAOCREDITODEBITO.VALORCORRECAO, 0)) * -1  AS valorCorrecao,
       CASE
           WHEN SUM(COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOPRINCIPAL, 0) +
                    COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOJUROS, 0) +
                    COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOMULTA, 0) +
                    COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOCORRECAO, 0)) > 0
           THEN SUM(COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOPRINCIPAL, 0) +
                    COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOJUROS, 0) +
                    COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOMULTA, 0) +
                    COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOCORRECAO, 0)) * -1
           ELSE SUM(COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTO, 0)) * -1
           END                                    AS valorDesconto
FROM TRIBDEVOLUCAOCREDITO DEVOLUCAOCREDITO
         JOIN TRIBDEVOLUCAOCREDITOITEM DEVOLUCAOCREDITOITEM
                   ON DEVOLUCAOCREDITOITEM.IDDEVOLUCAOCREDITO = DEVOLUCAOCREDITO.IDDEVOLUCAOCREDITO
         JOIN TRIBDEVOLUCAOCREDITODEBITO DEVOLUCAOCREDITODEBITO
                   ON DEVOLUCAOCREDITODEBITO.IDDEVOLUCAOCREDITO = DEVOLUCAOCREDITOITEM.IDDEVOLUCAOCREDITO AND
                      DEVOLUCAOCREDITODEBITO.SEQUENCIAITEM = DEVOLUCAOCREDITOITEM.SEQUENCIAITEM
		 JOIN CONTABANCARIA
		 		   ON CONTABANCARIA.ENTIDADE = DEVOLUCAOCREDITO.ENTIDADE AND
					  CONTABANCARIA.CONTABANCARIA = DEVOLUCAOCREDITO.CONTABANCARIA
         JOIN TRIBDEBITOPARCELARECEITA DEBITOPARCELARECEITA
                   ON DEVOLUCAOCREDITODEBITO.IDDEBITOPARCELARECEITA = DEBITOPARCELARECEITA.IDDEBITOPARCELARECEITA
         JOIN TRIBRECEITA RECEITA
                   ON RECEITA.ENTIDADE = DEBITOPARCELARECEITA.ENTIDADE AND
                      RECEITA.EXERCICIO = DEBITOPARCELARECEITA.EXERCICIO AND
                      RECEITA.RECEITA = DEBITOPARCELARECEITA.RECEITA
WHERE DEVOLUCAOCREDITO.DATA between :dataInicio and :dataFim
:FILTRO
GROUP BY RECEITA.DESCRICAO
UNION ALL
--estorno-devolucao-creditos
SELECT RECEITA.DESCRICAO                            AS tributo,
       SUM(COALESCE(DEVOLUCAOCREDITODEBITO.VALORDEVOLVIDO, 0)) AS valorPrincipal,
       SUM(COALESCE(DEVOLUCAOCREDITODEBITO.VALORJUROS, 0))     AS valorJuros,
       SUM(COALESCE(DEVOLUCAOCREDITODEBITO.VALORMULTA, 0))     AS valorMulta,
       SUM(COALESCE(DEVOLUCAOCREDITODEBITO.VALORCORRECAO, 0))  AS valorCorrecao,
       CASE
           WHEN SUM(COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOPRINCIPAL, 0) +
                    COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOJUROS, 0) +
                    COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOMULTA, 0) +
                    COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOCORRECAO, 0)) > 0
               THEN SUM(COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOPRINCIPAL, 0) +
                        COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOJUROS, 0) +
                        COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOMULTA, 0) +
                        COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTOCORRECAO, 0))
           ELSE SUM(COALESCE(DEVOLUCAOCREDITODEBITO.VALORDESCONTO, 0))
           END                                         AS VALORDESCONTO
FROM TRIBDEVOLUCAOCREDITO DEVOLUCAOCREDITO
         LEFT JOIN TRIBDEVOLUCAOCREDITOITEM DEVOLUCAOCREDITOITEM
                   ON DEVOLUCAOCREDITOITEM.IDDEVOLUCAOCREDITO = DEVOLUCAOCREDITO.IDDEVOLUCAOCREDITO
         LEFT JOIN TRIBDEVOLUCAOCREDITODEBITO DEVOLUCAOCREDITODEBITO
                   ON DEVOLUCAOCREDITODEBITO.IDDEVOLUCAOCREDITO = DEVOLUCAOCREDITOITEM.IDDEVOLUCAOCREDITO AND
                      DEVOLUCAOCREDITODEBITO.SEQUENCIAITEM = DEVOLUCAOCREDITOITEM.SEQUENCIAITEM
		 LEFT JOIN CONTABANCARIA
		 		   ON CONTABANCARIA.ENTIDADE = DEVOLUCAOCREDITO.ENTIDADE AND
					  CONTABANCARIA.CONTABANCARIA = DEVOLUCAOCREDITO.CONTABANCARIA
         LEFT JOIN TRIBDEBITOPARCELARECEITA DEBITOPARCELARECEITA
                   ON DEVOLUCAOCREDITODEBITO.IDDEBITOPARCELARECEITA = DEBITOPARCELARECEITA.IDDEBITOPARCELARECEITA
         LEFT JOIN TRIBRECEITA RECEITA
                   ON RECEITA.ENTIDADE = DEBITOPARCELARECEITA.ENTIDADE AND
                      RECEITA.EXERCICIO = DEBITOPARCELARECEITA.EXERCICIO AND
                      RECEITA.RECEITA = DEBITOPARCELARECEITA.RECEITA
         LEFT OUTER JOIN TRIBRECEITATIPO TIPORECEITA
                         ON RECEITA.TIPORECEITA = TIPORECEITA.TIPORECEITA
WHERE DEVOLUCAOCREDITO.DATA between :dataInicio and :dataFim
AND DEVOLUCAOCREDITO.DATACANCELAMENTO IS NOT NULL
:FILTRO
GROUP BY RECEITA.DESCRICAO