 select deb.entidade,
        deb.exercicio,
        deb.tipocadastro,
        deb.cadastrogeral,
        deb.guiarecolhimento as divida,
        deb.subdivida,
        deb.iddebito,
        SUM(rec.valor + rec.valorjuros + rec.valormulta + rec.valorcorrecao - rec.valordesconto) AS valorTotal,
        guia.descricao as descricaoDivida
 from tribdebito deb
 inner join tribdebitoparcela par
         on deb.entidade         = par.entidade
        and deb.exercicio        = par.exercicio
        and deb.tipocadastro     = par.tipocadastro
        and deb.cadastrogeral    = par.cadastrogeral
        and deb.guiarecolhimento = par.guiarecolhimento
        and deb.subdivida        = par.subdivida
 inner join tribsituacaoparcela sit
         on sit.situacaoparcela     = par.situacaodebito
 inner join tribdebitoparcelareceita rec
         on par.entidade         = rec.entidade
        and par.exercicio        = rec.exercicio
        and par.tipocadastro     = rec.tipocadastro
        and par.cadastrogeral    = rec.cadastrogeral
        and par.guiarecolhimento = rec.guiarecolhimento
        and par.subdivida        = rec.subdivida
        and par.parcela          = rec.parcela
 inner join tribguiarecolhimento guia
         on deb.entidade         = guia.entidade
        and deb.exercicio        = guia.exercicio
        and deb.guiarecolhimento = guia.guiarecolhimento
 where deb.entidade           = :entidade
 AND   deb.exercicio          = :exercicio
 AND   deb.tipoCadastro       = :tipoCadastro
 AND   deb.cadastroGeral      = :cadastroGeral
 AND   deb.constituido        = 'S'
 AND   sit.tiposituacaoparcela = 1
 AND exists (select 1
              from tribdebitoparcela debpar
             where deb.entidade         = debpar.entidade
               and deb.exercicio        = debpar.exercicio
               and deb.tipocadastro     = debpar.tipocadastro
               and deb.cadastrogeral    = debpar.cadastrogeral
               and deb.guiarecolhimento = debpar.guiarecolhimento
               and deb.subdivida        = debpar.subdivida
               and debpar.datavencimento  >= CURRENT_DATE)
 AND exists (select 1
          from tribguiarecolhimentoformapag dfp
         where dfp.entidade = deb.entidade
           and dfp.exercicio = deb.exercicio
           and dfp.guiarecolhimento = deb.guiarecolhimento
           and dfp.disponivelweb = 'S'
           and dfp.vencimento >= CURRENT_DATE)
           and deb.parcelado = 'N'
           and deb.reparcelado = 'N'

GROUP BY deb.entidade,
        deb.exercicio,
        deb.tipocadastro,
        deb.cadastrogeral,
        deb.guiarecolhimento,
        deb.subdivida,
        deb.iddebito,
        guia.descricao
ORDER BY deb.subdivida
