select x.Entidade,
      x.Identificacao,
      x.Banco,
      x.DataAutorizacao,
      x.FormaPagamento,
      x.iddebito,
      x.TipoCadastro,
      x.CadastroGeral,
      x.Exercicio,
      x.GuiaRecolhimento,
      x.SubDivida,
      x.parcela,
      x.DataVencimento,
      x.tipoFormaPagamento,
      x.pessoa,
      x.DataPrimeiraParcela
from (
Select
      tdao.Entidade,
      tdao.Identificacao,
      tdao.Banco,
      tdao.DataAutorizacao,
      tfp.FormaPagamento,
      tdeb.iddebito,
      tdao.TipoCadastro,
      tdao.CadastroGeral,
      tdao.Exercicio,
      tdao.GuiaRecolhimento,
      tdao.SubDivida,
      tdp.parcela,
      tdp.DataVencimento,
      tfp.tipoFormaPagamento,
      tcg.pessoa,
      tdeb.DataPrimeiraParcela,
      tdao.convenio
from TribDebitoAutomaticoOpcao tdao
left join TribDebito tdeb
 on tdao.Entidade = tdeb.Entidade
and tdao.Exercicio = tdeb.Exercicio
and tdao.TipoCadastro = tdeb.TipoCadastro
and tdao.CadastroGeral = tdeb.CadastroGeral
and tdao.GuiaRecolhimento = tdeb.GuiaRecolhimento
and tdao.SubDivida = tdeb.SubDivida
left join TribDebitoParcela tdp
 on tdeb.Entidade = tdp.Entidade
and tdeb.Exercicio = tdp.Exercicio
and tdeb.TipoCadastro = tdp.TipoCadastro
and tdeb.CadastroGeral = tdp.CadastroGeral
and tdeb.GuiaRecolhimento = tdp.GuiaRecolhimento
and tdeb.SubDivida = tdp.SubDivida
left join TribSituacaoParcela tsp
 on tdp.SituacaoDebito = tsp.SituacaoParcela
left join TribTipoSituacaoParcela ttsp
 on tsp.tiposituacaoparcela = ttsp.tiposituacaoparcela
left join TribCadastroGeral tcg
 on tdp.TipoCadastro = tcg.TipoCadastro
and tdp.CadastroGeral = tcg.CadastroGeral
left join TribFormaPagamento tfp
 on tdao.FormaPagamento = tfp.FormaPagamento
left join tribguiarecolhimentoformapag gfp
 on tdeb.entidade = gfp.entidade
and tdeb.exercicio = gfp.exercicio
and tdeb.guiarecolhimento = gfp.guiarecolhimento
and gfp.formapagamento = tdao.FormaPagamento
Where tfp.tipoFormaPagamento <> 'U'
and tdao.dataExclusao is null
and ttsp.tipo = 'A'
and not exists (select 1
                from tribremdebitoautomaticodetalhe rem
                where rem.entidade         = tdp.entidade
                and   rem.exercicio        = tdp.exercicio
                and   rem.tipocadastro     = tdp.tipocadastro
                and   rem.cadastrogeral    = tdp.cadastrogeral
                and   rem.guiarecolhimento = tdp.guiarecolhimento
                and   rem.subdivida        = tdp.subdivida
                and   ((rem.parcela is not null and rem.parcela= tdp.parcela) or rem.parcela is null))
union all
Select
      tdao.Entidade,
      tdao.Identificacao,
      tdao.Banco,
      tdao.DataAutorizacao,
      tfp.FormaPagamento,
      tdeb.iddebito,
      tdao.TipoCadastro,
      tdao.CadastroGeral,
      tdao.Exercicio,
      tdao.GuiaRecolhimento,
      tdao.SubDivida,
      null as parcela,
      gfp.vencimento as DataVencimento,
      tfp.tipoFormaPagamento,
      tcg.pessoa,
      tdeb.DataPrimeiraParcela,
      tdao.convenio
from TribDebitoAutomaticoOpcao tdao
left join TribDebito tdeb
on tdao.Entidade = tdeb.Entidade
and tdao.Exercicio = tdeb.Exercicio
and tdao.TipoCadastro = tdeb.TipoCadastro
and tdao.CadastroGeral = tdeb.CadastroGeral
and tdao.GuiaRecolhimento = tdeb.GuiaRecolhimento
and tdao.SubDivida = tdeb.SubDivida
left join TribDebitoParcela tdp
on tdeb.Entidade = tdp.Entidade
and tdeb.Exercicio = tdp.Exercicio
and tdeb.TipoCadastro = tdp.TipoCadastro
and tdeb.CadastroGeral = tdp.CadastroGeral
and tdeb.GuiaRecolhimento = tdp.GuiaRecolhimento
and tdeb.SubDivida = tdp.SubDivida
left join TribSituacaoParcela tsp
 on tdp.SituacaoDebito = tsp.SituacaoParcela
left join TribTipoSituacaoParcela ttsp
 on tsp.tiposituacaoparcela = ttsp.tiposituacaoparcela
left join TribCadastroGeral tcg
 on tdp.TipoCadastro = tcg.TipoCadastro
and tdp.CadastroGeral = tcg.CadastroGeral
left join TribFormaPagamento tfp
 on tdao.FormaPagamento = tfp.FormaPagamento
left join tribguiarecolhimentoformapag gfp
 on tdeb.entidade = gfp.entidade
and tdeb.exercicio = gfp.exercicio
and tdeb.guiarecolhimento = gfp.guiarecolhimento
and gfp.formapagamento = tdao.FormaPagamento
Where tfp.tipoFormaPagamento = 'U'
and tdao.dataExclusao is null
and ttsp.tipo = 'A'
and not exists (select 1
                from tribremdebitoautomaticodetalhe rem
                where rem.entidade         = tdp.entidade
                and   rem.exercicio        = tdp.exercicio
                and   rem.tipocadastro     = tdp.tipocadastro
                and   rem.cadastrogeral    = tdp.cadastrogeral
                and   rem.guiarecolhimento = tdp.guiarecolhimento
                and   rem.subdivida        = tdp.subdivida
                and   ((rem.parcela is not null and rem.parcela= tdp.parcela) or rem.parcela is null))
group by tdao.Entidade,
      tdao.Identificacao,
      tdao.Banco,
      tdao.DataAutorizacao,
      tfp.FormaPagamento,
      tdeb.iddebito,
      tdao.TipoCadastro,
      tdao.CadastroGeral,
      tdao.Exercicio,
      tdao.GuiaRecolhimento,
      tdao.SubDivida,
      gfp.vencimento,
      tfp.tipoFormaPagamento,
      tcg.pessoa,
      tdeb.DataPrimeiraParcela,
      tdao.convenio
) x
where x.Entidade = 1
 $[FILTROS]
order by x.tipocadastro, x.cadastrogeral, x.exercicio, x.guiarecolhimento, x.subDivida, x.datavencimento