select
    tdpr.iddebitoparcelareceita as idDebitoParcelaReceita,
    tdp.parcela as parcela,
    td.iddebito as idDebito,
    tlr.valor as valor,
    tlr.valorjuros as valorJuros,
    tlr.valormulta as valorMulta,
    tlr.valorcorrecao as valorCorrecao
from tribdebito td
    left join tribdebitoparcela tdp on
        td.entidade = tdp.entidade and
        td.exercicio = tdp.exercicio and
        td.tipocadastro = tdp.tipocadastro and
        td.cadastrogeral = tdp.cadastrogeral and
        td.guiarecolhimento = tdp.guiarecolhimento and
        td.subdivida = tdp.subdivida
    left join tribdebitoparcelareceita tdpr on
        tdpr.entidade = tdp.entidade and
        tdpr.exercicio = tdp.exercicio and
        tdpr.tipocadastro = tdp.tipocadastro and
        tdpr.cadastrogeral = tdp.cadastrogeral and
        tdpr.guiarecolhimento = tdp.guiarecolhimento and
        tdpr.subdivida = tdp.subdivida and
        tdpr.parcela = tdp.parcela
    left join triblivroparcelareceita tlr on
        tlr.entidade = tdpr.entidade and
        tlr.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
     left outer join TribLivro li on li.Entidade = tlr.Entidade
                                        and li.Exercicio = tlr.Exercicio
                                        and li.Livro = tlr.Livro
where tdpr.tipocadastro = :tipoCadastro
  and tdpr.cadastrogeral = :cadastroGeral
  and tlr.livro = :livro
  and tlr.exercicio = :exercicio
  and li.tipolivro = 'EFETIVO'
