SELECT
    deb.IDDEBITO,
    dpr.ENTIDADE,
    dpr.EXERCICIO,
    dpr.TIPOCADASTRO,
    dpr.CADASTROGERAL,
    dpr.GUIARECOLHIMENTO as DIVIDA,
    dpr.SUBDIVIDA,
    dpr.PARCELA,
    sum(dpr.VALOR) as VALOR,
    p.SITUACAOLEGAL,
    ARRAY_AGG(DPR.IDDEBITOPARCELARECEITA) AS IDDEBITOPARCELARECEITAS
FROM TRIBDEBITOPARCELARECEITA dpr
INNER JOIN TRIBDEBITO deb
    ON dpr.ENTIDADE = deb.ENTIDADE
    AND dpr.EXERCICIO = deb.EXERCICIO
    AND dpr.TIPOCADASTRO = deb.TIPOCADASTRO
    AND dpr.CADASTROGERAL = deb.CADASTROGERAL
    AND dpr.GUIARECOLHIMENTO = deb.GUIARECOLHIMENTO
    AND dpr.SUBDIVIDA = deb.SUBDIVIDA
INNER JOIN TRIBDEBITOPARCELA p
    ON p.entidade = dpr.entidade
    AND p.EXERCICIO = dpr.EXERCICIO
    AND p.TIPOCADASTRO = dpr.TIPOCADASTRO
    AND p.CADASTROGERAL = dpr.CADASTROGERAL
    AND p.GUIARECOLHIMENTO = dpr.GUIARECOLHIMENTO
    AND p.SUBDIVIDA = dpr.SUBDIVIDA
    AND p.PARCELA = dpr.PARCELA
INNER JOIN TRIBSITUACAOPARCELA s
    ON s.SITUACAOPARCELA = p.SITUACAODEBITO
INNER JOIN TRIBTIPOSITUACAOPARCELA ts
    ON ts.TIPOSITUACAOPARCELA = s.TIPOSITUACAOPARCELA
INNER JOIN TRIBCADASTROGERAL cg
    ON cg.TIPOCADASTRO = deb.tipoCadastro
    AND cg.cadastroGeral = deb.cadastroGeral
WHERE dpr.entidade = :entidade
    AND dpr.TIPOCADASTRO = :tipoCadastro
    AND dpr.VALOR > 0
    AND ts.TIPO = 'A'
    AND p.SITUACAOLEGAL IN (:situacoesLegais)
    AND cg.EXCLUSAOLOGICA = 'N'
    $[FILTROS]
GROUP BY
    deb.IDDEBITO,
    dpr.ENTIDADE,
    dpr.EXERCICIO,
    dpr.TIPOCADASTRO,
    dpr.CADASTROGERAL,
    dpr.GUIARECOLHIMENTO,
    dpr.SUBDIVIDA,
    dpr.PARCELA,
    p.SITUACAOLEGAL
ORDER BY
    dpr.ENTIDADE,
    dpr.EXERCICIO,
    dpr.TIPOCADASTRO,
    dpr.CADASTROGERAL,
    dpr.GUIARECOLHIMENTO,
    dpr.SUBDIVIDA,
    dpr.PARCELA;
