select tribparcelamento.idparcelamento,
tribparcelamento.numerocontrato,
tribparcelamento.anocontrato,
tribparcelamento.dataparcelamento,
tribparcelamento.tipocadastro,
tribparcelamento.cadastrogeral,
tribparcelamento.tipo as tipocontrato,
tribparamparcelamento.descricao as parametro,
situacao.descricao as situacao,
pessoa.nome,
(select count(distinct b.bloqueto) as total
	from tribparcelamentodebitoorigem tribparcelamentodebitoorigem
	left join tribdebito tribdebito on tribdebito.iddebito = tribparcelamentodebitoorigem.iddebitonovo
	left join tribdebitoparcelareceita dpr on tribdebito.entidade = dpr.entidade
	and tribdebito.exercicio = dpr.exercicio
	and tribdebito.tipocadastro = dpr.tipocadastro
	and tribdebito.cadastrogeral = dpr.cadastrogeral
	and tribdebito.guiarecolhimento = dpr.guiarecolhimento
	and tribdebito.subdivida = dpr.subdivida
	left join tribbloquetodebito bd on dpr.iddebitoparcelareceita = bd.iddebitoparcelareceita
	left join tribbloqueto b on bd.entidade = b.entidade
	and bd.exerciciobloqueto = b.exerciciobloqueto
	and bd.bloqueto = b.bloqueto
	left join tribcadastrogeral cg on b.tipocadastro = cg.tipocadastro
	and b.cadastrogeral = cg.cadastrogeral
	left join pessoa p on cg.pessoa = p.pessoa
	where b.entidade = :entidade
	and b.datavencimento >= cast(now() as date)
	and tribparcelamentodebitoorigem.idparcelamento = tribparcelamento.idparcelamento
) as totalbloquetosavencer,
(select max(case when dp.situacaolegal not in (0, 1) then 1 else 0 end) as existedebitojudicial
    from tribparcelamentodebitoorigem tribparcelamentodebitoorigem
    left outer join tribdebito tribdebito on tribdebito.iddebito = tribparcelamentodebitoorigem.iddebitonovo
    left outer join tribdebitoparcela dp on tribdebito.entidade = dp.entidade
    and tribdebito.exercicio = dp.exercicio
    and tribdebito.tipocadastro = dp.tipocadastro
    and tribdebito.cadastrogeral = dp.cadastrogeral
    and tribdebito.guiarecolhimento = dp.guiarecolhimento
    and tribdebito.subdivida = dp.subdivida
    where  tribparcelamentodebitoorigem.idparcelamento = tribparcelamento.idparcelamento
) as existedebitojudicial
from tribparcelamento tribparcelamento
join tribparamparcelamento tribparamparcelamento on tribparcelamento.idparametroparcelamento = tribparamparcelamento.idparametroparcelamento
join tribcadastrogeral tribcadastrogeral on tribparcelamento.tipocadastro = tribcadastrogeral.tipocadastro
and tribparcelamento.cadastrogeral = tribcadastrogeral.cadastrogeral
join pessoa pessoa on tribcadastrogeral.pessoa = pessoa.pessoa
join tribsituacaoparcelamento situacao on tribparcelamento.situacao = situacao.situacao
join tribparcelamentodebitoorigem tribparcelamentodebitoorigem on tribparcelamento.idparcelamento = tribparcelamentodebitoorigem.idparcelamento
join tribdebito tribdebito on tribparcelamentodebitoorigem.iddebitonovo = tribdebito.iddebito
join tribdebitoparcela tribdebitoparcela on tribdebito.entidade = tribdebitoparcela.entidade
and tribdebito.exercicio = tribdebitoparcela.exercicio
and tribdebito.tipocadastro = tribdebitoparcela.tipocadastro
and tribdebito.cadastrogeral = tribdebitoparcela.cadastrogeral
and tribdebito.guiarecolhimento = tribdebitoparcela.guiarecolhimento
and tribdebito.subdivida = tribdebitoparcela.subdivida
join tribdebitoparcelareceita tribdebitoparcelareceita on tribdebitoparcela.entidade = tribdebitoparcelareceita.entidade
and tribdebitoparcela.exercicio = tribdebitoparcelareceita.exercicio
and tribdebitoparcela.tipocadastro = tribdebitoparcelareceita.tipocadastro
and tribdebitoparcela.cadastrogeral = tribdebitoparcelareceita.cadastrogeral
and tribdebitoparcela.guiarecolhimento = tribdebitoparcelareceita.guiarecolhimento
and tribdebitoparcela.subdivida = tribdebitoparcelareceita.subdivida
and tribdebitoparcela.parcela = tribdebitoparcelareceita.parcela
left join tribbloquetodebito tribbloquetodebito on tribdebitoparcelareceita.iddebitoparcelareceita = tribbloquetodebito.iddebitoparcelareceita
left join tribbloqueto tribbloqueto on tribbloquetodebito.entidade = tribbloqueto.entidade
and tribbloquetodebito.exerciciobloqueto = tribbloqueto.exerciciobloqueto
and tribbloquetodebito.bloqueto = tribbloqueto.bloqueto
left join tribsituacaoparcela tribsituacaoparcela on tribdebitoparcela.situacaodebito = tribsituacaoparcela.situacaoparcela
where tribparcelamento.estornado = 'N'
and tribparcelamento.entidade = :entidade
and tribsituacaoparcela.tiposituacaoparcela <> 22
and ((
	select count(tribdebitoparcela.parcela)
	from tribdebitoparcela tribdebitoparcela
	left join tribsituacaoparcela tribsituacaoparcela on tribsituacaoparcela.situacaoparcela = tribdebitoparcela.situacaodebito
	left join tribtiposituacaoparcela tribtiposituacaoparcela on tribtiposituacaoparcela.tiposituacaoparcela = tribsituacaoparcela.tiposituacaoparcela
	where tribdebitoparcela.entidade = tribdebito.entidade
	and tribdebitoparcela.exercicio = tribdebito.exercicio
	and tribdebitoparcela.tipocadastro = tribdebito.tipocadastro
	and tribdebitoparcela.cadastrogeral = tribdebito.cadastrogeral
	and tribdebitoparcela.guiarecolhimento = tribdebito.guiarecolhimento
	and tribdebitoparcela.subdivida = tribdebito.subdivida
	and tribdebitoparcela.datavencimento < :DataVencimento
	and tribtiposituacaoparcela.tipo = 'A'
) >= (
	select tpp.numeroparcelasvencidas
	from tribparcelamento par
	join tribparamparcelamento tpp on (par.idparametroparcelamento = tpp.idparametroparcelamento)
	where par.idparcelamento = tribparcelamento.idparcelamento
))
$[FiltroDesfazerParcelamento]
group by tribparcelamento.idparcelamento,
tribparcelamento.numerocontrato,
tribparcelamento.anocontrato,
tribparcelamento.dataparcelamento,
tribparcelamento.tipocadastro,
tribparcelamento.cadastrogeral,
tribparcelamento.tipo,
tribparamparcelamento.descricao,
situacao.descricao,
pessoa.nome