select
	td.Entidade,
	td.TipoCadastro,
	td.CadastroGeral,
	td.Exercicio,
	td.IdDebito,
	td.GuiaRecolhimento as Divida,
	tgr.Descricao as DescricaoDivida,
	td.SubDivida,
	tdp.Parcela,
	tdpr.Receita as Tributo,
	td.DataCorrecao,
	td.DataCorrecaoIGPM,
	td.leiRefis,
	td.DataLancamento,
	tdp.DataVencimento,
	tdp.SituacaoDebito,
	tdp.SituacaoLegal,
	tdp.DataSituacao,
    tdpr.Valor as ValorPrincipal,
	tdr.ValorReceita,
	tdr.ValorRenuncia,
	0.00 as ValorJuros,
	0.00 as ValorMulta,
	0.00 as ValorCorrecao,
	0.00 as ValorDesconto,
	0.00 as ValorDescontoPrincipal,
	0.00 as ValorDescontoJuros,
	0.00 as ValorDescontoMulta,
	0.00 as ValorDescontoCorrecao,
	0.00 as ValorAtualizacao,
	td.FormaCorrecao FormaCorrecaoDebito,
	tec.FormaCorrecao FormaCorrecaoPadrao,
	tsp.TipoSituacaoParcela,
	fc.Descricao as DescricaoFormaCorrecao,
	tr.Descricao as DescricaoReceita,
	tsp.Sigla as situacaoDebitoSigla,
	case when  td.Parcelado = 'S' then 1 else 0 end as Parcelado,
	case when  td.Reparcelado = 'S' then 1 else 0 end as Reparcelado,
	ttsp.Tipo,
	td.FormaCorrecao,
	td.DataPrimeiraParcela MinDataVencimentoParcela,
	td.DataPrimeiraParcela,
	td.DescontoLei2004 as DescontoParcelamento,
	td.DescontoMultaPagtoEmDia as DescontoMultaParcelamento,
	td.DescontoJurosPagtoEmDia as DescontoJurosParcelamento,
	td.DescontoJurosFinanPagtoEmDia as DescontoJurosFinanParcelamento,
	case when  tgr.EmiteBloqueto = 'S' then 1 else 0 end as emiteBoleto,
	tgr.TipoGuiaRecolhimento,
	td.IdParcelamento,
	td.IdReparcelamento,
	tp.NumeroContrato as numeroParcelamento,
        tp.AnoContrato as exercicioParcelamento,
	tp.Tipo as TipoParcelamento,
	case when coalesce(tp.porContribuinte,'N') = 'S' then 1 else 0 end as porContribuinte,
	tcg.Pessoa,
	tsp.Descricao as SituacaoDebitoDescricao,
	tdp.IDProtesto,
	tdida.exercicio exercicioCDA,
	tdida.documento CDA,
	coalesce(td.NoProcessoComumUnica,
                cast(tdp.ProcessoJudicial as varchar(30))) as NoProcessoComumUnica,
	tdp.ProcessoAnulatoria,
	coalesce(tpp.formapagamento, :formapagamento) as formapagamento,
	coalesce(tpp.modelobloqueto, grfp.modelobloqueto) as modelobloqueto,
	coalesce(c.convenio, c1.convenio) as convenio,
	tpp.idparametroparcelamento,
	(
	select
		case
			ESTORNADO when 'N' then 'S'
			else 'N'
		end
	from
		TRIBESTORNOPARCELAMENTO ESTORNOPARC
	where
		ESTORNOPARC.IDESTORNOPARCELAMENTO = (
		select
			MAX(IDESTORNOPARCELAMENTO)
		from
			TRIBESTORNOPARCELAMENTODEBITO ESTORNOPARCDEB
		where
			ESTORNOPARCDEB.IDDEBITODESTINO = TD.IDDEBITO)) ESTORNADO,
    concat(substring(tc.descricao, 10 )::text,': ', td.cadastroGeral::text) as identificadorCadastro,
    tr.classificacao as classificacaotributo,
    trt.classificacaoreceitatipo as classificacaotipotributo,
    tgr.datalimitevencimentoboleto as datalimitevencimentoboleto
from tribDebitoParcelaReceita tdpr
left outer join tribDebitoReceita tdr
 on tdpr.Entidade = tdr.Entidade
and tdpr.Exercicio = tdr.Exercicio
and tdpr.TipoCadastro = tdr.TipoCadastro
and tdpr.CadastroGeral = tdr.CadastroGeral
and tdpr.GuiaRecolhimento = tdr.GuiaRecolhimento
and tdpr.SubDivida = tdr.SubDivida
and tdpr.receita = tdr.receita
left outer join tribDebitoParcela tdp
 on	tdpr.Entidade = tdp.Entidade
and tdpr.Exercicio = tdp.Exercicio
and tdpr.TipoCadastro = tdp.TipoCadastro
and tdpr.CadastroGeral = tdp.CadastroGeral
and tdpr.GuiaRecolhimento = tdp.GuiaRecolhimento
and tdpr.SubDivida = tdp.SubDivida
and tdpr.Parcela = tdp.Parcela
left outer join tribDebito td
 on td.Entidade = tdp.Entidade
and td.Exercicio = tdp.Exercicio
and td.TipoCadastro = tdp.TipoCadastro
and td.CadastroGeral = tdp.CadastroGeral
and td.GuiaRecolhimento = tdp.GuiaRecolhimento
and td.SubDivida = tdp.SubDivida
left outer join tribCadastroGeral tcg
 on td.TipoCadastro = tcg.TipoCadastro
and td.CadastroGeral = tcg.CadastroGeral
left outer join tribGuiaRecolhimento tgr
 on tdp.Entidade = tgr.Entidade
and tdp.Exercicio = tgr.Exercicio
and tdp.GuiaRecolhimento = tgr.GuiaRecolhimento
left outer join tribGuiaRecolhimentoReceita tgrr
 on	tgrr.Entidade = tdpr.Entidade
and tgrr.Exercicio = tdpr.Exercicio
and tgrr.GuiaRecolhimento = tdpr.GuiaRecolhimento
and tgrr.Receita = tdpr.Receita
left outer join TribEntidadeCorrecao tec
 on	tec.Entidade = tdp.Entidade
and tec.Exercicio = :Exercicio
and tec.Principal = 'S'
left outer join TribSituacaoParcela tsp
 on	tdp.SituacaoDebito = tsp.SituacaoParcela
left outer join TribTipoSituacaoParcela ttsp
 on tsp.TipoSituacaoParcela = ttsp.TipoSituacaoParcela
left outer join FormaCorrecao fc
on td.FormaCorrecao = fc.FormaCorrecao
left outer join TribReceita tr
 on	tdpr.Entidade = tr.Entidade
 and tdpr.Exercicio = tr.Exercicio
 and tdpr.Receita = tr.Receita
left join tribreceitatipo trt
 on trt.tiporeceita = tr.tiporeceita
left outer join TribParcelamento tp
 on td.IdParcelamento = tp.IdParcelamento
left outer join tribparamparcelamento tpp
 on tpp.idparametroparcelamento = tp.idparametroparcelamento
left outer join tribmodelobloqueto mb
 on mb.modelobloqueto = tpp.modelobloqueto
left join tribconvenio c
 on c.convenio = mb.convenio
left outer join tribguiarecolhimentoformapag grfp on
	(grfp.entidade = td.entidade
		and grfp.exercicio = td.exercicio
		and grfp.guiarecolhimento = td.guiarecolhimento
		and grfp.formapagamento = coalesce (tpp.formapagamento, :formapagamento))
left outer join tribmodelobloqueto mb1
 on mb1.modelobloqueto = grfp.modelobloqueto
left join tribconvenio c1
 on	c1.entidade = mb1.entidade
and c1.convenio = mb1.convenio
left outer join (
	select
		tdidaJoin.ENTIDADE,
		tdidaJoin.EXERCICIO,
		tdidaJoin.TIPODOCUMENTO,
		tdidaJoin.DOCUMENTO,
		tdidaJoin.SEQUENCIAITEM,
		tdidaJoin.EXERCICIODEBITO,
		tdidaJoin.TIPOCADASTRO,
		tdidaJoin.CADASTROGERAL,
		tdidaJoin.GUIARECOLHIMENTO,
		tdidaJoin.SUBDIVIDA,
		tdidaJoin.PARCELA,
		tdidaJoin.RECEITA
	from
		TribDocumentoItemDividaAtiva tdidaJoin
	inner join tribdocumento doc on
		(tdidaJoin.Entidade = doc.entidade
			and tdidaJoin.Exercicio = doc.exercicio
			and tdidaJoin.Tipodocumento = doc.tipodocumento
			and tdidaJoin.Documento = doc.documento)
	where
		tdidaJoin.tipodocumento = 26
		and (tdidaJoin.exercicio,
		tdidaJoin.DOCUMENTO) in (
		select
			MAX(tdidaMax.exercicio),
			MAX(tdidaMax.DOCUMENTO) as UltimoDocumento
		from
			TribDocumentoItemDividaAtiva tdidaMax
		join tribdocumento docMax on
			(docMax.entidade = tdidaMax.Entidade
				and docMax.Exercicio = tdidaMax.Exercicio
				and docMax.Tipodocumento = tdidaMax.Tipodocumento
				and docMax.Documento = tdidaMax.Documento
				and docMax.Cancelado = 'N')
		where
			tdidaMax.ENTIDADE = tdidaJoin.ENTIDADE
			and tdidaMax.EXERCICIODEBITO = tdidaJoin.EXERCICIODEBITO
			and tdidaMax.TIPOCADASTRO = tdidaJoin.TIPOCADASTRO
			and tdidaMax.CADASTROGERAL = tdidaJoin.CADASTROGERAL
			and tdidaMax.GUIARECOLHIMENTO = tdidaJoin.GUIARECOLHIMENTO
			and tdidaMax.SUBDIVIDA = tdidaJoin.SUBDIVIDA
			and tdidaMax.PARCELA = tdidaJoin.PARCELA
			and tdidaMax.RECEITA = tdidaJoin.RECEITA
			and tdidaMax.Tipodocumento = tdidaJoin.Tipodocumento
			and tdidamax.exercicio = (
			select
				max(tdidaExercicio.exercicio)
			from
				tribdocumentoitemdividaativa tdidaExercicio
			join tribdocumento docExercicio on
				(docExercicio.entidade = tdidaExercicio.Entidade
					and docExercicio.Exercicio = tdidaExercicio.Exercicio
					and docExercicio.Tipodocumento = tdidaExercicio.Tipodocumento
					and docExercicio.Documento = tdidaExercicio.Documento
					and docExercicio.Cancelado = 'N')
			where
				tdidaExercicio.ENTIDADE = tdidaJoin.ENTIDADE
				and tdidaExercicio.EXERCICIODEBITO = tdidaJoin.EXERCICIODEBITO
				and tdidaExercicio.TIPOCADASTRO = tdidaJoin.TIPOCADASTRO
				and tdidaExercicio.CADASTROGERAL = tdidaJoin.CADASTROGERAL
				and tdidaExercicio.GUIARECOLHIMENTO = tdidaJoin.GUIARECOLHIMENTO
				and tdidaExercicio.SUBDIVIDA = tdidaJoin.SUBDIVIDA
				and tdidaExercicio.PARCELA = tdidaJoin.PARCELA
				and tdidaExercicio.RECEITA = tdidaJoin.RECEITA
				and tdidaExercicio.Tipodocumento = tdidaJoin.Tipodocumento ) )
		and doc.cancelado = 'N' ) tdida on
	(tdpr.entidade = tdida.entidade
		and tdpr.exercicio = tdida.exerciciodebito
		and tdpr.tipocadastro = tdida.tipocadastro
		and tdpr.cadastrogeral = tdida.cadastrogeral
		and tdpr.guiarecolhimento = tdida.guiarecolhimento
		and tdpr.subdivida = tdida.subdivida
		and tdpr.receita = tdida.receita
		and tdpr.parcela = tdida.parcela)
    join tribtipocadastro tc on tc.tipocadastro = td.tipocadastro
where
	td.Entidade = :Entidade
	and td.Constituido = 'S'
	and tcg.Pessoa = :idPessoa
	and ttsp.Tipo = 'A'
	and :Filtro
order by
	td.Exercicio,
	td.Tipocadastro,
	td.Cadastrogeral,
	td.Guiarecolhimento,
	td.Subdivida,
	tdp.Parcela,
	tdpr.Receita
