SELECT debito.iddebito AS id,
	debito.ENTIDADE,
	debito.EXERCICIO,
	debito.TIPOCADASTRO,
	debito.CADASTROGERAL,
	pessoaCadastro.nome AS nomeCadastro,
	debito.GUIARECOLHIMENTO AS divida,
	divida.DESCRICAO AS dividaDescricao,
	debito.SUBDIVIDA,
	debito.DATALANCAMENTO,
	debito.DATAINCLUSAO,
	debito.DATACONTABILIZACAO,
	debito.DATAPRIMEIRAPARCELA,
	debito.DATACORRECAO,
	debito.DATACORRECAOIGPM,
	debito.PERCENTUALISS,
	debito.DESCONTOIMPOSTO,
	debito.DESCONTOLEI2004,
	debito.NUMEROPARCELA,
	debito.ISENCAOIPTU,
	CASE WHEN COALESCE(debito.PARCELADO,'N') = 'S' THEN parcelamento.NUMEROCONTRATO END AS numContratoParcelamento,
	CASE WHEN COALESCE(debito.REPARCELADO,'N') = 'S' THEN parcelamento.NUMEROCONTRATO END AS numContratoReparcelamento,
	COALESCE(pessoaUsuario.nome, usuario.nome) AS USUARIO,
	debito.PROGRAMA,
	formaCorrecao.formaCorrecao || ' - ' || formaCorrecao.descricao AS FORMACORRECAO,
	debito.PROCESSOPROCON,
    debito.EXERCICIOPROCESSOPROCON,
    debito.IDPARCELAMENTO,
	CASE WHEN COALESCE(debito.CONSTITUIDO,'S') = 'S' THEN 1 ELSE 0 END AS constituido
FROM TRIBDEBITO debito
LEFT OUTER JOIN tribCadastroGeral cg ON
	debito.tipoCadastro = cg.tipoCadastro
	AND debito.cadastroGeral = cg.cadastroGeral
LEFT OUTER JOIN pessoa pessoaCadastro ON
	cg.pessoa = pessoaCadastro.pessoa
LEFT OUTER JOIN tribParcelamento parcelamento ON
	debito.IDPARCELAMENTO = parcelamento.IDPARCELAMENTO
LEFT OUTER JOIN usuario ON
	debito.usuario = usuario.usuario
LEFT OUTER JOIN pessoa pessoaUsuario ON
	usuario.pessoa = pessoaUsuario.pessoa
LEFT OUTER JOIN formaCorrecao ON
    debito.FORMACORRECAO = formaCorrecao.formaCorrecao
LEFT OUTER JOIN tribGuiaRecolhimento divida ON
	debito.ENTIDADE = DIVIDA.ENTIDADE
	AND debito.EXERCICIO = divida.EXERCICIO
	AND	debito.GUIARECOLHIMENTO = divida.GUIARECOLHIMENTO
WHERE
	debito.IDDEBITO = :id
GROUP BY debito.iddebito,
	debito.ENTIDADE,
	debito.EXERCICIO,
	debito.TIPOCADASTRO,
	debito.CADASTROGERAL,
	pessoaCadastro.nome,
	debito.GUIARECOLHIMENTO,
	divida.DESCRICAO,
	debito.SUBDIVIDA,
	debito.DATALANCAMENTO,
	debito.DATACORRECAO,
	debito.DATAINCLUSAO,
	debito.DATACONTABILIZACAO,
	debito.DATAPRIMEIRAPARCELA,
	debito.DATACORRECAOIGPM,
	debito.PERCENTUALISS,
	debito.DESCONTOIMPOSTO,
	debito.DESCONTOLEI2004,
	debito.NUMEROPARCELA,
	debito.ISENCAOIPTU,
	debito.PARCELADO,
	debito.REPARCELADO,
	parcelamento.NUMEROCONTRATO,
	pessoaUsuario.nome,
	usuario.nome,
	debito.PROGRAMA,
	formaCorrecao.formaCorrecao,
    formaCorrecao.descricao,
    debito.PROCESSOPROCON,
    debito.EXERCICIOPROCESSOPROCON,
    debito.IDPARCELAMENTO,
    debito.CONSTITUIDO