SELECT DISTINCT
       td.idDebito,
       tdida.parcela
  FROM tribdocumento                   doc
  JOIN tribdocumentopeticaocda        tdip ON tdip.idpeticao = doc.idkey
  JOIN tribdocumento                   cda ON cda.idkey = tdip.idcertidaodividaativa
  JOIN tribdocumentoitemdividaativa  tdida ON (tdida.tipodocumento = cda.tipodocumento AND
                                                          tdida.exercicio = cda.exercicio AND
                                                          tdida.entidade = cda.entidade AND
                                                          tdida.documento = cda.documento)
  JOIN tribdebitoparcela               tdp ON ( tdida.entidade = tdp.entidade
                                           AND  tdida.exerciciodebito = tdp.exercicio
                                           AND  tdida.tipocadastro = tdp.tipocadastro
                                           AND  tdida.cadastrogeral = tdp.cadastrogeral
                                           AND  tdida.guiarecolhimento = tdp.guiarecolhimento
                                           AND  tdida.subdivida = tdp.subdivida
                                           AND  tdida.parcela = tdp.parcela )
  JOIN tribsituacaoparcela             tsp ON ( tdp.situacaodebito = tsp.situacaoparcela )
  JOIN tribtiposituacaoparcela        ttsp ON ( tsp.tiposituacaoparcela = ttsp.tiposituacaoparcela )
  JOIN tribdebito                       td ON ( tdp.entidade = td.entidade
                                           AND  tdp.exercicio = td.exercicio
                                           AND  tdp.tipocadastro = td.tipocadastro
                                           AND  tdp.cadastrogeral = td.cadastrogeral
                                           AND  tdp.guiarecolhimento = td.guiarecolhimento
                                           AND  tdp.subdivida = td.subdivida )
 WHERE doc.idkey = :documento
 ORDER BY td.idDebito, tdida.parcela;